/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Map;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.server.ReplicaManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeLogDirsRequest;
import org.apache.kafka.common.requests.DescribeLogDirsResponse;
import org.junit.Assert;
import org.junit.Test;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001E3Aa\u0004\t\u0001+!)!\u0004\u0001C\u00017!9Q\u0004\u0001b\u0001\n\u0003r\u0002BB\u0013\u0001A\u0003%q\u0004C\u0004'\u0001\t\u0007I\u0011\t\u0010\t\r\u001d\u0002\u0001\u0015!\u0003 \u0011\u001dA\u0003A1A\u0005\u0002%BaA\r\u0001!\u0002\u0013Q\u0003bB\u001a\u0001\u0005\u0004%\tA\b\u0005\u0007i\u0001\u0001\u000b\u0011B\u0010\t\u000fU\u0002!\u0019!C\u0001m!1!\t\u0001Q\u0001\n]Bqa\u0011\u0001C\u0002\u0013\u0005a\u0007\u0003\u0004E\u0001\u0001\u0006Ia\u000e\u0005\u0006\u000b\u0002!\tA\u0012\u0002\u001b\t\u0016\u001c8M]5cK2{w\rR5sgJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003#I\taa]3sm\u0016\u0014(\"A\n\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0006\t\u0003/ai\u0011\u0001E\u0005\u00033A\u0011qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0001\"a\u0006\u0001\u0002\u00171|w\rR5s\u0007>,h\u000e^\u000b\u0002?A\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t\u0019\u0011J\u001c;\u0002\u00191|w\rR5s\u0007>,h\u000e\u001e\u0011\u0002\u00159,XN\u0011:pW\u0016\u00148/A\u0006ok6\u0014%o\\6feN\u0004\u0013!\u0002;pa&\u001cW#\u0001\u0016\u0011\u0005-\u0002T\"\u0001\u0017\u000b\u00055r\u0013\u0001\u00027b]\u001eT\u0011aL\u0001\u0005U\u00064\u0018-\u0003\u00022Y\t11\u000b\u001e:j]\u001e\fa\u0001^8qS\u000e\u0004\u0013\u0001\u00049beRLG/[8o\u001dVl\u0017!\u00049beRLG/[8o\u001dVl\u0007%A\u0002uaB*\u0012a\u000e\t\u0003q\u0001k\u0011!\u000f\u0006\u0003um\naaY8n[>t'BA\n=\u0015\tid(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u007f\u0005\u0019qN]4\n\u0005\u0005K$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0005iB\u0004\u0004%A\u0002uaF\nA\u0001\u001e92A\u0005QB/Z:u\t\u0016\u001c8M]5cK2{w\rR5sgJ+\u0017/^3tiR\tq\t\u0005\u0002!\u0011&\u0011\u0011*\t\u0002\u0005+:LG\u000f\u000b\u0002\u000f\u0017B\u0011AjT\u0007\u0002\u001b*\u0011aJP\u0001\u0006UVt\u0017\u000e^\u0005\u0003!6\u0013A\u0001V3ti\u0002")
public class DescribeLogDirsRequestTest
extends BaseRequestTest {
    private final int logDirCount;
    private final int numBrokers;
    private final String topic;
    private final int partitionNum;
    private final TopicPartition tp0 = new TopicPartition(this.topic(), 0);
    private final TopicPartition tp1 = new TopicPartition(this.topic(), 1);

    @Override
    public int logDirCount() {
        return this.logDirCount;
    }

    @Override
    public int numBrokers() {
        return this.numBrokers;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionNum() {
        return this.partitionNum;
    }

    public TopicPartition tp0() {
        return this.tp0;
    }

    public TopicPartition tp1() {
        return this.tp1;
    }

    @Test
    public void testDescribeLogDirsRequest() {
        String onlineDir = new File((String)((KafkaServer)this.servers().head()).config().logDirs().head()).getAbsolutePath();
        String offlineDir = new File((String)((IterableLike)((KafkaServer)this.servers().head()).config().logDirs().tail()).head()).getAbsolutePath();
        ReplicaManager qual$1 = ((KafkaServer)this.servers().head()).replicaManager();
        String x$1 = offlineDir;
        boolean x$2 = qual$1.handleLogDirFailure$default$2();
        qual$1.handleLogDirFailure(x$1, x$2);
        this.createTopic(this.topic(), this.partitionNum(), 1, this.createTopic$default$4());
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), this.topic(), 10, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        DescribeLogDirsRequest request = (DescribeLogDirsRequest)new DescribeLogDirsRequest.Builder(null).build();
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.DESCRIBE_LOG_DIRS, this.controllerSocketServer(), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        Map logDirInfos = DescribeLogDirsResponse.parse((ByteBuffer)response, (short)request.version()).logDirInfos();
        Assert.assertEquals((long)this.logDirCount(), (long)logDirInfos.size());
        Assert.assertEquals((Object)Errors.KAFKA_STORAGE_ERROR, (Object)((DescribeLogDirsResponse.LogDirInfo)logDirInfos.get((Object)offlineDir)).error);
        Assert.assertEquals((long)0L, (long)((DescribeLogDirsResponse.LogDirInfo)logDirInfos.get((Object)offlineDir)).replicaInfos.size());
        Assert.assertEquals((Object)Errors.NONE, (Object)((DescribeLogDirsResponse.LogDirInfo)logDirInfos.get((Object)onlineDir)).error);
        DescribeLogDirsResponse.ReplicaInfo replicaInfo0 = (DescribeLogDirsResponse.ReplicaInfo)((DescribeLogDirsResponse.LogDirInfo)logDirInfos.get((Object)onlineDir)).replicaInfos.get(this.tp0());
        DescribeLogDirsResponse.ReplicaInfo replicaInfo1 = (DescribeLogDirsResponse.ReplicaInfo)((DescribeLogDirsResponse.LogDirInfo)logDirInfos.get((Object)onlineDir)).replicaInfos.get(this.tp1());
        LogManager qual$2 = ((KafkaServer)this.servers().head()).logManager();
        TopicPartition x$3 = this.tp0();
        boolean x$4 = qual$2.getLog$default$2();
        Log log0 = (Log)qual$2.getLog(x$3, x$4).get();
        LogManager qual$3 = ((KafkaServer)this.servers().head()).logManager();
        TopicPartition x$5 = this.tp1();
        boolean x$6 = qual$3.getLog$default$2();
        Log log1 = (Log)qual$3.getLog(x$5, x$6).get();
        Assert.assertEquals((long)log0.size(), (long)replicaInfo0.size);
        Assert.assertEquals((long)log1.size(), (long)replicaInfo1.size);
        LogManager qual$4 = ((KafkaServer)this.servers().head()).logManager();
        TopicPartition x$7 = this.tp0();
        boolean x$8 = qual$4.getLog$default$2();
        Assert.assertTrue((((Log)qual$4.getLog(x$7, x$8).get()).logEndOffset() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)((KafkaServer)this.servers().head()).replicaManager().getLogEndOffsetLag(this.tp0(), log0.logEndOffset(), false), (long)replicaInfo0.offsetLag);
        Assert.assertEquals((long)((KafkaServer)this.servers().head()).replicaManager().getLogEndOffsetLag(this.tp1(), log1.logEndOffset(), false), (long)replicaInfo1.offsetLag);
    }

    public DescribeLogDirsRequestTest() {
        this.logDirCount = 2;
        this.numBrokers = 1;
        this.topic = "topic";
        this.partitionNum = 2;
    }
}

