/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.AbstractCreateTopicsRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.junit.Assert;
import org.junit.Test;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001-2AAB\u0004\u0001\u0019!)\u0011\u0003\u0001C\u0001%!)A\u0003\u0001C\u0001+!)Q\u0005\u0001C\u0001+!)q\u0005\u0001C\u0001+!)\u0011\u0006\u0001C\u0001+\t92I]3bi\u0016$v\u000e]5dgJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003\u0011%\taa]3sm\u0016\u0014(\"\u0001\u0006\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0004\t\u0003\u001d=i\u0011aB\u0005\u0003!\u001d\u0011q$\u00112tiJ\f7\r^\"sK\u0006$X\rV8qS\u000e\u001c(+Z9vKN$H+Z:u\u0003\u0019a\u0014N\\5u}Q\t1\u0003\u0005\u0002\u000f\u0001\u0005iB/Z:u-\u0006d\u0017\u000eZ\"sK\u0006$X\rV8qS\u000e\u001c(+Z9vKN$8\u000fF\u0001\u0017!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\u0011)f.\u001b;)\u0005\ti\u0002C\u0001\u0010$\u001b\u0005y\"B\u0001\u0011\"\u0003\u0015QWO\\5u\u0015\u0005\u0011\u0013aA8sO&\u0011Ae\b\u0002\u0005)\u0016\u001cH/A\u000fuKN$XI\u001d:pe\u000e\u0013X-\u0019;f)>\u0004\u0018nY:SKF,Xm\u001d;tQ\t\u0019Q$A\u0010uKN$\u0018J\u001c<bY&$7I]3bi\u0016$v\u000e]5dgJ+\u0017/^3tiND#\u0001B\u000f\u0002#Q,7\u000f\u001e(pi\u000e{g\u000e\u001e:pY2,'\u000f\u000b\u0002\u0006;\u0001")
public class CreateTopicsRequestTest
extends AbstractCreateTopicsRequestTest {
    @Test
    public void testValidCreateTopicsRequests() {
        int timeout = 10000;
        this.validateValidCreateTopicsRequests((CreateTopicsRequest)new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic1"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1))}))).asJava(), timeout).build());
        this.validateValidCreateTopicsRequests((CreateTopicsRequest)new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic2"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)3))}))).asJava(), timeout).build());
        java.util.Map config3 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min.insync.replicas"), (Object)"2")}))).asJava();
        this.validateValidCreateTopicsRequests((CreateTopicsRequest)new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic3"), (Object)new CreateTopicsRequest.TopicDetails(5, (short)2, config3))}))).asJava(), timeout).build());
        java.util.Map<Integer, java.util.List<Integer>> assignments4 = this.replicaAssignmentToJava((scala.collection.immutable.Map<Object, List<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}))));
        this.validateValidCreateTopicsRequests((CreateTopicsRequest)new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic4"), (Object)new CreateTopicsRequest.TopicDetails(assignments4))}))).asJava(), timeout).build());
        java.util.Map<Integer, java.util.List<Integer>> assignments5 = this.replicaAssignmentToJava((scala.collection.immutable.Map<Object, List<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}))));
        java.util.Map config5 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min.insync.replicas"), (Object)"2")}))).asJava();
        this.validateValidCreateTopicsRequests((CreateTopicsRequest)new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic5"), (Object)new CreateTopicsRequest.TopicDetails(assignments5, config5))}))).asJava(), timeout).build());
        java.util.Map<Integer, java.util.List<Integer>> assignments8 = this.replicaAssignmentToJava((scala.collection.immutable.Map<Object, List<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}))));
        this.validateValidCreateTopicsRequests((CreateTopicsRequest)new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic6"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic7"), (Object)new CreateTopicsRequest.TopicDetails(5, (short)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic8"), (Object)new CreateTopicsRequest.TopicDetails(assignments8))}))).asJava(), timeout).build());
        this.validateValidCreateTopicsRequests((CreateTopicsRequest)new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic9"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic10"), (Object)new CreateTopicsRequest.TopicDetails(5, (short)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic11"), (Object)new CreateTopicsRequest.TopicDetails(assignments8))}))).asJava(), timeout, true).build());
    }

    @Test
    public void testErrorCreateTopicsRequests() {
        int timeout = 10000;
        String existingTopic = "existing-topic";
        this.createTopic(existingTopic, 1, 1, this.createTopic$default$4());
        this.validateErrorCreateTopicsRequests((CreateTopicsRequest)new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)existingTopic), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1))}))).asJava(), timeout).build(), (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)existingTopic), (Object)this.error(Errors.TOPIC_ALREADY_EXISTS, (Option<String>)new Some((Object)"Topic 'existing-topic' already exists.")))}))), this.validateErrorCreateTopicsRequests$default$3(), this.validateErrorCreateTopicsRequests$default$4());
        this.validateErrorCreateTopicsRequests((CreateTopicsRequest)new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-partitions"), (Object)new CreateTopicsRequest.TopicDetails(-1, (short)1))}))).asJava(), timeout).build(), (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-partitions"), (Object)this.error(Errors.INVALID_PARTITIONS, this.error$default$2()))}))), false, this.validateErrorCreateTopicsRequests$default$4());
        this.validateErrorCreateTopicsRequests((CreateTopicsRequest)new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-replication"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)(this.numBrokers() + 1)))}))).asJava(), timeout).build(), (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-replication"), (Object)this.error(Errors.INVALID_REPLICATION_FACTOR, this.error$default$2()))}))), false, this.validateErrorCreateTopicsRequests$default$4());
        java.util.Map invalidConfig = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"not.a.property"), (Object)"error")}))).asJava();
        this.validateErrorCreateTopicsRequests((CreateTopicsRequest)new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-config"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1, invalidConfig))}))).asJava(), timeout).build(), (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-config"), (Object)this.error(Errors.INVALID_CONFIG, this.error$default$2()))}))), false, this.validateErrorCreateTopicsRequests$default$4());
        java.util.Map config = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.format.version"), (Object)"invalid-value")}))).asJava();
        this.validateErrorCreateTopicsRequests((CreateTopicsRequest)new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-config-value"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1, config))}))).asJava(), timeout).build(), (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-config-value"), (Object)this.error(Errors.INVALID_CONFIG, this.error$default$2()))}))), false, this.validateErrorCreateTopicsRequests$default$4());
        java.util.Map<Integer, java.util.List<Integer>> invalidAssignments = this.replicaAssignmentToJava((scala.collection.immutable.Map<Object, List<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}))));
        this.validateErrorCreateTopicsRequests((CreateTopicsRequest)new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-assignment"), (Object)new CreateTopicsRequest.TopicDetails(invalidAssignments))}))).asJava(), timeout).build(), (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-assignment"), (Object)this.error(Errors.INVALID_REPLICA_ASSIGNMENT, this.error$default$2()))}))), false, this.validateErrorCreateTopicsRequests$default$4());
        this.validateErrorCreateTopicsRequests((CreateTopicsRequest)new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)existingTopic), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-partitions"), (Object)new CreateTopicsRequest.TopicDetails(-1, (short)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-replication"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)(this.numBrokers() + 1))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-assignment"), (Object)new CreateTopicsRequest.TopicDetails(invalidAssignments)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-none"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1))}))).asJava(), timeout).build(), (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)existingTopic), (Object)this.error(Errors.TOPIC_ALREADY_EXISTS, this.error$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-partitions"), (Object)this.error(Errors.INVALID_PARTITIONS, this.error$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-replication"), (Object)this.error(Errors.INVALID_REPLICATION_FACTOR, this.error$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-assignment"), (Object)this.error(Errors.INVALID_REPLICA_ASSIGNMENT, this.error$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-none"), (Object)this.error(Errors.NONE, this.error$default$2()))}))), false, this.validateErrorCreateTopicsRequests$default$4());
        this.validateTopicExists("partial-none");
        this.validateErrorCreateTopicsRequests((CreateTopicsRequest)new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-timeout"), (Object)new CreateTopicsRequest.TopicDetails(10, (short)3))}))).asJava(), 1).build(), (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-timeout"), (Object)this.error(Errors.REQUEST_TIMED_OUT, this.error$default$2()))}))), false, this.validateErrorCreateTopicsRequests$default$4());
        this.validateErrorCreateTopicsRequests((CreateTopicsRequest)new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-timeout-zero"), (Object)new CreateTopicsRequest.TopicDetails(10, (short)3))}))).asJava(), 0).build(), (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-timeout-zero"), (Object)this.error(Errors.REQUEST_TIMED_OUT, this.error$default$2()))}))), false, this.validateErrorCreateTopicsRequests$default$4());
        this.validateErrorCreateTopicsRequests((CreateTopicsRequest)new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-timeout-negative"), (Object)new CreateTopicsRequest.TopicDetails(10, (short)3))}))).asJava(), -1).build(), (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-timeout-negative"), (Object)this.error(Errors.REQUEST_TIMED_OUT, this.error$default$2()))}))), false, this.validateErrorCreateTopicsRequests$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), "error-timeout", 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), "error-timeout-zero", 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), "error-timeout-negative", 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        this.validateTopicExists("error-timeout");
        this.validateTopicExists("error-timeout-zero");
        this.validateTopicExists("error-timeout-negative");
    }

    @Test
    public void testInvalidCreateTopicsRequests() {
        CreateTopicsRequest singleRequest;
        CreateTopicsRequest x$1 = singleRequest = (CreateTopicsRequest)new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"duplicate-topic"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1))}))).asJava(), 1000).build();
        scala.collection.immutable.Map x$2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"duplicate-topic"), (Object)this.error(Errors.INVALID_REQUEST, (Option<String>)new Some((Object)"Create topics request from client `client-id` contains multiple entries for the following topics: duplicate-topic")))}));
        Some x$3 = new Some((Object)this.toStructWithDuplicateFirstTopic(singleRequest));
        boolean x$4 = this.validateErrorCreateTopicsRequests$default$3();
        this.validateErrorCreateTopicsRequests(x$1, (scala.collection.immutable.Map<String, ApiError>)x$2, x$4, (Option<Struct>)x$3);
        CreateTopicsRequest doubleRequestValidateOnly = (CreateTopicsRequest)new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"duplicate-topic"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-topic"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1))}))).asJava(), 1000, true).build();
        this.validateErrorCreateTopicsRequests(doubleRequestValidateOnly, (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"duplicate-topic"), (Object)this.error(Errors.INVALID_REQUEST, this.error$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-topic"), (Object)this.error(Errors.NONE, this.error$default$2()))}))), false, (Option<Struct>)new Some((Object)this.toStructWithDuplicateFirstTopic(doubleRequestValidateOnly)));
        CreateTopicsRequest doubleRequest = (CreateTopicsRequest)new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"duplicate-topic"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-topic"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1))}))).asJava(), 1000).build();
        this.validateErrorCreateTopicsRequests(doubleRequest, (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"duplicate-topic"), (Object)this.error(Errors.INVALID_REQUEST, this.error$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-topic"), (Object)this.error(Errors.NONE, this.error$default$2()))}))), false, (Option<Struct>)new Some((Object)this.toStructWithDuplicateFirstTopic(doubleRequest)));
        java.util.Map<Integer, java.util.List<Integer>> assignments = this.replicaAssignmentToJava((scala.collection.immutable.Map<Object, List<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}))));
        CreateTopicsRequest assignmentRequest = (CreateTopicsRequest)new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bad-args-topic"), (Object)new CreateTopicsRequest.TopicDetails(assignments))}))).asJava(), 1000).build();
        CreateTopicsRequest badArgumentsRequest = this.addPartitionsAndReplicationFactorToFirstTopic(assignmentRequest);
        this.validateErrorCreateTopicsRequests(badArgumentsRequest, (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bad-args-topic"), (Object)this.error(Errors.INVALID_REQUEST, this.error$default$2()))}))), false, this.validateErrorCreateTopicsRequests$default$4());
        CreateTopicsRequest assignmentRequestValidateOnly = (CreateTopicsRequest)new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bad-args-topic"), (Object)new CreateTopicsRequest.TopicDetails(assignments))}))).asJava(), 1000, true).build();
        CreateTopicsRequest badArgumentsRequestValidateOnly = this.addPartitionsAndReplicationFactorToFirstTopic(assignmentRequestValidateOnly);
        this.validateErrorCreateTopicsRequests(badArgumentsRequestValidateOnly, (scala.collection.immutable.Map<String, ApiError>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bad-args-topic"), (Object)this.error(Errors.INVALID_REQUEST, this.error$default$2()))}))), false, this.validateErrorCreateTopicsRequests$default$4());
    }

    @Test
    public void testNotController() {
        CreateTopicsRequest request = (CreateTopicsRequest)new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic1"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1))}))).asJava(), 1000).build();
        CreateTopicsResponse response = this.sendCreateTopicRequest(request, this.notControllerSocketServer());
        Errors error = ((ApiError)((Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(response.errors()).asScala()).head())._2()).error();
        Assert.assertEquals((String)"Expected controller error when routed incorrectly", (Object)Errors.NOT_CONTROLLER, (Object)error);
    }
}

