/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.cluster.BrokerEndPoint;
import kafka.server.AbstractFetcherManager;
import kafka.server.AbstractFetcherThread;
import kafka.server.InitialFetchState;
import kafka.server.OffsetAndEpoch;
import kafka.server.PartitionFetchState$;
import kafka.server.ReplicaState;
import kafka.server.Truncating$;
import org.apache.kafka.common.TopicPartition;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\t2Aa\u0001\u0003\u0001\u0013!)\u0001\u0003\u0001C\u0001#!)A\u0003\u0001C\u0001+\tQ\u0012IY:ue\u0006\u001cGOR3uG\",'/T1oC\u001e,'\u000fV3ti*\u0011QAB\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u001d\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\n\u0011\u0005M\u0001Q\"\u0001\u0003\u00023Q,7\u000f^!eI\u0006sGMU3n_Z,\u0007+\u0019:uSRLwN\u001c\u000b\u0002-A\u00111bF\u0005\u000311\u0011A!\u00168ji\"\u0012!A\u0007\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\tQA[;oSRT\u0011aH\u0001\u0004_J<\u0017BA\u0011\u001d\u0005\u0011!Vm\u001d;")
public class AbstractFetcherManagerTest {
    @Test
    public void testAddAndRemovePartition() {
        AbstractFetcherThread fetcher = (AbstractFetcherThread)EasyMock.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$1;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$1;
            }
            {
                this.fetcher$1 = fetcher$1;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        long fetchOffset = 10L;
        int leaderEpoch = 15;
        TopicPartition tp = new TopicPartition("topic", 0);
        InitialFetchState initialFetchState = new InitialFetchState(new BrokerEndPoint(0, "localhost", 9092), leaderEpoch, fetchOffset);
        fetcher.start();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        fetcher.addPartitions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetAndEpoch(fetchOffset, leaderEpoch))})));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)fetcher.fetchState(tp)).andReturn((Object)new Some((Object)PartitionFetchState$.MODULE$.apply(fetchOffset, leaderEpoch, (ReplicaState)Truncating$.MODULE$)));
        fetcher.removePartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)fetcher.fetchState(tp)).andReturn((Object)None$.MODULE$);
        EasyMock.replay((Object[])new Object[]{fetcher});
        fetcherManager.addFetcherForPartitions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})));
        Assert.assertEquals((Object)new Some((Object)fetcher), (Object)fetcherManager.getFetcher(tp));
        fetcherManager.removeFetcherForPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assert.assertEquals((Object)None$.MODULE$, (Object)fetcherManager.getFetcher(tp));
        EasyMock.verify((Object[])new Object[]{fetcher});
    }
}

