/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import kafka.log.CorruptIndexException;
import kafka.log.TimeIndex;
import kafka.log.TimeIndex$;
import kafka.log.TimestampOffset;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.InvalidOffsetException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001!4A!\u0005\n\u0001/!)!\u0005\u0001C\u0001G!9a\u0005\u0001a\u0001\n\u00039\u0003bB\u0016\u0001\u0001\u0004%\t\u0001\f\u0005\u0007k\u0001\u0001\u000b\u0015\u0002\u0015\t\u000fY\u0002!\u0019!C\u0001o!11\b\u0001Q\u0001\naBq\u0001\u0010\u0001C\u0002\u0013\u0005Q\b\u0003\u0004B\u0001\u0001\u0006IA\u0010\u0005\u0006\u0005\u0002!\ta\u0011\u0005\u0006\u0015\u0002!\ta\u0011\u0005\u0006\u001f\u0002!\ta\u0011\u0005\u0006)\u0002!\ta\u0011\u0005\u0006-\u0002!\ta\u0011\u0005\u00061\u0002!I!\u0017\u0005\u00069\u0002!\t!\u0018\u0005\u0006M\u0002!\ta\u0011\u0002\u000e)&lW-\u00138eKb$Vm\u001d;\u000b\u0005M!\u0012a\u00017pO*\tQ#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0002CA\r!\u001b\u0005Q\"BA\u000e\u001d\u0003\u0015QWO\\5u\u0015\tib$A\u0005tG\u0006d\u0017\r^3ti*\tq$A\u0002pe\u001eL!!\t\u000e\u0003\u0015)+f.\u001b;Tk&$X-\u0001\u0004=S:LGO\u0010\u000b\u0002IA\u0011Q\u0005A\u0007\u0002%\u0005\u0019\u0011\u000e\u001a=\u0016\u0003!\u0002\"!J\u0015\n\u0005)\u0012\"!\u0003+j[\u0016Le\u000eZ3y\u0003\u001dIG\r_0%KF$\"!L\u001a\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\tUs\u0017\u000e\u001e\u0005\bi\r\t\t\u00111\u0001)\u0003\rAH%M\u0001\u0005S\u0012D\b%\u0001\u0006nCb,e\u000e\u001e:jKN,\u0012\u0001\u000f\t\u0003]eJ!AO\u0018\u0003\u0007%sG/A\u0006nCb,e\u000e\u001e:jKN\u0004\u0013A\u00032bg\u0016|eMZ:fiV\ta\b\u0005\u0002/\u007f%\u0011\u0001i\f\u0002\u0005\u0019>tw-A\u0006cCN,wJ\u001a4tKR\u0004\u0013!B:fiV\u0004H#A\u0017)\u0005%)\u0005C\u0001$I\u001b\u00059%BA\u000e\u001f\u0013\tIuI\u0001\u0004CK\u001a|'/Z\u0001\ti\u0016\f'\u000fZ8x]\"\u0012!\u0002\u0014\t\u0003\r6K!AT$\u0003\u000b\u00053G/\u001a:\u0002\u0015Q,7\u000f\u001e'p_.,\u0006\u000f\u000b\u0002\f#B\u0011aIU\u0005\u0003'\u001e\u0013A\u0001V3ti\u0006aA/Z:u)J,hnY1uK\"\u0012A\"U\u0001\u000bi\u0016\u001cH/\u00119qK:$\u0007FA\u0007R\u00035\t\u0007\u000f]3oI\u0016sGO]5fgR\u0011QF\u0017\u0005\u00067:\u0001\r\u0001O\u0001\u000b]VlWI\u001c;sS\u0016\u001c\u0018a\u00058p]\u0016C\u0018n\u001d;b]R$V-\u001c9GS2,G#\u00010\u0011\u0005}#W\"\u00011\u000b\u0005\u0005\u0014\u0017AA5p\u0015\u0005\u0019\u0017\u0001\u00026bm\u0006L!!\u001a1\u0003\t\u0019KG.Z\u0001\u0010i\u0016\u001cHoU1oSRL8\t[3dW\"\u0012\u0001#\u0015")
public class TimeIndexTest
extends JUnitSuite {
    private TimeIndex idx = null;
    private final int maxEntries;
    private final long baseOffset;

    public TimeIndex idx() {
        return this.idx;
    }

    public void idx_$eq(TimeIndex x$1) {
        this.idx = x$1;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    @Before
    public void setup() {
        this.idx_$eq(new TimeIndex(this.nonExistantTempFile(), this.baseOffset(), this.maxEntries() * 12, TimeIndex$.MODULE$.$lessinit$greater$default$4()));
    }

    @After
    public void teardown() {
        block0: {
            if (this.idx() == null) break block0;
            this.idx().file().delete();
        }
    }

    @Test
    public void testLookUp() {
        Assert.assertEquals((Object)new TimestampOffset(-1L, this.baseOffset()), (Object)this.idx().lookup(100L));
        this.appendEntries(this.maxEntries() - 1);
        Assert.assertEquals((Object)new TimestampOffset(-1L, this.baseOffset()), (Object)this.idx().lookup(9L));
        Assert.assertEquals((Object)new TimestampOffset(20L, 65L), (Object)this.idx().lookup(25L));
        Assert.assertEquals((Object)new TimestampOffset(30L, 75L), (Object)this.idx().lookup(30L));
    }

    @Test
    public void testTruncate() {
        this.appendEntries(this.maxEntries() - 1);
        this.idx().truncate();
        Assert.assertEquals((long)0L, (long)this.idx().entries());
        this.appendEntries(this.maxEntries() - 1);
        this.idx().truncateTo(10L + this.baseOffset());
        Assert.assertEquals((long)0L, (long)this.idx().entries());
    }

    @Test
    public void testAppend() {
        this.appendEntries(this.maxEntries() - 1);
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TimeIndex qual$1 = this.idx();
            long x$1 = 10000L;
            long x$2 = 1000L;
            boolean x$3 = qual$1.maybeAppend$default$3();
            qual$1.maybeAppend(x$1, x$2, x$3);
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TimeIndexTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.idx().maybeAppend(10000L, (long)((this.maxEntries() - 2) * 10), true), ClassTag$.MODULE$.apply(InvalidOffsetException.class), new Position("TimeIndexTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        this.idx().maybeAppend(10000L, 1000L, true);
    }

    private void appendEntries(int numEntries) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numEntries).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            TimeIndex qual$1 = this.idx();
            long x$1 = i * 10;
            long x$2 = (long)(i * 10) + this.baseOffset();
            boolean x$3 = qual$1.maybeAppend$default$3();
            qual$1.maybeAppend(x$1, x$2, x$3);
        });
    }

    /*
     * WARNING - void declaration
     */
    public File nonExistantTempFile() {
        void var1_1;
        File file = TestUtils$.MODULE$.tempFile();
        file.delete();
        return var1_1;
    }

    @Test
    public void testSanityCheck() {
        this.idx().sanityCheck();
        this.appendEntries(5);
        TimestampOffset firstEntry = this.idx().entry(0);
        this.idx().sanityCheck();
        this.idx().close();
        BooleanRef shouldCorruptOffset = BooleanRef.create((boolean)false);
        BooleanRef shouldCorruptTimestamp = BooleanRef.create((boolean)false);
        BooleanRef shouldCorruptLength = BooleanRef.create((boolean)false);
        this.idx_$eq(new TimeIndex(this, shouldCorruptOffset, shouldCorruptTimestamp, firstEntry, shouldCorruptLength){
            private final BooleanRef shouldCorruptOffset$1;
            private final BooleanRef shouldCorruptTimestamp$1;
            private final TimestampOffset firstEntry$1;
            private final BooleanRef shouldCorruptLength$1;

            public TimestampOffset lastEntry() {
                TimestampOffset superLastEntry = super.lastEntry();
                long offset = this.shouldCorruptOffset$1.elem ? this.baseOffset() - 1L : superLastEntry.offset();
                long timestamp = this.shouldCorruptTimestamp$1.elem ? this.firstEntry$1.timestamp() - 1L : superLastEntry.timestamp();
                return new TimestampOffset(timestamp, offset);
            }

            /*
             * WARNING - void declaration
             */
            public long length() {
                void var1_1;
                long superLength = super.length();
                return this.shouldCorruptLength$1.elem ? superLength - 1L : var1_1;
            }
            {
                this.shouldCorruptOffset$1 = shouldCorruptOffset$1;
                this.shouldCorruptTimestamp$1 = shouldCorruptTimestamp$1;
                this.firstEntry$1 = firstEntry$1;
                this.shouldCorruptLength$1 = shouldCorruptLength$1;
                super($outer.idx().file(), $outer.baseOffset(), $outer.maxEntries() * 12, TimeIndex$.MODULE$.$lessinit$greater$default$4());
            }
        });
        shouldCorruptOffset.elem = true;
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.idx().sanityCheck(), ClassTag$.MODULE$.apply(CorruptIndexException.class), new Position("TimeIndexTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        shouldCorruptOffset.elem = false;
        shouldCorruptTimestamp.elem = true;
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.idx().sanityCheck(), ClassTag$.MODULE$.apply(CorruptIndexException.class), new Position("TimeIndexTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
        shouldCorruptTimestamp.elem = false;
        shouldCorruptLength.elem = true;
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.idx().sanityCheck(), ClassTag$.MODULE$.apply(CorruptIndexException.class), new Position("TimeIndexTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        shouldCorruptLength.elem = false;
        this.idx().sanityCheck();
        this.idx().close();
    }

    public TimeIndexTest() {
        this.maxEntries = 30;
        this.baseOffset = 45L;
    }
}

