/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import kafka.log.CompletedTxn;
import kafka.log.Log$;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.ProducerStateManager;
import kafka.log.TxnMetadata;
import kafka.log.ValidationType;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.errors.UnknownProducerIdException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Utils;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u0005h\u0001\u0002\"D\u0001!CQa\u0015\u0001\u0005\u0002QCqa\u0016\u0001A\u0002\u0013\u0005\u0001\fC\u0004b\u0001\u0001\u0007I\u0011\u00012\t\r-\u0004\u0001\u0015)\u0003Z\u0011\u001da\u0007\u00011A\u0005\u00025Dq!\u001d\u0001A\u0002\u0013\u0005!\u000f\u0003\u0004u\u0001\u0001\u0006KA\u001c\u0005\bk\u0002\u0011\r\u0011\"\u0001w\u0011\u001d\t\t\u0001\u0001Q\u0001\n]D\u0011\"a\u0001\u0001\u0005\u0004%\t!!\u0002\t\u0011\u00055\u0001\u0001)A\u0005\u0003\u000fA\u0011\"a\u0004\u0001\u0005\u0004%\t!!\u0005\t\u0011\u0005e\u0001\u0001)A\u0005\u0003'A\u0011\"a\u0007\u0001\u0005\u0004%\t!!\b\t\u0011\u0005-\u0002\u0001)A\u0005\u0003?Aq!!\f\u0001\t\u0003\ty\u0003C\u0004\u0002>\u0001!\t!a\f\t\u000f\u0005\u001d\u0003\u0001\"\u0001\u00020!9\u0011\u0011\u000b\u0001\u0005\u0002\u0005=\u0002bBA+\u0001\u0011\u0005\u0011q\u0006\u0005\b\u00033\u0002A\u0011AA\u0018\u0011\u001d\ti\u0006\u0001C\u0001\u0003_Aq!!\u001d\u0001\t\u0003\ty\u0003C\u0004\u0002v\u0001!\t!a\f\t\u000f\u0005e\u0004\u0001\"\u0001\u00020!9\u0011Q\u0010\u0001\u0005\u0002\u0005=\u0002bBAA\u0001\u0011\u0005\u0011q\u0006\u0005\b\u0003\u000b\u0003A\u0011AA\u0018\u0011\u001d\tI\t\u0001C\u0001\u0003_Aq!!$\u0001\t\u0003\ty\u0003C\u0004\u0002\u001a\u0002!\t!a\f\t\u000f\u0005u\u0005\u0001\"\u0001\u00020!9\u0011\u0011\u0015\u0001\u0005\u0002\u0005=\u0002bBAS\u0001\u0011\u0005\u0011q\u0006\u0005\b\u0003c\u0003A\u0011AA\u0018\u0011\u001d\t)\f\u0001C\u0001\u0003_Aq!!/\u0001\t\u0003\ty\u0003C\u0004\u0002>\u0002!\t!a\f\t\u000f\u0005\u0005\u0007\u0001\"\u0001\u00020!9\u0011Q\u0019\u0001\u0005\u0002\u0005=\u0002bBAe\u0001\u0011\u0005\u0011q\u0006\u0005\b\u0003\u001b\u0004A\u0011AA\u0018\u0011\u001d\t\t\u000e\u0001C\u0001\u0003_Aq!!6\u0001\t\u0003\ty\u0003C\u0004\u0002Z\u0002!\t!a\f\t\u000f\u0005u\u0007\u0001\"\u0001\u00020!9\u0011\u0011\u001d\u0001\u0005\u0002\u0005=\u0002bBAs\u0001\u0011\u0005\u0011q\u0006\u0005\b\u0003S\u0004A\u0011AA\u0018\u0011\u001d\t)\u0010\u0001C\u0001\u0003_Aq!!?\u0001\t\u0003\ty\u0003C\u0004\u0003\u0006\u0001!\t!a\f\t\u000f\t%\u0001\u0001\"\u0001\u00020!9!Q\u0002\u0001\u0005\u0002\u0005=\u0002b\u0002B\t\u0001\u0011\u0005\u0011q\u0006\u0005\b\u0005+\u0001A\u0011\u0002B\f\u0011\u001d\u0011\u0019\u0004\u0001C\u0005\u0005kA\u0011Ba\u001c\u0001#\u0003%IA!\u001d\t\u0013\t\u001d\u0005!%A\u0005\n\t%\u0005b\u0002BG\u0001\u0011%!q\u0012\u0005\n\u0005[\u0003\u0011\u0013!C\u0005\u0005\u0013C\u0011Ba,\u0001#\u0003%IA!-\t\u0013\tU\u0006!%A\u0005\n\tE\u0006b\u0002BG\u0001\u0011%!q\u0017\u0005\b\u0005\u001b\u0004A\u0011\u0002Bh\u0005a\u0001&o\u001c3vG\u0016\u00148\u000b^1uK6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003\t\u0016\u000b1\u0001\\8h\u0015\u00051\u0015!B6bM.\f7\u0001A\n\u0003\u0001%\u0003\"AS)\u000e\u0003-S!\u0001T'\u0002\u000b),h.\u001b;\u000b\u00059{\u0015!C:dC2\fG/Z:u\u0015\u0005\u0001\u0016aA8sO&\u0011!k\u0013\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0017A\u0002\u001fj]&$h\bF\u0001V!\t1\u0006!D\u0001D\u0003\u0019awn\u001a#jeV\t\u0011\f\u0005\u0002[?6\t1L\u0003\u0002];\u0006\u0011\u0011n\u001c\u0006\u0002=\u0006!!.\u0019<b\u0013\t\u00017L\u0001\u0003GS2,\u0017A\u00037pO\u0012K'o\u0018\u0013fcR\u00111-\u001b\t\u0003I\u001el\u0011!\u001a\u0006\u0002M\u0006)1oY1mC&\u0011\u0001.\u001a\u0002\u0005+:LG\u000fC\u0004k\u0007\u0005\u0005\t\u0019A-\u0002\u0007a$\u0013'A\u0004m_\u001e$\u0015N\u001d\u0011\u0002\u0019M$\u0018\r^3NC:\fw-\u001a:\u0016\u00039\u0004\"AV8\n\u0005A\u001c%\u0001\u0006)s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'/\u0001\tti\u0006$X-T1oC\u001e,'o\u0018\u0013fcR\u00111m\u001d\u0005\bU\u001a\t\t\u00111\u0001o\u00035\u0019H/\u0019;f\u001b\u0006t\u0017mZ3sA\u0005I\u0001/\u0019:uSRLwN\\\u000b\u0002oB\u0011\u0001P`\u0007\u0002s*\u0011!p_\u0001\u0007G>lWn\u001c8\u000b\u0005\u0019c(BA?P\u0003\u0019\t\u0007/Y2iK&\u0011q0\u001f\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003)\u0001\u0018M\u001d;ji&|g\u000eI\u0001\u000baJ|G-^2fe&#WCAA\u0004!\r!\u0017\u0011B\u0005\u0004\u0003\u0017)'\u0001\u0002'p]\u001e\f1\u0002\u001d:pIV\u001cWM]%eA\u0005\u0011R.\u0019=QS\u0012,\u0005\u0010]5sCRLwN\\'t+\t\t\u0019\u0002E\u0002e\u0003+I1!a\u0006f\u0005\rIe\u000e^\u0001\u0014[\u0006D\b+\u001b3FqBL'/\u0019;j_:l5\u000fI\u0001\u0005i&lW-\u0006\u0002\u0002 A!\u0011\u0011EA\u0014\u001b\t\t\u0019CC\u0002\u0002&e\fQ!\u001e;jYNLA!!\u000b\u0002$\tAQj\\2l)&lW-A\u0003uS6,\u0007%A\u0003tKR,\u0006\u000fF\u0001dQ\r\u0001\u00121\u0007\t\u0005\u0003k\tI$\u0004\u0002\u00028)\u0011AjT\u0005\u0005\u0003w\t9D\u0001\u0004CK\u001a|'/Z\u0001\ti\u0016\f'\u000fR8x]\"\u001a\u0011#!\u0011\u0011\t\u0005U\u00121I\u0005\u0005\u0003\u000b\n9DA\u0003BMR,'/\u0001\nuKN$()Y:jG&#W*\u00199qS:<\u0007f\u0001\n\u0002LA!\u0011QGA'\u0013\u0011\ty%a\u000e\u0003\tQ+7\u000f^\u0001'i\u0016\u001cH/\u00119qK:$G\u000b\u001f8NCJ\\WM],ji\"tu\u000e\u0015:pIV\u001cWM]*uCR,\u0007fA\n\u0002L\u0005qB/Z:u!J|G-^2feN+\u0017/^3oG\u0016<&/\u00199Be>,h\u000e\u001a\u0015\u0004)\u0005-\u0013!\f;fgR\u0004&o\u001c3vG\u0016\u00148+Z9vK:\u001cWmV5uQ^\u0013\u0018\r]!s_VtGMQ1uG\"\u0014VmY8sI\"\u001aQ#a\u0013\u0002KQ,7\u000f\u001e)s_\u0012,8-\u001a:TKF,XM\\2f\u0013:4\u0018\r\\5e/J\f\u0007/\u0011:pk:$\u0007f\u0002\f\u0002L\u0005\u0005\u00141M\u0001\tKb\u0004Xm\u0019;fI\u000e\u0012\u0011Q\r\t\u0005\u0003O\ni'\u0004\u0002\u0002j)\u0019\u00111N=\u0002\r\u0015\u0014(o\u001c:t\u0013\u0011\ty'!\u001b\u00037=+Ho\u00144Pe\u0012,'oU3rk\u0016t7-Z#yG\u0016\u0004H/[8o\u0003)\"Xm\u001d;O_Z\u000bG.\u001b3bi&|gn\u00148GSJ\u001cH/\u00128uef<\u0006.\u001a8M_\u0006$\u0017N\\4M_\u001eD3aFA&\u0003m!Xm\u001d;D_:$(o\u001c7SK\u000e|'\u000f\u001a\"v[B\u001cX\t]8dQ\"\u001a\u0001$a\u0013\u0002AQ,7\u000f\u001e+y]\u001aK'o\u001d;PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1DC\u000eDW\r\u001a\u0015\u00043\u0005-\u0013A\f;fgRtuN\\'bi\u000eD\u0017N\\4Uq:4\u0015N]:u\u001f\u001a47/\u001a;NKR\fG-\u0019;b\u001d>$8)Y2iK\u0012D3AGA&\u0003y!Xm\u001d;Qe\u0016\u0004\u0018M]3Va\u0012\fG/\u001a#pKNtu\u000e^'vi\u0006$X\rK\u0002\u001c\u0003\u0017\na$\u001e9eCR,\u0007K]8ek\u000e,'\u000f\u0016:b]N\f7\r^5p]N#\u0018\r^3)\u0007q\tY%\u0001\u0017uKN$x*\u001e;PMN+\u0017/^3oG\u0016\fe\r^3s\u0007>tGO]8m%\u0016\u001cwN\u001d3Fa>\u001c\u0007NQ;na\"\u001aQ$a\u0013\u0002aQ,7\u000f\u001e(p]R\u0013\u0018M\\:bGRLwN\\1m\u0003B\u0004XM\u001c3XSRDwJ\\4pS:<GK]1og\u0006\u001cG/[8oQ\u001dq\u00121JA1\u0003#\u001b#!a%\u0011\t\u0005\u001d\u0014QS\u0005\u0005\u0003/\u000bIG\u0001\rJ]Z\fG.\u001b3Uq:\u001cF/\u0019;f\u000bb\u001cW\r\u001d;j_:\fq\u0006^3tiR\u0013XO\\2bi\u0016\fe\u000e\u001a*fY>\fGMU3n_Z,7oT;u\u001f\u001a\u0014\u0016M\\4f':\f\u0007o\u001d5piND3aHA&\u0003A!Xm\u001d;UC.,7K\\1qg\"|G\u000fK\u0002!\u0003\u0017\nq\u0003^3tiJ+7m\u001c<fe\u001a\u0013x.\\*oCB\u001c\bn\u001c;)\u0007\u0005\nY%A\u000fuKN$(+Z7pm\u0016,\u0005\u0010]5sK\u0012\u0004\u0016\u000eZ:P]J+Gn\\1eQ\u001d\u0011\u00131JA1\u0003S\u001b#!a+\u0011\t\u0005\u001d\u0014QV\u0005\u0005\u0003_\u000bIG\u0001\u000eV].twn\u001e8Qe>$WoY3s\u0013\u0012,\u0005pY3qi&|g.A\u0017uKN$\u0018iY2faR\f\u0005\u000f]3oI^KG\u000f[8viB\u0013x\u000eZ;dKJ\u001cF/\u0019;f\u001f:\u0014V\r\u001d7jG\u0006D3aIA&\u0003%\"Xm\u001d;BG\u000e,\u0007\u000f^!qa\u0016tGmV5uQN+\u0017/^3oG\u0016<\u0015\r]:P]J+\u0007\u000f\\5dC\"\u001aA%a\u0013\u00023Q,7\u000f\u001e#fY\u0016$Xm\u00158baNDw\u000e^:CK\u001a|'/\u001a\u0015\u0004K\u0005-\u0013\u0001\u0004;fgR$&/\u001e8dCR,\u0007f\u0001\u0014\u0002L\u00051C/Z:u\r&\u00148\u000f^+ogR\f'\r\\3PM\u001a\u001cX\r^!gi\u0016\u0014HK];oG\u0006$\u0018n\u001c8)\u0007\u001d\nY%\u0001\u0013uKN$h)\u001b:tiVs7\u000f^1cY\u0016|eMZ:fi\u00063G/\u001a:Fm&\u001cG/[8oQ\rA\u00131J\u0001\u0011i\u0016\u001cH\u000f\u0016:v]\u000e\fG/\u001a%fC\u0012D3!KA&\u0003=\"Xm\u001d;M_\u0006$gI]8n':\f\u0007o\u001d5piJ+Wn\u001c<fg:{gNU3uC&tW\r\u001a)s_\u0012,8-\u001a:tQ\rQ\u00131J\u0001\"i\u0016\u001cHoU6jaNs\u0017\r]:i_RLem\u00144gg\u0016$XK\\2iC:<W\r\u001a\u0015\u0004W\u0005-\u0013a\u0004;fgR\u001cF/\u0019:u\u001f\u001a47/\u001a;)\u00071\nY%\u0001\ruKN$\b+\u001b3FqBL'/\u0019;j_:$\u0016.\\3pkRDs!LA&\u0003C\nI+A\fuKN$h)\u001b:tiVs7\u000f^1cY\u0016|eMZ:fi\"\u001aa&a\u0013\u0002]Q,7\u000f\u001e)s_\u0012,8-\u001a:t/&$\bn\u00148h_&tw\r\u0016:b]N\f7\r^5p]N$uN\u001c;FqBL'/\u001a\u0015\u0004_\u0005-\u0013!\f;fgR\u001cV-];f]\u000e,gj\u001c;WC2LG-\u0019;fI\u001a{'o\u0012:pkBlU\r^1eCR\fGk\u001c9jG\"\u001a\u0001'a\u0013\u00029Q,7\u000f^(mI\u0016\u0003xn\u00195G_J\u001cuN\u001c;s_2\u0014VmY8sI\":\u0011'a\u0013\u0002b\u000558EAAx!\u0011\t9'!=\n\t\u0005M\u0018\u0011\u000e\u0002\u0018!J|G-^2fe\u001a+gnY3e\u000bb\u001cW\r\u001d;j_:\fa\u0003^3ti\u000e{wN\u001d3j]\u0006$xN\u001d$f]\u000eLgn\u001a\u0015\u0004e\u0005-\u0013\u0001\t;fgR\u001cun\u001c:eS:\fGo\u001c:GK:\u001cW\rZ!gi\u0016\u0014(+\u001a7pC\u0012DsaMA&\u0003C\nip\t\u0002\u0002\u0000B!\u0011q\rB\u0001\u0013\u0011\u0011\u0019!!\u001b\u0003KQ\u0013\u0018M\\:bGRLwN\\\"p_J$\u0017N\\1u_J4UM\\2fI\u0016C8-\u001a9uS>t\u0017!\b;fgRdu.\u00193Ge>lW)\u001c9usNs\u0017\r]:i_R4\u0015\u000e\\3)\u0007Q\nY%A\u0011uKN$Hj\\1e\rJ|W\u000e\u0016:v]\u000e\fG/\u001a3T]\u0006\u00048\u000f[8u\r&dW\rK\u00026\u0003\u0017\nq\u0004^3ti2{\u0017\r\u001a$s_6\u001cuN\u001d:vaR\u001cf.\u00199tQ>$h)\u001b7fQ\r1\u00141J\u0001\u001ci\u0016\u001cH/\u00119qK:$W)\u001c9us\u000e{g\u000e\u001e:pY\n\u000bGo\u00195)\u0007]\nY%A\u000euKN$Hj\\1e\rJ|WnQ8seV\u0004Ho\u00158baNDw\u000e\u001e\u000b\u0004G\ne\u0001b\u0002B\u000eq\u0001\u0007!QD\u0001\u0010[\u0006\\WMR5mK\u000e{'O];qiB1AMa\b\u0003$\rL1A!\tf\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0003&\t=RB\u0001B\u0014\u0015\u0011\u0011ICa\u000b\u0002\u0011\rD\u0017M\u001c8fYNT1A!\f^\u0003\rq\u0017n\\\u0005\u0005\u0005c\u00119CA\u0006GS2,7\t[1o]\u0016d\u0017AE1qa\u0016tG-\u00128e)btW*\u0019:lKJ$\u0002Ca\u000e\u0003D\t\u001d#\u0011\nB*\u0005G\u00129Ga\u001b\u0011\u000f\u0011\u0014ID!\u0010\u0002\b%\u0019!1H3\u0003\rQ+\b\u000f\\33!\r1&qH\u0005\u0004\u0005\u0003\u001a%\u0001D\"p[BdW\r^3e)bt\u0007B\u0002B#s\u0001\u0007a.A\u0004nCB\u0004\u0018N\\4\t\u000f\u0005\r\u0011\b1\u0001\u0002\b!9!1J\u001dA\u0002\t5\u0013!\u00049s_\u0012,8-\u001a:Fa>\u001c\u0007\u000eE\u0002e\u0005\u001fJ1A!\u0015f\u0005\u0015\u0019\u0006n\u001c:u\u0011\u001d\u0011)&\u000fa\u0001\u0005/\n1bY8oiJ|G\u000eV=qKB!!\u0011\fB0\u001b\t\u0011YFC\u0002\u0003^e\faA]3d_J$\u0017\u0002\u0002B1\u00057\u0012\u0011cQ8oiJ|GNU3d_J$G+\u001f9f\u0011\u001d\u0011)'\u000fa\u0001\u0003\u000f\taa\u001c4gg\u0016$\b\"\u0003B5sA\u0005\t\u0019AA\n\u0003A\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007\u000eC\u0005\u0003ne\u0002\n\u00111\u0001\u0002\b\u0005IA/[7fgR\fW\u000e]\u0001\u001dCB\u0004XM\u001c3F]\u0012$\u0006P\\'be.,'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011\u0019H\u000b\u0003\u0002\u0014\tU4F\u0001B<!\u0011\u0011IHa!\u000e\u0005\tm$\u0002\u0002B?\u0005\u007f\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u0005U-\u0001\u0006b]:|G/\u0019;j_:LAA!\"\u0003|\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00029\u0005\u0004\b/\u001a8e\u000b:$G\u000b\u001f8NCJ\\WM\u001d\u0013eK\u001a\fW\u000f\u001c;%oU\u0011!1\u0012\u0016\u0005\u0003\u000f\u0011)(\u0001\u0004baB,g\u000e\u001a\u000b\u0012G\nE%1\u0013BK\u0005/\u0013YJ!(\u0003 \n%\u0006\"\u00027=\u0001\u0004q\u0007bBA\u0002y\u0001\u0007\u0011q\u0001\u0005\b\u0005\u0017b\u0004\u0019\u0001B'\u0011\u001d\u0011I\n\u0010a\u0001\u0003'\t1a]3r\u0011\u001d\u0011)\u0007\u0010a\u0001\u0003\u000fA\u0011B!\u001c=!\u0003\u0005\r!a\u0002\t\u0013\t\u0005F\b%AA\u0002\t\r\u0016aD5t)J\fgn]1di&|g.\u00197\u0011\u0007\u0011\u0014)+C\u0002\u0003(\u0016\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0003,r\u0002\n\u00111\u0001\u0003$\u0006a\u0011n\u001d$s_6\u001cE.[3oi\u0006\u0001\u0012\r\u001d9f]\u0012$C-\u001a4bk2$HEN\u0001\u0011CB\u0004XM\u001c3%I\u00164\u0017-\u001e7uI]*\"Aa-+\t\t\r&QO\u0001\u0011CB\u0004XM\u001c3%I\u00164\u0017-\u001e7uIa\"Rb\u0019B]\u0005w\u0013iLa0\u0003B\n-\u0007\"\u00027A\u0001\u0004q\u0007bBA\u0002\u0001\u0002\u0007\u0011q\u0001\u0005\b\u0005\u0017\u0002\u0005\u0019\u0001B'\u0011\u001d\u0011)\u0007\u0011a\u0001\u0003\u000fAqAa1A\u0001\u0004\u0011)-A\u0003cCR\u001c\u0007\u000e\u0005\u0003\u0003Z\t\u001d\u0017\u0002\u0002Be\u00057\u00121BU3d_J$')\u0019;dQ\"9!1\u0016!A\u0002\t\r\u0016AF2veJ,g\u000e^*oCB\u001c\bn\u001c;PM\u001a\u001cX\r^:\u0016\u0005\tE\u0007C\u0002Bj\u0005;\f9!\u0004\u0002\u0003V*!!q\u001bBm\u0003%IW.\\;uC\ndWMC\u0002\u0003\\\u0016\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011yN!6\u0003\u0007M+G\u000f")
public class ProducerStateManagerTest
extends JUnitSuite {
    private File logDir = null;
    private ProducerStateManager stateManager = null;
    private final TopicPartition partition = new TopicPartition("test", 0);
    private final long producerId;
    private final int maxPidExpirationMs;
    private final MockTime time = new MockTime();

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public ProducerStateManager stateManager() {
        return this.stateManager;
    }

    public void stateManager_$eq(ProducerStateManager x$1) {
        this.stateManager = x$1;
    }

    public TopicPartition partition() {
        return this.partition;
    }

    public long producerId() {
        return this.producerId;
    }

    public int maxPidExpirationMs() {
        return this.maxPidExpirationMs;
    }

    public MockTime time() {
        return this.time;
    }

    @Before
    public void setUp() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.stateManager_$eq(new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs()));
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testBasicIdMapping() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, this.append$default$7(), this.append$default$8());
        this.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, this.append$default$7(), this.append$default$8()), ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        this.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.append(this.stateManager(), this.producerId(), epoch, 5, 0L, 2L, this.append$default$7(), this.append$default$8()), ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.append(this.stateManager(), this.producerId(), (short)(epoch + 1), 0, 0L, 3L, this.append$default$7(), this.append$default$8());
        this.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 4L, this.append$default$7(), this.append$default$8()), ClassTag$.MODULE$.apply(ProducerFencedException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
    }

    @Test
    public void testAppendTxnMarkerWithNoProducerState() {
        short producerEpoch = (short)2;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 27L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        ProducerStateEntry firstEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fail("Expected last entry to be defined", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91)));
        Assert.assertEquals((long)producerEpoch, (long)firstEntry.producerEpoch());
        Assert.assertEquals((long)this.producerId(), (long)firstEntry.producerId());
        Assert.assertEquals((long)-1L, (long)firstEntry.lastSeq());
        this.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.append(this.stateManager(), this.producerId(), (short)0, 0, 0L, 4L, this.append$default$7(), this.append$default$8()), ClassTag$.MODULE$.apply(ProducerFencedException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        this.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.append(this.stateManager(), this.producerId(), producerEpoch, 17, 0L, 4L, this.append$default$7(), this.append$default$8()), ClassTag$.MODULE$.apply(UnknownProducerIdException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, 39L, 4L, this.append$default$7(), this.append$default$8());
        ProducerStateEntry secondEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fail("Expected last entry to be defined", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109)));
        Assert.assertEquals((long)producerEpoch, (long)secondEntry.producerEpoch());
        Assert.assertEquals((long)this.producerId(), (long)secondEntry.producerId());
        Assert.assertEquals((long)0L, (long)secondEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = sequence;
        long x$5 = offset;
        boolean x$6 = false;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$7();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$8, x$6);
        this.append(this.stateManager(), this.producerId(), epoch, 0, offset + 500L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assert.assertEquals((long)epoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)0L, (long)lastEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWithWrapAroundBatchRecord() {
        short epoch = (short)15;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), false);
        appendInfo.append(epoch, 0x7FFFFFF5, 9, this.time().milliseconds(), 2000L, 2020L, false);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assert.assertEquals((long)0x7FFFFFF5L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)9L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)2000L, (long)lastEntry.firstOffset());
        Assert.assertEquals((long)2020L, (long)lastEntry.lastDataOffset());
    }

    @Test(expected=OutOfOrderSequenceException.class)
    public void testProducerSequenceInvalidWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = sequence;
        long x$5 = offset;
        boolean x$6 = false;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$7();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$8, x$6);
        this.append(this.stateManager(), this.producerId(), epoch, 1, offset + 500L, this.append$default$6(), this.append$default$7(), this.append$default$8());
    }

    @Test
    public void testNoValidationOnFirstEntryWhenLoadingLog() {
        short epoch = (short)5;
        int sequence = 16;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = sequence;
        long x$5 = offset;
        boolean x$6 = false;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$7();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$8, x$6);
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assert.assertEquals((long)epoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)sequence, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)sequence, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)offset, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((long)offset, (long)lastEntry.firstOffset());
    }

    @Test
    public void testControlRecordBumpsEpoch() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        short bumpedEpoch = (short)1;
        Tuple2<CompletedTxn, Object> tuple2 = this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        CompletedTxn completedTxn = (CompletedTxn)tuple2._1();
        long lastStableOffset = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)completedTxn, (Object)BoxesRunTime.boxToLong((long)lastStableOffset));
        Tuple2 tuple23 = tuple22;
        CompletedTxn completedTxn2 = (CompletedTxn)tuple23._1();
        long lastStableOffset2 = tuple23._2$mcJ$sp();
        Assert.assertEquals((long)1L, (long)completedTxn2.firstOffset());
        Assert.assertEquals((long)1L, (long)completedTxn2.lastOffset());
        Assert.assertEquals((long)2L, (long)lastStableOffset2);
        Assert.assertTrue((boolean)completedTxn2.isAborted());
        Assert.assertEquals((long)this.producerId(), (long)completedTxn2.producerId());
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assert.assertEquals((long)bumpedEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((long)-1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)-1L, (long)lastEntry.lastSeq());
        this.append(this.stateManager(), this.producerId(), bumpedEpoch, 0, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)this.stateManager().lastEntry(this.producerId()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.firstSeq())));
    }

    @Test
    public void testTxnFirstOffsetMetadataCached() {
        short producerEpoch = (short)0;
        long offset = 992342L;
        int seq = 0;
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.producerId(), ProducerStateEntry$.MODULE$.empty(this.producerId()), (ValidationType)ValidationType.Full$.MODULE$);
        producerAppendInfo.append(producerEpoch, seq, seq, this.time().milliseconds(), offset, offset, true);
        LogOffsetMetadata logOffsetMetadata = new LogOffsetMetadata(offset, 990000L, 234224);
        producerAppendInfo.maybeCacheTxnFirstOffsetMetadata(logOffsetMetadata);
        this.stateManager().update(producerAppendInfo);
        Assert.assertEquals((Object)new Some((Object)logOffsetMetadata), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testNonMatchingTxnFirstOffsetMetadataNotCached() {
        short producerEpoch = (short)0;
        long offset = 992342L;
        int seq = 0;
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.producerId(), ProducerStateEntry$.MODULE$.empty(this.producerId()), (ValidationType)ValidationType.Full$.MODULE$);
        producerAppendInfo.append(producerEpoch, seq, seq, this.time().milliseconds(), offset, offset, true);
        LogOffsetMetadata logOffsetMetadata = new LogOffsetMetadata(offset - 23429L, 990000L, 234224);
        producerAppendInfo.maybeCacheTxnFirstOffsetMetadata(logOffsetMetadata);
        this.stateManager().update(producerAppendInfo);
        Assert.assertEquals((Object)new Some((Object)new LogOffsetMetadata(offset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testPrepareUpdateDoesNotMutate() {
        short producerEpoch = (short)0;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), true);
        appendInfo.append(producerEpoch, 0, 5, this.time().milliseconds(), 15L, 20L, false);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerAppendInfo nextAppendInfo = this.stateManager().prepareUpdate(this.producerId(), true);
        nextAppendInfo.append(producerEpoch, 6, 10, this.time().milliseconds(), 26L, 30L, false);
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assert.assertEquals((long)0L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)5L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        this.stateManager().update(nextAppendInfo);
        lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assert.assertEquals((long)0L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)10L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
    }

    @Test
    public void updateProducerTransactionState() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 15;
        long offset = 9L;
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, offset, this.append$default$6(), this.append$default$7(), this.append$default$8());
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), true);
        appendInfo.append(producerEpoch, 1, 5, this.time().milliseconds(), 16L, 20L, true);
        ProducerStateEntry lastEntry = appendInfo.toEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)5L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)16L, (long)lastEntry.firstOffset());
        Assert.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)new .colon.colon((Object)new TxnMetadata(this.producerId(), 16L), (List)Nil$.MODULE$), (Object)appendInfo.startedTransactions());
        appendInfo.append(producerEpoch, 6, 10, this.time().milliseconds(), 26L, 30L, true);
        lastEntry = appendInfo.toEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)10L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)16L, (long)lastEntry.firstOffset());
        Assert.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)new .colon.colon((Object)new TxnMetadata(this.producerId(), 16L), (List)Nil$.MODULE$), (Object)appendInfo.startedTransactions());
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, coordinatorEpoch);
        CompletedTxn completedTxn = appendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, 40L, this.time().milliseconds());
        Assert.assertEquals((long)this.producerId(), (long)completedTxn.producerId());
        Assert.assertEquals((long)16L, (long)completedTxn.firstOffset());
        Assert.assertEquals((long)40L, (long)completedTxn.lastOffset());
        Assert.assertFalse((boolean)completedTxn.isAborted());
        lastEntry = appendInfo.toEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)10L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)16L, (long)lastEntry.firstOffset());
        Assert.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((long)coordinatorEpoch, (long)lastEntry.coordinatorEpoch());
        Assert.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)new .colon.colon((Object)new TxnMetadata(this.producerId(), 16L), (List)Nil$.MODULE$), (Object)appendInfo.startedTransactions());
    }

    @Test
    public void testOutOfSequenceAfterControlRecordEpochBump() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$8();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$6, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        short x$11 = epoch;
        int x$12 = 1;
        long x$13 = 1L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        boolean x$16 = this.append$default$8();
        this.append(x$9, x$10, x$11, x$12, x$13, x$15, x$14, x$16);
        short bumpedEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        this.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ProducerStateManager x$17 = this.stateManager();
            long x$18 = this.producerId();
            short x$19 = bumpedEpoch;
            int x$20 = 2;
            long x$21 = 2L;
            boolean x$22 = true;
            long x$23 = this.append$default$6();
            boolean x$24 = this.append$default$8();
            this.append(x$17, x$18, x$19, x$20, x$21, x$23, x$22, x$24);
        }, ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
        this.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ProducerStateManager x$25 = this.stateManager();
            long x$26 = this.producerId();
            short x$27 = (short)(bumpedEpoch + 1);
            int x$28 = 2;
            long x$29 = 2L;
            boolean x$30 = true;
            long x$31 = this.append$default$6();
            boolean x$32 = this.append$default$8();
            this.append(x$25, x$26, x$27, x$28, x$29, x$31, x$30, x$32);
        }, ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
        ProducerStateManager x$33 = this.stateManager();
        long x$34 = this.producerId();
        short x$35 = bumpedEpoch;
        int x$36 = 0;
        long x$37 = 0L;
        boolean x$38 = true;
        long x$39 = this.append$default$6();
        boolean x$40 = this.append$default$8();
        this.append(x$33, x$34, x$35, x$36, x$37, x$39, x$38, x$40);
        Assert.assertEquals((long)bumpedEpoch, (long)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).producerEpoch());
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastSeq());
    }

    @Test(expected=InvalidTxnStateException.class)
    public void testNonTransactionalAppendWithOngoingTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$8();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$6, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        short x$11 = epoch;
        int x$12 = 1;
        long x$13 = 1L;
        boolean x$14 = false;
        long x$15 = this.append$default$6();
        boolean x$16 = this.append$default$8();
        this.append(x$9, x$10, x$11, x$12, x$13, x$15, x$14, x$16);
    }

    @Test
    public void testTruncateAndReloadRemovesOutOfRangeSnapshots() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 3, 3L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 4, 4L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.stateManager().truncateAndReload(1L, 3L, this.time().milliseconds());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)this.stateManager().oldestSnapshotOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)3L)), (Object)this.stateManager().latestSnapshotOffset());
    }

    @Test
    public void testTakeSnapshot() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((String)"Directory doesn't contain a single file as expected", (long)1L, (long)this.logDir().list().length);
        Assert.assertTrue((String)"Snapshot file is empty", (((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().list())).head()).length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRecoverFromSnapshot() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        this.append(recoveredMapping, this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
    }

    @Test(expected=UnknownProducerIdException.class)
    public void testRemoveExpiredPidsOnReload() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        this.append(recoveredMapping, this.producerId(), epoch, 2, 2L, 70001L, this.append$default$7(), this.append$default$8());
    }

    @Test
    public void testAcceptAppendWithoutProducerStateOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        int sequence = 2;
        Assert.assertFalse((boolean)recoveredMapping.activeProducers().contains((Object)BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateManager x$1 = recoveredMapping;
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = sequence;
        long x$5 = 2L;
        long x$6 = 70001L;
        boolean x$7 = false;
        boolean x$8 = this.append$default$7();
        this.append(x$1, x$2, x$3, x$4, x$5, x$6, x$8, x$7);
        Assert.assertTrue((boolean)recoveredMapping.activeProducers().contains((Object)BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)Option$.MODULE$.option2Iterable(recoveredMapping.activeProducers().get((Object)BoxesRunTime.boxToLong((long)this.producerId()))).head();
        Assert.assertEquals((long)epoch, (long)producerStateEntry.producerEpoch());
        Assert.assertEquals((long)sequence, (long)producerStateEntry.firstSeq());
        Assert.assertEquals((long)sequence, (long)producerStateEntry.lastSeq());
    }

    @Test
    public void testAcceptAppendWithSequenceGapsOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        int outOfOrderSequence = 3;
        try {
            ProducerStateManager x$1 = this.stateManager();
            long x$2 = this.producerId();
            short x$3 = epoch;
            int x$4 = outOfOrderSequence;
            long x$5 = 1L;
            long x$6 = 1L;
            boolean x$7 = true;
            boolean x$8 = this.append$default$7();
            this.append(x$1, x$2, x$3, x$4, x$5, x$6, x$8, x$7);
            throw this.fail("Expected an OutOfOrderSequenceException to be raised.", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 438));
        }
        catch (OutOfOrderSequenceException outOfOrderSequenceException) {
        }
        catch (Exception exception) {
            throw this.fail("Expected an OutOfOrderSequenceException to be raised.", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 443));
        }
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)this.stateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)this.producerId()))).lastSeq());
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        short x$11 = epoch;
        int x$12 = outOfOrderSequence;
        long x$13 = 1L;
        long x$14 = 1L;
        boolean x$15 = false;
        boolean x$16 = this.append$default$7();
        this.append(x$9, x$10, x$11, x$12, x$13, x$14, x$16, x$15);
        Assert.assertEquals((long)outOfOrderSequence, (long)((ProducerStateEntry)this.stateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)this.producerId()))).lastSeq());
    }

    @Test
    public void testDeleteSnapshotsBefore() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(3L);
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(4L);
        Assert.assertEquals((long)0L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
    }

    @Test
    public void testTruncate() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().truncate();
        Assert.assertEquals((long)0L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testFirstUnstableOffsetAfterTruncation() {
        short epoch = (short)0;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$32 = epoch;
        int x$42 = sequence;
        long x$52 = 99L;
        boolean x$62 = true;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$8();
        this.append(x$1, x$2, x$32, x$42, x$52, x$7, x$62, x$8);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.messageOffset())));
        this.stateManager().takeSnapshot();
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 105L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        this.stateManager().onHighWatermarkUpdated(106L);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.messageOffset())));
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 106L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().truncateAndReload(0L, 106L, this.time().milliseconds());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.messageOffset())));
        this.stateManager().truncateAndReload(0L, 100L, this.time().milliseconds());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.messageOffset())));
    }

    @Test
    public void testFirstUnstableOffsetAfterEviction() {
        short epoch = (short)0;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = sequence;
        long x$5 = 99L;
        boolean x$6 = true;
        long x$72 = this.append$default$6();
        boolean x$82 = this.append$default$8();
        this.append(x$1, x$2, x$3, x$4, x$5, x$72, x$6, x$82);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.messageOffset())));
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = 2L;
        short x$11 = epoch;
        int x$12 = 0;
        long x$13 = 106L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        boolean x$16 = this.append$default$8();
        this.append(x$9, x$10, x$11, x$12, x$13, x$15, x$14, x$16);
        this.stateManager().truncateHead(100L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)106)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.messageOffset())));
    }

    @Test
    public void testTruncateHead() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        long anotherPid = 2L;
        this.append(this.stateManager(), anotherPid, epoch, 0, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), anotherPid, epoch, 1, 3L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4})), this.currentSnapshotOffsets());
        this.stateManager().truncateHead(2L);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4})), this.currentSnapshotOffsets());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{anotherPid})), (Object)this.stateManager().activeProducers().keySet());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        Option maybeEntry = this.stateManager().lastEntry(anotherPid);
        Assert.assertTrue((boolean)maybeEntry.isDefined());
        Assert.assertEquals((long)3L, (long)((ProducerStateEntry)maybeEntry.get()).lastDataOffset());
        this.stateManager().truncateHead(3L);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{anotherPid})), (Object)this.stateManager().activeProducers().keySet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4})), this.currentSnapshotOffsets());
        Assert.assertEquals((long)4L, (long)this.stateManager().mapEndOffset());
        this.stateManager().truncateHead(5L);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.stateManager().activeProducers().keySet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
        Assert.assertEquals((long)5L, (long)this.stateManager().mapEndOffset());
    }

    @Test
    public void testLoadFromSnapshotRemovesNonRetainedProducers() {
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        this.append(this.stateManager(), pid1, epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), pid2, epoch, 0, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.stateManager().activeProducers().size());
        this.stateManager().truncateAndReload(1L, 2L, this.time().milliseconds());
        Assert.assertEquals((long)1L, (long)this.stateManager().activeProducers().size());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(pid1));
        Option entry = this.stateManager().lastEntry(pid2);
        Assert.assertTrue((boolean)entry.isDefined());
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)entry.get()).lastSeq());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)entry.get()).lastDataOffset());
    }

    @Test
    public void testSkipSnapshotIfOffsetUnchanged() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testStartOffset() {
        short epoch = (short)0;
        long pid2 = 2L;
        this.append(this.stateManager(), pid2, epoch, 0, 0L, 1L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 0, 1L, 2L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 2L, 3L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 3L, 4L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
            recoveredMapping.truncateAndReload(0L, 1L, this.time().milliseconds());
            this.append(recoveredMapping, pid2, epoch, 1, 4L, 5L, this.append$default$7(), this.append$default$8());
        }, ClassTag$.MODULE$.apply(UnknownProducerIdException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 613));
    }

    @Test(expected=UnknownProducerIdException.class)
    public void testPidExpirationTimeout() {
        short epoch = (short)5;
        int sequence = 37;
        this.append(this.stateManager(), this.producerId(), epoch, sequence, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.time().sleep((long)(this.maxPidExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
    }

    @Test
    public void testFirstUnstableOffset() {
        short epoch = (short)5;
        int sequence = 0;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = sequence;
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$8();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$6, x$8);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.messageOffset())));
        long anotherPid = 2L;
        ProducerStateManager x$92 = this.stateManager();
        long x$102 = anotherPid;
        short x$112 = epoch;
        int x$122 = sequence;
        long x$132 = 105L;
        boolean x$142 = true;
        long x$152 = this.append$default$6();
        boolean x$16 = this.append$default$8();
        this.append(x$92, x$102, x$112, x$122, x$132, x$152, x$142, x$16);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.messageOffset())));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 109L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.messageOffset())));
        this.stateManager().onHighWatermarkUpdated(100L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.messageOffset())));
        this.stateManager().onHighWatermarkUpdated(110L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.messageOffset())));
        this.appendEndTxnMarker(this.stateManager(), anotherPid, epoch, ControlRecordType.ABORT, 112L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.messageOffset())));
        this.stateManager().onHighWatermarkUpdated(113L);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToLong((long)x$15.messageOffset())));
    }

    @Test
    public void testProducersWithOngoingTransactionsDontExpire() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = sequence;
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$8();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$6, x$8);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        this.time().sleep((long)(this.maxPidExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
    }

    @Test
    public void testSequenceNotValidatedForGroupMetadataTopic() {
        TopicPartition partition = new TopicPartition("__consumer_offsets", 0);
        ProducerStateManager stateManager = new ProducerStateManager(partition, this.logDir(), this.maxPidExpirationMs());
        short epoch = (short)0;
        ProducerStateManager x$1 = stateManager;
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = -1;
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$8();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$6, x$8);
        ProducerStateManager x$9 = stateManager;
        long x$10 = this.producerId();
        short x$11 = epoch;
        int x$12 = -1;
        long x$13 = 100L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        boolean x$16 = this.append$default$8();
        this.append(x$9, x$10, x$11, x$12, x$13, x$15, x$14, x$16);
    }

    @Test(expected=ProducerFencedException.class)
    public void testOldEpochForControlRecord() {
        short epoch = (short)5;
        int sequence = 0;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = sequence;
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$8();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$6, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)3, ControlRecordType.COMMIT, 100L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
    }

    @Test
    public void testCoordinatorFencing() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = sequence;
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$8();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$6, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        Option lastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)lastEntry.map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToInteger((int)x$16.coordinatorEpoch())));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 101L, 1, this.appendEndTxnMarker$default$7());
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 102L, 2, this.appendEndTxnMarker$default$7());
        try {
            this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 103L, 1, this.appendEndTxnMarker$default$7());
            throw this.fail("Expected coordinator to be fenced", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 724));
        }
        catch (TransactionCoordinatorFencedException e) {
            return;
        }
    }

    @Test(expected=TransactionCoordinatorFencedException.class)
    public void testCoordinatorFencedAfterReload() {
        short producerEpoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = producerEpoch;
        int x$4 = 0;
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$8();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$6, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 2L, 70000L);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 0, this.appendEndTxnMarker$default$7());
    }

    @Test
    public void testLoadFromEmptySnapshotFile() {
        this.testLoadFromCorruptSnapshot((Function1<FileChannel, BoxedUnit>)(Function1 & Serializable & scala.Serializable)file -> {
            file.truncate(0L);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testLoadFromTruncatedSnapshotFile() {
        this.testLoadFromCorruptSnapshot((Function1<FileChannel, BoxedUnit>)(Function1 & Serializable & scala.Serializable)file -> {
            ProducerStateManagerTest.$anonfun$testLoadFromTruncatedSnapshotFile$1(file);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testLoadFromCorruptSnapshotFile() {
        this.testLoadFromCorruptSnapshot((Function1<FileChannel, BoxedUnit>)(Function1 & Serializable & scala.Serializable)file -> {
            ProducerStateManagerTest.$anonfun$testLoadFromCorruptSnapshotFile$1(file);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAppendEmptyControlBatch() {
        long producerId = 23423L;
        short producerEpoch = (short)145;
        int baseOffset = 15;
        RecordBatch batch = (RecordBatch)EasyMock.createMock(RecordBatch.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.expect((Object)batch.iterator()).andReturn(Collections.emptyIterator()).once();
        EasyMock.replay((Object[])new Object[]{batch});
        this.append(this.stateManager(), producerId, producerEpoch, baseOffset, batch, true);
        Assert.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)this.stateManager().lastEntry(producerId).get()).currentTxnFirstOffset());
    }

    private void testLoadFromCorruptSnapshot(Function1<FileChannel, BoxedUnit> makeFileCorrupt) {
        short epoch = (short)0;
        long producerId = 1L;
        this.append(this.stateManager(), producerId, epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), producerId, epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Option latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)latestSnapshotOffset);
        File snapshotToTruncate = Log$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)latestSnapshotOffset.get()));
        try (FileChannel channel = FileChannel.open(snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            makeFileCorrupt.apply((Object)channel);
        }
        ProducerStateManager reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assert.assertFalse((boolean)snapshotToTruncate.exists());
        ProducerStateEntry loadedProducerState = (ProducerStateEntry)reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)producerId));
        Assert.assertEquals((long)0L, (long)loadedProducerState.lastDataOffset());
    }

    private Tuple2<CompletedTxn, Object> appendEndTxnMarker(ProducerStateManager mapping, long producerId, short producerEpoch, ControlRecordType controlType, long offset, int coordinatorEpoch, long timestamp) {
        ProducerAppendInfo producerAppendInfo = this.stateManager().prepareUpdate(producerId, true);
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlType, coordinatorEpoch);
        CompletedTxn completedTxn = producerAppendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, offset, timestamp);
        mapping.update(producerAppendInfo);
        long lastStableOffset = mapping.completeTxn(completedTxn);
        mapping.updateMapEndOffset(offset + 1L);
        return new Tuple2((Object)completedTxn, (Object)BoxesRunTime.boxToLong((long)lastStableOffset));
    }

    private void append(ProducerStateManager stateManager, long producerId, short producerEpoch, int seq, long offset, long timestamp, boolean isTransactional, boolean isFromClient) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, isFromClient);
        producerAppendInfo.append(producerEpoch, seq, seq, timestamp, offset, offset, isTransactional);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private void append(ProducerStateManager stateManager, long producerId, short producerEpoch, long offset, RecordBatch batch, boolean isFromClient) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, isFromClient);
        producerAppendInfo.append(batch);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private int appendEndTxnMarker$default$6() {
        return 0;
    }

    private long appendEndTxnMarker$default$7() {
        return this.time().milliseconds();
    }

    private long append$default$6() {
        return this.time().milliseconds();
    }

    private boolean append$default$7() {
        return false;
    }

    private boolean append$default$8() {
        return true;
    }

    private Set<Object> currentSnapshotOffsets() {
        return new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).map((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFile(file)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).toSet();
    }

    public static final /* synthetic */ void $anonfun$testLoadFromTruncatedSnapshotFile$1(FileChannel file) {
        Assert.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.truncate(file.size() / 2L);
    }

    public static final /* synthetic */ void $anonfun$testLoadFromCorruptSnapshotFile$1(FileChannel file) {
        Assert.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.write(ByteBuffer.wrap((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{37}), ClassTag$.MODULE$.Byte())), file.size() / 2L);
    }

    public ProducerStateManagerTest() {
        this.producerId = 1L;
        this.maxPidExpirationMs = 60000;
    }
}

