/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import kafka.log.AbortedTxn;
import kafka.log.BatchMetadata;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.log.LogSegment$;
import kafka.log.LogUtils$;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateManager;
import kafka.log.ProducerStateManager$;
import kafka.log.RollParams;
import kafka.server.FetchDataInfo;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\ra\u0001\u0002\u0015*\u00019BQ!\u000e\u0001\u0005\u0002YBq!\u000f\u0001C\u0002\u0013\u0005!\b\u0003\u0004G\u0001\u0001\u0006Ia\u000f\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0011\u0019!\u0006\u0001)A\u0005\u0013\"IQ\u000b\u0001a\u0001\u0002\u0004%\tA\u0016\u0005\n?\u0002\u0001\r\u00111A\u0005\u0002\u0001D\u0011B\u001a\u0001A\u0002\u0003\u0005\u000b\u0015B,\t\u000b\u001d\u0004A\u0011\u00015\t\u000fm\u0004\u0011\u0013!C\u0001y\"I\u0011q\u0002\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0003\u0005\b\u0003+\u0001A\u0011AA\f\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000fBq!a\u0016\u0001\t\u0003\t9\u0005C\u0004\u0002b\u0001!\t!a\u0012\t\u000f\u0005-\u0004\u0001\"\u0001\u0002H!9\u0011q\u000e\u0001\u0005\u0002\u0005\u001d\u0003bBA:\u0001\u0011\u0005\u0011q\t\u0005\b\u0003o\u0002A\u0011AA$\u0011\u001d\tY\b\u0001C\u0001\u0003\u000fBq!a \u0001\t\u0003\t9\u0005C\u0004\u0002\u0004\u0002!\t!a\u0012\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002H!9\u00111\u0012\u0001\u0005\u0002\u0005\u001d\u0003bBAH\u0001\u0011\u0005\u0011q\t\u0005\b\u0003'\u0003A\u0011AA$\u0011\u001d\t9\n\u0001C\u0001\u0003\u000fBq!a'\u0001\t\u0003\t9\u0005C\u0004\u0002 \u0002!I!!)\t\u0011\u0005%\u0007!%A\u0005\nqD\u0001\"a3\u0001#\u0003%I\u0001 \u0005\n\u0003\u001b\u0004\u0011\u0013!C\u0005\u0003\u001fDq!a5\u0001\t\u0003\t9\u0005C\u0004\u0002X\u0002!\t!a\u0012\t\r\u001d\u0004A\u0011BAn\u0011\u001d\t\u0019\u0010\u0001C\u0001\u0003\u000fBq!a>\u0001\t\u0003\t9\u0005C\u0004\u0002|\u0002!\t!a\u0012\t\u000f\u0005}\b\u0001\"\u0001\u0002H\tqAj\\4TK\u001elWM\u001c;UKN$(B\u0001\u0016,\u0003\rawn\u001a\u0006\u0002Y\u0005)1.\u00194lC\u000e\u00011C\u0001\u00010!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u000e\t\u0003q\u0001i\u0011!K\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o+\u0005Y\u0004C\u0001\u001fE\u001b\u0005i$B\u0001 @\u0003\u0019\u0019w.\\7p]*\u0011A\u0006\u0011\u0006\u0003\u0003\n\u000ba!\u00199bG\",'\"A\"\u0002\u0007=\u0014x-\u0003\u0002F{\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0011\u0002\u0011M,w-\\3oiN,\u0012!\u0013\t\u0004\u0015>\u000bV\"A&\u000b\u00051k\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0003\u001dF\n!bY8mY\u0016\u001cG/[8o\u0013\t\u00016JA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bC\u0001\u001dS\u0013\t\u0019\u0016F\u0001\u0006M_\u001e\u001cVmZ7f]R\f\u0011b]3h[\u0016tGo\u001d\u0011\u0002\r1|w\rR5s+\u00059\u0006C\u0001-^\u001b\u0005I&B\u0001.\\\u0003\tIwNC\u0001]\u0003\u0011Q\u0017M^1\n\u0005yK&\u0001\u0002$jY\u0016\f!\u0002\\8h\t&\u0014x\fJ3r)\t\tG\r\u0005\u00021E&\u00111-\r\u0002\u0005+:LG\u000fC\u0004f\u000f\u0005\u0005\t\u0019A,\u0002\u0007a$\u0013'A\u0004m_\u001e$\u0015N\u001d\u0011\u0002\u001b\r\u0014X-\u0019;f'\u0016<W.\u001a8u)\u0011\t\u0016N\\:\t\u000b)L\u0001\u0019A6\u0002\r=4gm]3u!\t\u0001D.\u0003\u0002nc\t!Aj\u001c8h\u0011\u001dy\u0017\u0002%AA\u0002A\f!#\u001b8eKbLe\u000e^3sm\u0006d')\u001f;fgB\u0011\u0001']\u0005\u0003eF\u00121!\u00138u\u0011\u001d!\u0018\u0002%AA\u0002U\fA\u0001^5nKB\u0011a/_\u0007\u0002o*\u0011\u00010P\u0001\u0006kRLGn]\u0005\u0003u^\u0014A\u0001V5nK\u000692M]3bi\u0016\u001cVmZ7f]R$C-\u001a4bk2$HEM\u000b\u0002{*\u0012\u0001O`\u0016\u0002\u007fB!\u0011\u0011AA\u0006\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011!C;oG\",7m[3e\u0015\r\tI!M\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0007\u0003\u0007\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003]\u0019'/Z1uKN+w-\\3oi\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u0014)\u0012QO`\u0001\be\u0016\u001cwN\u001d3t)\u0019\tI\"!\n\u0002(A!\u00111DA\u0011\u001b\t\tiBC\u0002\u0002 u\naA]3d_J$\u0017\u0002BA\u0012\u0003;\u0011Q\"T3n_JL(+Z2pe\u0012\u001c\b\"\u00026\r\u0001\u0004Y\u0007bBA\u000b\u0019\u0001\u0007\u0011\u0011\u0006\t\u0006a\u0005-\u0012qF\u0005\u0004\u0003[\t$A\u0003\u001fsKB,\u0017\r^3e}A!\u0011\u0011GA \u001d\u0011\t\u0019$a\u000f\u0011\u0007\u0005U\u0012'\u0004\u0002\u00028)\u0019\u0011\u0011H\u0017\u0002\rq\u0012xn\u001c;?\u0013\r\ti$M\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00131\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005u\u0012'A\u0003tKR,\b\u000fF\u0001bQ\ri\u00111\n\t\u0005\u0003\u001b\n\u0019&\u0004\u0002\u0002P)\u0019\u0011\u0011\u000b\"\u0002\u000b),h.\u001b;\n\t\u0005U\u0013q\n\u0002\u0007\u0005\u00164wN]3\u0002\u0011Q,\u0017M\u001d3po:D3ADA.!\u0011\ti%!\u0018\n\t\u0005}\u0013q\n\u0002\u0006\u0003\u001a$XM]\u0001\u0017i\u0016\u001cHOU3bI>sW)\u001c9usN+w-\\3oi\"\u001aq\"!\u001a\u0011\t\u00055\u0013qM\u0005\u0005\u0003S\nyE\u0001\u0003UKN$\u0018!\u0007;fgR\u0014V-\u00193CK\u001a|'/\u001a$jeN$xJ\u001a4tKRD3\u0001EA3\u00035!Xm\u001d;NCb|eMZ:fi\"\u001a\u0011#!\u001a\u0002#Q,7\u000f\u001e*fC\u0012\fe\r^3s\u0019\u0006\u001cH\u000fK\u0002\u0013\u0003K\nq\u0002^3tiJ+\u0017\r\u001a$s_6<\u0015\r\u001d\u0015\u0004'\u0005\u0015\u0014\u0001\u0004;fgR$&/\u001e8dCR,\u0007f\u0001\u000b\u0002f\u0005AB/Z:u)J,hnY1uK\u0016k\u0007\u000f^=TK\u001elWM\u001c;)\u0007U\t)'\u0001\u001cuKN$(+\u001a7pC\u0012d\u0015M]4fgR$\u0016.\\3ti\u0006l\u0007/\u00118e\u001d\u0016DHo\u00144gg\u0016$\u0018I\u001a;feR\u0013XO\\2bi&|g\u000eK\u0002\u0017\u0003K\n\u0001\u0003^3tiR\u0013XO\\2bi\u00164U\u000f\u001c7)\u0007]\t)'A\ruKN$h)\u001b8e\u001f\u001a47/\u001a;CsRKW.Z:uC6\u0004\bf\u0001\r\u0002f\u0005IB/Z:u\u001d\u0016DHo\u00144gg\u0016$8)\u00197dk2\fG/[8oQ\rI\u0012QM\u0001\u0017i\u0016\u001cHo\u00115b]\u001e,g)\u001b7f'V4g-\u001b=fg\"\u001a!$!\u001a\u0002;Q,7\u000f\u001e*fG>4XM]=GSb,7oQ8seV\u0004H/\u00138eKbD3aGA3\u0003m!Xm\u001d;SK\u000e|g/\u001a:Ue\u0006t7/Y2uS>t\u0017J\u001c3fq\"\u001aA$!\u001a\u0002\u001b\u0015tG\r\u0016=o%\u0016\u001cwN\u001d3t)A\tI\"a)\u0002.\u0006E\u00161XA_\u0003\u0003\f)\rC\u0004\u0002&v\u0001\r!a*\u0002#\r|g\u000e\u001e:pYJ+7m\u001c:e)f\u0004X\r\u0005\u0003\u0002\u001c\u0005%\u0016\u0002BAV\u0003;\u0011\u0011cQ8oiJ|GNU3d_J$G+\u001f9f\u0011\u0019\ty+\ba\u0001W\u0006Q\u0001O]8ek\u000e,'/\u00133\t\u000f\u0005MV\u00041\u0001\u00026\u0006i\u0001O]8ek\u000e,'/\u00129pG\"\u00042\u0001MA\\\u0013\r\tI,\r\u0002\u0006'\"|'\u000f\u001e\u0005\u0006Uv\u0001\ra\u001b\u0005\t\u0003\u007fk\u0002\u0013!a\u0001a\u0006!\u0002/\u0019:uSRLwN\u001c'fC\u0012,'/\u00129pG\"D\u0001\"a1\u001e!\u0003\u0005\r\u0001]\u0001\u0011G>|'\u000fZ5oCR|'/\u00129pG\"D\u0001\"a2\u001e!\u0003\u0005\ra[\u0001\ni&lWm\u001d;b[B\fq#\u001a8e)bt'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0002/\u0015tG\r\u0016=o%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u00122\u0014aF3oIRChNU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00138+\t\t\tN\u000b\u0002l}\u0006\tC/Z:u%\u0016\u001cwN^3ss\u001aK\u00070Z:D_J\u0014X\u000f\u001d;US6,\u0017J\u001c3fq\"\u001a\u0011%!\u001a\u0002=Q,7\u000f\u001e*fG>4XM]=XSRD7i\u001c:skB$X*Z:tC\u001e,\u0007f\u0001\u0012\u0002fQI\u0011+!8\u0002b\u0006-\u0018q\u001e\u0005\u0007\u0003?\u001c\u0003\u0019A6\u0002\u0015\t\f7/Z(gMN,G\u000fC\u0004\u0002d\u000e\u0002\r!!:\u0002#\u0019LG.Z!me\u0016\fG-_#ySN$8\u000fE\u00021\u0003OL1!!;2\u0005\u001d\u0011un\u001c7fC:Da!!<$\u0001\u0004\u0001\u0018\u0001D5oSR4\u0015\u000e\\3TSj,\u0007bBAyG\u0001\u0007\u0011Q]\u0001\faJ,\u0017\r\u001c7pG\u0006$X-A\u0014uKN$8I]3bi\u0016<\u0016\u000e\u001e5J]&$h)\u001b7f'&TX-\u00119qK:$W*Z:tC\u001e,\u0007f\u0001\u0013\u0002f\u00059C/Z:u\u0007J,\u0017\r^3XSRD\u0017J\\5u\r&dWmU5{K\u000ecW-\u0019:TQV$Hm\\<oQ\r)\u0013QM\u0001/g\"|W\u000f\u001c3UeVt7-\u0019;f\u000bZ,g.\u00134PM\u001a\u001cX\r\u001e)pS:$8\u000fV8B\u000f\u0006\u0004\u0018J\u001c+iK2{w\rK\u0002'\u0003K\n!\u0003^3ti\u0006\u0003\b/\u001a8e\rJ|WNR5mK\"\u001aq%!\u001a")
public class LogSegmentTest {
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final ArrayBuffer<LogSegment> segments = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private File logDir;

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public ArrayBuffer<LogSegment> segments() {
        return this.segments;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogSegment createSegment(long offset, int indexIntervalBytes, Time time) {
        LogSegment seg = LogUtils$.MODULE$.createSegment(offset, this.logDir(), indexIntervalBytes, time);
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public MemoryRecords records(long offset, Seq<String> records) {
        return MemoryRecords.withRecords((byte)1, (long)offset, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])((SimpleRecord[])((TraversableOnce)records.map((Function1 & Serializable & scala.Serializable)s -> new SimpleRecord(offset * 10L, s.getBytes()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
    }

    @Before
    public void setup() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
    }

    @After
    public void teardown() {
        this.segments().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testReadOnEmptySegment() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        long x$1 = 40L;
        int x$2 = 300;
        None$ x$3 = None$.MODULE$;
        long x$4 = seg.read$default$4();
        boolean x$5 = seg.read$default$5();
        FetchDataInfo read = seg.read(x$1, (Option)x$3, x$2, x$4, x$5);
        Assert.assertNull((String)"Read beyond the last offset in the segment should be null", (Object)read);
    }

    @Test
    public void testReadBeforeFirstOffset() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "little", "bee"}));
        seg.append(53L, -1L, -1L, ms);
        long x$1 = 41L;
        int x$2 = 300;
        None$ x$3 = None$.MODULE$;
        long x$4 = seg.read$default$4();
        boolean x$5 = seg.read$default$5();
        Records read = seg.read(x$1, (Option)x$3, x$2, x$4, x$5).records();
        TestUtils$.MODULE$.checkEquals(ms.records().iterator(), read.records().iterator());
    }

    @Test
    public void testMaxOffset() {
        int baseOffset = 50;
        LogSegment seg = this.createSegment(baseOffset, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(baseOffset, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "beautiful"}));
        seg.append(52L, -1L, -1L, ms);
        LogSegmentTest.validate$1(50L, ms, seg);
        LogSegmentTest.validate$1(51L, ms, seg);
        LogSegmentTest.validate$1(52L, ms, seg);
    }

    @Test
    public void testReadAfterLast() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        long x$1 = 52L;
        int x$2 = 200;
        None$ x$3 = None$.MODULE$;
        long x$4 = seg.read$default$4();
        boolean x$5 = seg.read$default$5();
        FetchDataInfo read = seg.read(x$1, (Option)x$3, x$2, x$4, x$5);
        Assert.assertNull((String)"Read beyond the last offset in the segment should give null", (Object)read);
    }

    @Test
    public void testReadFromGap() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        long x$1 = 55L;
        int x$2 = 200;
        None$ x$3 = None$.MODULE$;
        long x$4 = seg.read$default$4();
        boolean x$5 = seg.read$default$5();
        FetchDataInfo read = seg.read(x$1, (Option)x$3, x$2, x$4, x$5);
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records().records().iterator());
    }

    @Test
    public void testTruncate() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        IntRef offset = IntRef.create((int)40);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 30).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            MemoryRecords ms1 = this.records(offset$3.elem, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
            seg.append((long)offset$3.elem, -1L, -1L, ms1);
            MemoryRecords ms2 = this.records(offset$3.elem + 1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
            seg.append((long)(offset$3.elem + 1), -1L, -1L, ms2);
            FetchDataInfo read = seg.read((long)offset$3.elem, (Option)None$.MODULE$, 10000, seg.read$default$4(), seg.read$default$5());
            Assert.assertEquals((Object)new .colon.colon((Object)((Record)ms1.records().iterator().next()), (List)new .colon.colon((Object)((Record)ms2.records().iterator().next()), (List)Nil$.MODULE$)), (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(read.records().records()).asScala()).toList());
            seg.truncateTo((long)(offset$3.elem + 1));
            FetchDataInfo read2 = seg.read((long)offset$3.elem, (Option)None$.MODULE$, 10000, seg.read$default$4(), seg.read$default$5());
            Assert.assertEquals((long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(read2.records().records()).asScala()).size());
            TestUtils$.MODULE$.checkEquals(ms1.records().iterator(), read2.records().records().iterator());
            ++offset$3.elem;
        });
    }

    @Test
    public void testTruncateEmptySegment() {
        int maxSegmentMs = 300000;
        MockTime time = new MockTime();
        long x$1 = 0L;
        MockTime x$2 = time;
        int x$3 = this.createSegment$default$2();
        LogSegment seg = this.createSegment(x$1, x$3, (Time)x$2);
        seg.close();
        long x$4 = 0L;
        MockTime x$5 = time;
        int x$6 = this.createSegment$default$2();
        LogSegment reopened = this.createSegment(x$4, x$6, (Time)x$5);
        Assert.assertEquals((long)0L, (long)seg.timeIndex().sizeInBytes());
        Assert.assertEquals((long)0L, (long)seg.offsetIndex().sizeInBytes());
        time.sleep(500L);
        reopened.truncateTo(57L);
        Assert.assertEquals((long)0L, (long)reopened.timeWaitedForRoll(time.milliseconds(), -1L));
        Assert.assertFalse((boolean)reopened.timeIndex().isFull());
        Assert.assertFalse((boolean)reopened.offsetIndex().isFull());
        RollParams rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, 100L, 1024, time.milliseconds());
        Assert.assertFalse((boolean)reopened.shouldRoll(rollParams));
        time.sleep((long)(maxSegmentMs + 1));
        Assert.assertEquals((long)(maxSegmentMs + 1), (long)reopened.timeWaitedForRoll(time.milliseconds(), -1L));
        rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, 100L, 1024, time.milliseconds());
        Assert.assertFalse((boolean)reopened.shouldRoll(rollParams));
        rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, (long)Integer.MAX_VALUE + 200L, 1024, time.milliseconds());
        Assert.assertTrue((boolean)reopened.shouldRoll(rollParams));
    }

    @Test
    public void testReloadLargestTimestampAndNextOffsetAfterTruncation() {
        int numMessages = 30;
        LogSegment seg = this.createSegment(40L, 2 * this.records(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})).sizeInBytes() - 1, this.createSegment$default$3());
        IntRef offset = IntRef.create((int)40);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            seg.append((long)offset$4.elem, (long)offset$4.elem, (long)offset$4.elem, this.records(offset$4.elem, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})));
            ++offset$4.elem;
        });
        Assert.assertEquals((long)offset.elem, (long)seg.readNextOffset());
        int expectedNumEntries = numMessages / 2 - 1;
        Assert.assertEquals((String)new StringBuilder(25).append("Should have ").append(expectedNumEntries).append(" time indexes").toString(), (long)expectedNumEntries, (long)seg.timeIndex().entries());
        seg.truncateTo(41L);
        Assert.assertEquals((String)"Should have 0 time indexes", (long)0L, (long)seg.timeIndex().entries());
        Assert.assertEquals((String)"Largest timestamp should be 400", (long)400L, (long)seg.largestTimestamp());
        Assert.assertEquals((long)41L, (long)seg.readNextOffset());
    }

    @Test
    public void testTruncateFull() {
        MockTime time = new MockTime();
        long x$1 = 40L;
        MockTime x$2 = time;
        int x$3 = this.createSegment$default$2();
        LogSegment seg = this.createSegment(x$1, x$3, (Time)x$2);
        seg.append(41L, -1L, -1L, this.records(40L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
        time.sleep(500L);
        Assert.assertEquals((long)500L, (long)seg.timeWaitedForRoll(time.milliseconds(), -1L));
        seg.truncateTo(0L);
        Assert.assertEquals((long)0L, (long)seg.timeWaitedForRoll(time.milliseconds(), -1L));
        Assert.assertFalse((boolean)seg.timeIndex().isFull());
        Assert.assertFalse((boolean)seg.offsetIndex().isFull());
        Assert.assertNull((String)"Segment should be empty.", (Object)seg.read(0L, (Option)None$.MODULE$, 1024, seg.read$default$4(), seg.read$default$5()));
        seg.append(41L, -1L, -1L, this.records(40L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
    }

    @Test
    public void testFindOffsetByTimestamp() {
        int messageSize = this.records(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"msg00"})).sizeInBytes();
        LogSegment seg = this.createSegment(40L, messageSize * 2 - 1, this.createSegment$default$3());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(40), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> seg.append((long)i, (long)(i * 10), (long)i, this.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(3).append("msg").append(i).toString()}))));
        Assert.assertEquals((long)490L, (long)seg.largestTimestamp());
        Assert.assertEquals((long)42L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)420L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assert.assertEquals((long)43L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)421L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assert.assertEquals((long)43L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)430L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assert.assertEquals((long)44L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)431L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assert.assertEquals((Object)None$.MODULE$, (Object)seg.findOffsetByTimestamp(491L, seg.findOffsetByTimestamp$default$2()));
        Assert.assertEquals((long)41L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)401L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assert.assertEquals((long)40L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)399L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
    }

    @Test
    public void testNextOffsetCalculation() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        Assert.assertEquals((long)40L, (long)seg.readNextOffset());
        seg.append(52L, -1L, -1L, this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "you"})));
        Assert.assertEquals((long)53L, (long)seg.readNextOffset());
    }

    @Test
    public void testChangeFileSuffixes() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        File logFile = seg.log().file();
        File indexFile = seg.offsetIndex().file();
        seg.changeFileSuffixes("", ".deleted");
        Assert.assertEquals((Object)new StringBuilder(8).append(logFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.log().file().getAbsolutePath());
        Assert.assertEquals((Object)new StringBuilder(8).append(indexFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.offsetIndex().file().getAbsolutePath());
        Assert.assertTrue((boolean)seg.log().file().exists());
        Assert.assertTrue((boolean)seg.offsetIndex().file().exists());
    }

    @Test
    public void testRecoveryFixesCorruptIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> seg.append((long)i, -1L, -1L, this.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)i)).toString()}))));
        File indexFile = seg.offsetIndex().file();
        TestUtils$.MODULE$.writeNonsenseToFile(indexFile, 5L, (int)indexFile.length());
        seg.recover(new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3()), seg.recover$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assert.assertEquals((long)i, (long)((Record)seg.read((long)i, (Option)new Some((Object)BoxesRunTime.boxToLong((long)(i + 1))), 1024, seg.read$default$4(), seg.read$default$5()).records().records().iterator().next()).offset()));
    }

    @Test
    public void testRecoverTransactionIndex() {
        LogSegment segment = this.createSegment(100L, this.createSegment$default$2(), this.createSegment$default$3());
        short producerEpoch = (short)0;
        int partitionLeaderEpoch = 15;
        int sequence = 100;
        long pid1 = 5L;
        long pid2 = 10L;
        segment.append(101L, -1L, 100L, MemoryRecords.withTransactionalRecords((long)100L, (CompressionType)CompressionType.NONE, (long)pid1, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(103L, -1L, 102L, MemoryRecords.withTransactionalRecords((long)102L, (CompressionType)CompressionType.NONE, (long)pid2, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(105L, -1L, 104L, MemoryRecords.withRecords((long)104L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(partitionLeaderEpoch), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(106L, -1L, 106L, this.endTxnRecords(ControlRecordType.ABORT, pid2, producerEpoch, 106L, this.endTxnRecords$default$5(), this.endTxnRecords$default$6(), this.endTxnRecords$default$7()));
        segment.append(107L, -1L, 107L, this.endTxnRecords(ControlRecordType.COMMIT, pid1, producerEpoch, 107L, this.endTxnRecords$default$5(), this.endTxnRecords$default$6(), this.endTxnRecords$default$7()));
        ProducerStateManager stateManager = new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3());
        segment.recover(stateManager, segment.recover$default$2());
        Assert.assertEquals((long)108L, (long)stateManager.mapEndOffset());
        List abortedTxns = segment.txnIndex().allAbortedTxns();
        Assert.assertEquals((long)1L, (long)abortedTxns.size());
        AbortedTxn abortedTxn = (AbortedTxn)abortedTxns.head();
        Assert.assertEquals((long)pid2, (long)abortedTxn.producerId());
        Assert.assertEquals((long)102L, (long)abortedTxn.firstOffset());
        Assert.assertEquals((long)106L, (long)abortedTxn.lastOffset());
        Assert.assertEquals((long)100L, (long)abortedTxn.lastStableOffset());
        stateManager = new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3());
        stateManager.loadProducerEntry(new ProducerStateEntry(pid2, (Queue)Queue$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BatchMetadata[]{new BatchMetadata(10, 10L, 5, -1L)})), producerEpoch, 0, (Option)new Some((Object)BoxesRunTime.boxToLong((long)75L))));
        segment.recover(stateManager, segment.recover$default$2());
        Assert.assertEquals((long)108L, (long)stateManager.mapEndOffset());
        abortedTxns = segment.txnIndex().allAbortedTxns();
        Assert.assertEquals((long)1L, (long)abortedTxns.size());
        abortedTxn = (AbortedTxn)abortedTxns.head();
        Assert.assertEquals((long)pid2, (long)abortedTxn.producerId());
        Assert.assertEquals((long)75L, (long)abortedTxn.firstOffset());
        Assert.assertEquals((long)106L, (long)abortedTxn.lastOffset());
        Assert.assertEquals((long)100L, (long)abortedTxn.lastStableOffset());
    }

    private MemoryRecords endTxnRecords(ControlRecordType controlRecordType, long producerId, short producerEpoch, long offset, int partitionLeaderEpoch, int coordinatorEpoch, long timestamp) {
        EndTransactionMarker marker = new EndTransactionMarker(controlRecordType, coordinatorEpoch);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)partitionLeaderEpoch, (long)producerId, (short)producerEpoch, (EndTransactionMarker)marker);
    }

    private int endTxnRecords$default$5() {
        return 0;
    }

    private int endTxnRecords$default$6() {
        return 0;
    }

    private long endTxnRecords$default$7() {
        return -1L;
    }

    @Test
    public void testRecoveryFixesCorruptTimeIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> seg.append((long)i, (long)(i * 10), (long)i, this.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)i)).toString()}))));
        File timeIndexFile = seg.timeIndex().file();
        TestUtils$.MODULE$.writeNonsenseToFile(timeIndexFile, 5L, (int)timeIndexFile.length());
        seg.recover(new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3()), seg.recover$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            block0: {
                Assert.assertEquals((long)i, (long)((FileRecords.TimestampAndOffset)seg$6.findOffsetByTimestamp((long)((long)(i * 10)), (long)seg$6.findOffsetByTimestamp$default$2()).get()).offset);
                if (i >= 99) break block0;
                Assert.assertEquals((long)(i + 1), (long)((FileRecords.TimestampAndOffset)seg$6.findOffsetByTimestamp((long)((long)(i * 10 + 1)), (long)seg$6.findOffsetByTimestamp$default$2()).get()).offset);
            }
        });
    }

    @Test
    public void testRecoveryWithCorruptMessage() {
        int messagesAppended = 20;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), messagesAppended).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> seg.append((long)i, -1L, -1L, this.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)i)).toString()}))));
            int offsetToBeginCorruption = TestUtils$.MODULE$.random().nextInt(messagesAppended);
            FileRecords.LogOffsetPosition recordPosition = seg.log().searchForOffsetWithSize((long)offsetToBeginCorruption, 0);
            int position = recordPosition.position + TestUtils$.MODULE$.random().nextInt(15);
            TestUtils$.MODULE$.writeNonsenseToFile(seg.log().file(), position, (int)(seg.log().file().length() - (long)position));
            seg.recover(new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3()), seg.recover$default$2());
            Assert.assertEquals((String)"Should have truncated off bad messages.", (Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), offsetToBeginCorruption).toList(), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(seg.log().batches()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.lastOffset()), Iterable$.MODULE$.canBuildFrom())).toList());
            seg.deleteIfExists();
        });
    }

    private LogSegment createSegment(long baseOffset, boolean fileAlreadyExists, int initFileSize, boolean preallocate) {
        File tempDir = TestUtils$.MODULE$.tempDir();
        LogConfig logConfig = new LogConfig((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.IndexIntervalBytesProp()), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentIndexBytesProp()), (Object)BoxesRunTime.boxToInteger((int)1000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentJitterMsProp()), (Object)BoxesRunTime.boxToInteger((int)0))}))).asJava(), LogConfig$.MODULE$.apply$default$2());
        LogSegment seg = LogSegment$.MODULE$.open(tempDir, baseOffset, logConfig, Time.SYSTEM, fileAlreadyExists, initFileSize, preallocate, LogSegment$.MODULE$.open$default$8());
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public int createSegment$default$2() {
        return 10;
    }

    public Time createSegment$default$3() {
        return Time.SYSTEM;
    }

    @Test
    public void testCreateWithInitFileSizeAppendMessage() {
        LogSegment seg = this.createSegment(40L, false, 0x20000000, true);
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        long x$1 = 55L;
        int x$2 = 200;
        None$ x$3 = None$.MODULE$;
        long x$4 = seg.read$default$4();
        boolean x$5 = seg.read$default$5();
        FetchDataInfo read = seg.read(x$1, (Option)x$3, x$2, x$4, x$5);
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records().records().iterator());
    }

    @Test
    public void testCreateWithInitFileSizeClearShutdown() {
        File tempDir = TestUtils$.MODULE$.tempDir();
        LogConfig logConfig = new LogConfig((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.IndexIntervalBytesProp()), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentIndexBytesProp()), (Object)BoxesRunTime.boxToInteger((int)1000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentJitterMsProp()), (Object)BoxesRunTime.boxToInteger((int)0))}))).asJava(), LogConfig$.MODULE$.apply$default$2());
        LogSegment seg = LogSegment$.MODULE$.open(tempDir, 40L, logConfig, Time.SYSTEM, false, 0x20000000, true, LogSegment$.MODULE$.open$default$8());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        long x$1 = 55L;
        int x$2 = 200;
        None$ x$3 = None$.MODULE$;
        long x$4 = seg.read$default$4();
        boolean x$5 = seg.read$default$5();
        FetchDataInfo read = seg.read(x$1, (Option)x$3, x$2, x$4, x$5);
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records().records().iterator());
        int oldSize = seg.log().sizeInBytes();
        long oldPosition = seg.log().channel().position();
        long oldFileSize = seg.log().file().length();
        Assert.assertEquals((long)0x20000000L, (long)oldFileSize);
        seg.close();
        Assert.assertEquals((long)oldSize, (long)seg.log().file().length());
        LogSegment segReopen = LogSegment$.MODULE$.open(tempDir, 40L, logConfig, Time.SYSTEM, true, 0x20000000, true, LogSegment$.MODULE$.open$default$8());
        this.segments().$plus$eq((Object)segReopen);
        long x$6 = 55L;
        int x$7 = 200;
        None$ x$8 = None$.MODULE$;
        long x$9 = segReopen.read$default$4();
        boolean x$10 = segReopen.read$default$5();
        FetchDataInfo readAgain = segReopen.read(x$6, (Option)x$8, x$7, x$9, x$10);
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), readAgain.records().records().iterator());
        int size = segReopen.log().sizeInBytes();
        long position = segReopen.log().channel().position();
        long fileSize = segReopen.log().file().length();
        Assert.assertEquals((long)oldPosition, (long)position);
        Assert.assertEquals((long)oldSize, (long)size);
        Assert.assertEquals((long)size, (long)fileSize);
    }

    @Test
    public void shouldTruncateEvenIfOffsetPointsToAGapInTheLog() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        int offset = 40;
        MemoryRecords ms1 = LogSegmentTest.records$1(offset, "first message");
        seg.append((long)offset, -1L, -1L, ms1);
        MemoryRecords ms2 = LogSegmentTest.records$1(offset + 3, "message after gap");
        seg.append((long)(offset + 3), -1L, -1L, ms2);
        seg.truncateTo((long)(offset + 1));
        FetchDataInfo log = seg.read((long)offset, (Option)None$.MODULE$, 10000, seg.read$default$4(), seg.read$default$5());
        Assert.assertEquals((long)offset, (long)((RecordBatch)log.records().batches().iterator().next()).baseOffset());
        Assert.assertEquals((long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(log.records().batches()).asScala()).size());
    }

    @Test
    public void testAppendFromFile() {
        File tempDir = TestUtils$.MODULE$.tempDir();
        FileRecords fileRecords = FileRecords.open((File)Log$.MODULE$.logFile(tempDir, 0L, Log$.MODULE$.logFile$default$3()));
        fileRecords.append(LogSegmentTest.records$2(0L, 1024));
        fileRecords.append(LogSegmentTest.records$2(500L, 0x100001));
        int sizeBeforeOverflow = fileRecords.sizeInBytes();
        fileRecords.append(LogSegmentTest.records$2(0x80000004L, 1024));
        int sizeAfterOverflow = fileRecords.sizeInBytes();
        LogSegment segment = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        int bytesAppended = segment.appendFromFile(fileRecords, 0);
        Assert.assertEquals((long)sizeBeforeOverflow, (long)bytesAppended);
        Assert.assertEquals((long)sizeBeforeOverflow, (long)segment.size());
        LogSegment overflowSegment = this.createSegment(Integer.MAX_VALUE, this.createSegment$default$2(), this.createSegment$default$3());
        int overflowBytesAppended = overflowSegment.appendFromFile(fileRecords, sizeBeforeOverflow);
        Assert.assertEquals((long)(sizeAfterOverflow - sizeBeforeOverflow), (long)overflowBytesAppended);
        Assert.assertEquals((long)overflowBytesAppended, (long)overflowSegment.size());
        Utils.delete((File)tempDir);
    }

    public static final /* synthetic */ boolean $anonfun$testMaxOffset$1(long offset$2, Record x$2) {
        return x$2.offset() == offset$2;
    }

    private static final void validate$1(long offset, MemoryRecords ms$1, LogSegment seg$1) {
        long x$1 = offset;
        int x$22 = 1024;
        Some x$3 = new Some((Object)BoxesRunTime.boxToLong((long)(offset + 1L)));
        long x$4 = seg$1.read$default$4();
        boolean x$5 = seg$1.read$default$5();
        Assert.assertEquals((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(ms$1.records()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LogSegmentTest.$anonfun$testMaxOffset$1(offset, x$2)))).toList(), (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(seg$1.read(x$1, (Option)x$3, x$22, x$4, x$5).records().records()).asScala()).toList());
    }

    private static final MemoryRecords records$1(long offset, String record) {
        return MemoryRecords.withRecords((byte)2, (long)offset, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(offset * 1000L, record.getBytes())});
    }

    private static final MemoryRecords records$2(long offset, int size) {
        return MemoryRecords.withRecords((byte)2, (long)offset, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new byte[size])});
    }
}

