/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.log.CleanerConfig;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.server.FetchDataInfo;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u001da\u0001B\u0017/\u0001MBQA\u000f\u0001\u0005\u0002mBqA\u0010\u0001C\u0002\u0013\u0005q\b\u0003\u0004G\u0001\u0001\u0006I\u0001\u0011\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0011\u0019a\u0005\u0001)A\u0005\u0013\"9Q\n\u0001b\u0001\n\u0003A\u0005B\u0002(\u0001A\u0003%\u0011\nC\u0004P\u0001\t\u0007I\u0011\u0001)\t\re\u0003\u0001\u0015!\u0003R\u0011\u001dQ\u0006A1A\u0005\u0002mCaa\u0018\u0001!\u0002\u0013a\u0006b\u00021\u0001\u0001\u0004%\t!\u0019\u0005\bQ\u0002\u0001\r\u0011\"\u0001j\u0011\u0019y\u0007\u0001)Q\u0005E\"9\u0001\u000f\u0001a\u0001\n\u0003\t\bbB;\u0001\u0001\u0004%\tA\u001e\u0005\u0007q\u0002\u0001\u000b\u0015\u0002:\t\u000fe\u0004!\u0019!C\u0001u\"9\u00111\u0001\u0001!\u0002\u0013Y\b\"CA\u0003\u0001\t\u0007I\u0011AA\u0004\u0011!\ty\u0001\u0001Q\u0001\n\u0005%\u0001bBA\t\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003O\u0001A\u0011AA\n\u0011\u001d\t\t\u0004\u0001C\u0001\u0003'Aq!a\u000f\u0001\t\u0003\t\u0019\u0002C\u0004\u0002@\u0001!\t!a\u0005\t\u000f\u0005\r\u0003\u0001\"\u0001\u0002\u0014!9\u0011q\t\u0001\u0005\u0002\u0005M\u0001bBA&\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003\u001f\u0002A\u0011AA\n\u0011\u001d\t\u0019\u0006\u0001C\u0005\u0003+Bq!a\u001c\u0001\t\u0003\t\u0019\u0002C\u0004\u0002t\u0001!\t!a\u0005\t\u000f\u0005]\u0004\u0001\"\u0001\u0002\u0014!9\u00111\u0010\u0001\u0005\u0002\u0005M\u0001bBA@\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003\u0007\u0003A\u0011AA\n\u0011\u001d\t9\t\u0001C\u0005\u0003\u0013Cq!a.\u0001\t\u0013\tI\fC\u0005\u0002B\u0002\t\n\u0011\"\u0003\u0002D\"9\u0011\u0011\u001c\u0001\u0005\u0002\u0005M\u0001bBAo\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003C\u0004A\u0011BAr\u0011%\u0011\t\u0001AI\u0001\n\u0013\u0011\u0019A\u0001\bM_\u001el\u0015M\\1hKJ$Vm\u001d;\u000b\u0005=\u0002\u0014a\u00017pO*\t\u0011'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001!\u0004CA\u001b9\u001b\u00051$\"A\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005e2$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002yA\u0011Q\bA\u0007\u0002]\u0005!A/[7f+\u0005\u0001\u0005CA!E\u001b\u0005\u0011%BA\"1\u0003\u0015)H/\u001b7t\u0013\t)%I\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003=i\u0017\r\u001f*pY2Le\u000e^3sm\u0006dW#A%\u0011\u0005UR\u0015BA&7\u0005\rIe\u000e^\u0001\u0011[\u0006D(k\u001c7m\u0013:$XM\u001d<bY\u0002\n1\"\\1y\u0019><\u0017iZ3Ng\u0006aQ.\u0019=M_\u001e\fu-Z'tA\u0005AAn\\4Qe>\u00048/F\u0001R!\t\u0011v+D\u0001T\u0015\t!V+\u0001\u0003vi&d'\"\u0001,\u0002\t)\fg/Y\u0005\u00031N\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0003%awn\u001a)s_B\u001c\b%A\u0005m_\u001e\u001cuN\u001c4jOV\tA\f\u0005\u0002>;&\u0011aL\f\u0002\n\u0019><7i\u001c8gS\u001e\f!\u0002\\8h\u0007>tg-[4!\u0003\u0019awn\u001a#jeV\t!\r\u0005\u0002dM6\tAM\u0003\u0002f+\u0006\u0011\u0011n\\\u0005\u0003O\u0012\u0014AAR5mK\u0006QAn\\4ESJ|F%Z9\u0015\u0005)l\u0007CA\u001bl\u0013\tagG\u0001\u0003V]&$\bb\u00028\u000e\u0003\u0003\u0005\rAY\u0001\u0004q\u0012\n\u0014a\u00027pO\u0012K'\u000fI\u0001\u000bY><W*\u00198bO\u0016\u0014X#\u0001:\u0011\u0005u\u001a\u0018B\u0001;/\u0005)aunZ'b]\u0006<WM]\u0001\u000fY><W*\u00198bO\u0016\u0014x\fJ3r)\tQw\u000fC\u0004o!\u0005\u0005\t\u0019\u0001:\u0002\u00171|w-T1oC\u001e,'\u000fI\u0001\u0005]\u0006lW-F\u0001|!\tax0D\u0001~\u0015\tqX+\u0001\u0003mC:<\u0017bAA\u0001{\n11\u000b\u001e:j]\u001e\fQA\\1nK\u0002\n\u0011D^3ss2\u000b'oZ3M_\u001e4E.^:i\u0013:$XM\u001d<bYV\u0011\u0011\u0011\u0002\t\u0004k\u0005-\u0011bAA\u0007m\t!Aj\u001c8h\u0003i1XM]=MCJ<W\rT8h\r2,8\u000f[%oi\u0016\u0014h/\u00197!\u0003\u0015\u0019X\r^+q)\u0005Q\u0007f\u0001\f\u0002\u0018A!\u0011\u0011DA\u0012\u001b\t\tYB\u0003\u0003\u0002\u001e\u0005}\u0011!\u00026v]&$(BAA\u0011\u0003\ry'oZ\u0005\u0005\u0003K\tYB\u0001\u0004CK\u001a|'/Z\u0001\ti\u0016\f'\u000fR8x]\"\u001aq#a\u000b\u0011\t\u0005e\u0011QF\u0005\u0005\u0003_\tYBA\u0003BMR,'/A\u0007uKN$8I]3bi\u0016dun\u001a\u0015\u00041\u0005U\u0002\u0003BA\r\u0003oIA!!\u000f\u0002\u001c\t!A+Z:u\u0003y!Xm\u001d;De\u0016\fG/\u001a'pO^KG\u000f[%om\u0006d\u0017\u000e\u001a'pO\u0012K'\u000fK\u0002\u001a\u0003k\tQ\u0003^3ti\u001e+GOT8o\u000bbL7\u000f^3oi2{w\rK\u0002\u001b\u0003k\t!\u0004^3ti\u000ecW-\u00198va\u0016C\b/\u001b:fIN+w-\\3oiND3aGA\u001b\u0003\u0005\"Xm\u001d;DY\u0016\fg.\u001e9TK\u001elWM\u001c;t)>l\u0015-\u001b8uC&t7+\u001b>fQ\ra\u0012QG\u0001+i\u0016\u001cH\u000fR8fg:$8\t\\3b]2{wm],ji\"\u001cu.\u001c9bGR$U\r\\3uKB{G.[2zQ\ri\u0012QG\u0001%i\u0016\u001cH\u000fR8fg:$8\t\\3b]2{wm],ji\"\u001cu.\u001c9bGR\u0004v\u000e\\5ds\"\u001aa$!\u000e\u0002'Q,7\u000f\u001e#pKNtGo\u00117fC:dunZ:\u0015\u0007)\f9\u0006C\u0004\u0002Z}\u0001\r!a\u0017\u0002\rA|G.[2z!\u0011\ti&a\u001b\u000f\t\u0005}\u0013q\r\t\u0004\u0003C2TBAA2\u0015\r\t)GM\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005%d'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0003\tiGC\u0002\u0002jY\n!\u0003^3tiRKW.\u001a\"bg\u0016$g\t\\;tQ\"\u001a\u0001%!\u000e\u00023Q,7\u000f\u001e'fCN$Hj\\1eK\u0012\f5o]5h]6,g\u000e\u001e\u0015\u0004C\u0005U\u0012a\t;fgR$vo\u001c'pO6\u000bg.Y4feN,6/\u001b8h'\u0006lW\rR5s\r\u0006LGn\u001d\u0015\u0004E\u0005U\u0012\u0001\b;fgR\u001c\u0005.Z2la>Lg\u000e\u001e*fG>4XM]=Q_&tGo\u001d\u0015\u0004G\u0005U\u0012!\f;fgR\u0014VmY8wKJLH)\u001b:fGR|'/_'baBLgnZ,ji\"$&/Y5mS:<7\u000b\\1tQ\"\u001aA%!\u000e\u0002cQ,7\u000f\u001e*fG>4XM]=ESJ,7\r^8ss6\u000b\u0007\u000f]5oO^KG\u000f\u001b*fY\u0006$\u0018N^3ESJ,7\r^8ss\"\u001aQ%!\u000e\u00021Y,'/\u001b4z\u0007\",7m\u001b9pS:$(+Z2pm\u0016\u0014\u0018\u0010F\u0004k\u0003\u0017\u000b\u0019,!.\t\u000f\u00055e\u00051\u0001\u0002\u0010\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t7\u000f\u0005\u0004\u0002\u0012\u0006m\u0015\u0011\u0015\b\u0005\u0003'\u000b9J\u0004\u0003\u0002b\u0005U\u0015\"A\u001c\n\u0007\u0005ee'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005u\u0015q\u0014\u0002\u0004'\u0016\f(bAAMmA!\u00111UAX\u001b\t\t)K\u0003\u0003\u0002(\u0006%\u0016AB2p[6|gNC\u00022\u0003WSA!!,\u0002 \u00051\u0011\r]1dQ\u0016LA!!-\u0002&\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007\"\u00029'\u0001\u0004\u0011\b\"\u00021'\u0001\u0004\u0011\u0017\u0001E2sK\u0006$X\rT8h\u001b\u0006t\u0017mZ3s)\r\u0011\u00181\u0018\u0005\n\u0003{;\u0003\u0013!a\u0001\u0003\u007f\u000bq\u0001\\8h\t&\u00148\u000fE\u0003\u0002\u0012\u0006m%-\u0001\u000ede\u0016\fG/\u001a'pO6\u000bg.Y4fe\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002F*\"\u0011qXAdW\t\tI\r\u0005\u0003\u0002L\u0006UWBAAg\u0015\u0011\ty-!5\u0002\u0013Ut7\r[3dW\u0016$'bAAjm\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0017Q\u001a\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017A\t;fgR4\u0015\u000e\\3SK\u001a,'/\u001a8dKN\fe\r^3s\u0003NLhn\u0019#fY\u0016$X\rK\u0002*\u0003k\t\u0011\u0005^3ti\u000eCWmY6q_&tGOR8s\u001f:d\u00170\u00114gK\u000e$X\r\u001a'pOND3AKA\u001b\u0003\u001d\u0011X-\u00193M_\u001e$\u0002\"!:\u0002r\u0006e\u0018Q \t\u0005\u0003O\fi/\u0004\u0002\u0002j*\u0019\u00111\u001e\u0019\u0002\rM,'O^3s\u0013\u0011\ty/!;\u0003\u001b\u0019+Go\u00195ECR\f\u0017J\u001c4p\u0011\u0019y3\u00061\u0001\u0002tB\u0019Q(!>\n\u0007\u0005]hFA\u0002M_\u001eDq!a?,\u0001\u0004\tI!\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\t\u0003\u007f\\\u0003\u0013!a\u0001\u0013\u0006IQ.\u0019=MK:<G\u000f[\u0001\u0012e\u0016\fG\rT8hI\u0011,g-Y;mi\u0012\u001aTC\u0001B\u0003U\rI\u0015q\u0019")
public class LogManagerTest {
    private final MockTime time = new MockTime();
    private final int maxRollInterval;
    private final int maxLogAgeMs;
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private File logDir;
    private LogManager logManager;
    private final String name;
    private final long veryLargeLogFlushInterval;

    public MockTime time() {
        return this.time;
    }

    public int maxRollInterval() {
        return this.maxRollInterval;
    }

    public int maxLogAgeMs() {
        return this.maxLogAgeMs;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public String name() {
        return this.name;
    }

    public long veryLargeLogFlushInterval() {
        return this.veryLargeLogFlushInterval;
    }

    @Before
    public void setUp() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1()));
        this.logManager().startup();
    }

    @After
    public void tearDown() {
        if (this.logManager() != null) {
            this.logManager().shutdown();
        }
        Utils.delete((File)this.logDir());
        this.logManager().liveLogDirs().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            LogManagerTest.$anonfun$tearDown$1(x$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreateLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        LogConfig x$2 = this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        Assert.assertEquals((long)1L, (long)this.logManager().liveLogDirs().size());
        File logFile = new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString());
        Assert.assertTrue((boolean)logFile.exists());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
    }

    @Test
    public void testCreateLogWithInvalidLogDir() {
        Seq dirs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir(), new File("\u0000")}));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)dirs));
        this.logManager().startup();
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        LogConfig x$2 = this.logConfig();
        boolean x$3 = true;
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        File logFile = new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString());
        Assert.assertTrue((boolean)logFile.exists());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
    }

    @Test
    public void testGetNonExistentLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(x$1, x$2);
        Assert.assertEquals((String)"No log should be found.", (Object)None$.MODULE$, (Object)log);
        File logFile = new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString());
        Assert.assertTrue((!logFile.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testCleanupExpiredSegments() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$12 = new TopicPartition(this.name(), 0);
        LogConfig x$2 = this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$12, x$2, x$3, x$4);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
            offset$1.elem = info.lastOffset();
        });
        Assert.assertTrue((String)"There should be more than one segment now.", (log.numberOfSegments() > 1 ? 1 : 0) != 0);
        log.onHighWatermarkIncremented(log.logEndOffset());
        log.logSegments().foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testCleanupExpiredSegments$2(this, x$1)));
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assert.assertEquals((String)"Now there should only be only one segment in the index.", (long)1L, (long)log.numberOfSegments());
        this.time().sleep(Predef$.MODULE$.Long2long(log.config().fileDeleteDelayMs()) + 1L);
        Assert.assertEquals((String)"Files should have been deleted", (long)(log.numberOfSegments() * 4 + 1), (long)log.dir().list().length);
        Assert.assertEquals((String)"Should get empty fetch off new log.", (long)0L, (long)this.readLog(log, offset.elem + 1L, this.readLog$default$3()).records().sizeInBytes());
        try {
            this.readLog(log, 0L, this.readLog$default$3());
            Assert.fail((String)"Should get exception from fetching earlier.");
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {}
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
    }

    @Test
    public void testCleanupSegmentsToMaintainSize() {
        int setSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()).sizeInBytes();
        this.logManager().shutdown();
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(10 * setSize));
        logProps.put(LogConfig$.MODULE$.RetentionBytesProp(), Predef$.MODULE$.long2Long(50L * (long)setSize + 10L));
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1()));
        this.logManager().startup();
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        LogConfig x$2 = config;
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        LongRef offset = LongRef.create((long)0L);
        int numMessages = 200;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
            offset$2.elem = BoxesRunTime.unboxToLong((Object)info.firstOffset().get());
        });
        log.onHighWatermarkIncremented(log.logEndOffset());
        Assert.assertEquals((String)"Check we have the expected number of segments.", (long)(numMessages * setSize / Predef$.MODULE$.Integer2int(config.segmentSize())), (long)log.numberOfSegments());
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assert.assertEquals((String)"Now there should be exactly 6 segments", (long)6L, (long)log.numberOfSegments());
        this.time().sleep(Predef$.MODULE$.Long2long(log.config().fileDeleteDelayMs()) + 1L);
        Assert.assertEquals((String)"Files should have been deleted", (long)(log.numberOfSegments() * 3 + 3), (long)log.dir().list().length);
        Assert.assertEquals((String)"Should get empty fetch off new log.", (long)0L, (long)this.readLog(log, offset.elem + 1L, this.readLog$default$3()).records().sizeInBytes());
        try {
            this.readLog(log, 0L, this.readLog$default$3());
            Assert.fail((String)"Should get exception from fetching earlier.");
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {}
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
    }

    @Test
    public void testDoesntCleanLogsWithCompactDeletePolicy() {
        this.testDoesntCleanLogs(new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString());
    }

    @Test
    public void testDoesntCleanLogsWithCompactPolicy() {
        this.testDoesntCleanLogs(LogConfig$.MODULE$.Compact());
    }

    private void testDoesntCleanLogs(String policy) {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), policy);
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        LogConfig x$22 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, x$22, x$3, x$4);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
            offset$3.elem = info.lastOffset();
        });
        int numSegments = log.numberOfSegments();
        Assert.assertTrue((String)"There should be more than one segment now.", (log.numberOfSegments() > 1 ? 1 : 0) != 0);
        log.logSegments().foreach((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testDoesntCleanLogs$2(this, x$2)));
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assert.assertEquals((String)"number of segments shouldn't have changed", (long)numSegments, (long)log.numberOfSegments());
    }

    @Test
    public void testTimeBasedFlush() {
        this.logManager().shutdown();
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.FlushMsProp(), Predef$.MODULE$.int2Integer(1000));
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1()));
        this.logManager().startup();
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        LogConfig x$2 = config;
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        long lastFlush = log.lastFlushTime();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach((Function1 & Serializable & scala.Serializable)_ -> LogManagerTest.$anonfun$testTimeBasedFlush$1(log, BoxesRunTime.unboxToInt((Object)_)));
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assert.assertTrue((String)"Time based flush should have been triggered", (lastFlush != log.lastFlushTime() ? 1 : 0) != 0);
    }

    @Test
    public void testLeastLoadedAssignment() {
        Seq dirs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{TestUtils$.MODULE$.tempDir(), TestUtils$.MODULE$.tempDir(), TestUtils$.MODULE$.tempDir()}));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)dirs));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            LogManager qual$1 = this.logManager();
            TopicPartition x$1 = new TopicPartition("test", partition);
            LogConfig x$2 = this.logConfig();
            boolean x$32 = qual$1.getOrCreateLog$default$3();
            boolean x$42 = qual$1.getOrCreateLog$default$4();
            qual$1.getOrCreateLog(x$1, x$2, x$32, x$42);
            Assert.assertEquals((String)"We should have created the right number of logs", (long)(partition + 1), (long)this.logManager().allLogs().size());
            Iterable counts = (Iterable)this.logManager().allLogs().groupBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.dir().getParent()).values().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.size()), Iterable$.MODULE$.canBuildFrom());
            Assert.assertTrue((String)"Load should balance evenly", (BoxesRunTime.unboxToInt((Object)counts.max((Ordering)Ordering.Int$.MODULE$)) <= BoxesRunTime.unboxToInt((Object)counts.min((Ordering)Ordering.Int$.MODULE$)) + 1 ? 1 : 0) != 0);
        });
    }

    @Test
    public void testTwoLogManagersUsingSameDirFails() {
        try {
            this.createLogManager(this.createLogManager$default$1());
            Assert.fail((String)"Should not be able to create a second log manager instance with the same data directory");
        }
        catch (KafkaException kafkaException) {}
    }

    @Test
    public void testCheckpointRecoveryPoints() {
        this.verifyCheckpointRecovery((Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 1), new TopicPartition("test-b", 1)}))), this.logManager(), this.logDir());
    }

    @Test
    public void testRecoveryDirectoryMappingWithTrailingSlash() {
        this.logManager().shutdown();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{new File(new StringBuilder(0).append(TestUtils$.MODULE$.tempDir().getAbsolutePath()).append(File.separator).toString())}))), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4()));
        this.logManager().startup();
        this.verifyCheckpointRecovery((Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 1)}))), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    @Test
    public void testRecoveryDirectoryMappingWithRelativeDirectory() {
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{new File("data", this.logDir().getName()).getAbsoluteFile()})))));
        this.logManager().startup();
        this.verifyCheckpointRecovery((Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 1)}))), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    private void verifyCheckpointRecovery(Seq<TopicPartition> topicPartitions, LogManager logManager, File logDir) {
        Seq logs = (Seq)topicPartitions.map((Function1 & Serializable & scala.Serializable)x$5 -> logManager.getOrCreateLog(x$5, this.logConfig(), logManager.getOrCreateLog$default$3(), logManager.getOrCreateLog$default$4()), Seq$.MODULE$.canBuildFrom());
        logs.foreach((Function1 & Serializable & scala.Serializable)log -> {
            LogManagerTest.$anonfun$verifyCheckpointRecovery$2(log);
            return BoxedUnit.UNIT;
        });
        logManager.checkpointLogRecoveryOffsets();
        Map checkpoints = new OffsetCheckpointFile(new File(logDir, LogManager$.MODULE$.RecoveryPointCheckpointFile()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read();
        ((IterableLike)topicPartitions.zip((GenIterable)logs, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LogManagerTest.$anonfun$verifyCheckpointRecovery$4(checkpoints, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private LogManager createLogManager(Seq<File> logDirs) {
        LogConfig x$1 = this.logConfig();
        Seq<File> x$2 = logDirs;
        MockTime x$3 = this.time();
        CleanerConfig x$4 = TestUtils$.MODULE$.createLogManager$default$3();
        return TestUtils$.MODULE$.createLogManager(x$2, x$1, x$4, x$3);
    }

    private Seq<File> createLogManager$default$1() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}));
    }

    @Test
    public void testFileReferencesAfterAsyncDelete() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        LogConfig x$2 = this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        LogSegment activeSegment = log.activeSegment();
        String logName = activeSegment.log().file().getName();
        String indexName = activeSegment.offsetIndex().file().getName();
        String timeIndexName = activeSegment.timeIndex().file().getName();
        String txnIndexName = activeSegment.txnIndex().file().getName();
        File[] indexFilesOnDiskBeforeDelete = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])activeSegment.log().file().getParentFile().listFiles())).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$1(x$6)));
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = new TopicPartition(this.name(), 0);
        boolean x$62 = qual$2.asyncDelete$default$2();
        Log removedLog = qual$2.asyncDelete(x$5, x$62);
        LogSegment removedSegment = removedLog.activeSegment();
        Seq indexFilesAfterDelete = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{removedSegment.offsetIndex().file(), removedSegment.timeIndex().file(), removedSegment.txnIndex().file()}));
        Assert.assertEquals((Object)new File(removedLog.dir(), logName), (Object)removedSegment.log().file());
        Assert.assertEquals((Object)new File(removedLog.dir(), indexName), (Object)removedSegment.offsetIndex().file());
        Assert.assertEquals((Object)new File(removedLog.dir(), timeIndexName), (Object)removedSegment.timeIndex().file());
        Assert.assertEquals((Object)new File(removedLog.dir(), txnIndexName), (Object)removedSegment.txnIndex().file());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])indexFilesOnDiskBeforeDelete)).foreach((Function1 & Serializable & scala.Serializable)fileBeforeDelete -> {
            LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$2(indexFilesAfterDelete, fileBeforeDelete);
            return BoxedUnit.UNIT;
        });
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assert.assertTrue((String)"Logs deleted too early", (boolean)this.logManager().hasLogsToBeDeleted());
        this.time().sleep(Predef$.MODULE$.Long2long(this.logManager().currentDefaultConfig().fileDeleteDelayMs()) - (long)this.logManager().InitialTaskDelayMs());
        Assert.assertFalse((String)"Logs not deleted", (boolean)this.logManager().hasLogsToBeDeleted());
    }

    @Test
    public void testCheckpointForOnlyAffectedLogs() {
        Seq tps = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 0), new TopicPartition("test-a", 1), new TopicPartition("test-a", 2), new TopicPartition("test-b", 0), new TopicPartition("test-b", 1)}));
        Seq allLogs = (Seq)tps.map((Function1 & Serializable & scala.Serializable)x$9 -> {
            LogManager qual$1 = this.logManager();
            TopicPartition x$1 = x$9;
            LogConfig x$2 = this.logConfig();
            boolean x$3 = qual$1.getOrCreateLog$default$3();
            boolean x$4 = qual$1.getOrCreateLog$default$4();
            return qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        }, Seq$.MODULE$.canBuildFrom());
        allLogs.foreach((Function1 & Serializable & scala.Serializable)log -> {
            LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$2(log);
            return BoxedUnit.UNIT;
        });
        this.logManager().checkpointRecoveryOffsetsAndCleanSnapshot(this.logDir(), (Seq)allLogs.filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$4(x$10))));
        Map checkpoints = new OffsetCheckpointFile(new File(this.logDir(), LogManager$.MODULE$.RecoveryPointCheckpointFile()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read();
        ((IterableLike)tps.zip((GenIterable)allLogs, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$5(checkpoints, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private FetchDataInfo readLog(Log log, long offset, int maxLength) {
        return log.read(offset, maxLength, (Option)None$.MODULE$, true, false);
    }

    private int readLog$default$3() {
        return 1024;
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$testCleanupExpiredSegments$2(LogManagerTest $this, LogSegment x$1) {
        return x$1.log().file().setLastModified($this.time().milliseconds());
    }

    public static final /* synthetic */ boolean $anonfun$testDoesntCleanLogs$2(LogManagerTest $this, LogSegment x$2) {
        return x$2.log().file().setLastModified($this.time().milliseconds());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testTimeBasedFlush$1(Log log$4, int _) {
        MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        return log$4.appendAsLeader(set, 0, log$4.appendAsLeader$default$3(), log$4.appendAsLeader$default$4());
    }

    public static final /* synthetic */ void $anonfun$verifyCheckpointRecovery$2(Log log) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4()));
        log.flush();
    }

    public static final /* synthetic */ void $anonfun$verifyCheckpointRecovery$4(Map checkpoints$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        Log log = (Log)tuple2._2();
        Assert.assertEquals((String)"Recovery point should equal checkpoint", (long)BoxesRunTime.unboxToLong((Object)checkpoints$1.apply((Object)tp)), (long)log.recoveryPoint());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)log.minSnapshotsOffsetToRetain())), (Object)log.oldestProducerSnapshotOffset());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$testFileReferencesAfterAsyncDelete$1(File x$6) {
        return x$6.getName().endsWith("index");
    }

    public static final /* synthetic */ boolean $anonfun$testFileReferencesAfterAsyncDelete$3(File fileBeforeDelete$1, File x$7) {
        String string = x$7.getName();
        String string2 = fileBeforeDelete$1.getName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testFileReferencesAfterAsyncDelete$2(Seq indexFilesAfterDelete$1, File fileBeforeDelete) {
        Option fileInIndex = indexFilesAfterDelete$1.find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$3(fileBeforeDelete, x$7)));
        Assert.assertEquals((String)new StringBuilder(51).append("Could not find index file ").append(fileBeforeDelete.getName()).append(" in indexFilesAfterDelete").toString(), (Object)new Some((Object)fileBeforeDelete.getName()), (Object)fileInIndex.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getName()));
        Assert.assertNotEquals((String)"File reference was not updated in index", (Object)fileBeforeDelete.getAbsolutePath(), (Object)((File)fileInIndex.get()).getAbsolutePath());
    }

    public static final /* synthetic */ void $anonfun$testCheckpointForOnlyAffectedLogs$2(Log log) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4()));
        log.flush();
    }

    public static final /* synthetic */ boolean $anonfun$testCheckpointForOnlyAffectedLogs$4(Log x$10) {
        return x$10.dir().getName().contains("test-a");
    }

    public static final /* synthetic */ void $anonfun$testCheckpointForOnlyAffectedLogs$5(Map checkpoints$2, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            Log log = (Log)tuple2._2();
            Assert.assertEquals((String)"Recovery point should equal checkpoint", (long)BoxesRunTime.unboxToLong((Object)checkpoints$2.apply((Object)tp)), (long)log.recoveryPoint());
            if (tp.topic().equals("test-a")) {
                Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)log.minSnapshotsOffsetToRetain())), (Object)log.oldestProducerSnapshotOffset());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Assert.assertNotEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)log.minSnapshotsOffsetToRetain())), (Object)log.oldestProducerSnapshotOffset());
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public LogManagerTest() {
        this.maxRollInterval = 100;
        this.maxLogAgeMs = 600000;
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(4096));
        this.logProps().put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(this.maxLogAgeMs()));
        this.logProps().put(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        this.logConfig = new LogConfig((java.util.Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.logDir = null;
        this.logManager = null;
        this.name = "kafka";
        this.veryLargeLogFlushInterval = 10000000L;
    }
}

