/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused;
import kafka.log.LogCleaningState;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.LogUtils$;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Logging;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t]c\u0001\u0002\u00192\u0001YBQa\u0012\u0001\u0005\u0002!Cqa\u0013\u0001C\u0002\u0013\u0005A\n\u0003\u0004V\u0001\u0001\u0006I!\u0014\u0005\b-\u0002\u0011\r\u0011\"\u0001M\u0011\u00199\u0006\u0001)A\u0005\u001b\"9\u0001\f\u0001b\u0001\n\u0003I\u0006BB2\u0001A\u0003%!\fC\u0004e\u0001\t\u0007I\u0011A3\t\r1\u0004\u0001\u0015!\u0003g\u0011\u001di\u0007A1A\u0005\u00029DaA\u001d\u0001!\u0002\u0013y\u0007bB:\u0001\u0005\u0004%\t\u0001\u001e\u0005\u0007q\u0002\u0001\u000b\u0011B;\t\u000fe\u0004!\u0019!C\u0001u\"9\u00111\u0003\u0001!\u0002\u0013YhABA\u000b\u0001\u0001\t9\u0002\u0003\u0007\u0002 A\u0011\t\u0011)A\u0005\u0003C\tI\u0004\u0003\u0007\u0002<A\u0011\t\u0011)A\u0005\u0003{\tI\u0005\u0003\u0007\u0002LA\u0011\t\u0011)A\u0005\u0003\u001b\nI\u0006\u0003\u0004H!\u0011\u0005\u00111\f\u0005\b\u0003O\u0002B\u0011IA5\u0011\u001d\tI\b\u0001C\u0001\u0003wBq!a$\u0001\t\u0003\tY\bC\u0004\u0002\u001a\u0002!\t!a\u001f\t\u000f\u0005u\u0005\u0001\"\u0001\u0002|!9\u0011\u0011\u0015\u0001\u0005\u0002\u0005m\u0004bBAS\u0001\u0011\u0005\u00111\u0010\u0005\b\u0003S\u0003A\u0011AA>\u0011\u001d\ti\u000b\u0001C\u0001\u0003wBq!!-\u0001\t\u0003\tY\bC\u0004\u00026\u0002!\t!a\u001f\t\u000f\u0005e\u0006\u0001\"\u0001\u0002|!9\u0011Q\u0018\u0001\u0005\u0002\u0005m\u0004bBAa\u0001\u0011\u0005\u00111\u0010\u0005\b\u0003\u000b\u0004A\u0011AA>\u0011\u001d\tI\r\u0001C\u0001\u0003wBq!!4\u0001\t\u0003\tY\bC\u0004\u0002R\u0002!\t!a\u001f\t\u000f\u0005U\u0007\u0001\"\u0001\u0002|!9\u0011\u0011\u001c\u0001\u0005\n\u0005m\u0007bBAm\u0001\u0011%\u0011q\u001c\u0005\n\u0003_\u0004\u0011\u0013!C\u0005\u0003cDqAa\u0002\u0001\t\u0013\u0011I\u0001C\u0005\u0003$\u0001\t\n\u0011\"\u0003\u0003&!9!\u0011\u0006\u0001\u0005\n\t-\u0002\"\u0003B\u001b\u0001E\u0005I\u0011\u0002B\u001c\u0011\u001d\u0011Y\u0004\u0001C\u0005\u0005{\u0011Q\u0003T8h\u00072,\u0017M\\3s\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u00023g\u0005\u0019An\\4\u000b\u0003Q\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001o\u0005\u0003\"\u0001O \u000e\u0003eR!AO\u001e\u0002\u000b),h.\u001b;\u000b\u0005qj\u0014!C:dC2\fG/Z:u\u0015\u0005q\u0014aA8sO&\u0011\u0001)\u000f\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007C\u0001\"F\u001b\u0005\u0019%B\u0001#4\u0003\u0015)H/\u001b7t\u0013\t15IA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005I\u0005C\u0001&\u0001\u001b\u0005\t\u0014A\u0002;na\u0012K'/F\u0001N!\tq5+D\u0001P\u0015\t\u0001\u0016+\u0001\u0002j_*\t!+\u0001\u0003kCZ\f\u0017B\u0001+P\u0005\u00111\u0015\u000e\\3\u0002\u000fQl\u0007\u000fR5sA\u00051An\\4ESJ\fq\u0001\\8h\t&\u0014\b%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0003i\u0003\"aW1\u000e\u0003qS!!\u00180\u0002\r\r|W.\\8o\u0015\t!tL\u0003\u0002a{\u00051\u0011\r]1dQ\u0016L!A\u0019/\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007%\u0001\u0005m_\u001e\u0004&o\u001c9t+\u00051\u0007CA4k\u001b\u0005A'BA5R\u0003\u0011)H/\u001b7\n\u0005-D'A\u0003)s_B,'\u000f^5fg\u0006IAn\\4Qe>\u00048\u000fI\u0001\nY><7i\u001c8gS\u001e,\u0012a\u001c\t\u0003\u0015BL!!]\u0019\u0003\u00131{wmQ8oM&<\u0017A\u00037pO\u000e{gNZ5hA\u0005!A/[7f+\u0005)\bC\u0001\"w\u0013\t98I\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003I\u0019G.Z1oKJ\u001c\u0005.Z2la>Lg\u000e^:\u0016\u0003m\u0004b\u0001`A\u00045\u0006-Q\"A?\u000b\u0005y|\u0018aB7vi\u0006\u0014G.\u001a\u0006\u0005\u0003\u0003\t\u0019!\u0001\u0006d_2dWm\u0019;j_:T!!!\u0002\u0002\u000bM\u001c\u0017\r\\1\n\u0007\u0005%QPA\u0002NCB\u0004B!!\u0004\u0002\u00105\u0011\u00111A\u0005\u0005\u0003#\t\u0019A\u0001\u0003M_:<\u0017aE2mK\u0006tWM]\"iK\u000e\\\u0007o\\5oiN\u0004#!\u0006'pO\u000ecW-\u00198fe6\u000bg.Y4fe6{7m[\n\u0004!\u0005e\u0001c\u0001&\u0002\u001c%\u0019\u0011QD\u0019\u0003#1{wm\u00117fC:,'/T1oC\u001e,'/A\u0004m_\u001e$\u0015N]:\u0011\u000b\u0005\r\u00121G'\u000f\t\u0005\u0015\u0012q\u0006\b\u0005\u0003O\ti#\u0004\u0002\u0002*)\u0019\u00111F\u001b\u0002\rq\u0012xn\u001c;?\u0013\t\t)!\u0003\u0003\u00022\u0005\r\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003k\t9DA\u0002TKFTA!!\r\u0002\u0004%!\u0011qDA\u000e\u0003\u0011awnZ:\u0011\r\t\u000byDWA\"\u0013\r\t\te\u0011\u0002\u0005!>|G\u000eE\u0002K\u0003\u000bJ1!a\u00122\u0005\raunZ\u0005\u0005\u0003w\tY\"\u0001\u000bm_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\u001c\t\u0005\u0003\u001f\n)&\u0004\u0002\u0002R)\u0019\u00111K\u001a\u0002\rM,'O^3s\u0013\u0011\t9&!\u0015\u0003)1{w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m\u0013\u0011\tY%a\u0007\u0015\u0011\u0005u\u0013\u0011MA2\u0003K\u00022!a\u0018\u0011\u001b\u0005\u0001\u0001bBA\u0010)\u0001\u0007\u0011\u0011\u0005\u0005\b\u0003w!\u0002\u0019AA\u001f\u0011\u001d\tY\u0005\u0006a\u0001\u0003\u001b\nQ#\u00197m\u00072,\u0017M\\3s\u0007\",7m\u001b9pS:$8/\u0006\u0002\u0002lA9\u0011QNA;5\u0006-a\u0002BA8\u0003c\u0002B!a\n\u0002\u0004%!\u00111OA\u0002\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011BA<\u0015\u0011\t\u0019(a\u0001\u0002\u0011Q,\u0017M\u001d#po:$\"!! \u0011\t\u00055\u0011qP\u0005\u0005\u0003\u0003\u000b\u0019A\u0001\u0003V]&$\bf\u0001\f\u0002\u0006B!\u0011qQAF\u001b\t\tII\u0003\u0002;{%!\u0011QRAE\u0005\u0015\te\r^3s\u0003a\"Xm\u001d;He\u0006\u0014g)\u001b7uQ&,7\u000f^\"p[B\f7\r^3e\u0019><'+\u001a;ve:\u001cHj\\4XSRDG)\u001b:uS\u0016\u001cHOU1uS>D3aFAJ!\u0011\t9)!&\n\t\u0005]\u0015\u0011\u0012\u0002\u0005)\u0016\u001cH/A\u001duKN$xI]1c\r&dG\u000f[5fgR\u001cu.\u001c9bGR,G\rT8h\u0013\u001etwN]3t+:\u001cG.Z1oC\ndW\rU1si&$\u0018n\u001c8tQ\rA\u00121S\u00019i\u0016\u001cHo\u0012:bE\u001aKG\u000e\u001e5jKN$8i\\7qC\u000e$X\r\u001a'pO&;gn\u001c:fg&s\u0007K]8he\u0016\u001c8\u000fU1si&$\u0018n\u001c8tQ\rI\u00121S\u0001Ui\u0016\u001cHo\u0012:bE\u001aKG\u000e\u001e5jKN$8i\\7qC\u000e$X\r\u001a'pO&;gn\u001c:fg\n{G\u000f[%o!J|wM]3tgB\u000b'\u000f^5uS>t7/\u00118e+:\u001cG.Z1oC\ndW\rU1si&$\u0018n\u001c8tQ\rQ\u00121S\u0001Ei\u0016\u001cH\u000fT8hg^KG\u000f[*fO6,g\u000e^:U_\u0012+G.\u001a;f'\"|W\u000f\u001c3O_R\u001cuN\\:jI\u0016\u00148\t\\3b]V\u0004\bk\u001c7jGf$U\r\\3uK2{wm\u001d\u0015\u00047\u0005M\u0015\u0001\u0013;fgRdunZ:XSRD7+Z4nK:$8\u000fV8EK2,G/Z*i_VdGmQ8og&$WM]\"mK\u0006tW\u000f\u001d)pY&\u001c\u0017pQ8na\u0006\u001cG\u000fR3mKR,Gj\\4tQ\ra\u00121S\u0001Ci\u0016\u001cH\u000fT8hg^KG\u000f[*fO6,g\u000e^:U_\u0012+G.\u001a;f'\"|W\u000f\u001c3D_:\u001c\u0018\u000eZ3s\u00072,\u0017M\\;q!>d\u0017nY=D_6\u0004\u0018m\u0019;M_\u001e\u001c\bfA\u000f\u0002\u0014\u0006YC/Z:u\u0019><7/\u00168eKJ\u001cE.Z1okBLe.\u001a7jO&\u0014G.\u001a$pe\u000e{W\u000e]1di&|g\u000eK\u0002\u001f\u0003'\u000b\u0001\u0006^3ti\u000e{gnY;se\u0016tG\u000fT8h\u00072,\u0017M\\;q\u0003:$Gj\\4UeVt7-\u0019;j_:D3aHAJ\u0003!\"Xm\u001d;D_:\u001cWO\u001d:f]RdunZ\"mK\u0006tW\u000f]!oIR{\u0007/[2EK2,G/[8oQ\r\u0001\u00131S\u0001Ci\u0016\u001cH\u000fT8hg^KG\u000f[*fO6,g\u000e^:U_\u0012+G.\u001a;f'\"|W\u000f\u001c3O_R\u001cuN\\:jI\u0016\u0014XK\\2mK\u0006t\u0017M\u00197f!\u0006\u0014H/\u001b;j_:\u001c\bfA\u0011\u0002\u0014\u0006YB/Z:u\u00072,\u0017M\\1cY\u0016|eMZ:fiN4uN\u001d(p]\u0016D3AIAJ\u0003m!Xm\u001d;DY\u0016\fg.\u00192mK>3gm]3ug\u001a{'\u000fV5nK\"\u001a1%a%\u0002AQ,7\u000f^\"mK\u0006t\u0017M\u00197f\u001f\u001a47/\u001a;t\r>\u00148\u000b[8siRKW.\u001a\u0015\u0004I\u0005M\u0015A\u000b;fgR,f\u000eZ3dS\u0012,G\r\u0016:b]N\f7\r^5p]\u0006dG)\u0019;b\u001d>$8\t\\3b]\u0006\u0014G.\u001a\u0015\u0004K\u0005M\u0015\u0001\u0005;fgR$uN\\3DY\u0016\fg.\u001b8hQ\r1\u00131S\u0001\u0011i\u0016\u001cH\u000fR8oK\u0012+G.\u001a;j]\u001eD3aJAJ\u0003Q\u0019'/Z1uK\u000ecW-\u00198fe6\u000bg.Y4feR!\u0011\u0011DAo\u0011\u0019\u0011\u0004\u00061\u0001\u0002DQ1\u0011\u0011DAq\u0003KDq!a9*\u0001\u0004\ti$\u0001\u0003q_>d\u0007\"CAtSA\u0005\t\u0019AAu\u0003\u0019!x.T8dWB!\u0011QBAv\u0013\u0011\ti/a\u0001\u0003\u000f\t{w\u000e\\3b]\u0006q2M]3bi\u0016\u001cE.Z1oKJl\u0015M\\1hKJ$C-\u001a4bk2$HEM\u000b\u0003\u0003gTC!!;\u0002v.\u0012\u0011q\u001f\t\u0005\u0003s\u0014\u0019!\u0004\u0002\u0002|*!\u0011Q`A\u0000\u0003%)hn\u00195fG.,GM\u0003\u0003\u0003\u0002\u0005\r\u0011AC1o]>$\u0018\r^5p]&!!QAA~\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\nGJ,\u0017\r^3M_\u001e$\u0002\"a\u0011\u0003\f\tU!q\u0004\u0005\b\u0005\u001bY\u0003\u0019\u0001B\b\u0003-\u0019XmZ7f]R\u001c\u0016N_3\u0011\t\u00055!\u0011C\u0005\u0005\u0005'\t\u0019AA\u0002J]RDqAa\u0006,\u0001\u0004\u0011I\"A\u0007dY\u0016\fg.\u001e9Q_2L7-\u001f\t\u0005\u0003[\u0012Y\"\u0003\u0003\u0003\u001e\u0005]$AB*ue&tw\rC\u0005\u0003\"-\u0002\n\u00111\u0001\u0003\u0010\u0005i1/Z4nK:$8oQ8v]R\f1c\u0019:fCR,Gj\\4%I\u00164\u0017-\u001e7uIM*\"Aa\n+\t\t=\u0011Q_\u0001\b[\u0006\\W\rT8h)\u0019\t\u0019E!\f\u00032!A!qF\u0017\u0011\u0002\u0003\u0007Q*A\u0002eSJDaAa\r.\u0001\u0004y\u0017AB2p]\u001aLw-A\tnC.,Gj\\4%I\u00164\u0017-\u001e7uIE*\"A!\u000f+\u00075\u000b)0A\u0004sK\u000e|'\u000fZ:\u0015\u0011\t}\"1\nB(\u0005'\u0002BA!\u0011\u0003H5\u0011!1\t\u0006\u0004\u0005\u000bb\u0016A\u0002:fG>\u0014H-\u0003\u0003\u0003J\t\r#!D'f[>\u0014\u0018PU3d_J$7\u000fC\u0004\u0003N=\u0002\rAa\u0004\u0002\u0007-,\u0017\u0010C\u0004\u0003R=\u0002\rAa\u0004\u0002\u000bY\fG.^3\t\u000f\tUs\u00061\u0001\u0002\f\u0005IA/[7fgR\fW\u000e\u001d")
public class LogCleanerManagerTest
extends JUnitSuite
implements Logging {
    private final File tmpDir;
    private final File logDir;
    private final TopicPartition topicPartition;
    private final Properties logProps;
    private final LogConfig logConfig;
    private final MockTime time;
    private final scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        LogCleanerManagerTest logCleanerManagerTest = this;
        synchronized (logCleanerManagerTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints() {
        return this.cleanerCheckpoints;
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testGrabFilthiestCompactedLogReturnsLogWithDirtiestRatio() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log1 = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), 1);
        Log log2 = this.createLog(records.sizeInBytes() * 10, LogConfig$.MODULE$.Compact(), 2);
        Log log3 = this.createLog(records.sizeInBytes() * 15, LogConfig$.MODULE$.Compact(), 3);
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        TopicPartition tp1 = new TopicPartition("wishing well", 0);
        logs.put((Object)tp1, (Object)log1);
        TopicPartition tp2 = new TopicPartition("wishing well", 1);
        logs.put((Object)tp2, (Object)log2);
        TopicPartition tp3 = new TopicPartition("wishing well", 2);
        logs.put((Object)tp3, (Object)log3);
        LogCleanerManagerMock cleanerManager = (LogCleanerManagerMock)this.createCleanerManager((Pool<TopicPartition, Log>)logs, true);
        this.cleanerCheckpoints().put((Object)tp1, (Object)BoxesRunTime.boxToLong((long)0L));
        this.cleanerCheckpoints().put((Object)tp2, (Object)BoxesRunTime.boxToLong((long)1L));
        this.cleanerCheckpoints().put((Object)tp3, (Object)BoxesRunTime.boxToLong((long)15L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time()).get();
        Assert.assertEquals((Object)log2, (Object)filthiestLog.log());
        Assert.assertEquals((Object)tp2, (Object)filthiestLog.topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresUncleanablePartitions() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log1 = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), 1);
        Log log2 = this.createLog(records.sizeInBytes() * 10, LogConfig$.MODULE$.Compact(), 2);
        Log log3 = this.createLog(records.sizeInBytes() * 15, LogConfig$.MODULE$.Compact(), 3);
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        TopicPartition tp1 = new TopicPartition("wishing well", 0);
        logs.put((Object)tp1, (Object)log1);
        TopicPartition tp2 = new TopicPartition("wishing well", 1);
        logs.put((Object)tp2, (Object)log2);
        TopicPartition tp3 = new TopicPartition("wishing well", 2);
        logs.put((Object)tp3, (Object)log3);
        LogCleanerManagerMock cleanerManager = (LogCleanerManagerMock)this.createCleanerManager((Pool<TopicPartition, Log>)logs, true);
        this.cleanerCheckpoints().put((Object)tp1, (Object)BoxesRunTime.boxToLong((long)0L));
        this.cleanerCheckpoints().put((Object)tp2, (Object)BoxesRunTime.boxToLong((long)1L));
        this.cleanerCheckpoints().put((Object)tp3, (Object)BoxesRunTime.boxToLong((long)15L));
        cleanerManager.markPartitionUncleanable(log2.dir().getParent(), tp2);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time()).get();
        Assert.assertEquals((Object)log3, (Object)filthiestLog.log());
        Assert.assertEquals((Object)tp3, (Object)filthiestLog.topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresInProgressPartitions() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log1 = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), 1);
        Log log2 = this.createLog(records.sizeInBytes() * 10, LogConfig$.MODULE$.Compact(), 2);
        Log log3 = this.createLog(records.sizeInBytes() * 15, LogConfig$.MODULE$.Compact(), 3);
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        TopicPartition tp1 = new TopicPartition("wishing well", 0);
        logs.put((Object)tp1, (Object)log1);
        TopicPartition tp2 = new TopicPartition("wishing well", 1);
        logs.put((Object)tp2, (Object)log2);
        TopicPartition tp3 = new TopicPartition("wishing well", 2);
        logs.put((Object)tp3, (Object)log3);
        LogCleanerManagerMock cleanerManager = (LogCleanerManagerMock)this.createCleanerManager((Pool<TopicPartition, Log>)logs, true);
        this.cleanerCheckpoints().put((Object)tp1, (Object)BoxesRunTime.boxToLong((long)0L));
        this.cleanerCheckpoints().put((Object)tp2, (Object)BoxesRunTime.boxToLong((long)1L));
        this.cleanerCheckpoints().put((Object)tp3, (Object)BoxesRunTime.boxToLong((long)15L));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time()).get();
        Assert.assertEquals((Object)log3, (Object)filthiestLog.log());
        Assert.assertEquals((Object)tp3, (Object)filthiestLog.topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresBothInProgressPartitionsAndUncleanablePartitions() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log1 = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), 1);
        Log log2 = this.createLog(records.sizeInBytes() * 10, LogConfig$.MODULE$.Compact(), 2);
        Log log3 = this.createLog(records.sizeInBytes() * 15, LogConfig$.MODULE$.Compact(), 3);
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        TopicPartition tp1 = new TopicPartition("wishing well", 0);
        logs.put((Object)tp1, (Object)log1);
        TopicPartition tp2 = new TopicPartition("wishing well", 1);
        logs.put((Object)tp2, (Object)log2);
        TopicPartition tp3 = new TopicPartition("wishing well", 2);
        logs.put((Object)tp3, (Object)log3);
        LogCleanerManagerMock cleanerManager = (LogCleanerManagerMock)this.createCleanerManager((Pool<TopicPartition, Log>)logs, true);
        this.cleanerCheckpoints().put((Object)tp1, (Object)BoxesRunTime.boxToLong((long)0L));
        this.cleanerCheckpoints().put((Object)tp2, (Object)BoxesRunTime.boxToLong((long)1L));
        this.cleanerCheckpoints().put((Object)tp3, (Object)BoxesRunTime.boxToLong((long)15L));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.markPartitionUncleanable(log3.dir().getParent(), tp3);
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time());
        Assert.assertTrue((boolean)filthiestLog.isEmpty());
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderCleanupPolicyDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)readyToDelete);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)readyToDelete);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)readyToDelete);
    }

    @Test
    public void testLogsUnderCleanupIneligibleForCompaction() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.onHighWatermarkIncremented(2L);
        Iterable deletableLog = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)deletableLog.size());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), log.config().segmentSize());
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), log.config().retentionMs());
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.int2Integer(0));
        LogConfig config = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        log.config_$eq(config);
        Option cleanable = cleanerManager.grabFilthiestCompactedLog((Time)this.time());
        Assert.assertEquals((String)"should have 0 logs ready to be compacted", (long)0L, (long)Option$.MODULE$.option2Iterable(cleanable).size());
        cleanerManager.resumeCleaning((Iterable)deletableLog.map((Function1 & Serializable & scala.Serializable)x$1 -> (TopicPartition)x$1._1(), Iterable$.MODULE$.canBuildFrom()));
        Option cleanable2 = cleanerManager.grabFilthiestCompactedLog((Time)this.time());
        Assert.assertEquals((String)"should have 1 logs ready to be compacted", (long)1L, (long)Option$.MODULE$.option2Iterable(cleanable2).size());
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        LogConfig config2 = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        log.config_$eq(config2);
        Iterable deletableLog2 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)deletableLog2.size());
        cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{((LogToClean)cleanable2.get()).topicPartition()})));
        Iterable deletableLog3 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)deletableLog3.size());
    }

    @Test
    public void testConcurrentLogCleanupAndLogTruncation() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortAndPauseCleaning(log.topicPartition());
        cleanerManager.resumeCleaning((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{log.topicPartition()})));
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1 & Serializable & scala.Serializable)x$2 -> (TopicPartition)x$2._1(), Iterable$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log.topicPartition()));
    }

    @Test
    public void testConcurrentLogCleanupAndTopicDeletion() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortCleaning(log.topicPartition());
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1 & Serializable & scala.Serializable)x$3 -> (TopicPartition)x$3._1(), Iterable$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log.topicPartition()));
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderUncleanablePartitions() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.markPartitionUncleanable(log.dir().getParent(), this.topicPartition());
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)readyToDelete);
    }

    @Test
    public void testCleanableOffsetsForNone() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        Log log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        scala.collection.immutable.Map lastClean = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)0L))}));
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, this.topicPartition(), lastClean, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((String)"The first uncleanable offset begins with the active segment.", (long)log.activeSegment().baseOffset(), (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testCleanableOffsetsForTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        Log log = this.makeLog(x$2, x$1);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        LogSegment activeSegAtT0 = log.activeSegment();
        this.time().sleep(compactionLag + 1);
        long t1 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        scala.collection.immutable.Map lastClean = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)0L))}));
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, this.topicPartition(), lastClean, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((String)"The first uncleanable offset begins with the second block of log entries.", (long)activeSegAtT0.baseOffset(), (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testCleanableOffsetsForShortTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        Log log = this.makeLog(x$2, x$1);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        this.time().sleep(compactionLag + 1);
        scala.collection.immutable.Map lastClean = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)0L))}));
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, this.topicPartition(), lastClean, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((String)"The first uncleanable offset begins with active segment.", (long)log.activeSegment().baseOffset(), (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testUndecidedTransactionalDataNotCleanable() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        Log log = this.makeLog(x$2, x$1);
        long producerId = 15L;
        short producerEpoch = (short)0;
        int sequence = 0;
        log.appendAsLeader(MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "1".getBytes(), "a".getBytes()), new SimpleRecord(this.time().milliseconds(), "2".getBytes(), "b".getBytes())}), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)(sequence + 2), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "3".getBytes(), "c".getBytes())}), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        log.onHighWatermarkIncremented(3L);
        this.time().sleep(compactionLag + 1);
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, this.topicPartition(), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)0L))})), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._2$mcJ$sp());
        log.appendAsLeader(MemoryRecords.withEndTransactionMarker((long)this.time().milliseconds(), (long)producerId, (short)producerEpoch, (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.ABORT, 15)), 0, false, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        log.onHighWatermarkIncremented(4L);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, this.topicPartition(), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)0L))})), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((long)3L, (long)cleanableOffsets._2$mcJ$sp());
        this.time().sleep(compactionLag + 1);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, this.topicPartition(), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)0L))})), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((long)4L, (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testDoneCleaning() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        Log log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 445));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)new LogCleaningPaused(1));
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 448));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L);
        Assert.assertTrue((boolean)cleanerManager.cleaningState(this.topicPartition()).isEmpty());
        Assert.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()).nonEmpty());
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L);
        Assert.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(this.topicPartition()).get());
        Assert.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()).nonEmpty());
    }

    @Test
    public void testDoneDeleting() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        TopicPartition tp = new TopicPartition("log", 0);
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 468));
        cleanerManager.setCleaningState(tp, (LogCleaningState)new LogCleaningPaused(1));
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 471));
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assert.assertTrue((boolean)cleanerManager.cleaningState(tp).isEmpty());
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assert.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(tp).get());
    }

    private LogCleanerManager createCleanerManager(Log log) {
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logs.put((Object)this.topicPartition(), (Object)log);
        return this.createCleanerManager((Pool<TopicPartition, Log>)logs, this.createCleanerManager$default$2());
    }

    private LogCleanerManager createCleanerManager(Pool<TopicPartition, Log> pool, boolean toMock) {
        return toMock ? new LogCleanerManagerMock((Seq<File>)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}), pool, null) : new LogCleanerManager((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}), pool, null);
    }

    private boolean createCleanerManager$default$2() {
        return false;
    }

    private Log createLog(int segmentSize, String cleanupPolicy, int segmentsCount) {
        File partitionDir;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), cleanupPolicy);
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.double2Double(0.05));
        LogConfig config = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        File x$1 = partitionDir = new File(this.logDir(), "log-0");
        LogConfig x$2 = config;
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$8 = 3600000;
        int x$9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$10 = new LogDirFailureChannel(10);
        Log log = Log$.MODULE$.apply(x$1, x$2, x$3, x$4, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), segmentsCount).foreach((Function1 & Serializable & scala.Serializable)i -> LogCleanerManagerTest.$anonfun$createLog$1(this, log, BoxesRunTime.unboxToInt((Object)i)));
        return log;
    }

    private int createLog$default$3() {
        return 0;
    }

    private Log makeLog(File dir, LogConfig config) {
        File x$1 = dir;
        LogConfig x$2 = config;
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$8 = 3600000;
        int x$9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$10 = new LogDirFailureChannel(10);
        return Log$.MODULE$.apply(x$1, x$2, x$3, x$4, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10);
    }

    private File makeLog$default$1() {
        return this.logDir();
    }

    private MemoryRecords records(int key, int value, long timestamp) {
        return MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(timestamp, ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes())});
    }

    public static final /* synthetic */ SimpleRecord $anonfun$createLog$2(LogCleanerManagerTest $this, int endOffset$1, LongRef lastTimestamp$1, int offset) {
        long currentTimestamp = $this.time().milliseconds();
        if (offset == endOffset$1 - 1) {
            lastTimestamp$1.elem = currentTimestamp;
        }
        return new SimpleRecord(currentTimestamp, new StringBuilder(4).append("key-").append(offset).toString().getBytes(), new StringBuilder(6).append("value-").append(offset).toString().getBytes());
    }

    public static final /* synthetic */ LogSegment $anonfun$createLog$1(LogCleanerManagerTest $this, Log log$2, int i) {
        int startOffset = i * 10;
        int endOffset = startOffset + 10;
        LogSegment segment = LogUtils$.MODULE$.createSegment(startOffset, $this.logDir(), LogUtils$.MODULE$.createSegment$default$3(), LogUtils$.MODULE$.createSegment$default$4());
        LongRef lastTimestamp = LongRef.create((long)0L);
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(startOffset), endOffset).map((Function1 & Serializable & scala.Serializable)offset -> LogCleanerManagerTest.$anonfun$createLog$2($this, endOffset, lastTimestamp, BoxesRunTime.unboxToInt((Object)offset)), IndexedSeq$.MODULE$.canBuildFrom());
        segment.append((long)endOffset, lastTimestamp.elem, (long)endOffset, MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))));
        return log$2.addSegment(segment);
    }

    public LogCleanerManagerTest() {
        Logging.$init$((Logging)this);
        this.tmpDir = TestUtils$.MODULE$.tempDir();
        this.logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        this.topicPartition = new TopicPartition("log", 0);
        this.logProps = new Properties();
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logConfig = new LogConfig((Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.time = new MockTime(1400000000000L, 1000L);
        this.cleanerCheckpoints = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public class LogCleanerManagerMock
    extends LogCleanerManager {
        public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
            return this.kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer().cleanerCheckpoints().toMap(Predef$.MODULE$.$conforms());
        }

        public /* synthetic */ LogCleanerManagerTest kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer() {
            return LogCleanerManagerTest.this;
        }

        public LogCleanerManagerMock(Seq<File> logDirs, Pool<TopicPartition, Log> logs, LogDirFailureChannel logDirFailureChannel) {
            if (LogCleanerManagerTest.this == null) {
                throw null;
            }
            super(logDirs, logs, logDirFailureChannel);
        }
    }
}

