/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import kafka.log.BrokerCompressionTest$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.message.BrokerCompressionCodec$;
import kafka.message.CompressionCodec;
import kafka.message.CompressionCodec$;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchDataInfo;
import kafka.server.LogDirFailureChannel;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.scalatest.junit.JUnitSuite;
import scala.None$;
import scala.Option;
import scala.reflect.ScalaSignature;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c\u0001B\n\u0015\u0001eA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\te\u0001\u0011\t\u0011)A\u0005K!)1\u0007\u0001C\u0001i!9\u0011\b\u0001b\u0001\n\u0003Q\u0004BB\"\u0001A\u0003%1\bC\u0004E\u0001\t\u0007I\u0011\u0001\u001e\t\r\u0015\u0003\u0001\u0015!\u0003<\u0011\u001d1\u0005A1A\u0005\u0002\u001dCaA\u0014\u0001!\u0002\u0013A\u0005bB(\u0001\u0005\u0004%\t\u0001\u0015\u0005\u0007)\u0002\u0001\u000b\u0011B)\t\u000bU\u0003A\u0011\u0001,\t\u000b\u0005\u0004A\u0011\u0001,\b\u000bU$\u0002\u0012\u0001<\u0007\u000bM!\u0002\u0012A<\t\u000bMzA\u0011\u0001@\t\r}|A\u0011AA\u0001\u0011%\t\tdDA\u0001\n\u0013\t\u0019DA\u000bCe>\\WM]\"p[B\u0014Xm]:j_:$Vm\u001d;\u000b\u0005U1\u0012a\u00017pO*\tq#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Q\u0002CA\u000e#\u001b\u0005a\"BA\u000f\u001f\u0003\u0015QWO\\5u\u0015\ty\u0002%A\u0005tG\u0006d\u0017\r^3ti*\t\u0011%A\u0002pe\u001eL!a\t\u000f\u0003\u0015)+f.\u001b;Tk&$X-\u0001\nnKN\u001c\u0018mZ3D_6\u0004(/Z:tS>t\u0007C\u0001\u00140\u001d\t9S\u0006\u0005\u0002)W5\t\u0011F\u0003\u0002+1\u00051AH]8pizR\u0011\u0001L\u0001\u0006g\u000e\fG.Y\u0005\u0003]-\na\u0001\u0015:fI\u00164\u0017B\u0001\u00192\u0005\u0019\u0019FO]5oO*\u0011afK\u0001\u0012EJ|7.\u001a:D_6\u0004(/Z:tS>t\u0017A\u0002\u001fj]&$h\bF\u00026oa\u0002\"A\u000e\u0001\u000e\u0003QAQ\u0001J\u0002A\u0002\u0015BQAM\u0002A\u0002\u0015\na\u0001^7q\t&\u0014X#A\u001e\u0011\u0005q\nU\"A\u001f\u000b\u0005yz\u0014AA5p\u0015\u0005\u0001\u0015\u0001\u00026bm\u0006L!AQ\u001f\u0003\t\u0019KG.Z\u0001\bi6\u0004H)\u001b:!\u0003\u0019awn\u001a#je\u00069An\\4ESJ\u0004\u0013\u0001\u0002;j[\u0016,\u0012\u0001\u0013\t\u0003\u00132k\u0011A\u0013\u0006\u0003\u0017Z\tQ!\u001e;jYNL!!\u0014&\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\n\u0011\u0002\\8h\u0007>tg-[4\u0016\u0003E\u0003\"A\u000e*\n\u0005M#\"!\u0003'pO\u000e{gNZ5h\u0003)awnZ\"p]\u001aLw\rI\u0001\ti\u0016\f'\u000fR8x]R\tq\u000b\u0005\u0002Y36\t1&\u0003\u0002[W\t!QK\\5uQ\taA\f\u0005\u0002^?6\taL\u0003\u0002\u001eA%\u0011\u0001M\u0018\u0002\u0006\u0003\u001a$XM]\u0001\u001ai\u0016\u001cHO\u0011:pW\u0016\u00148+\u001b3f\u0007>l\u0007O]3tg&|g\u000e\u000b\u0002\u000eGB\u0011Q\fZ\u0005\u0003Kz\u0013A\u0001V3ti\"\"\u0001aZ7o!\tA7.D\u0001j\u0015\tQg,\u0001\u0004sk:tWM]\u0005\u0003Y&\u0014qAU;o/&$\b.A\u0003wC2,XmI\u0001p!\t\u00018/D\u0001r\u0015\t\u0011h,A\u0004sk:tWM]:\n\u0005Q\f(!\u0004)be\u0006lW\r^3sSj,G-A\u000bCe>\\WM]\"p[B\u0014Xm]:j_:$Vm\u001d;\u0011\u0005Yz1cA\bywB\u0011\u0001,_\u0005\u0003u.\u0012a!\u00118z%\u00164\u0007C\u0001-}\u0013\ti8F\u0001\u0007TKJL\u0017\r\\5{C\ndW\rF\u0001w\u0003)\u0001\u0018M]1nKR,'o]\u000b\u0003\u0003\u0007\u0001b!!\u0002\u0002\f\u0005=QBAA\u0004\u0015\r\tIaP\u0001\u0005kRLG.\u0003\u0003\u0002\u000e\u0005\u001d!AC\"pY2,7\r^5p]B!\u0001,!\u0005&\u0013\r\t\u0019b\u000b\u0002\u0006\u0003J\u0014\u0018-\u001f\u0015\u0004#\u0005]\u0001\u0003BA\r\u0003WqA!a\u0007\u0002(9!\u0011QDA\u0013\u001d\u0011\ty\"a\t\u000f\u0007!\n\t#C\u0001\"\u0013\ti\u0002%\u0003\u0002s=&\u0019\u0011\u0011F9\u0002\u001bA\u000b'/Y7fi\u0016\u0014\u0018N_3e\u0013\u0011\ti#a\f\u0003\u0015A\u000b'/Y7fi\u0016\u00148OC\u0002\u0002*E\f1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u0007\t\u0005\u0003o\ti$\u0004\u0002\u0002:)\u0019\u00111H \u0002\t1\fgnZ\u0005\u0005\u0003\u007f\tID\u0001\u0004PE*,7\r\u001e")
public class BrokerCompressionTest
extends JUnitSuite {
    private final String messageCompression;
    private final String brokerCompression;
    private final File tmpDir;
    private final File logDir;
    private final MockTime time;
    private final LogConfig logConfig;

    @Parameterized.Parameters
    public static Collection<String[]> parameters() {
        return BrokerCompressionTest$.MODULE$.parameters();
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public MockTime time() {
        return this.time;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testBrokerSideCompression() {
        CompressionCodec messageCompressionCode = CompressionCodec$.MODULE$.getCompressionCodec(this.messageCompression);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CompressionTypeProp(), this.brokerCompression);
        File x$1 = this.logDir();
        LogConfig x$2 = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$8 = 3600000;
        int x$9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$10 = new LogDirFailureChannel(10);
        Log log = Log$.MODULE$.apply(x$1, x$2, x$3, x$4, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10);
        log.appendAsLeader(MemoryRecords.withRecords((CompressionType)CompressionType.forId((int)messageCompressionCode.codec()), (int)0, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes())}), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        if (!this.brokerCompression.equals("producer")) {
            CompressionCodec brokerCompressionCode = BrokerCompressionCodec$.MODULE$.getCompressionCodec(this.brokerCompression);
            Assert.assertEquals((String)new StringBuilder(39).append("Compression at offset 0 should produce ").append(brokerCompressionCode.name()).toString(), (long)brokerCompressionCode.codec(), (long)BrokerCompressionTest.readBatch$1((int)0, (Log)log).compressionType().id);
        } else {
            Assert.assertEquals((String)new StringBuilder(39).append("Compression at offset 0 should produce ").append(messageCompressionCode.name()).toString(), (long)messageCompressionCode.codec(), (long)BrokerCompressionTest.readBatch$1((int)0, (Log)log).compressionType().id);
        }
    }

    private static final RecordBatch readBatch$1(int offset, Log log$1) {
        long x$1 = offset;
        int x$2 = 4096;
        None$ x$3 = None$.MODULE$;
        boolean x$4 = false;
        boolean x$5 = true;
        FetchDataInfo fetchInfo = log$1.read(x$1, x$2, (Option)x$3, x$5, x$4);
        return (RecordBatch)fetchInfo.records().batches().iterator().next();
    }

    public BrokerCompressionTest(String messageCompression, String brokerCompression) {
        this.messageCompression = messageCompression;
        this.brokerCompression = brokerCompression;
        this.tmpDir = TestUtils$.MODULE$.tempDir();
        this.logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        this.time = new MockTime(0L, 0L);
        this.logConfig = LogConfig$.MODULE$.apply();
    }
}

