/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.controller.ControllerStats;
import kafka.network.Processor;
import kafka.server.KafkaApis;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005mg\u0001\u0002\u0017.\u0001IBQ!\u000f\u0001\u0005\u0002iBq!\u0010\u0001C\u0002\u0013\u0005a\b\u0003\u0004F\u0001\u0001\u0006Ia\u0010\u0005\b\r\u0002\u0011\r\u0011\"\u0001?\u0011\u00199\u0005\u0001)A\u0005\u007f!9\u0001\n\u0001b\u0001\n\u0003I\u0005BB'\u0001A\u0003%!\nC\u0004O\u0001\u0001\u0007I\u0011A(\t\u000fa\u0003\u0001\u0019!C\u00013\"1q\f\u0001Q!\nACq\u0001\u0019\u0001A\u0002\u0013\u0005q\nC\u0004b\u0001\u0001\u0007I\u0011\u00012\t\r\u0011\u0004\u0001\u0015)\u0003Q\u0011\u001d)\u0007\u00011A\u0005\u0002\u0019Dq!\u001f\u0001A\u0002\u0013\u0005!\u0010\u0003\u0004}\u0001\u0001\u0006Ka\u001a\u0005\b{\u0002\u0001\r\u0011\"\u0001\u007f\u0011%\t9\u0001\u0001a\u0001\n\u0003\tI\u0001C\u0004\u0002\u000e\u0001\u0001\u000b\u0015B@\t\u0013\u0005=\u0001A1A\u0005\u0002\u0005E\u0001\u0002CA\u000f\u0001\u0001\u0006I!a\u0005\t\u0013\u0005}\u0001A1A\u0005\u0002\u0005\u0005\u0002\u0002CA\u0018\u0001\u0001\u0006I!a\t\t\u0011\u0005E\u0002A1A\u0005\u0002yBq!a\r\u0001A\u0003%q\bC\u0005\u00026\u0001\u0011\r\u0011\"\u0001\u00028!A\u0011Q\n\u0001!\u0002\u0013\tI\u0004C\u0005\u0002P\u0001\u0011\r\u0011\"\u0001\u00028!A\u0011\u0011\u000b\u0001!\u0002\u0013\tI\u0004C\u0004\u0002T\u0001!\t%!\u0016\t\u000f\u0005\u0015\u0004\u0001\"\u0011\u0002V!9\u0011q\u000e\u0001\u0005\n\u0005E\u0004bBA=\u0001\u0011\u0005\u0011Q\u000b\u0005\b\u0003\u0007\u0003A\u0011AA+\u0011\u001d\ty\t\u0001C\u0001\u0003+Bq!a%\u0001\t\u0003\t)\u0006C\u0004\u0002\u001a\u0002!\t!!\u0016\t\u000f\u0005u\u0005\u0001\"\u0001\u0002V!9\u0011q\u0014\u0001\u0005\u0002\u0005U\u0003bBAQ\u0001\u0011%\u00111\u0015\u0005\b\u0003O\u0003A\u0011BAU\u0011\u001d\t\t\r\u0001C\u0001\u0003+Bq!!2\u0001\t\u0013\t9MA\rV]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8UKN$(B\u0001\u00180\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\u000b\u0003A\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001gA\u0011AgN\u0007\u0002k)\u0011agL\u0001\u0003u.L!\u0001O\u001b\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\t1\b\u0005\u0002=\u00015\tQ&A\u0005ce>\\WM]%ecU\tq\b\u0005\u0002A\u00076\t\u0011IC\u0001C\u0003\u0015\u00198-\u00197b\u0013\t!\u0015IA\u0002J]R\f!B\u0019:pW\u0016\u0014\u0018\nZ\u0019!\u0003%\u0011'o\\6fe&#''\u0001\u0006ce>\\WM]%ee\u0001\n\u0001$\u001a8bE2,7i\u001c8ue>dG.\u001a3TQV$Hm\\<o+\u0005Q\u0005C\u0001!L\u0013\ta\u0015IA\u0004C_>dW-\u00198\u00023\u0015t\u0017M\u00197f\u0007>tGO]8mY\u0016$7\u000b[;uI><h\u000eI\u0001\rG>tg-[4Qe>\u00048/M\u000b\u0002!B\u0011\u0011KV\u0007\u0002%*\u00111\u000bV\u0001\u0005kRLGNC\u0001V\u0003\u0011Q\u0017M^1\n\u0005]\u0013&A\u0003)s_B,'\u000f^5fg\u0006\u00012m\u001c8gS\u001e\u0004&o\u001c9tc}#S-\u001d\u000b\u00035v\u0003\"\u0001Q.\n\u0005q\u000b%\u0001B+oSRDqAX\u0005\u0002\u0002\u0003\u0007\u0001+A\u0002yIE\nQbY8oM&<\u0007K]8qgF\u0002\u0013\u0001D2p]\u001aLw\r\u0015:paN\u0014\u0014\u0001E2p]\u001aLw\r\u0015:paN\u0014t\fJ3r)\tQ6\rC\u0004_\u0019\u0005\u0005\t\u0019\u0001)\u0002\u001b\r|gNZ5h!J|\u0007o\u001d\u001a!\u0003\u001d\u0019wN\u001c4jON,\u0012a\u001a\t\u0004QB\u001chBA5o\u001d\tQW.D\u0001l\u0015\ta\u0017'\u0001\u0004=e>|GOP\u0005\u0002\u0005&\u0011q.Q\u0001\ba\u0006\u001c7.Y4f\u0013\t\t(OA\u0002TKFT!a\\!\u0011\u0005Q<X\"A;\u000b\u0005Y|\u0013AB:feZ,'/\u0003\u0002yk\nY1*\u00194lC\u000e{gNZ5h\u0003-\u0019wN\u001c4jON|F%Z9\u0015\u0005i[\bb\u00020\u0010\u0003\u0003\u0005\raZ\u0001\tG>tg-[4tA\u000591/\u001a:wKJ\u001cX#A@\u0011\t!\u0004\u0018\u0011\u0001\t\u0004i\u0006\r\u0011bAA\u0003k\nY1*\u00194lCN+'O^3s\u0003-\u0019XM\u001d<feN|F%Z9\u0015\u0007i\u000bY\u0001C\u0004_%\u0005\u0005\t\u0019A@\u0002\u0011M,'O^3sg\u0002\naA]1oI>lWCAA\n!\u0011\t)\"!\u0007\u000e\u0005\u0005]!BA*B\u0013\u0011\tY\"a\u0006\u0003\rI\u000bg\u000eZ8n\u0003\u001d\u0011\u0018M\u001c3p[\u0002\nQ\u0001^8qS\u000e,\"!a\t\u0011\t\u0005\u0015\u00121F\u0007\u0003\u0003OQ1!!\u000bU\u0003\u0011a\u0017M\\4\n\t\u00055\u0012q\u0005\u0002\u0007'R\u0014\u0018N\\4\u0002\rQ|\u0007/[2!\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\u0002\u0019A\f'\u000f^5uS>t\u0017\n\u001a\u0011\u0002\u001f-\fgm[1Ba&\u001cHj\\4hKJ,\"!!\u000f\u0011\t\u0005m\u0012\u0011J\u0007\u0003\u0003{QA!a\u0010\u0002B\u0005)An\\45U*!\u00111IA#\u0003\u0019\t\u0007/Y2iK*\u0011\u0011qI\u0001\u0004_J<\u0017\u0002BA&\u0003{\u0011a\u0001T8hO\u0016\u0014\u0018\u0001E6bM.\f\u0017\t]5t\u0019><w-\u001a:!\u0003YqW\r^<pe.\u0004&o\\2fgN|'\u000fT8hO\u0016\u0014\u0018a\u00068fi^|'o\u001b)s_\u000e,7o]8s\u0019><w-\u001a:!\u0003\u0015\u0019X\r^+q)\u0005Q\u0006f\u0001\u0010\u0002ZA!\u00111LA1\u001b\t\tiF\u0003\u0003\u0002`\u0005\u0015\u0013!\u00026v]&$\u0018\u0002BA2\u0003;\u0012aAQ3g_J,\u0017\u0001\u0003;fCJ$un\u001e8)\u0007}\tI\u0007\u0005\u0003\u0002\\\u0005-\u0014\u0002BA7\u0003;\u0012Q!\u00114uKJ\fAb\u001d;beR\u0014%o\\6feN$2AWA:\u0011\u001d\t)\b\ta\u0001\u0003o\nqa\u00197vgR,'\u000fE\u0002iaB\u000b\u0001\u0005^3tiVs7\r\\3b]2+\u0017\rZ3s\u000b2,7\r^5p]\u0016s\u0017M\u00197fI\"\u001a\u0011%! \u0011\t\u0005m\u0013qP\u0005\u0005\u0003\u0003\u000biF\u0001\u0003UKN$\u0018!\t;fgR,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:$\u0015n]1cY\u0016$\u0007f\u0001\u0012\u0002\bB!\u00111LAE\u0013\u0011\tY)!\u0018\u0003\r%;gn\u001c:fQ\r\u0011\u0013QP\u00010i\u0016\u001cH/\u00168dY\u0016\fg\u000eT3bI\u0016\u0014X\t\\3di&|g.\u00128bE2,GMQ=U_BL7m\u0014<feJLG-\u001a\u0015\u0004G\u0005u\u0014A\f;fgR\u001cE.Z1o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o\t&\u001c\u0018M\u00197fI\nKHk\u001c9jG>3XM\u001d:jI\u0016D3\u0001JADQ\r!\u0013QP\u0001.i\u0016\u001cH/\u00168dY\u0016\fg\u000eT3bI\u0016\u0014X\t\\3di&|g.\u00138wC2LG\rV8qS\u000e|e/\u001a:sS\u0012,\u0007fA\u0013\u0002~\u0005\u0011c/\u001a:jMf,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:,e.\u00192mK\u0012\f1E^3sS\u001aLXK\\2mK\u0006tG*Z1eKJ,E.Z2uS>tG)[:bE2,G-\u0001\btQV$Hm\\<o'\u0016\u0014h/\u001a:\u0015\u0007i\u000b)\u000b\u0003\u0004wQ\u0001\u0007\u0011\u0011A\u0001\u0013G>t7/^7f\u00032dW*Z:tC\u001e,7\u000f\u0006\u0004\u0002,\u0006m\u0016Q\u0018\t\u0005QB\fi\u000b\u0005\u0003\u00020\u0006]f\u0002BAY\u0003g\u0003\"A[!\n\u0007\u0005U\u0016)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003[\tILC\u0002\u00026\u0006Cq!a\b*\u0001\u0004\ti\u000b\u0003\u0004\u0002@&\u0002\raP\u0001\f]VlW*Z:tC\u001e,7/\u0001\u0013uKN$Hk\u001c9jGVs7\r\\3b]2+\u0017\rZ3s\u000b2,7\r^5p]\u0016s\u0017M\u00197fQ\rQ\u0013QP\u0001\u0012GJ,\u0017\r^3BI6Lgn\u00117jK:$HCAAe!\u0011\tY-a6\u000e\u0005\u00055'\u0002BAh\u0003#\fQ!\u00193nS:TA!a5\u0002V\u000691\r\\5f]R\u001c(b\u0001\u0019\u0002B%!\u0011\u0011\\Ag\u0005-\tE-\\5o\u00072LWM\u001c;")
public class UncleanLeaderElectionTest
extends ZooKeeperTestHarness {
    private final int brokerId1;
    private final int brokerId2;
    private final boolean enableControlledShutdown;
    private Properties configProps1 = null;
    private Properties configProps2 = null;
    private Seq<KafkaConfig> configs = (Seq)Seq$.MODULE$.empty();
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.empty();
    private final Random random = new Random();
    private final String topic = new StringBuilder(5).append("topic").append(this.random().nextLong()).toString();
    private final int partitionId;
    private final Logger kafkaApisLogger = Logger.getLogger(KafkaApis.class);
    private final Logger networkProcessorLogger = Logger.getLogger(Processor.class);

    public int brokerId1() {
        return this.brokerId1;
    }

    public int brokerId2() {
        return this.brokerId2;
    }

    public boolean enableControlledShutdown() {
        return this.enableControlledShutdown;
    }

    public Properties configProps1() {
        return this.configProps1;
    }

    public void configProps1_$eq(Properties x$1) {
        this.configProps1 = x$1;
    }

    public Properties configProps2() {
        return this.configProps2;
    }

    public void configProps2_$eq(Properties x$1) {
        this.configProps2 = x$1;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public void configs_$eq(Seq<KafkaConfig> x$1) {
        this.configs = x$1;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public Random random() {
        return this.random;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public Logger kafkaApisLogger() {
        return this.kafkaApisLogger;
    }

    public Logger networkProcessorLogger() {
        return this.networkProcessorLogger;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.configProps1_$eq(TestUtils$.MODULE$.createBrokerConfig(this.brokerId1(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        this.configProps2_$eq(TestUtils$.MODULE$.createBrokerConfig(this.brokerId2(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)configProps -> {
            configProps.put("controlled.shutdown.enable", ((Object)BoxesRunTime.boxToBoolean((boolean)this.enableControlledShutdown())).toString());
            configProps.put("controlled.shutdown.max.retries", "1");
            return configProps.put("controlled.shutdown.retry.backoff.ms", "1000");
        });
        this.kafkaApisLogger().setLevel(Level.FATAL);
        this.networkProcessorLogger().setLevel(Level.FATAL);
    }

    @Override
    @After
    public void tearDown() {
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            CoreUtils$.MODULE$.delete(server.config().logDirs());
            return BoxedUnit.UNIT;
        });
        this.kafkaApisLogger().setLevel(Level.ERROR);
        this.networkProcessorLogger().setLevel(Level.ERROR);
        super.tearDown();
    }

    private void startBrokers(Seq<Properties> cluster) {
        cluster.foreach((Function1 & Serializable & scala.Serializable)props -> {
            UncleanLeaderElectionTest.$anonfun$startBrokers$1(this, props);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testUncleanLeaderElectionEnabled() {
        this.configProps1().put("unclean.leader.election.enable", "true");
        this.configProps2().put("unclean.leader.election.enable", "true");
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}))), this.servers());
        this.verifyUncleanLeaderElectionEnabled();
    }

    @Test
    @Ignore
    public void testUncleanLeaderElectionDisabled() {
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}))), this.servers());
        this.verifyUncleanLeaderElectionDisabled();
    }

    @Test
    public void testUncleanLeaderElectionEnabledByTopicOverride() {
        this.configProps1().put("unclean.leader.election.enable", "false");
        this.configProps2().put("unclean.leader.election.enable", "false");
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "true");
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}))), this.servers(), topicProps);
        this.verifyUncleanLeaderElectionEnabled();
    }

    @Test
    @Ignore
    public void testCleanLeaderElectionDisabledByTopicOverride() {
        this.configProps1().put("unclean.leader.election.enable", "true");
        this.configProps2().put("unclean.leader.election.enable", "true");
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "false");
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}))), this.servers(), topicProps);
        this.verifyUncleanLeaderElectionDisabled();
    }

    @Test
    public void testUncleanLeaderElectionInvalidTopicOverride() {
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1()}))));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "invalid");
        this.intercept((Function0 & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1()})))}))), this.servers(), topicProps), ClassTag$.MODULE$.apply(ConfigException.class), new Position("UncleanLeaderElectionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
    }

    public void verifyUncleanLeaderElectionEnabled() {
        int leaderId = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("Leader for ").append(this.topic()).append(new StringOps(Predef$.MODULE$.augmentString(" is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leaderId)}))).toString());
        Assert.assertTrue((String)new StringBuilder(46).append("Leader id is set to expected value for topic: ").append(this.topic()).toString(), (leaderId == this.brokerId1() || leaderId == this.brokerId2() ? 1 : 0) != 0);
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Follower for ").append(this.topic()).append(new StringOps(Predef$.MODULE$.augmentString(" is: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)followerId)}))).toString());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "first", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)Nil$.MODULE$), this.consumeAllMessages(this.topic(), 1));
        ((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$3(followerId, server)))).map((Function1 & Serializable & scala.Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "second", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
        Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
        this.servers().map((Function1 & Serializable & scala.Serializable)x$1 -> {
            UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$5(x$1);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        ((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$6(leaderId, x$2)))).map((Function1 & Serializable & scala.Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        KafkaServer followerServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$8(followerId, x$3))).get();
        followerServer.startup();
        KafkaZkClient x$32 = this.zkClient();
        String x$4 = this.topic();
        int x$5 = this.partitionId();
        Some x$6 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
        long x$7 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$8 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$32, x$4, x$5, x$7, x$8, (Option<Object>)x$6);
        Assert.assertEquals((long)1L, (long)followerServer.kafkaController().controllerContext().stats().uncleanLeaderElectionRate().count());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
        Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"third", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
    }

    public void verifyUncleanLeaderElectionDisabled() {
        int leaderId = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("Leader for ").append(this.topic()).append(new StringOps(Predef$.MODULE$.augmentString(" is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leaderId)}))).toString());
        Assert.assertTrue((String)new StringBuilder(46).append("Leader id is set to expected value for topic: ").append(this.topic()).toString(), (leaderId == this.brokerId1() || leaderId == this.brokerId2() ? 1 : 0) != 0);
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Follower for ").append(this.topic()).append(new StringOps(Predef$.MODULE$.augmentString(" is: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)followerId)}))).toString());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "first", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)Nil$.MODULE$), this.consumeAllMessages(this.topic(), 1));
        ((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$3(followerId, server)))).map((Function1 & Serializable & scala.Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "second", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
        Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
        this.servers().map((Function1 & Serializable & scala.Serializable)server -> {
            UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$5(server);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        ((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$6(leaderId, server)))).map((Function1 & Serializable & scala.Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        KafkaServer followerServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$8(followerId, x$4))).get();
        followerServer.startup();
        KafkaZkClient x$3 = this.zkClient();
        String x$42 = this.topic();
        int x$5 = this.partitionId();
        Some x$6 = new Some((Object)BoxesRunTime.boxToInteger((int)-1));
        long x$7 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$8 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$3, x$42, x$5, x$7, x$8, (Option<Object>)x$6);
        Assert.assertEquals((long)0L, (long)followerServer.kafkaController().controllerContext().stats().uncleanLeaderElectionRate().count());
        try {
            TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", 1000, 1000);
            throw this.fail("Message produced while leader is down should fail, but it succeeded", new Position("UncleanLeaderElectionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
        }
        catch (Throwable throwable) {
            ExecutionException executionException;
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof ExecutionException) || !((executionException = (ExecutionException)throwable2).getCause() instanceof TimeoutException)) {
                throw throwable;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            Assert.assertEquals((Object)List$.MODULE$.empty(), this.consumeAllMessages(this.topic(), 0));
            ((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$9(leaderId, server)))).map((Function1 & Serializable & scala.Serializable)server -> {
                server.startup();
                return BoxedUnit.UNIT;
            }, Seq$.MODULE$.canBuildFrom());
            KafkaZkClient x$9 = this.zkClient();
            String x$10 = this.topic();
            int x$11 = this.partitionId();
            Some x$12 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderId));
            long x$13 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
            Option<Object> x$14 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$9, x$10, x$11, x$13, x$14, (Option<Object>)x$12);
            TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            ((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$11(leaderId, server)))).map((Function1 & Serializable & scala.Serializable)server -> {
                this.shutdownServer(server);
                return BoxedUnit.UNIT;
            }, Seq$.MODULE$.canBuildFrom());
            KafkaZkClient x$15 = this.zkClient();
            String x$16 = this.topic();
            int x$17 = this.partitionId();
            Some x$18 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
            long x$19 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
            Option<Object> x$20 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$15, x$16, x$17, x$19, x$20, (Option<Object>)x$18);
            Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)new .colon.colon((Object)"third", (List)Nil$.MODULE$))), this.consumeAllMessages(this.topic(), 3));
            return;
        }
    }

    private void shutdownServer(KafkaServer server) {
        server.shutdown();
        server.awaitShutdown();
    }

    private Seq<String> consumeAllMessages(String topic, int numMessages) {
        Seq seq;
        String brokerList;
        String x$1 = brokerList = TestUtils$.MODULE$.bootstrapServers(this.servers(), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
        String x$2 = new StringBuilder(5).append("group").append(this.random().nextLong()).toString();
        boolean x$3 = false;
        StringDeserializer x$4 = new StringDeserializer();
        String x$52 = TestUtils$.MODULE$.createConsumer$default$3();
        boolean x$6 = TestUtils$.MODULE$.createConsumer$default$5();
        int x$7 = TestUtils$.MODULE$.createConsumer$default$6();
        SecurityProtocol x$8 = TestUtils$.MODULE$.createConsumer$default$7();
        Option<File> x$9 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$10 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$11 = TestUtils$.MODULE$.createConsumer$default$10();
        try (KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(x$1, x$2, x$52, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$4);){
            TopicPartition tp = new TopicPartition(topic, this.partitionId());
            consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava());
            consumer.seek(tp, 0L);
            seq = (Seq)TestUtils$.MODULE$.consumeRecords(consumer, numMessages, TestUtils$.MODULE$.consumeRecords$default$3()).map((Function1 & Serializable & scala.Serializable)x$5 -> (String)x$5.value(), Seq$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    @Test
    public void testTopicUncleanLeaderElectionEnable() {
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        this.adminZkClient().createTopicWithAssignment(this.topic(), new Properties(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))})));
        int leaderId = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "first", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)Nil$.MODULE$), this.consumeAllMessages(this.topic(), 1));
        ((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnable$1(followerId, server)))).map((Function1 & Serializable & scala.Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "second", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
        Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
        this.servers().map((Function1 & Serializable & scala.Serializable)server -> {
            UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnable$3(server);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        ((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnable$4(leaderId, server)))).map((Function1 & Serializable & scala.Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        KafkaServer followerServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnable$6(followerId, x$6))).get();
        followerServer.startup();
        Assert.assertEquals((long)0L, (long)followerServer.kafkaController().controllerContext().stats().uncleanLeaderElectionRate().count());
        try {
            TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", 1000, 1000);
            throw this.fail("Message produced while leader is down should fail, but it succeeded", new Position("UncleanLeaderElectionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
        }
        catch (Throwable throwable) {
            ExecutionException executionException;
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof ExecutionException) || !((executionException = (ExecutionException)throwable2).getCause() instanceof TimeoutException)) {
                throw throwable;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            Assert.assertEquals((Object)List$.MODULE$.empty(), this.consumeAllMessages(this.topic(), 0));
            AdminClient adminClient = this.createAdminClient();
            Properties newProps = new Properties();
            newProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
            TestUtils$.MODULE$.alterTopicConfigs(adminClient, this.topic(), newProps).all().get();
            adminClient.close();
            KafkaZkClient x$3 = this.zkClient();
            String x$4 = this.topic();
            int x$5 = this.partitionId();
            Some x$62 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
            long x$7 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
            Option<Object> x$8 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$3, x$4, x$5, x$7, x$8, (Option<Object>)x$62);
            Assert.assertEquals((long)1L, (long)followerServer.kafkaController().controllerContext().stats().uncleanLeaderElectionRate().count());
            TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
            Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"third", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
            return;
        }
    }

    private AdminClient createAdminClient() {
        Properties config = new Properties();
        String bootstrapServers = TestUtils$.MODULE$.bootstrapServers(this.servers(), new ListenerName("PLAINTEXT"));
        config.put("bootstrap.servers", bootstrapServers);
        config.put("metadata.max.age.ms", "10");
        return AdminClient.create((Properties)config);
    }

    public static final /* synthetic */ void $anonfun$startBrokers$1(UncleanLeaderElectionTest $this, Properties props) {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        KafkaServer server = TestUtils$.MODULE$.createServer(config, TestUtils$.MODULE$.createServer$default$2());
        $this.configs_$eq((Seq<KafkaConfig>)((Seq)$this.configs().$plus$plus((GenTraversableOnce)new .colon.colon((Object)config, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())));
        $this.servers_$eq((Seq<KafkaServer>)((Seq)$this.servers().$plus$plus((GenTraversableOnce)new .colon.colon((Object)server, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())));
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionEnabled$3(int followerId$1, KafkaServer server) {
        return server.config().brokerId() == followerId$1;
    }

    public static final /* synthetic */ void $anonfun$verifyUncleanLeaderElectionEnabled$5(KafkaServer x$1) {
        ControllerStats qual$1 = x$1.kafkaController().controllerContext().stats();
        String x$12 = "UncleanLeaderElectionsPerSec";
        Map x$2 = qual$1.removeMetric$default$2();
        qual$1.removeMetric(x$12, x$2);
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionEnabled$6(int leaderId$1, KafkaServer x$2) {
        return x$2.config().brokerId() == leaderId$1;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionEnabled$8(int followerId$1, KafkaServer x$3) {
        return x$3.config().brokerId() == followerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$3(int followerId$2, KafkaServer server) {
        return server.config().brokerId() == followerId$2;
    }

    public static final /* synthetic */ void $anonfun$verifyUncleanLeaderElectionDisabled$5(KafkaServer server) {
        ControllerStats qual$1 = server.kafkaController().controllerContext().stats();
        String x$1 = "UncleanLeaderElectionsPerSec";
        Map x$2 = qual$1.removeMetric$default$2();
        qual$1.removeMetric(x$1, x$2);
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$6(int leaderId$2, KafkaServer server) {
        return server.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$8(int followerId$2, KafkaServer x$4) {
        return x$4.config().brokerId() == followerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$9(int leaderId$2, KafkaServer server) {
        return server.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$11(int leaderId$2, KafkaServer server) {
        return server.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicUncleanLeaderElectionEnable$1(int followerId$3, KafkaServer server) {
        return server.config().brokerId() == followerId$3;
    }

    public static final /* synthetic */ void $anonfun$testTopicUncleanLeaderElectionEnable$3(KafkaServer server) {
        ControllerStats qual$1 = server.kafkaController().controllerContext().stats();
        String x$1 = "UncleanLeaderElectionsPerSec";
        Map x$2 = qual$1.removeMetric$default$2();
        qual$1.removeMetric(x$1, x$2);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicUncleanLeaderElectionEnable$4(int leaderId$3, KafkaServer server) {
        return server.config().brokerId() == leaderId$3;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicUncleanLeaderElectionEnable$6(int followerId$3, KafkaServer x$6) {
        return x$6.config().brokerId() == followerId$3;
    }

    public UncleanLeaderElectionTest() {
        this.brokerId1 = 0;
        this.brokerId2 = 1;
        this.enableControlledShutdown = true;
        this.partitionId = 0;
    }
}

