/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.util.Arrays;
import kafka.coordinator.group.MemberMetadata;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001-4A!\u0006\f\u0001;!)\u0001\u0006\u0001C\u0001S!9A\u0006\u0001b\u0001\n\u0003i\u0003B\u0002\u001c\u0001A\u0003%a\u0006C\u00048\u0001\t\u0007I\u0011A\u0017\t\ra\u0002\u0001\u0015!\u0003/\u0011\u001dI\u0004A1A\u0005\u00025BaA\u000f\u0001!\u0002\u0013q\u0003bB\u001e\u0001\u0005\u0004%\t!\f\u0005\u0007y\u0001\u0001\u000b\u0011\u0002\u0018\t\u000fu\u0002!\u0019!C\u0001[!1a\b\u0001Q\u0001\n9Bqa\u0010\u0001C\u0002\u0013\u0005\u0001\t\u0003\u0004H\u0001\u0001\u0006I!\u0011\u0005\b\u0011\u0002\u0011\r\u0011\"\u0001A\u0011\u0019I\u0005\u0001)A\u0005\u0003\")!\n\u0001C\u0001\u0017\")Q\u000b\u0001C\u0001\u0017\")q\u000b\u0001C\u0001\u0017\")\u0011\f\u0001C\u0001\u0017\")\u0011\u000e\u0001C\u0001\u0017\n\u0011R*Z7cKJlU\r^1eCR\fG+Z:u\u0015\t9\u0002$A\u0003he>,\bO\u0003\u0002\u001a5\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u0005Y\u0012!B6bM.\f7\u0001A\n\u0003\u0001y\u0001\"a\b\u0014\u000e\u0003\u0001R!!\t\u0012\u0002\u000b),h.\u001b;\u000b\u0005\r\"\u0013!C:dC2\fG/Z:u\u0015\u0005)\u0013aA8sO&\u0011q\u0005\t\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0017A\u0002\u001fj]&$h\bF\u0001+!\tY\u0003!D\u0001\u0017\u0003\u001d9'o\\;q\u0013\u0012,\u0012A\f\t\u0003_Qj\u0011\u0001\r\u0006\u0003cI\nA\u0001\\1oO*\t1'\u0001\u0003kCZ\f\u0017BA\u001b1\u0005\u0019\u0019FO]5oO\u0006AqM]8va&#\u0007%\u0001\u0005dY&,g\u000e^%e\u0003%\u0019G.[3oi&#\u0007%\u0001\u0006dY&,g\u000e\u001e%pgR\f1b\u00197jK:$\bj\\:uA\u0005AQ.Z7cKJLE-A\u0005nK6\u0014WM]%eA\u0005a\u0001O]8u_\u000e|G\u000eV=qK\u0006i\u0001O]8u_\u000e|G\u000eV=qK\u0002\n!C]3cC2\fgnY3US6,w.\u001e;NgV\t\u0011\t\u0005\u0002C\u000b6\t1IC\u0001E\u0003\u0015\u00198-\u00197b\u0013\t15IA\u0002J]R\f1C]3cC2\fgnY3US6,w.\u001e;Ng\u0002\n\u0001c]3tg&|g\u000eV5nK>,H/T:\u0002#M,7o]5p]RKW.Z8vi6\u001b\b%A\u000fuKN$X*\u0019;dQ\u0016\u001c8+\u001e9q_J$X\r\u001a)s_R|7m\u001c7t)\u0005a\u0005C\u0001\"N\u0013\tq5I\u0001\u0003V]&$\bF\u0001\tQ!\t\t6+D\u0001S\u0015\t\tC%\u0003\u0002U%\n!A+Z:u\u0003q!Xm\u001d;W_R,gi\u001c:Qe\u00164WM\u001d:fIB\u0013x\u000e^8d_2D#!\u0005)\u0002\u0019Q,7\u000f^'fi\u0006$\u0017\r^1)\u0005I\u0001\u0016a\n;fgRlU\r^1eCR\f'+Y5tKN|e.\u00168tkB\u0004xN\u001d;fIB\u0013x\u000e^8d_2DCa\u0005)\\9\u0006AQ\r\u001f9fGR,GmI\u0001^!\tqfM\u0004\u0002`I:\u0011\u0001mY\u0007\u0002C*\u0011!\rH\u0001\u0007yI|w\u000e\u001e \n\u0003\u0011K!!Z\"\u0002\u000fA\f7m[1hK&\u0011q\r\u001b\u0002\u0019\u00132dWmZ1m\u0003J<W/\\3oi\u0016C8-\u001a9uS>t'BA3D\u0003\u0011\"Xm\u001d;W_R,'+Y5tKN|eNT8TkB\u0004xN\u001d;fIB\u0013x\u000e^8d_2\u001c\b\u0006\u0002\u000bQ7r\u0003")
public class MemberMetadataTest
extends JUnitSuite {
    private final String groupId;
    private final String clientId;
    private final String clientHost;
    private final String memberId;
    private final String protocolType;
    private final int rebalanceTimeoutMs;
    private final int sessionTimeoutMs;

    public String groupId() {
        return this.groupId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String clientHost() {
        return this.clientHost;
    }

    public String memberId() {
        return this.memberId;
    }

    public String protocolType() {
        return this.protocolType;
    }

    public int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    public int sessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    @Test
    public void testMatchesSupportedProtocols() {
        .colon.colon protocols = new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$);
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)protocols);
        Assert.assertTrue((boolean)member.matches((List)protocols));
        Assert.assertFalse((boolean)member.matches((List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0}), ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)));
        Assert.assertFalse((boolean)member.matches((List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)));
        Assert.assertFalse((boolean)member.matches((List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$))));
    }

    @Test
    public void testVoteForPreferredProtocol() {
        .colon.colon protocols = new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$));
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)protocols);
        Assert.assertEquals((Object)"range", (Object)member.vote((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "roundrobin"}))));
        Assert.assertEquals((Object)"roundrobin", (Object)member.vote((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"blah", "roundrobin"}))));
    }

    @Test
    public void testMetadata() {
        .colon.colon protocols = new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0}), ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{1}), ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$));
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)protocols);
        Assert.assertTrue((boolean)Arrays.equals((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0}), ClassTag$.MODULE$.Byte()), member.metadata("range")));
        Assert.assertTrue((boolean)Arrays.equals((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{1}), ClassTag$.MODULE$.Byte()), member.metadata("roundrobin")));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMetadataRaisesOnUnsupportedProtocol() {
        .colon.colon protocols = new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$));
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)protocols);
        member.metadata("blah");
        throw this.fail(new Position("MemberMetadataTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVoteRaisesOnNoSupportedProtocols() {
        .colon.colon protocols = new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$));
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)protocols);
        member.vote((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"blah"})));
        throw this.fail(new Position("MemberMetadataTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
    }

    public MemberMetadataTest() {
        this.groupId = "groupId";
        this.clientId = "clientId";
        this.clientHost = "clientHost";
        this.memberId = "memberId";
        this.protocolType = "consumer";
        this.rebalanceTimeoutMs = 60000;
        this.sessionTimeoutMs = 10000;
    }
}

