/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.controller.Callbacks;
import kafka.controller.Callbacks$;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewReplica$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.StateChangeLogger;
import kafka.controller.TopicDeletionManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.ResponseMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tud\u0001\u0002(P\u0001QCQa\u0018\u0001\u0005\u0002\u0001Dqa\u0019\u0001A\u0002\u0013%A\rC\u0004i\u0001\u0001\u0007I\u0011B5\t\rI\u0004\u0001\u0015)\u0003f\u0011\u001d\u0019\b\u00011A\u0005\nQDqa\u001f\u0001A\u0002\u0013%A\u0010\u0003\u0004\u007f\u0001\u0001\u0006K!\u001e\u0005\t\u007f\u0002\u0001\r\u0011\"\u0003\u0002\u0002!I\u0011\u0011\u0002\u0001A\u0002\u0013%\u00111\u0002\u0005\t\u0003\u001f\u0001\u0001\u0015)\u0003\u0002\u0004!I\u0011\u0011\u0003\u0001A\u0002\u0013%\u00111\u0003\u0005\n\u00037\u0001\u0001\u0019!C\u0005\u0003;A\u0001\"!\t\u0001A\u0003&\u0011Q\u0003\u0005\n\u0003G\u0001\u0001\u0019!C\u0005\u0003KA\u0011\"a\u0011\u0001\u0001\u0004%I!!\u0012\t\u0011\u0005%\u0003\u0001)Q\u0005\u0003OA\u0011\"a\u0013\u0001\u0001\u0004%I!!\u0014\t\u0013\u0005U\u0003\u00011A\u0005\n\u0005]\u0003\u0002CA.\u0001\u0001\u0006K!a\u0014\t\u0013\u0005u\u0003A1A\u0005\n\u0005}\u0003\u0002CA4\u0001\u0001\u0006I!!\u0019\t\u0013\u0005%\u0004A1A\u0005\n\u0005-\u0004\u0002CA=\u0001\u0001\u0006I!!\u001c\t\u0013\u0005m\u0004A1A\u0005\n\u0005}\u0003\u0002CA?\u0001\u0001\u0006I!!\u0019\t\u0013\u0005}\u0004A1A\u0005\n\u0005\u0005\u0005\u0002CAK\u0001\u0001\u0006I!a!\t\u0013\u0005]\u0005A1A\u0005\n\u0005e\u0005\u0002CAR\u0001\u0001\u0006I!a'\t\u0013\u0005\u0015\u0006A1A\u0005\n\u0005\u001d\u0006\u0002CAU\u0001\u0001\u0006I!a\u000e\t\u0013\u0005-\u0006A1A\u0005\n\u00055\u0006\u0002CAY\u0001\u0001\u0006I!a,\t\u000f\u0005M\u0006\u0001\"\u0001\u00026\"9\u00111\u0019\u0001\u0005\u0002\u0005U\u0006bBAg\u0001\u0011\u0005\u0011Q\u0017\u0005\b\u0003#\u0004A\u0011AA[\u0011\u001d\t)\u000e\u0001C\u0001\u0003kCq!!7\u0001\t\u0003\t)\fC\u0004\u0002^\u0002!\t!!.\t\u000f\u0005\u0005\b\u0001\"\u0001\u00026\"9\u0011Q\u001d\u0001\u0005\u0002\u0005U\u0006bBAu\u0001\u0011\u0005\u0011Q\u0017\u0005\b\u0003[\u0004A\u0011AA[\u0011\u001d\t\t\u0010\u0001C\u0001\u0003kCq!!>\u0001\t\u0003\t)\fC\u0004\u0002z\u0002!\t!!.\t\u000f\u0005u\b\u0001\"\u0001\u00026\"9!\u0011\u0001\u0001\u0005\u0002\u0005U\u0006b\u0002B\u0003\u0001\u0011\u0005\u0011Q\u0017\u0005\b\u0005\u0013\u0001A\u0011AA[\u0011\u001d\u0011i\u0001\u0001C\u0001\u0003kCqA!\u0005\u0001\t\u0003\t)\fC\u0004\u0003\u0016\u0001!\t!!.\t\u000f\te\u0001\u0001\"\u0001\u00026\"9!Q\u0004\u0001\u0005\u0002\u0005U\u0006b\u0002B\u0011\u0001\u0011\u0005\u0011Q\u0017\u0005\b\u0005K\u0001A\u0011AA[\u0011\u001d\u0011I\u0003\u0001C\u0001\u0003kCqA!\f\u0001\t\u0003\t)\fC\u0004\u00032\u0001!\t!!.\t\u000f\tU\u0002\u0001\"\u0001\u00026\"9!\u0011\b\u0001\u0005\u0002\u0005U\u0006b\u0002B\u001f\u0001\u0011\u0005\u0011Q\u0017\u0005\b\u0005\u0003\u0002A\u0011AA[\u0011\u001d\u0011)\u0005\u0001C\u0001\u0003kCqA!\u0013\u0001\t\u0003\t)\fC\u0004\u0003N\u0001!\t!!.\t\u000f\tE\u0003\u0001\"\u0001\u00026\"9!Q\u000b\u0001\u0005\u0002\u0005U\u0006b\u0002B-\u0001\u0011\u0005\u0011Q\u0017\u0005\b\u0005;\u0002A\u0011AA[\u0011\u001d\u0011\t\u0007\u0001C\u0001\u0003kCqA!\u001a\u0001\t\u0003\t)\fC\u0004\u0003j\u0001!\t!!.\t\u000f\t5\u0004\u0001\"\u0001\u00026\"9!\u0011\u000f\u0001\u0005\n\tM$a\u0006*fa2L7-Y*uCR,W*Y2iS:,G+Z:u\u0015\t\u0001\u0016+\u0001\u0006d_:$(o\u001c7mKJT\u0011AU\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\u000b\u0005\u0002W;6\tqK\u0003\u0002Y3\u0006)!.\u001e8ji*\u0011!lW\u0001\ng\u000e\fG.\u0019;fgRT\u0011\u0001X\u0001\u0004_J<\u0017B\u00010X\u0005)QUK\\5u'VLG/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\u0004\"A\u0019\u0001\u000e\u0003=\u000b\u0011cY8oiJ|G\u000e\\3s\u0007>tG/\u001a=u+\u0005)\u0007C\u00012g\u0013\t9wJA\tD_:$(o\u001c7mKJ\u001cuN\u001c;fqR\fQcY8oiJ|G\u000e\\3s\u0007>tG/\u001a=u?\u0012*\u0017\u000f\u0006\u0002kaB\u00111N\\\u0007\u0002Y*\tQ.A\u0003tG\u0006d\u0017-\u0003\u0002pY\n!QK\\5u\u0011\u001d\t8!!AA\u0002\u0015\f1\u0001\u001f\u00132\u0003I\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0011\u0002\u00195|7m\u001b.l\u00072LWM\u001c;\u0016\u0003U\u0004\"A^=\u000e\u0003]T!\u0001_)\u0002\u0005i\\\u0017B\u0001>x\u00055Y\u0015MZ6b5.\u001cE.[3oi\u0006\u0001Rn\\2l5.\u001cE.[3oi~#S-\u001d\u000b\u0003UvDq!\u001d\u0004\u0002\u0002\u0003\u0007Q/A\u0007n_\u000e\\'l[\"mS\u0016tG\u000fI\u0001![>\u001c7nQ8oiJ|G\u000e\\3s\u0005J|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007.\u0006\u0002\u0002\u0004A\u0019!-!\u0002\n\u0007\u0005\u001dqJ\u0001\u000fD_:$(o\u001c7mKJ\u0014%o\\6feJ+\u0017/^3ti\n\u000bGo\u00195\u0002I5|7m[\"p]R\u0014x\u000e\u001c7fe\n\u0013xn[3s%\u0016\fX/Z:u\u0005\u0006$8\r[0%KF$2A[A\u0007\u0011!\t\u0018\"!AA\u0002\u0005\r\u0011!I7pG.\u001cuN\u001c;s_2dWM\u001d\"s_.,'OU3rk\u0016\u001cHOQ1uG\"\u0004\u0013\u0001G7pG.$v\u000e]5d\t\u0016dW\r^5p]6\u000bg.Y4feV\u0011\u0011Q\u0003\t\u0004E\u0006]\u0011bAA\r\u001f\n!Bk\u001c9jG\u0012+G.\u001a;j_:l\u0015M\\1hKJ\fA$\\8dWR{\u0007/[2EK2,G/[8o\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000fF\u0002k\u0003?A\u0001\"\u001d\u0007\u0002\u0002\u0003\u0007\u0011QC\u0001\u001a[>\u001c7\u000eV8qS\u000e$U\r\\3uS>tW*\u00198bO\u0016\u0014\b%\u0001\u0007sKBd\u0017nY1Ti\u0006$X-\u0006\u0002\u0002(AA\u0011\u0011FA\u001a\u0003o\ti$\u0004\u0002\u0002,)!\u0011QFA\u0018\u0003\u001diW\u000f^1cY\u0016T1!!\rm\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003k\tYCA\u0002NCB\u00042AYA\u001d\u0013\r\tYd\u0014\u0002\u0014!\u0006\u0014H/\u001b;j_:\fe\u000e\u001a*fa2L7-\u0019\t\u0004E\u0006}\u0012bAA!\u001f\na!+\u001a9mS\u000e\f7\u000b^1uK\u0006\u0001\"/\u001a9mS\u000e\f7\u000b^1uK~#S-\u001d\u000b\u0004U\u0006\u001d\u0003\u0002C9\u0010\u0003\u0003\u0005\r!a\n\u0002\u001bI,\u0007\u000f\\5dCN#\u0018\r^3!\u0003M\u0011X\r\u001d7jG\u0006\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f+\t\ty\u0005E\u0002c\u0003#J1!a\u0015P\u0005M\u0011V\r\u001d7jG\u0006\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f\u0003]\u0011X\r\u001d7jG\u0006\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f?\u0012*\u0017\u000fF\u0002k\u00033B\u0001\"\u001d\n\u0002\u0002\u0003\u0007\u0011qJ\u0001\u0015e\u0016\u0004H.[2b'R\fG/Z'bG\"Lg.\u001a\u0011\u0002\u0011\t\u0014xn[3s\u0013\u0012,\"!!\u0019\u0011\u0007-\f\u0019'C\u0002\u0002f1\u00141!\u00138u\u0003%\u0011'o\\6fe&#\u0007%\u0001\u0004d_:4\u0017nZ\u000b\u0003\u0003[\u0002B!a\u001c\u0002v5\u0011\u0011\u0011\u000f\u0006\u0004\u0003g\n\u0016AB:feZ,'/\u0003\u0003\u0002x\u0005E$aC&bM.\f7i\u001c8gS\u001e\fqaY8oM&<\u0007%A\bd_:$(o\u001c7mKJ,\u0005o\\2i\u0003A\u0019wN\u001c;s_2dWM]#q_\u000eD\u0007%A\u0005qCJ$\u0018\u000e^5p]V\u0011\u00111\u0011\t\u0005\u0003\u000b\u000b\t*\u0004\u0002\u0002\b*!\u0011\u0011RAF\u0003\u0019\u0019w.\\7p]*\u0019!+!$\u000b\u0007\u0005=5,\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003'\u000b9I\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u0015A\f'\u000f^5uS>t\u0007%\u0001\u0006qCJ$\u0018\u000e^5p]N,\"!a'\u0011\r\u0005u\u0015qTAB\u001b\t\ty#\u0003\u0003\u0002\"\u0006=\"aA*fc\u0006Y\u0001/\u0019:uSRLwN\\:!\u0003\u001d\u0011X\r\u001d7jG\u0006,\"!a\u000e\u0002\u0011I,\u0007\u000f\\5dC\u0002\n\u0001B]3qY&\u001c\u0017m]\u000b\u0003\u0003_\u0003b!!(\u0002 \u0006]\u0012!\u0003:fa2L7-Y:!\u0003\u0015\u0019X\r^+q)\u0005Q\u0007f\u0001\u0012\u0002:B!\u00111XA`\u001b\t\tiL\u0003\u0002Y7&!\u0011\u0011YA_\u0005\u0019\u0011UMZ8sK\u0006aC/Z:u\u001d>tW\r_5ti\u0016tGOU3qY&\u001c\u0017\rV8OK^\u0014V\r\u001d7jG\u0006$&/\u00198tSRLwN\u001c\u0015\u0004G\u0005\u001d\u0007\u0003BA^\u0003\u0013LA!a3\u0002>\n!A+Z:u\u0003Y\"Xm\u001d;J]Z\fG.\u001b3O_:,\u00070[:uK:$(+\u001a9mS\u000e\fGk\\(oY&tWMU3qY&\u001c\u0017\r\u0016:b]NLG/[8oQ\r!\u0013qY\u00018i\u0016\u001cH/\u00138wC2LGMT8oKbL7\u000f^3oiJ+\u0007\u000f\\5dCR{wJ\u001a4mS:,'+\u001a9mS\u000e\fGK]1og&$\u0018n\u001c8)\u0007\u0015\n9-A uKN$\u0018J\u001c<bY&$gj\u001c8fq&\u001cH/\u001a8u%\u0016\u0004H.[2b)>\u0014V\r\u001d7jG\u0006$U\r\\3uS>t7\u000b^1si\u0016$GK]1og&$\u0018n\u001c8)\u0007\u0019\n9-\u0001\"uKN$\u0018J\u001c<bY&$gj\u001c8fq&\u001cH/\u001a8u%\u0016\u0004H.[2b)>\u0014V\r\u001d7jG\u0006$U\r\\3uS>t\u0017J\\3mS\u001eL'\r\\3Ue\u0006t7/\u001b;j_:D3aJAd\u0003\t#Xm\u001d;J]Z\fG.\u001b3O_:,\u00070[:uK:$(+\u001a9mS\u000e\fGk\u001c*fa2L7-\u0019#fY\u0016$\u0018n\u001c8Tk\u000e\u001cWm]:gk2$&/\u00198tSRLwN\u001c\u0015\u0004Q\u0005\u001d\u0017a\r;fgRLeN^1mS\u0012tUm\u001e*fa2L7-\u0019+p\u001d>tW\r_5ti\u0016tGOU3qY&\u001c\u0017\r\u0016:b]NLG/[8oQ\rI\u0013qY\u0001(i\u0016\u001cHOT3x%\u0016\u0004H.[2b)>|e\u000e\\5oKJ+\u0007\u000f\\5dCR\u0013\u0018M\\:ji&|g\u000eK\u0002+\u0003\u000f\f\u0001\u0006^3ti:+wOU3qY&\u001c\u0017\rV8PM\u001ad\u0017N\\3SKBd\u0017nY1Ue\u0006t7/\u001b;j_:D3aKAd\u0003]\"Xm\u001d;J]Z\fG.\u001b3OK^\u0014V\r\u001d7jG\u0006$vNU3qY&\u001c\u0017\rR3mKRLwN\\*uCJ$X\r\u001a+sC:\u001c\u0018\u000e^5p]\"\u001aA&a2\u0002uQ,7\u000f^%om\u0006d\u0017\u000e\u001a(foJ+\u0007\u000f\\5dCR{'+\u001a9mS\u000e\fG)\u001a7fi&|g.\u00138fY&<\u0017N\u00197f)J\fgn]5uS>t\u0007fA\u0017\u0002H\u0006QD/Z:u\u0013:4\u0018\r\\5e\u001d\u0016<(+\u001a9mS\u000e\fGk\u001c*fa2L7-\u0019#fY\u0016$\u0018n\u001c8Tk\u000e\u001cWm]:gk2$&/\u00198tSRLwN\u001c\u0015\u0004]\u0005\u001d\u0017A\u000e;fgRLeN^1mS\u0012|e\u000e\\5oKJ+\u0007\u000f\\5dCR{gj\u001c8fq&\u001cH/\u001a8u%\u0016\u0004H.[2b)J\fgn]5uS>t\u0007fA\u0018\u0002H\u0006qC/Z:u\u0013:4\u0018\r\\5e\u001f:d\u0017N\\3SKBd\u0017nY1U_:+wOU3qY&\u001c\u0017\r\u0016:b]NLG/[8oQ\r\u0001\u0014qY\u0001+i\u0016\u001cHo\u00148mS:,'+\u001a9mS\u000e\fGk\\(oY&tWMU3qY&\u001c\u0017\r\u0016:b]NLG/[8oQ\r\t\u0014qY\u0001,i\u0016\u001cHo\u00148mS:,'+\u001a9mS\u000e\fGk\\(gM2Lg.\u001a*fa2L7-\u0019+sC:\u001c\u0018\u000e^5p]\"\u001a!'a2\u0002uQ,7\u000f^%om\u0006d\u0017\u000eZ(oY&tWMU3qY&\u001c\u0017\rV8SKBd\u0017nY1EK2,G/[8o'R\f'\u000f^3e)J\fgn]5uS>t\u0007fA\u001a\u0002H\u0006iD/Z:u\u0013:4\u0018\r\\5e\u001f:d\u0017N\\3SKBd\u0017nY1U_J+\u0007\u000f\\5dC\u0012+G.\u001a;j_:Le.\u001a7jO&\u0014G.\u001a+sC:\u001c\u0018\u000e^5p]\"\u001aA'a2\u0002{Q,7\u000f^%om\u0006d\u0017\u000eZ(oY&tWMU3qY&\u001c\u0017\rV8SKBd\u0017nY1EK2,G/[8o'V\u001c7-Z:tMVdGK]1og&$\u0018n\u001c8)\u0007U\n9-A\u001cuKN$\u0018J\u001c<bY&$wJ\u001a4mS:,'+\u001a9mS\u000e\fGk\u001c(p]\u0016D\u0018n\u001d;f]R\u0014V\r\u001d7jG\u0006$&/\u00198tSRLwN\u001c\u0015\u0004m\u0005\u001d\u0017a\f;fgRLeN^1mS\u0012|eM\u001a7j]\u0016\u0014V\r\u001d7jG\u0006$vNT3x%\u0016\u0004H.[2b)J\fgn]5uS>t\u0007fA\u001c\u0002H\u0006YC/Z:u\u001f\u001a4G.\u001b8f%\u0016\u0004H.[2b)>|e\u000e\\5oKJ+\u0007\u000f\\5dCR\u0013\u0018M\\:ji&|g\u000eK\u00029\u0003\u000f\fA\u0007^3ti>3g\r\\5oKJ+\u0007\u000f\\5dCR{'+\u001a9mS\u000e\fG)\u001a7fi&|gn\u0015;beR,G\r\u0016:b]NLG/[8oQ\rI\u0014qY\u0001?i\u0016\u001cH/\u00138wC2LGm\u00144gY&tWMU3qY&\u001c\u0017\rV8SKBd\u0017nY1EK2,G/[8o\u0013:,G.[4jE2,GK]1og&$\u0018n\u001c8)\u0007i\n9-\u0001 uKN$\u0018J\u001c<bY&$wJ\u001a4mS:,'+\u001a9mS\u000e\fGk\u001c*fa2L7-\u0019#fY\u0016$\u0018n\u001c8Tk\u000e\u001cWm]:gk2$&/\u00198tSRLwN\u001c\u0015\u0004w\u0005\u001d\u0017a\u0010;fgRLeN^1mS\u0012\u0014V\r\u001d7jG\u0006$U\r\\3uS>t7\u000b^1si\u0016$Gk\u001c(p]\u0016D\u0018n\u001d;f]R\u0014V\r\u001d7jG\u0006$&/\u00198tSRLwN\u001c\u0015\u0004y\u0005\u001d\u0017a\u000e;fgRLeN^1mS\u0012\u0014V\r\u001d7jG\u0006$U\r\\3uS>t7\u000b^1si\u0016$Gk\u001c(foJ+\u0007\u000f\\5dCR\u0013\u0018M\\:ji&|g\u000eK\u0002>\u0003\u000f\f!\b^3ti&sg/\u00197jIJ+\u0007\u000f\\5dC\u0012+G.\u001a;j_:\u001cF/\u0019:uK\u0012$vn\u00148mS:,'+\u001a9mS\u000e\fGK]1og&$\u0018n\u001c8)\u0007y\n9-A\u001euKN$\u0018J\u001c<bY&$'+\u001a9mS\u000e\fG)\u001a7fi&|gn\u0015;beR,G\rV8PM\u001ad\u0017N\\3SKBd\u0017nY1Ue\u0006t7/\u001b;j_:D3aPAd\u0003}\"Xm\u001d;SKBd\u0017nY1EK2,G/[8o'R\f'\u000f^3e)>\u0014V\r\u001d7jG\u0006$U\r\\3uS>t\u0017J\\3mS\u001eL'\r\\3Ue\u0006t7/\u001b;j_:D3\u0001QAd\u0003}\"Xm\u001d;SKBd\u0017nY1EK2,G/[8o'R\f'\u000f^3e)>\u0014V\r\u001d7jG\u0006$U\r\\3uS>t7+^2dKN\u001ch-\u001e7Ue\u0006t7/\u001b;j_:D3!QAd\u0003m\"Xm\u001d;SKBd\u0017nY1EK2,G/[8o'V\u001c7-Z:tMVdGk\u001c(p]\u0016D\u0018n\u001d;f]R\u0014V\r\u001d7jG\u0006$&/\u00198tSRLwN\u001c\u0015\u0004\u0005\u0006\u001d\u0017A\u000f;fgRLeN^1mS\u0012\u0014V\r\u001d7jG\u0006$U\r\\3uS>t7+^2dKN\u001ch-\u001e7U_:+wOU3qY&\u001c\u0017\r\u0016:b]NLG/[8oQ\r\u0019\u0015qY\u0001>i\u0016\u001cH/\u00138wC2LGMU3qY&\u001c\u0017\rR3mKRLwN\\*vG\u000e,7o\u001d4vYR{wJ\u001c7j]\u0016\u0014V\r\u001d7jG\u0006$&/\u00198tSRLwN\u001c\u0015\u0004\t\u0006\u001d\u0017A\u0010;fgRLeN^1mS\u0012\u0014V\r\u001d7jG\u0006$U\r\\3uS>t7+^2dKN\u001ch-\u001e7U_>3g\r\\5oKJ+\u0007\u000f\\5dCR\u0013\u0018M\\:ji&|g\u000eK\u0002F\u0003\u000f\fa\t^3ti&sg/\u00197jIJ+\u0007\u000f\\5dC\u0012+G.\u001a;j_:\u001cVoY2fgN4W\u000f\u001c+p%\u0016\u0004H.[2b\t\u0016dW\r^5p]N#\u0018M\u001d;fIR\u0013\u0018M\\:ji&|g\u000eK\u0002G\u0003\u000f\f\u0011\n^3ti&sg/\u00197jIJ+\u0007\u000f\\5dC\u0012+G.\u001a;j_:\u001cVoY2fgN4W\u000f\u001c+p%\u0016\u0004H.[2b\t\u0016dW\r^5p]&sW\r\\5hS\ndW\r\u0016:b]NLG/[8oQ\r9\u0015qY\u0001Ci\u0016\u001cH/\u00138wC2LGMU3qY&\u001c\u0017\rR3mKRLwN\\%oK2Lw-\u001b2mKR{gj\u001c8fq&\u001cH/\u001a8u%\u0016\u0004H.[2b)J\fgn]5uS>t\u0007f\u0001%\u0002H\u0006QD/Z:u\u0013:4\u0018\r\\5e%\u0016\u0004H.[2b\t\u0016dW\r^5p]&sW\r\\5hS\ndW\rV8OK^\u0014V\r\u001d7jG\u0006$&/\u00198tSRLwN\u001c\u0015\u0004\u0013\u0006\u001d\u0017A\u000e;fgR\u0014V\r\u001d7jG\u0006$U\r\\3uS>t\u0017J\\3mS\u001eL'\r\\3U_>sG.\u001b8f%\u0016\u0004H.[2b)J\fgn]5uS>t\u0007f\u0001&\u0002H\u00061E/Z:u\u0013:4\u0018\r\\5e%\u0016\u0004H.[2b\t\u0016dW\r^5p]&sW\r\\5hS\ndW\rV8SKBd\u0017nY1EK2,G/[8o'R\f'\u000f^3e)J\fgn]5uS>t\u0007fA&\u0002H\u0006IE/Z:u\u0013:4\u0018\r\\5e%\u0016\u0004H.[2b\t\u0016dW\r^5p]&sW\r\\5hS\ndW\rV8SKBd\u0017nY1EK2,G/[8o'V\u001c7-Z:tMVdGK]1og&$\u0018n\u001c8)\u00071\u000b9-A\u000buKN$\u0018J\u001c<bY&$GK]1og&$\u0018n\u001c8\u0015\u000b)\u0014)H!\u001f\t\u000f\t]T\n1\u0001\u0002>\u0005IaM]8n'R\fG/\u001a\u0005\b\u0005wj\u0005\u0019AA\u001f\u0003\u001d!xn\u0015;bi\u0016\u0004")
public class ReplicaStateMachineTest
extends JUnitSuite {
    private ControllerContext controllerContext = null;
    private KafkaZkClient mockZkClient = null;
    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch = null;
    private TopicDeletionManager mockTopicDeletionManager = null;
    private Map<PartitionAndReplica, ReplicaState> replicaState = null;
    private ReplicaStateMachine replicaStateMachine = null;
    private final int brokerId;
    private final KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
    private final int controllerEpoch;
    private final TopicPartition partition = new TopicPartition("t", 0);
    private final Seq<TopicPartition> partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition()}));
    private final PartitionAndReplica replica = new PartitionAndReplica(this.partition(), this.brokerId());
    private final Seq<PartitionAndReplica> replicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PartitionAndReplica[]{this.replica()}));

    private ControllerContext controllerContext() {
        return this.controllerContext;
    }

    private void controllerContext_$eq(ControllerContext x$1) {
        this.controllerContext = x$1;
    }

    private KafkaZkClient mockZkClient() {
        return this.mockZkClient;
    }

    private void mockZkClient_$eq(KafkaZkClient x$1) {
        this.mockZkClient = x$1;
    }

    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch() {
        return this.mockControllerBrokerRequestBatch;
    }

    private void mockControllerBrokerRequestBatch_$eq(ControllerBrokerRequestBatch x$1) {
        this.mockControllerBrokerRequestBatch = x$1;
    }

    private TopicDeletionManager mockTopicDeletionManager() {
        return this.mockTopicDeletionManager;
    }

    private void mockTopicDeletionManager_$eq(TopicDeletionManager x$1) {
        this.mockTopicDeletionManager = x$1;
    }

    private Map<PartitionAndReplica, ReplicaState> replicaState() {
        return this.replicaState;
    }

    private void replicaState_$eq(Map<PartitionAndReplica, ReplicaState> x$1) {
        this.replicaState = x$1;
    }

    private ReplicaStateMachine replicaStateMachine() {
        return this.replicaStateMachine;
    }

    private void replicaStateMachine_$eq(ReplicaStateMachine x$1) {
        this.replicaStateMachine = x$1;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    private TopicPartition partition() {
        return this.partition;
    }

    private Seq<TopicPartition> partitions() {
        return this.partitions;
    }

    private PartitionAndReplica replica() {
        return this.replica;
    }

    private Seq<PartitionAndReplica> replicas() {
        return this.replicas;
    }

    @Before
    public void setUp() {
        this.controllerContext_$eq(new ControllerContext());
        this.controllerContext().epoch_$eq(this.controllerEpoch());
        this.mockZkClient_$eq((KafkaZkClient)EasyMock.createMock(KafkaZkClient.class));
        this.mockControllerBrokerRequestBatch_$eq((ControllerBrokerRequestBatch)EasyMock.createMock(ControllerBrokerRequestBatch.class));
        this.mockTopicDeletionManager_$eq((TopicDeletionManager)EasyMock.createMock(TopicDeletionManager.class));
        this.replicaState_$eq((Map<PartitionAndReplica, ReplicaState>)Map$.MODULE$.empty());
        this.replicaStateMachine_$eq(new ReplicaStateMachine(this.config(), new StateChangeLogger(this.brokerId(), true, (Option)None$.MODULE$), this.controllerContext(), this.mockTopicDeletionManager(), this.mockZkClient(), this.replicaState(), this.mockControllerBrokerRequestBatch()));
    }

    @Test
    public void testNonexistentReplicaToNewReplicaTransition() {
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        NewReplica$ x$2 = NewReplica$.MODULE$;
        Callbacks x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        Assert.assertEquals((Object)NewReplica$.MODULE$, (Object)this.replicaState().apply((Object)this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToOnlineReplicaTransition() {
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        OnlineReplica$ x$2 = OnlineReplica$.MODULE$;
        Callbacks x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        Assert.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState().apply((Object)this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToOfflineReplicaTransition() {
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        OfflineReplica$ x$2 = OfflineReplica$.MODULE$;
        Callbacks x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        Assert.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState().apply((Object)this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToReplicaDeletionStartedTransition() {
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        ReplicaDeletionStarted$ x$2 = ReplicaDeletionStarted$.MODULE$;
        Callbacks x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        Assert.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState().apply((Object)this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToReplicaDeletionIneligibleTransition() {
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        ReplicaDeletionIneligible$ x$2 = ReplicaDeletionIneligible$.MODULE$;
        Callbacks x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        Assert.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState().apply((Object)this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToReplicaDeletionSuccessfulTransition() {
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        ReplicaDeletionSuccessful$ x$2 = ReplicaDeletionSuccessful$.MODULE$;
        Callbacks x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        Assert.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState().apply((Object)this.replica()));
    }

    @Test
    public void testInvalidNewReplicaToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)NewReplica$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testNewReplicaToOnlineReplicaTransition() {
        this.replicaState().put((Object)this.replica(), (Object)NewReplica$.MODULE$);
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        OnlineReplica$ x$2 = OnlineReplica$.MODULE$;
        Callbacks x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        Assert.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState().apply((Object)this.replica()));
    }

    @Test
    public void testNewReplicaToOfflineReplicaTransition() {
        this.replicaState().put((Object)this.replica(), (Object)NewReplica$.MODULE$);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().addStopReplicaRequestForBrokers((Seq)EasyMock.eq((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), (TopicPartition)EasyMock.eq((Object)this.partition()), EasyMock.eq((boolean)false), (Function2)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockControllerBrokerRequestBatch()});
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        OfflineReplica$ x$2 = OfflineReplica$.MODULE$;
        Callbacks x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        EasyMock.verify((Object[])new Object[]{this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OfflineReplica$.MODULE$, (Object)this.replicaState().apply((Object)this.replica()));
    }

    @Test
    public void testInvalidNewReplicaToReplicaDeletionStartedTransition() {
        this.testInvalidTransition((ReplicaState)NewReplica$.MODULE$, (ReplicaState)ReplicaDeletionStarted$.MODULE$);
    }

    @Test
    public void testInvalidNewReplicaToReplicaDeletionIneligibleTransition() {
        this.testInvalidTransition((ReplicaState)NewReplica$.MODULE$, (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
    }

    @Test
    public void testInvalidNewReplicaToReplicaDeletionSuccessfulTransition() {
        this.testInvalidTransition((ReplicaState)NewReplica$.MODULE$, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
    }

    @Test
    public void testInvalidOnlineReplicaToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testInvalidOnlineReplicaToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    @Test
    public void testOnlineReplicaToOnlineReplicaTransition() {
        this.replicaState().put((Object)this.replica(), (Object)OnlineReplica$.MODULE$);
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        this.controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), leaderIsrAndControllerEpoch, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        OnlineReplica$ x$2 = OnlineReplica$.MODULE$;
        Callbacks x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState().apply((Object)this.replica()));
    }

    @Test
    public void testOnlineReplicaToOfflineReplicaTransition() {
        int otherBrokerId = this.brokerId() + 1;
        List replicaIds = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId}));
        this.replicaState().put((Object)this.replica(), (Object)OnlineReplica$.MODULE$);
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)replicaIds);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), replicaIds);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().addStopReplicaRequestForBrokers((Seq)EasyMock.eq((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), (TopicPartition)EasyMock.eq((Object)this.partition()), EasyMock.eq((boolean)false), (Function2)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        LeaderAndIsr adjustedLeaderAndIsr = leaderAndIsr.newLeaderAndIsr(LeaderAndIsr$.MODULE$.NoLeader(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})));
        LeaderAndIsr updatedLeaderAndIsr = adjustedLeaderAndIsr.withZkVersion(adjustedLeaderAndIsr.zkVersion() + 1);
        LeaderIsrAndControllerEpoch updatedLeaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch());
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GetDataResponse[]{new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L))})));
        EasyMock.expect((Object)this.mockZkClient().updateLeaderAndIsr((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)adjustedLeaderAndIsr)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).andReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)updatedLeaderAndIsr)})), (Seq)Seq$.MODULE$.empty(), Predef$.MODULE$.Map().empty()));
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.mockTopicDeletionManager().isTopicQueuedUpForDeletion(this.partition().topic()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})), this.partition(), updatedLeaderIsrAndControllerEpoch, (Seq)replicaIds, false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch(), this.mockTopicDeletionManager()});
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        OfflineReplica$ x$2 = OfflineReplica$.MODULE$;
        Callbacks x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch(), this.mockTopicDeletionManager()});
        Assert.assertEquals((Object)updatedLeaderIsrAndControllerEpoch, (Object)this.controllerContext().partitionLeadershipInfo().apply((Object)this.partition()));
        Assert.assertEquals((Object)OfflineReplica$.MODULE$, (Object)this.replicaState().apply((Object)this.replica()));
    }

    @Test
    public void testInvalidOnlineReplicaToReplicaDeletionStartedTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)ReplicaDeletionStarted$.MODULE$);
    }

    @Test
    public void testInvalidOnlineReplicaToReplicaDeletionIneligibleTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
    }

    @Test
    public void testInvalidOnlineReplicaToReplicaDeletionSuccessfulTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
    }

    @Test
    public void testInvalidOfflineReplicaToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)OfflineReplica$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testInvalidOfflineReplicaToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)OfflineReplica$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    @Test
    public void testOfflineReplicaToOnlineReplicaTransition() {
        this.replicaState().put((Object)this.replica(), (Object)OfflineReplica$.MODULE$);
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        this.controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), leaderIsrAndControllerEpoch, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        OnlineReplica$ x$2 = OnlineReplica$.MODULE$;
        Callbacks x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState().apply((Object)this.replica()));
    }

    @Test
    public void testOfflineReplicaToReplicaDeletionStartedTransition() {
        Callbacks callbacks = new Callbacks(Callbacks$.MODULE$.$lessinit$greater$default$1());
        this.replicaState().put((Object)this.replica(), (Object)OfflineReplica$.MODULE$);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), true, callbacks.stopReplicaResponseCallback());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)ReplicaDeletionStarted$.MODULE$, callbacks);
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)ReplicaDeletionStarted$.MODULE$, (Object)this.replicaState().apply((Object)this.replica()));
    }

    @Test
    public void testInvalidOfflineReplicaToReplicaDeletionIneligibleTransition() {
        this.testInvalidTransition((ReplicaState)OfflineReplica$.MODULE$, (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
    }

    @Test
    public void testInvalidOfflineReplicaToReplicaDeletionSuccessfulTransition() {
        this.testInvalidTransition((ReplicaState)OfflineReplica$.MODULE$, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionStartedToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionStarted$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionStartedToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionStarted$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionStartedToOnlineReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionStarted$.MODULE$, (ReplicaState)OnlineReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionStartedToOfflineReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionStarted$.MODULE$, (ReplicaState)OfflineReplica$.MODULE$);
    }

    @Test
    public void testReplicaDeletionStartedToReplicaDeletionIneligibleTransition() {
        this.replicaState().put((Object)this.replica(), (Object)ReplicaDeletionStarted$.MODULE$);
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        ReplicaDeletionIneligible$ x$2 = ReplicaDeletionIneligible$.MODULE$;
        Callbacks x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        Assert.assertEquals((Object)ReplicaDeletionIneligible$.MODULE$, (Object)this.replicaState().apply((Object)this.replica()));
    }

    @Test
    public void testReplicaDeletionStartedToReplicaDeletionSuccessfulTransition() {
        this.replicaState().put((Object)this.replica(), (Object)ReplicaDeletionStarted$.MODULE$);
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        ReplicaDeletionSuccessful$ x$2 = ReplicaDeletionSuccessful$.MODULE$;
        Callbacks x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        Assert.assertEquals((Object)ReplicaDeletionSuccessful$.MODULE$, (Object)this.replicaState().apply((Object)this.replica()));
    }

    @Test
    public void testReplicaDeletionSuccessfulToNonexistentReplicaTransition() {
        this.replicaState().put((Object)this.replica(), (Object)ReplicaDeletionSuccessful$.MODULE$);
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        NonExistentReplica$ x$2 = NonExistentReplica$.MODULE$;
        Callbacks x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)this.controllerContext().partitionReplicaAssignment(this.partition()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.replicaState().get((Object)this.replica()));
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToOnlineReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)OnlineReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToOfflineReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)OfflineReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToReplicaDeletionStartedTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)ReplicaDeletionStarted$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToReplicaDeletionIneligibleTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionIneligibleToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionIneligible$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionIneligibleToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionIneligible$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    @Test
    public void testReplicaDeletionIneligibleToOnlineReplicaTransition() {
        this.replicaState().put((Object)this.replica(), (Object)ReplicaDeletionIneligible$.MODULE$);
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        this.controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), leaderIsrAndControllerEpoch, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        OnlineReplica$ x$2 = OnlineReplica$.MODULE$;
        Callbacks x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState().apply((Object)this.replica()));
    }

    @Test
    public void testInvalidReplicaDeletionIneligibleToReplicaDeletionStartedTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionIneligible$.MODULE$, (ReplicaState)ReplicaDeletionStarted$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionIneligibleToReplicaDeletionSuccessfulTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionIneligible$.MODULE$, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
    }

    private void testInvalidTransition(ReplicaState fromState, ReplicaState toState) {
        this.replicaState().put((Object)this.replica(), (Object)fromState);
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        ReplicaState x$2 = toState;
        Callbacks x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, x$2, x$3);
        Assert.assertEquals((Object)fromState, (Object)this.replicaState().apply((Object)this.replica()));
    }

    public ReplicaStateMachineTest() {
        this.brokerId = 5;
        this.controllerEpoch = 50;
    }
}

