/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import java.util.Properties;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.controller.Callbacks;
import kafka.controller.ControlledShutdownPartitionLeaderElectionStrategy$;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.ControllerEventManager;
import kafka.controller.KafkaController;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewPartition$;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflinePartitionLeaderElectionStrategy$;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine;
import kafka.controller.PreferredReplicaPartitionLeaderElectionStrategy$;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.StateChangeLogger;
import kafka.controller.TopicDeletionManager;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.CreateResponse;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.ResponseMetadata;
import kafka.zookeeper.ZooKeeperClientException;
import org.apache.kafka.common.TopicPartition;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mh\u0001B\u001b7\u0001mBQA\u0012\u0001\u0005\u0002\u001dCqA\u0013\u0001A\u0002\u0013%1\nC\u0004P\u0001\u0001\u0007I\u0011\u0002)\t\re\u0003\u0001\u0015)\u0003M\u0011\u001dQ\u0006\u00011A\u0005\nmCqA\u0019\u0001A\u0002\u0013%1\r\u0003\u0004f\u0001\u0001\u0006K\u0001\u0018\u0005\bM\u0002\u0001\r\u0011\"\u0003h\u0011\u001dY\u0007\u00011A\u0005\n1DaA\u001c\u0001!B\u0013A\u0007bB8\u0001\u0001\u0004%I\u0001\u001d\u0005\bi\u0002\u0001\r\u0011\"\u0003v\u0011\u00199\b\u0001)Q\u0005c\"9\u0001\u0010\u0001a\u0001\n\u0013I\b\"CA\u000f\u0001\u0001\u0007I\u0011BA\u0010\u0011\u001d\t\u0019\u0003\u0001Q!\niD\u0011\"!\n\u0001\u0001\u0004%I!a\n\t\u0013\u0005=\u0002\u00011A\u0005\n\u0005E\u0002\u0002CA\u001b\u0001\u0001\u0006K!!\u000b\t\u0013\u0005]\u0002A1A\u0005\n\u0005e\u0002\u0002CA!\u0001\u0001\u0006I!a\u000f\t\u0013\u0005\r\u0003A1A\u0005\n\u0005\u0015\u0003\u0002CA*\u0001\u0001\u0006I!a\u0012\t\u0013\u0005U\u0003A1A\u0005\n\u0005e\u0002\u0002CA,\u0001\u0001\u0006I!a\u000f\t\u0013\u0005e\u0003A1A\u0005\n\u0005m\u0003\u0002CA/\u0001\u0001\u0006I!!\u0002\t\u0013\u0005}\u0003A1A\u0005\n\u0005\u0005\u0004\u0002CA6\u0001\u0001\u0006I!a\u0019\t\u000f\u00055\u0004\u0001\"\u0001\u0002p!9\u0011Q\u0010\u0001\u0005\u0002\u0005=\u0004bBAD\u0001\u0011\u0005\u0011q\u000e\u0005\b\u0003\u0017\u0003A\u0011AA8\u0011\u001d\ty\t\u0001C\u0001\u0003_Bq!a%\u0001\t\u0003\ty\u0007C\u0004\u0002\u0018\u0002!\t!a\u001c\t\u000f\u0005m\u0005\u0001\"\u0001\u0002p!9\u0011q\u0014\u0001\u0005\u0002\u0005=\u0004bBAR\u0001\u0011\u0005\u0011q\u000e\u0005\b\u0003O\u0003A\u0011AA8\u0011\u001d\tY\u000b\u0001C\u0001\u0003_Bq!a,\u0001\t\u0003\ty\u0007C\u0004\u00024\u0002!\t!a\u001c\t\u000f\u0005]\u0006\u0001\"\u0001\u0002p!9\u00111\u0018\u0001\u0005\u0002\u0005=\u0004bBA`\u0001\u0011\u0005\u0011q\u000e\u0005\b\u0003\u0007\u0004A\u0011AA8\u0011\u001d\t9\r\u0001C\u0001\u0003_Bq!a3\u0001\t\u0013\ti\rC\u0004\u0002h\u0002!\t!a\u001c\t\u000f\u0005-\b\u0001\"\u0001\u0002p!9\u0011q\u001e\u0001\u0005\u0002\u0005=$!\u0007)beRLG/[8o'R\fG/Z'bG\"Lg.\u001a+fgRT!a\u000e\u001d\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001:\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u001f\u0011\u0005u\"U\"\u0001 \u000b\u0005}\u0002\u0015!\u00026v]&$(BA!C\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001D\u0003\ry'oZ\u0005\u0003\u000bz\u0012!BS+oSR\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\t\u0001\n\u0005\u0002J\u00015\ta'A\td_:$(o\u001c7mKJ\u001cuN\u001c;fqR,\u0012\u0001\u0014\t\u0003\u00136K!A\u0014\u001c\u0003#\r{g\u000e\u001e:pY2,'oQ8oi\u0016DH/A\u000bd_:$(o\u001c7mKJ\u001cuN\u001c;fqR|F%Z9\u0015\u0005E;\u0006C\u0001*V\u001b\u0005\u0019&\"\u0001+\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001b&\u0001B+oSRDq\u0001W\u0002\u0002\u0002\u0003\u0007A*A\u0002yIE\n!cY8oiJ|G\u000e\\3s\u0007>tG/\u001a=uA\u0005aQn\\2l5.\u001cE.[3oiV\tA\f\u0005\u0002^A6\taL\u0003\u0002`q\u0005\u0011!p[\u0005\u0003Cz\u0013QbS1gW\u0006T6n\u00117jK:$\u0018\u0001E7pG.T6n\u00117jK:$x\fJ3r)\t\tF\rC\u0004Y\r\u0005\u0005\t\u0019\u0001/\u0002\u001b5|7m\u001b.l\u00072LWM\u001c;!\u0003\u0001jwnY6D_:$(o\u001c7mKJ\u0014%o\\6feJ+\u0017/^3ti\n\u000bGo\u00195\u0016\u0003!\u0004\"!S5\n\u0005)4$\u0001H\"p]R\u0014x\u000e\u001c7fe\n\u0013xn[3s%\u0016\fX/Z:u\u0005\u0006$8\r[\u0001%[>\u001c7nQ8oiJ|G\u000e\\3s\u0005J|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007n\u0018\u0013fcR\u0011\u0011+\u001c\u0005\b1&\t\t\u00111\u0001i\u0003\u0005jwnY6D_:$(o\u001c7mKJ\u0014%o\\6feJ+\u0017/^3ti\n\u000bGo\u00195!\u0003aiwnY6U_BL7\rR3mKRLwN\\'b]\u0006<WM]\u000b\u0002cB\u0011\u0011J]\u0005\u0003gZ\u0012A\u0003V8qS\u000e$U\r\\3uS>tW*\u00198bO\u0016\u0014\u0018\u0001H7pG.$v\u000e]5d\t\u0016dW\r^5p]6\u000bg.Y4fe~#S-\u001d\u000b\u0003#ZDq\u0001\u0017\u0007\u0002\u0002\u0003\u0007\u0011/A\rn_\u000e\\Gk\u001c9jG\u0012+G.\u001a;j_:l\u0015M\\1hKJ\u0004\u0013A\u00049beRLG/[8o'R\fG/Z\u000b\u0002uB910!\u0001\u0002\u0006\u0005]Q\"\u0001?\u000b\u0005ut\u0018aB7vi\u0006\u0014G.\u001a\u0006\u0003\u007fN\u000b!bY8mY\u0016\u001cG/[8o\u0013\r\t\u0019\u0001 \u0002\u0004\u001b\u0006\u0004\b\u0003BA\u0004\u0003'i!!!\u0003\u000b\t\u0005-\u0011QB\u0001\u0007G>lWn\u001c8\u000b\u0007e\nyAC\u0002\u0002\u0012\t\u000ba!\u00199bG\",\u0017\u0002BA\u000b\u0003\u0013\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eE\u0002J\u00033I1!a\u00077\u00059\u0001\u0016M\u001d;ji&|gn\u0015;bi\u0016\f!\u0003]1si&$\u0018n\u001c8Ti\u0006$Xm\u0018\u0013fcR\u0019\u0011+!\t\t\u000fa{\u0011\u0011!a\u0001u\u0006y\u0001/\u0019:uSRLwN\\*uCR,\u0007%A\u000bqCJ$\u0018\u000e^5p]N#\u0018\r^3NC\u000eD\u0017N\\3\u0016\u0005\u0005%\u0002cA%\u0002,%\u0019\u0011Q\u0006\u001c\u0003+A\u000b'\u000f^5uS>t7\u000b^1uK6\u000b7\r[5oK\u0006I\u0002/\u0019:uSRLwN\\*uCR,W*Y2iS:,w\fJ3r)\r\t\u00161\u0007\u0005\t1J\t\t\u00111\u0001\u0002*\u00051\u0002/\u0019:uSRLwN\\*uCR,W*Y2iS:,\u0007%\u0001\u0005ce>\\WM]%e+\t\tY\u0004E\u0002S\u0003{I1!a\u0010T\u0005\rIe\u000e^\u0001\nEJ|7.\u001a:JI\u0002\naaY8oM&<WCAA$!\u0011\tI%a\u0014\u000e\u0005\u0005-#bAA'q\u000511/\u001a:wKJLA!!\u0015\u0002L\tY1*\u00194lC\u000e{gNZ5h\u0003\u001d\u0019wN\u001c4jO\u0002\nqbY8oiJ|G\u000e\\3s\u000bB|7\r[\u0001\u0011G>tGO]8mY\u0016\u0014X\t]8dQ\u0002\n\u0011\u0002]1si&$\u0018n\u001c8\u0016\u0005\u0005\u0015\u0011A\u00039beRLG/[8oA\u0005Q\u0001/\u0019:uSRLwN\\:\u0016\u0005\u0005\r\u0004CBA3\u0003O\n)!D\u0001\u007f\u0013\r\tIG \u0002\u0004'\u0016\f\u0018a\u00039beRLG/[8og\u0002\nQa]3u+B$\u0012!\u0015\u0015\u0004=\u0005M\u0004\u0003BA;\u0003sj!!a\u001e\u000b\u0005}\u0012\u0015\u0002BA>\u0003o\u0012aAQ3g_J,\u0017\u0001\r;fgRtuN\\3ySN$XM\u001c;QCJ$\u0018\u000e^5p]R{g*Z<QCJ$\u0018\u000e^5p]R\u0013\u0018M\\:ji&|g\u000eK\u0002 \u0003\u0003\u0003B!!\u001e\u0002\u0004&!\u0011QQA<\u0005\u0011!Vm\u001d;\u0002uQ,7\u000f^%om\u0006d\u0017\u000e\u001a(p]\u0016D\u0018n\u001d;f]R\u0004\u0016M\u001d;ji&|g\u000eV8P]2Lg.\u001a)beRLG/[8o)J\fgn]5uS>t\u0007f\u0001\u0011\u0002\u0002\u0006YD/Z:u\u0013:4\u0018\r\\5e\u001d>tW\r_5ti\u0016tG\u000fU1si&$\u0018n\u001c8U_>3g\r\\5oKB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8)\u0007\u0005\n\t)A\u0016uKN$h*Z<QCJ$\u0018\u000e^5p]R{wJ\u001c7j]\u0016\u0004\u0016M\u001d;ji&|g\u000e\u0016:b]NLG/[8oQ\r\u0011\u0013\u0011Q\u0001Li\u0016\u001cHOT3x!\u0006\u0014H/\u001b;j_:$vn\u00148mS:,\u0007+\u0019:uSRLwN\u001c+sC:\u001c\u0018\u000e^5p]j[W\u000b^5mg\u0016C8-\u001a9uS>tgI]8n\u0007J,\u0017\r^3Ti\u0006$Xm\u001d\u0015\u0004G\u0005\u0005\u0015\u0001\u0012;fgRtUm\u001e)beRLG/[8o)>|e\u000e\\5oKB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8FeJ|'oQ8eK\u001a\u0013x.\\\"sK\u0006$Xm\u0015;bi\u0016\u001c\bf\u0001\u0013\u0002\u0002\u0006aC/Z:u\u001d\u0016<\b+\u0019:uSRLwN\u001c+p\u001f\u001a4G.\u001b8f!\u0006\u0014H/\u001b;j_:$&/\u00198tSRLwN\u001c\u0015\u0004K\u0005\u0005\u0015a\u000e;fgRLeN^1mS\u0012tUm\u001e)beRLG/[8o)>tuN\\3ySN$XM\u001c;QCJ$\u0018\u000e^5p]R\u0013\u0018M\\:ji&|g\u000eK\u0002'\u0003\u0003\u000bQ\u0005^3ti>sG.\u001b8f!\u0006\u0014H/\u001b;j_:$vn\u00148mS:,GK]1og&$\u0018n\u001c8)\u0007\u001d\n\t)\u0001\u001euKN$xJ\u001c7j]\u0016\u0004\u0016M\u001d;ji&|g\u000eV8P]2Lg.\u001a+sC:\u001c\u0018\u000e^5p]\u001a{'oQ8oiJ|G\u000e\\3e'\",H\u000fZ8x]\"\u001a\u0001&!!\u0002MQ,7\u000f^(oY&tW\rU1si&$\u0018n\u001c8U_>3g\r\\5oKR\u0013\u0018M\\:ji&|g\u000eK\u0002*\u0003\u0003\u000b!\b^3ti&sg/\u00197jI>sG.\u001b8f!\u0006\u0014H/\u001b;j_:$vNT8oKbL7\u000f^3oiB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8)\u0007)\n\t)\u0001\u001auKN$\u0018J\u001c<bY&$wJ\u001c7j]\u0016\u0004\u0016M\u001d;ji&|g\u000eV8OK^\u0004\u0016M\u001d;ji&|g\u000e\u0016:b]NLG/[8oQ\rY\u0013\u0011Q\u00010i\u0016\u001cHo\u00144gY&tW\rU1si&$\u0018n\u001c8U_>sG.\u001b8f!\u0006\u0014H/\u001b;j_:$&/\u00198tSRLwN\u001c\u0015\u0004Y\u0005\u0005\u0015A\u0014;fgR|eM\u001a7j]\u0016\u0004\u0016M\u001d;ji&|g\u000eV8P]2Lg.\u001a)beRLG/[8o)J\fgn]5uS>t'l[+uS2\u001cX\t_2faRLwN\u001c$s_6\u001cF/\u0019;f\u0019>|7.\u001e9)\u00075\n\t)A$uKN$xJ\u001a4mS:,\u0007+\u0019:uSRLwN\u001c+p\u001f:d\u0017N\\3QCJ$\u0018\u000e^5p]R\u0013\u0018M\\:ji&|g.\u0012:s_J\u001cu\u000eZ3Ge>l7\u000b^1uK2{wn[;qQ\rq\u0013\u0011Q\u00015i\u0016\u001cHo\u00144gY&tW\rU1si&$\u0018n\u001c8U_:{g.\u001a=jgR,g\u000e\u001e)beRLG/[8o)J\fgn]5uS>t\u0007fA\u0018\u0002\u0002\u0006\u0019D/Z:u\u0013:4\u0018\r\\5e\u001f\u001a4G.\u001b8f!\u0006\u0014H/\u001b;j_:$vNT3x!\u0006\u0014H/\u001b;j_:$&/\u00198tSRLwN\u001c\u0015\u0004a\u0005\u0005\u0015!\n9sKB\f'/Z'pG.$v.\u00127fGRdU-\u00193fe\u001a{'\u000fU1si&$\u0018n\u001c8t)\r\t\u0016q\u001a\u0005\b\u0003?\n\u0004\u0019AAi!\u0019\t\u0019.a9\u0002\u00069!\u0011Q[Ap\u001d\u0011\t9.!8\u000e\u0005\u0005e'bAAnu\u00051AH]8pizJ\u0011\u0001V\u0005\u0004\u0003C\u001c\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003S\n)OC\u0002\u0002bN\u000b!\u0005^3tiV\u0003H-\u0019;j]\u001e|eM\u001a7j]\u0016\u0004\u0016M\u001d;ji&|gn]\"pk:$\bf\u0001\u001a\u0002\u0002\u0006\u0011D/Z:u\u001d>|eM\u001a7j]\u0016\u0004\u0016M\u001d;ji&|gn]\"iC:<WMR8s)>\u0004\u0018nY:CK&tw\rR3mKR,G\rK\u00024\u0003\u0003\u000bQ\u0007^3tiV\u0003H-\u0019;j]\u001e|eM\u001a7j]\u0016\u0004\u0016M\u001d;ji&|gn]\"pk:$H)\u001e:j]\u001e$v\u000e]5d\t\u0016dW\r^5p]\"\u001aA'!!")
public class PartitionStateMachineTest
extends JUnitSuite {
    private ControllerContext controllerContext = null;
    private KafkaZkClient mockZkClient = null;
    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch = null;
    private TopicDeletionManager mockTopicDeletionManager = null;
    private Map<TopicPartition, PartitionState> partitionState = null;
    private PartitionStateMachine partitionStateMachine = null;
    private final int brokerId;
    private final KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
    private final int controllerEpoch;
    private final TopicPartition partition = new TopicPartition("t", 0);
    private final Seq<TopicPartition> partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition()}));

    private ControllerContext controllerContext() {
        return this.controllerContext;
    }

    private void controllerContext_$eq(ControllerContext x$1) {
        this.controllerContext = x$1;
    }

    private KafkaZkClient mockZkClient() {
        return this.mockZkClient;
    }

    private void mockZkClient_$eq(KafkaZkClient x$1) {
        this.mockZkClient = x$1;
    }

    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch() {
        return this.mockControllerBrokerRequestBatch;
    }

    private void mockControllerBrokerRequestBatch_$eq(ControllerBrokerRequestBatch x$1) {
        this.mockControllerBrokerRequestBatch = x$1;
    }

    private TopicDeletionManager mockTopicDeletionManager() {
        return this.mockTopicDeletionManager;
    }

    private void mockTopicDeletionManager_$eq(TopicDeletionManager x$1) {
        this.mockTopicDeletionManager = x$1;
    }

    private Map<TopicPartition, PartitionState> partitionState() {
        return this.partitionState;
    }

    private void partitionState_$eq(Map<TopicPartition, PartitionState> x$1) {
        this.partitionState = x$1;
    }

    private PartitionStateMachine partitionStateMachine() {
        return this.partitionStateMachine;
    }

    private void partitionStateMachine_$eq(PartitionStateMachine x$1) {
        this.partitionStateMachine = x$1;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    private TopicPartition partition() {
        return this.partition;
    }

    private Seq<TopicPartition> partitions() {
        return this.partitions;
    }

    @Before
    public void setUp() {
        this.controllerContext_$eq(new ControllerContext());
        this.controllerContext().epoch_$eq(this.controllerEpoch());
        this.mockZkClient_$eq((KafkaZkClient)EasyMock.createMock(KafkaZkClient.class));
        this.mockControllerBrokerRequestBatch_$eq((ControllerBrokerRequestBatch)EasyMock.createMock(ControllerBrokerRequestBatch.class));
        this.mockTopicDeletionManager_$eq((TopicDeletionManager)EasyMock.createMock(TopicDeletionManager.class));
        this.partitionState_$eq((Map<TopicPartition, PartitionState>)Map$.MODULE$.empty());
        this.partitionStateMachine_$eq(new PartitionStateMachine(this.config(), new StateChangeLogger(this.brokerId(), true, (Option)None$.MODULE$), this.controllerContext(), this.mockZkClient(), this.partitionState(), this.mockControllerBrokerRequestBatch()));
        this.partitionStateMachine().setTopicDeletionManager(this.mockTopicDeletionManager());
    }

    @Test
    public void testNonexistentPartitionToNewPartitionTransition() {
        PartitionStateMachine qual$1 = this.partitionStateMachine();
        Seq<TopicPartition> x$1 = this.partitions();
        NewPartition$ x$2 = NewPartition$.MODULE$;
        Option x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (PartitionState)x$2, x$3);
        Assert.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testInvalidNonexistentPartitionToOnlinePartitionTransition() {
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)OfflinePartitionLeaderElectionStrategy$.MODULE$));
        Assert.assertEquals((Object)NonExistentPartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testInvalidNonexistentPartitionToOfflinePartitionTransition() {
        PartitionStateMachine qual$1 = this.partitionStateMachine();
        Seq<TopicPartition> x$1 = this.partitions();
        OfflinePartition$ x$2 = OfflinePartition$.MODULE$;
        Option x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (PartitionState)x$2, x$3);
        Assert.assertEquals((Object)NonExistentPartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testNewPartitionToOnlinePartitionTransition() {
        this.controllerContext().setLiveBrokerAndEpochs((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        this.partitionState().put((Object)this.partition(), (Object)NewPartition$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().createTopicPartitionStatesRaw((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderIsrAndControllerEpoch)})), this.controllerContext().epochZkVersion())).andReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateResponse[]{new CreateResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), null, new ResponseMetadata(0L, 0L))})));
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), leaderIsrAndControllerEpoch, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), true);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)OfflinePartitionLeaderElectionStrategy$.MODULE$));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testNewPartitionToOnlinePartitionTransitionZkUtilsExceptionFromCreateStates() {
        this.controllerContext().setLiveBrokerAndEpochs((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        this.partitionState().put((Object)this.partition(), (Object)NewPartition$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().createTopicPartitionStatesRaw((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderIsrAndControllerEpoch)})), this.controllerContext().epochZkVersion())).andThrow((Throwable)new ZooKeeperClientException("test"));
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)OfflinePartitionLeaderElectionStrategy$.MODULE$));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testNewPartitionToOnlinePartitionTransitionErrorCodeFromCreateStates() {
        this.controllerContext().setLiveBrokerAndEpochs((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        this.partitionState().put((Object)this.partition(), (Object)NewPartition$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().createTopicPartitionStatesRaw((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderIsrAndControllerEpoch)})), this.controllerContext().epochZkVersion())).andReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateResponse[]{new CreateResponse(KeeperException.Code.NODEEXISTS, null, (Option)new Some((Object)this.partition()), null, new ResponseMetadata(0L, 0L))})));
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)OfflinePartitionLeaderElectionStrategy$.MODULE$));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testNewPartitionToOfflinePartitionTransition() {
        this.partitionState().put((Object)this.partition(), (Object)NewPartition$.MODULE$);
        PartitionStateMachine qual$1 = this.partitionStateMachine();
        Seq<TopicPartition> x$1 = this.partitions();
        OfflinePartition$ x$2 = OfflinePartition$.MODULE$;
        Option x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (PartitionState)x$2, x$3);
        Assert.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testInvalidNewPartitionToNonexistentPartitionTransition() {
        this.partitionState().put((Object)this.partition(), (Object)NewPartition$.MODULE$);
        PartitionStateMachine qual$1 = this.partitionStateMachine();
        Seq<TopicPartition> x$1 = this.partitions();
        NonExistentPartition$ x$2 = NonExistentPartition$.MODULE$;
        Option x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (PartitionState)x$2, x$3);
        Assert.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testOnlinePartitionToOnlineTransition() {
        this.controllerContext().setLiveBrokerAndEpochs((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        this.partitionState().put((Object)this.partition(), (Object)OnlinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GetDataResponse[]{new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L))})));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeader(this.brokerId());
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withZkVersion(2);
        EasyMock.expect((Object)this.mockZkClient().updateLeaderAndIsr((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).andReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)updatedLeaderAndIsr)})), (Seq)Seq$.MODULE$.empty(), Predef$.MODULE$.Map().empty()));
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)PreferredReplicaPartitionLeaderElectionStrategy$.MODULE$));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testOnlinePartitionToOnlineTransitionForControlledShutdown() {
        int otherBrokerId = this.brokerId() + 1;
        this.controllerContext().setLiveBrokerAndEpochs((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5()), TestUtils$.MODULE$.createBrokerAndEpoch(otherBrokerId, "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().shuttingDownBrokerIds().add((Object)BoxesRunTime.boxToInteger((int)this.brokerId()));
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})));
        this.partitionState().put((Object)this.partition(), (Object)OnlinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GetDataResponse[]{new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L))})));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeaderAndIsr(otherBrokerId, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})));
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withZkVersion(2);
        EasyMock.expect((Object)this.mockZkClient().updateLeaderAndIsr((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).andReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)updatedLeaderAndIsr)})), (Seq)Seq$.MODULE$.empty(), Predef$.MODULE$.Map().empty()));
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)ControlledShutdownPartitionLeaderElectionStrategy$.MODULE$));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testOnlinePartitionToOfflineTransition() {
        this.partitionState().put((Object)this.partition(), (Object)OnlinePartition$.MODULE$);
        PartitionStateMachine qual$1 = this.partitionStateMachine();
        Seq<TopicPartition> x$1 = this.partitions();
        OfflinePartition$ x$2 = OfflinePartition$.MODULE$;
        Option x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (PartitionState)x$2, x$3);
        Assert.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testInvalidOnlinePartitionToNonexistentPartitionTransition() {
        this.partitionState().put((Object)this.partition(), (Object)OnlinePartition$.MODULE$);
        PartitionStateMachine qual$1 = this.partitionStateMachine();
        Seq<TopicPartition> x$1 = this.partitions();
        NonExistentPartition$ x$2 = NonExistentPartition$.MODULE$;
        Option x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (PartitionState)x$2, x$3);
        Assert.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testInvalidOnlinePartitionToNewPartitionTransition() {
        this.partitionState().put((Object)this.partition(), (Object)OnlinePartition$.MODULE$);
        PartitionStateMachine qual$1 = this.partitionStateMachine();
        Seq<TopicPartition> x$1 = this.partitions();
        NewPartition$ x$2 = NewPartition$.MODULE$;
        Option x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (PartitionState)x$2, x$3);
        Assert.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testOfflinePartitionToOnlinePartitionTransition() {
        this.controllerContext().setLiveBrokerAndEpochs((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        this.partitionState().put((Object)this.partition(), (Object)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GetDataResponse[]{new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L))})));
        EasyMock.expect((Object)this.mockZkClient().getLogConfigs((Seq)Seq$.MODULE$.empty(), this.config().originals())).andReturn((Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition().topic()), (Object)LogConfig$.MODULE$.apply())})), (Object)Predef$.MODULE$.Map().empty()));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeader(this.brokerId());
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withZkVersion(2);
        EasyMock.expect((Object)this.mockZkClient().updateLeaderAndIsr((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).andReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)updatedLeaderAndIsr)})), (Seq)Seq$.MODULE$.empty(), Predef$.MODULE$.Map().empty()));
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)OfflinePartitionLeaderElectionStrategy$.MODULE$));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testOfflinePartitionToOnlinePartitionTransitionZkUtilsExceptionFromStateLookup() {
        this.controllerContext().setLiveBrokerAndEpochs((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        this.partitionState().put((Object)this.partition(), (Object)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andThrow((Throwable)new ZooKeeperClientException(""));
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)OfflinePartitionLeaderElectionStrategy$.MODULE$));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testOfflinePartitionToOnlinePartitionTransitionErrorCodeFromStateLookup() {
        this.controllerContext().setLiveBrokerAndEpochs((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        this.partitionState().put((Object)this.partition(), (Object)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GetDataResponse[]{new GetDataResponse(KeeperException.Code.NONODE, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L))})));
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)OfflinePartitionLeaderElectionStrategy$.MODULE$));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testOfflinePartitionToNonexistentPartitionTransition() {
        this.partitionState().put((Object)this.partition(), (Object)OfflinePartition$.MODULE$);
        PartitionStateMachine qual$1 = this.partitionStateMachine();
        Seq<TopicPartition> x$1 = this.partitions();
        NonExistentPartition$ x$2 = NonExistentPartition$.MODULE$;
        Option x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (PartitionState)x$2, x$3);
        Assert.assertEquals((Object)NonExistentPartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testInvalidOfflinePartitionToNewPartitionTransition() {
        this.partitionState().put((Object)this.partition(), (Object)OfflinePartition$.MODULE$);
        PartitionStateMachine qual$1 = this.partitionStateMachine();
        Seq<TopicPartition> x$1 = this.partitions();
        NewPartition$ x$2 = NewPartition$.MODULE$;
        Option x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (PartitionState)x$2, x$3);
        Assert.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    private void prepareMockToElectLeaderForPartitions(Seq<TopicPartition> partitions) {
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        this.prepareMockToGetTopicPartitionsStatesRaw$1(leaderAndIsr, partitions);
        this.prepareMockToGetLogConfigs$1();
        this.prepareMockToUpdateLeaderAndIsr$1(partitions, leaderAndIsr);
    }

    @Test
    public void testUpdatingOfflinePartitionsCount() {
        this.controllerContext().setLiveBrokerAndEpochs((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        Seq partitionIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        String topic = "test";
        Seq partitions = (Seq)partitionIds.map((Function1 & Serializable & scala.Serializable)x$1 -> PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCount$1(BoxesRunTime.unboxToInt((Object)x$1)), Seq$.MODULE$.canBuildFrom());
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCount$2(this, partition);
            return BoxedUnit.UNIT;
        });
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.mockTopicDeletionManager().isTopicWithDeletionStarted(topic))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        EasyMock.expectLastCall().anyTimes();
        this.prepareMockToElectLeaderForPartitions((Seq<TopicPartition>)partitions);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockTopicDeletionManager()});
        PartitionStateMachine qual$1 = this.partitionStateMachine();
        Seq x$12 = partitions;
        NewPartition$ x$2 = NewPartition$.MODULE$;
        Option x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$12, (PartitionState)x$2, x$3);
        PartitionStateMachine qual$2 = this.partitionStateMachine();
        Seq x$4 = partitions;
        OfflinePartition$ x$5 = OfflinePartition$.MODULE$;
        Option x$6 = qual$2.handleStateChanges$default$3();
        qual$2.handleStateChanges(x$4, (PartitionState)x$5, x$6);
        Assert.assertEquals((String)new StringBuilder(37).append("There should be ").append(partitions.size()).append(" offline partition(s)").toString(), (long)partitions.size(), (long)this.partitionStateMachine().offlinePartitionCount());
        this.partitionStateMachine().handleStateChanges(partitions, (PartitionState)OnlinePartition$.MODULE$, (Option)new Some((Object)OfflinePartitionLeaderElectionStrategy$.MODULE$));
        Assert.assertEquals((String)"There should be no offline partition(s)", (long)0L, (long)this.partitionStateMachine().offlinePartitionCount());
    }

    @Test
    public void testNoOfflinePartitionsChangeForTopicsBeingDeleted() {
        Seq partitionIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        String topic = "test";
        Seq partitions = (Seq)partitionIds.map((Function1 & Serializable & scala.Serializable)x$2 -> PartitionStateMachineTest.$anonfun$testNoOfflinePartitionsChangeForTopicsBeingDeleted$1(BoxesRunTime.unboxToInt((Object)x$2)), Seq$.MODULE$.canBuildFrom());
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.mockTopicDeletionManager().isTopicWithDeletionStarted(topic))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockTopicDeletionManager()});
        PartitionStateMachine qual$1 = this.partitionStateMachine();
        Seq x$1 = partitions;
        NewPartition$ x$22 = NewPartition$.MODULE$;
        Option x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (PartitionState)x$22, x$3);
        PartitionStateMachine qual$2 = this.partitionStateMachine();
        Seq x$4 = partitions;
        OfflinePartition$ x$5 = OfflinePartition$.MODULE$;
        Option x$6 = qual$2.handleStateChanges$default$3();
        qual$2.handleStateChanges(x$4, (PartitionState)x$5, x$6);
        Assert.assertEquals((String)"There should be no offline partition(s)", (long)0L, (long)this.partitionStateMachine().offlinePartitionCount());
    }

    @Test
    public void testUpdatingOfflinePartitionsCountDuringTopicDeletion() {
        Seq partitionIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        String topic = "test";
        Seq partitions = (Seq)partitionIds.map((Function1 & Serializable & scala.Serializable)x$3 -> PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$1(BoxesRunTime.unboxToInt((Object)x$3)), Seq$.MODULE$.canBuildFrom());
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$2(this, partition);
            return BoxedUnit.UNIT;
        });
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        props.put(KafkaConfig$.MODULE$.DeleteTopicEnableProp(), "true");
        KafkaConfig customConfig = KafkaConfig$.MODULE$.fromProps(props);
        ReplicaStateMachine replicaStateMachine = PartitionStateMachineTest.createMockReplicaStateMachine$1(topic);
        this.partitionStateMachine_$eq(new PartitionStateMachine(customConfig, new StateChangeLogger(this.brokerId(), true, (Option)None$.MODULE$), this.controllerContext(), this.mockZkClient(), this.partitionState(), this.mockControllerBrokerRequestBatch()));
        KafkaController mockController = this.createMockController$1(customConfig, replicaStateMachine, partitions);
        ControllerEventManager mockEventManager = (ControllerEventManager)EasyMock.createMock(ControllerEventManager.class);
        EasyMock.replay((Object[])new Object[]{mockController, replicaStateMachine, mockEventManager});
        TopicDeletionManager topicDeletionManager = new TopicDeletionManager(mockController, mockEventManager, this.mockZkClient());
        this.partitionStateMachine().setTopicDeletionManager(topicDeletionManager);
        PartitionStateMachine qual$1 = this.partitionStateMachine();
        Seq x$1 = partitions;
        NewPartition$ x$2 = NewPartition$.MODULE$;
        Option x$32 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (PartitionState)x$2, x$32);
        PartitionStateMachine qual$2 = this.partitionStateMachine();
        Seq x$4 = partitions;
        OfflinePartition$ x$5 = OfflinePartition$.MODULE$;
        Option x$6 = qual$2.handleStateChanges$default$3();
        qual$2.handleStateChanges(x$4, (PartitionState)x$5, x$6);
        Assert.assertEquals((String)new StringBuilder(37).append("There should be ").append(partitions.size()).append(" offline partition(s)").toString(), (long)partitions.size(), (long)mockController.partitionStateMachine().offlinePartitionCount());
        topicDeletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Assert.assertEquals((String)"There should be no offline partition(s)", (long)0L, (long)this.partitionStateMachine().offlinePartitionCount());
    }

    private final void prepareMockToGetTopicPartitionsStatesRaw$1(LeaderAndIsr leaderAndIsr$1, Seq partitions$1) {
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr$1, this.controllerEpoch());
        Seq getDataResponses = (Seq)partitions$1.map((Function1 & Serializable & scala.Serializable)p -> new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some(p), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), Seq$.MODULE$.canBuildFrom());
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(partitions$1)).andReturn((Object)getDataResponses);
    }

    private final void prepareMockToGetLogConfigs$1() {
        Seq topicsForPartitionsWithNoLiveInSyncReplicas = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        EasyMock.expect((Object)this.mockZkClient().getLogConfigs(topicsForPartitionsWithNoLiveInSyncReplicas, this.config().originals())).andReturn((Object)new Tuple2((Object)Predef$.MODULE$.Map().empty(), (Object)Predef$.MODULE$.Map().empty()));
    }

    private final void prepareMockToUpdateLeaderAndIsr$1(Seq partitions$1, LeaderAndIsr leaderAndIsr$1) {
        scala.collection.immutable.Map updatedLeaderAndIsr = ((TraversableOnce)partitions$1.map((Function1 & Serializable & scala.Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partition), (Object)leaderAndIsr$1.newLeaderAndIsr(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        EasyMock.expect((Object)this.mockZkClient().updateLeaderAndIsr(updatedLeaderAndIsr, this.controllerEpoch(), this.controllerContext().epochZkVersion())).andReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult(updatedLeaderAndIsr, (Seq)Seq$.MODULE$.empty(), Predef$.MODULE$.Map().empty()));
    }

    public static final /* synthetic */ TopicPartition $anonfun$testUpdatingOfflinePartitionsCount$1(int x$1) {
        return new TopicPartition("test", x$1);
    }

    public static final /* synthetic */ void $anonfun$testUpdatingOfflinePartitionsCount$2(PartitionStateMachineTest $this, TopicPartition partition) {
        $this.controllerContext().updatePartitionReplicaAssignment(partition, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.brokerId()})));
    }

    public static final /* synthetic */ TopicPartition $anonfun$testNoOfflinePartitionsChangeForTopicsBeingDeleted$1(int x$2) {
        return new TopicPartition("test", x$2);
    }

    public static final /* synthetic */ TopicPartition $anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$1(int x$3) {
        return new TopicPartition("test", x$3);
    }

    public static final /* synthetic */ void $anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$2(PartitionStateMachineTest $this, TopicPartition partition) {
        $this.controllerContext().updatePartitionReplicaAssignment(partition, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.brokerId()})));
    }

    /*
     * WARNING - void declaration
     */
    private static final ReplicaStateMachine createMockReplicaStateMachine$1(String topic$1) {
        void var1_1;
        ReplicaStateMachine replicaStateMachine = (ReplicaStateMachine)EasyMock.createMock(ReplicaStateMachine.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)replicaStateMachine.areAllReplicasForTopicDeleted(topic$1))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)replicaStateMachine.isAtLeastOneReplicaInDeletionStartedState(topic$1))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)replicaStateMachine.isAnyReplicaInState(topic$1, (ReplicaState)ReplicaDeletionIneligible$.MODULE$))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).anyTimes();
        EasyMock.expect((Object)replicaStateMachine.replicasInState(topic$1, (ReplicaState)ReplicaDeletionIneligible$.MODULE$)).andReturn((Object)Predef$.MODULE$.Set().empty()).anyTimes();
        EasyMock.expect((Object)replicaStateMachine.replicasInState(topic$1, (ReplicaState)ReplicaDeletionStarted$.MODULE$)).andReturn((Object)Predef$.MODULE$.Set().empty()).anyTimes();
        EasyMock.expect((Object)replicaStateMachine.replicasInState(topic$1, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$)).andReturn((Object)Predef$.MODULE$.Set().empty()).anyTimes();
        replicaStateMachine.handleStateChanges((Seq)EasyMock.anyObject(), (ReplicaState)EasyMock.anyObject(), (Callbacks)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expectLastCall().anyTimes();
        return var1_1;
    }

    private final KafkaController createMockController$1(KafkaConfig customConfig$1, ReplicaStateMachine replicaStateMachine$1, Seq partitions$2) {
        KafkaController mockController = (KafkaController)EasyMock.createMock(KafkaController.class);
        EasyMock.expect((Object)mockController.controllerContext()).andReturn((Object)this.controllerContext()).anyTimes();
        EasyMock.expect((Object)mockController.config()).andReturn((Object)customConfig$1).anyTimes();
        EasyMock.expect((Object)mockController.partitionStateMachine()).andReturn((Object)this.partitionStateMachine()).anyTimes();
        EasyMock.expect((Object)mockController.replicaStateMachine()).andReturn((Object)replicaStateMachine$1).anyTimes();
        mockController.sendUpdateMetadataRequest((Seq)Seq$.MODULE$.empty(), (Set)partitions$2.toSet());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expectLastCall().anyTimes();
        return mockController;
    }

    public PartitionStateMachineTest() {
        this.brokerId = 5;
        this.controllerEpoch = 50;
    }
}

