/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import kafka.controller.ControllerEvent;
import kafka.controller.ControllerState;
import kafka.controller.ControllerTestUtils$;
import kafka.controller.KafkaController;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionState;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.VolatileObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea\u0001B\n\u0015\u0001eAQA\n\u0001\u0005\u0002\u001dBqA\u000b\u0001C\u0002\u0013\u00051\u0006\u0003\u00047\u0001\u0001\u0006I\u0001\f\u0005\bo\u0001\u0011\r\u0011\"\u00019\u0011\u0019y\u0004\u0001)A\u0005s!9\u0001\t\u0001b\u0001\n\u0003A\u0004BB!\u0001A\u0003%\u0011\bC\u0004C\u0001\t\u0007I\u0011\u0001\u001d\t\r\r\u0003\u0001\u0015!\u0003:\u0011\u001d!\u0005A1A\u0005\u0002\u0015CaA\u0014\u0001!\u0002\u00131\u0005bB(\u0001\u0005\u0004%\t\u0001\u0015\u0005\u0007/\u0002\u0001\u000b\u0011B)\t\u000fa\u0003!\u0019!C\u00013\"1!\r\u0001Q\u0001\niCQa\u0019\u0001\u0005B\u0011DQa\u001e\u0001\u0005BaDa!a\u0002\u0001\t\u0003A(AF\"p]R\u0014x\u000e\u001c7fe\u001a\u000b\u0017\u000e\\8wKJ$Vm\u001d;\u000b\u0005U1\u0012AC2p]R\u0014x\u000e\u001c7fe*\tq#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001Q\u0002\u0005\u0005\u0002\u001c=5\tAD\u0003\u0002\u001e-\u0005Y\u0011N\u001c;fOJ\fG/[8o\u0013\tyBD\u0001\fLC\u001a\\\u0017mU3sm\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t!\t\tC%D\u0001#\u0015\t\u0019c#A\u0003vi&d7/\u0003\u0002&E\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001)!\tI\u0003!D\u0001\u0015\u0003\rawnZ\u000b\u0002YA\u0011Q\u0006N\u0007\u0002])\u0011q\u0006M\u0001\u0006Y><GG\u001b\u0006\u0003cI\na!\u00199bG\",'\"A\u001a\u0002\u0007=\u0014x-\u0003\u00026]\t1Aj\\4hKJ\fA\u0001\\8hA\u0005Aa.^7O_\u0012,7/F\u0001:!\tQT(D\u0001<\u0015\u0005a\u0014!B:dC2\f\u0017B\u0001 <\u0005\rIe\u000e^\u0001\n]Vlgj\u001c3fg\u0002\n\u0001B\\;n!\u0006\u0014Ho]\u0001\n]Vl\u0007+\u0019:ug\u0002\nA\"\\:h#V,W/Z*ju\u0016\fQ\"\\:h#V,W/Z*ju\u0016\u0004\u0013!\u0002;pa&\u001cW#\u0001$\u0011\u0005\u001dcU\"\u0001%\u000b\u0005%S\u0015\u0001\u00027b]\u001eT\u0011aS\u0001\u0005U\u00064\u0018-\u0003\u0002N\u0011\n11\u000b\u001e:j]\u001e\fa\u0001^8qS\u000e\u0004\u0013aD8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:\u0016\u0003E\u0003\"AU+\u000e\u0003MS!\u0001\u0016&\u0002\tU$\u0018\u000e\\\u0005\u0003-N\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0003Ayg/\u001a:sS\u0012Lgn\u001a)s_B\u001c\b%A\u0004nKR\u0014\u0018nY:\u0016\u0003i\u0003\"a\u00171\u000e\u0003qS!\u0001W/\u000b\u0005y{\u0016AB2p[6|gN\u0003\u0002\u0018a%\u0011\u0011\r\u0018\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0016\u0003\u0015\u00042A\u001a8r\u001d\t9GN\u0004\u0002iW6\t\u0011N\u0003\u0002k1\u00051AH]8pizJ\u0011\u0001P\u0005\u0003[n\nq\u0001]1dW\u0006<W-\u0003\u0002pa\n\u00191+Z9\u000b\u00055\\\u0004C\u0001:v\u001b\u0005\u0019(B\u0001;\u0017\u0003\u0019\u0019XM\u001d<fe&\u0011ao\u001d\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u0005uK\u0006\u0014Hi\\<o)\u0005I\bC\u0001\u001e{\u0013\tY8H\u0001\u0003V]&$\bFA\t~!\rq\u00181A\u0007\u0002\u007f*\u0019\u0011\u0011\u0001\u001a\u0002\u000b),h.\u001b;\n\u0007\u0005\u0015qPA\u0003BMR,'/A\u0010uKN$\b*\u00198eY\u0016LE\u000e\\3hC2\u001cF/\u0019;f\u000bb\u001cW\r\u001d;j_:D3AEA\u0006!\rq\u0018QB\u0005\u0004\u0003\u001fy(\u0001\u0002+fgR\u0004")
public class ControllerFailoverTest
extends KafkaServerTestHarness {
    private final Logger log = Logger.getLogger(ControllerFailoverTest.class);
    private final int numNodes;
    private final int numParts;
    private final int msgQueueSize;
    private final String topic;
    private final Properties overridingProps = new Properties();
    private final Metrics metrics = new Metrics();

    public Logger log() {
        return this.log;
    }

    public int numNodes() {
        return this.numNodes;
    }

    public int numParts() {
        return this.numParts;
    }

    public int msgQueueSize() {
        return this.msgQueueSize;
    }

    public String topic() {
        return this.topic;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numNodes(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.metrics().close();
    }

    @Test
    public void testHandleIllegalStateException() {
        KafkaController initialController = (KafkaController)this.servers().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ControllerFailoverTest.$anonfun$testHandleIllegalStateException$1(x$2))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.kafkaController()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fail("Could not find controller", new Position("ControllerFailoverTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58)));
        int initialEpoch = initialController.epoch();
        this.createTopic(this.topic(), 1, 1, this.createTopic$default$4());
        TopicPartition topicPartition = new TopicPartition("topic1", 0);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> initialController.partitionStateMachine().partitionsInState((PartitionState)OnlinePartition$.MODULE$).contains((Object)topicPartition), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Partition ").append(topicPartition).append(" did not transition to online state").toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        CountDownLatch latch = new CountDownLatch(1);
        VolatileObjectRef exceptionThrown = VolatileObjectRef.create((Object)None$.MODULE$);
        ControllerEvent illegalStateEvent = ControllerTestUtils$.MODULE$.createMockControllerEvent((ControllerState)ControllerState.BrokerChange$.MODULE$, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try {
                throw initialController.handleIllegalState(new IllegalStateException("Thrown for test purposes"));
            }
            catch (Throwable t) {
                exceptionThrown$1.elem = new Some((Object)t);
                latch.await();
                return;
            }
        });
        initialController.eventManager().put(illegalStateEvent);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !initialController.kafkaScheduler().isStarted(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Scheduler was not shutdown", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !initialController.isActive(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Controller did not become inactive", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        latch.countDown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((Option)exceptionThrown$1.elem).isDefined(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "handleIllegalState did not throw an exception", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertTrue((String)new StringBuilder(73).append("handleIllegalState should throw an IllegalStateException, but ").append((Option)exceptionThrown.elem).append(" was thrown").toString(), (boolean)(((Option)exceptionThrown.elem).get() instanceof IllegalStateException));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.servers().exists((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)ControllerFailoverTest.$anonfun$testHandleIllegalStateException$14(initialEpoch, server))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to find controller", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    public static final /* synthetic */ boolean $anonfun$testHandleIllegalStateException$1(KafkaServer x$2) {
        return x$2.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testHandleIllegalStateException$14(int initialEpoch$1, KafkaServer server) {
        return server.kafkaController().isActive() && server.kafkaController().epoch() > initialEpoch$1;
    }

    public ControllerFailoverTest() {
        this.numNodes = 2;
        this.numParts = 1;
        this.msgQueueSize = 1;
        this.topic = "topic1";
        this.overridingProps().put(KafkaConfig$.MODULE$.NumPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.numParts())).toString());
    }
}

