/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_0_10_2_IV0$;
import kafka.api.Request$;
import kafka.cluster.Partition;
import kafka.cluster.Partition$;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.common.UnexpectedAppendOffsetException;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.DelayedOperationKey;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.LogReadResult$;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.TopicPartitionOperationKey;
import kafka.utils.CoreUtils$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.OffsetNotAvailableException;
import org.apache.kafka.common.errors.ReplicaNotAvailableException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\tuf\u0001B A\u0001\u0015CQ\u0001\u0014\u0001\u0005\u00025Cq\u0001\u0015\u0001C\u0002\u0013\u0005\u0011\u000b\u0003\u0004V\u0001\u0001\u0006IA\u0015\u0005\b-\u0002\u0011\r\u0011\"\u0001X\u0011\u0019\u0019\u0007\u0001)A\u00051\"9A\r\u0001b\u0001\n\u0003)\u0007B\u00027\u0001A\u0003%a\rC\u0004n\u0001\t\u0007I\u0011\u00018\t\rU\u0004\u0001\u0015!\u0003p\u0011\u001d1\bA1A\u0005\u0002]Da! \u0001!\u0002\u0013A\b\"\u0003@\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0000\u0011-\t\t\u0002\u0001a\u0001\u0002\u0004%\t!a\u0005\t\u0017\u0005}\u0001\u00011A\u0001B\u0003&\u0011\u0011\u0001\u0005\u000b\u0003C\u0001\u0001\u0019!a\u0001\n\u0003y\bbCA\u0012\u0001\u0001\u0007\t\u0019!C\u0001\u0003KA1\"!\u000b\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0002!Q\u00111\u0006\u0001A\u0002\u0003\u0007I\u0011A@\t\u0017\u00055\u0002\u00011AA\u0002\u0013\u0005\u0011q\u0006\u0005\f\u0003g\u0001\u0001\u0019!A!B\u0013\t\t\u0001C\u0006\u00026\u0001\u0001\r\u00111A\u0005\u0002\u0005]\u0002bCA \u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0003B1\"!\u0012\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002:!Y\u0011q\t\u0001A\u0002\u0003\u0007I\u0011AA%\u0011-\t9\u0006\u0001a\u0001\u0002\u0004%\t!!\u0017\t\u0017\u0005u\u0003\u00011A\u0001B\u0003&\u00111\n\u0005\f\u0003?\u0002\u0001\u0019!a\u0001\n\u0003\t\t\u0007C\u0006\u0002j\u0001\u0001\r\u00111A\u0005\u0002\u0005-\u0004bCA8\u0001\u0001\u0007\t\u0011)Q\u0005\u0003GB1\"!\u001d\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002t!Y\u0011\u0011\u0013\u0001A\u0002\u0003\u0007I\u0011AAJ\u0011-\t9\n\u0001a\u0001\u0002\u0003\u0006K!!\u001e\t\u000f\u0005e\u0005\u0001\"\u0001\u0002\u001c\"9\u00111\u0016\u0001\u0005\n\u00055\u0006bBAk\u0001\u0011\u0005\u00111\u0014\u0005\b\u0003?\u0004A\u0011AAN\u0011\u001d\tI\u000f\u0001C\u0001\u00037Cq!!<\u0001\t\u0003\tY\nC\u0004\u0002r\u0002!\t!a'\t\u000f\u0005U\b\u0001\"\u0001\u0002\u001c\"9\u0011\u0011 \u0001\u0005\u0002\u0005m\u0005bBA\u007f\u0001\u0011\u0005\u00111\u0014\u0005\b\u0005\u0003\u0001A\u0011AAN\u0011\u001d\u0011)\u0001\u0001C\u0001\u00037CqA!\u0003\u0001\t\u0003\tY\nC\u0004\u0003\u000e\u0001!\t!a'\t\u000f\tE\u0001\u0001\"\u0001\u0002\u001c\"9!Q\u0003\u0001\u0005\u0002\u0005m\u0005b\u0002B\r\u0001\u0011\u0005\u00111\u0014\u0005\b\u0005;\u0001A\u0011\u0002B\u0010\u0011%\u0011i\u0004AI\u0001\n\u0013\u0011y\u0004C\u0004\u0003V\u0001!\t!a'\t\u000f\te\u0003\u0001\"\u0001\u0002\u001c\"9!Q\f\u0001\u0005\u0002\u0005m\u0005b\u0002B1\u0001\u0011\u0005\u00111\u0014\u0005\b\u0005K\u0002A\u0011AAN\u0011\u001d\u0011I\u0007\u0001C\u0001\u00037CqA!\u001c\u0001\t\u0003\tY\nC\u0004\u0003r\u0001!\tAa\u001d\t\u0013\t-\u0006!%A\u0005\u0002\t5\u0006b\u0002BY\u0001\u0011\u0005!1\u0017\u0005\n\u0005w\u0003\u0011\u0013!C\u0001\u0005[\u0013Q\u0002U1si&$\u0018n\u001c8UKN$(BA!C\u0003\u001d\u0019G.^:uKJT\u0011aQ\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\t\u0005\u0002H\u00156\t\u0001JC\u0001J\u0003\u0015\u00198-\u00197b\u0013\tY\u0005J\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00039\u0003\"a\u0014\u0001\u000e\u0003\u0001\u000b\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u000b\u0002%B\u0011qiU\u0005\u0003)\"\u00131!\u00138u\u0003%\u0011'o\\6fe&#\u0007%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0003a\u0003\"!W1\u000e\u0003iS!a\u0017/\u0002\r\r|W.\\8o\u0015\t\u0019UL\u0003\u0002_?\u00061\u0011\r]1dQ\u0016T\u0011\u0001Y\u0001\u0004_J<\u0017B\u00012[\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u0005i&lW-F\u0001g!\t9'.D\u0001i\u0015\tI')A\u0003vi&d7/\u0003\u0002lQ\nAQj\\2l)&lW-A\u0003uS6,\u0007%\u0001\tce>\\WM\u001d+pa&\u001c7\u000b^1ugV\tq\u000e\u0005\u0002qg6\t\u0011O\u0003\u0002s\u0005\u000611/\u001a:wKJL!\u0001^9\u0003!\t\u0013xn[3s)>\u0004\u0018nY*uCR\u001c\u0018!\u00052s_.,'\u000fV8qS\u000e\u001cF/\u0019;tA\u00059Q.\u001a;sS\u000e\u001cX#\u0001=\u0011\u0005e\\X\"\u0001>\u000b\u0005YT\u0016B\u0001?{\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\u0007i6\u0004H)\u001b:\u0016\u0005\u0005\u0005\u0001\u0003BA\u0002\u0003\u001bi!!!\u0002\u000b\t\u0005\u001d\u0011\u0011B\u0001\u0003S>T!!a\u0003\u0002\t)\fg/Y\u0005\u0005\u0003\u001f\t)A\u0001\u0003GS2,\u0017A\u0003;na\u0012K'o\u0018\u0013fcR!\u0011QCA\u000e!\r9\u0015qC\u0005\u0004\u00033A%\u0001B+oSRD\u0011\"!\b\u000e\u0003\u0003\u0005\r!!\u0001\u0002\u0007a$\u0013'A\u0004u[B$\u0015N\u001d\u0011\u0002\u000f1|w\rR5sc\u0005YAn\\4ESJ\ft\fJ3r)\u0011\t)\"a\n\t\u0013\u0005u\u0001#!AA\u0002\u0005\u0005\u0011\u0001\u00037pO\u0012K'/\r\u0011\u0002\u000f1|w\rR5se\u0005YAn\\4ESJ\u0014t\fJ3r)\u0011\t)\"!\r\t\u0013\u0005u1#!AA\u0002\u0005\u0005\u0011\u0001\u00037pO\u0012K'O\r\u0011\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\u0011\u0011\u0011\b\t\u0004a\u0006m\u0012bAA\u001fc\nq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018A\u0005:fa2L7-Y'b]\u0006<WM]0%KF$B!!\u0006\u0002D!I\u0011Q\u0004\f\u0002\u0002\u0003\u0007\u0011\u0011H\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA\u0005QAn\\4NC:\fw-\u001a:\u0016\u0005\u0005-\u0003\u0003BA'\u0003'j!!a\u0014\u000b\u0007\u0005E#)A\u0002m_\u001eLA!!\u0016\u0002P\tQAj\\4NC:\fw-\u001a:\u0002\u001d1|w-T1oC\u001e,'o\u0018\u0013fcR!\u0011QCA.\u0011%\ti\"GA\u0001\u0002\u0004\tY%A\u0006m_\u001el\u0015M\\1hKJ\u0004\u0013!\u00037pO\u000e{gNZ5h+\t\t\u0019\u0007\u0005\u0003\u0002N\u0005\u0015\u0014\u0002BA4\u0003\u001f\u0012\u0011\u0002T8h\u0007>tg-[4\u0002\u001b1|wmQ8oM&<w\fJ3r)\u0011\t)\"!\u001c\t\u0013\u0005uA$!AA\u0002\u0005\r\u0014A\u00037pO\u000e{gNZ5hA\u0005i\u0011/^8uC6\u000bg.Y4feN,\"!!\u001e\u0011\t\u0005]\u00141\u0012\b\u0005\u0003s\n9I\u0004\u0003\u0002|\u0005\u0015e\u0002BA?\u0003\u0007k!!a \u000b\u0007\u0005\u0005E)\u0001\u0004=e>|GOP\u0005\u0002\u0007&\u0011!OQ\u0005\u0004\u0003\u0013\u000b\u0018\u0001D)v_R\fg)Y2u_JL\u0018\u0002BAG\u0003\u001f\u0013Q\"U;pi\u0006l\u0015M\\1hKJ\u001c(bAAEc\u0006\t\u0012/^8uC6\u000bg.Y4feN|F%Z9\u0015\t\u0005U\u0011Q\u0013\u0005\n\u0003;y\u0012\u0011!a\u0001\u0003k\na\"];pi\u0006l\u0015M\\1hKJ\u001c\b%A\u0003tKR,\b\u000f\u0006\u0002\u0002\u0016!\u001a\u0011%a(\u0011\t\u0005\u0005\u0016qU\u0007\u0003\u0003GS1!!*`\u0003\u0015QWO\\5u\u0013\u0011\tI+a)\u0003\r\t+gm\u001c:f\u0003M\u0019'/Z1uK2{w\r\u0015:pa\u0016\u0014H/[3t)\u0011\ty+a/\u0011\t\u0005E\u0016qW\u0007\u0003\u0003gSA!!.\u0002\n\u0005!Q\u000f^5m\u0013\u0011\tI,a-\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0004\u0002>\n\u0002\r!a0\u0002\u0013=4XM\u001d:jI\u0016\u001c\b\u0003CAa\u0003\u0013\fy-a4\u000f\t\u0005\r\u0017Q\u0019\t\u0004\u0003{B\u0015bAAd\u0011\u00061\u0001K]3eK\u001aLA!a3\u0002N\n\u0019Q*\u00199\u000b\u0007\u0005\u001d\u0007\n\u0005\u0003\u0002B\u0006E\u0017\u0002BAj\u0003\u001b\u0014aa\u0015;sS:<\u0017\u0001\u0003;fCJ$un\u001e8)\u0007\r\nI\u000e\u0005\u0003\u0002\"\u0006m\u0017\u0002BAo\u0003G\u0013Q!\u00114uKJ\fq\u0004^3ti6\u000b7.\u001a'fC\u0012,'/\u00169eCR,7/\u00129pG\"\u001c\u0015m\u00195fQ\r!\u00131\u001d\t\u0005\u0003C\u000b)/\u0003\u0003\u0002h\u0006\r&\u0001\u0002+fgR\f!\u0007^3ti6\u000b7.\u001a'fC\u0012,'\u000fR8fg:{G/\u00169eCR,W\t]8dQ\u000e\u000b7\r[3G_J|E\u000e\u001a$pe6\fGo\u001d\u0015\u0004K\u0005\r\u0018\u0001\u000b;fgRl\u0015-\u001f2f%\u0016\u0004H.Y2f\u0007V\u0014(/\u001a8u/&$\bNR;ukJ,'+\u001a9mS\u000e\f\u0007f\u0001\u0014\u0002d\u0006aD/Z:u\u001b\u0006L(-\u001a*fa2\f7-Z\"veJ,g\u000e^,ji\"4U\u000f^;sKJ+\u0007\u000f\\5dC\u0012KgMZ3sK:$()Y:f\u001f\u001a47/\u001a;tQ\r9\u00131]\u00010i\u0016\u001cHOR3uG\"|eMZ:fiNs\u0017\r]:i_R,\u0005o\\2i-\u0006d\u0017\u000eZ1uS>tgi\u001c:MK\u0006$WM\u001d\u0015\u0004Q\u0005\r\u0018!\r;fgR4U\r^2i\u001f\u001a47/\u001a;T]\u0006\u00048\u000f[8u\u000bB|7\r\u001b,bY&$\u0017\r^5p]\u001a{'OR8mY><XM\u001d\u0015\u0004S\u0005\r\u0018a\u000b;fgR|eMZ:fi\u001a{'\u000fT3bI\u0016\u0014X\t]8dQZ\u000bG.\u001b3bi&|gNR8s\u0019\u0016\fG-\u001a:)\u0007)\n\u0019/A\u0017uKN$xJ\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"4\u0016\r\\5eCRLwN\u001c$pe\u001a{G\u000e\\8xKJD3aKAr\u0003\u0019\"Xm\u001d;SK\u0006$'+Z2pe\u0012,\u0005o\\2i-\u0006d\u0017\u000eZ1uS>tgi\u001c:MK\u0006$WM\u001d\u0015\u0004Y\u0005\r\u0018\u0001\u000b;fgR\u0014V-\u00193SK\u000e|'\u000fZ#q_\u000eDg+\u00197jI\u0006$\u0018n\u001c8G_J4u\u000e\u001c7po\u0016\u0014\bfA\u0017\u0002d\u0006\u0019D/Z:u\r\u0016$8\r[(gMN,GOR8s)&lWm\u001d;b[B,\u0005o\\2i-\u0006d\u0017\u000eZ1uS>tgi\u001c:MK\u0006$WM\u001d\u0015\u0004]\u0005\r\u0018!\u000e;fgR4U\r^2i\u001f\u001a47/\u001a;G_J$\u0016.\\3ti\u0006l\u0007/\u00129pG\"4\u0016\r\\5eCRLwN\u001c$pe\u001a{G\u000e\\8xKJD3aLAr\u0003!\"Xm\u001d;GKR\u001c\u0007\u000eT1uKN$xJ\u001a4tKRLen\u00197vI\u0016\u001cH*Z1eKJ,\u0005o\\2iQ\r\u0001\u00141]\u0001&i\u0016\u001cH/T8o_R|g.[2PM\u001a\u001cX\r^:BMR,'\u000fT3bI\u0016\u00148\t[1oO\u0016D3!MAr\u0003]\u0019X\r^;q!\u0006\u0014H/\u001b;j_:<\u0016\u000e\u001e5N_\u000e\\7\u000f\u0006\u0005\u0003\"\t\u001d\"1\u0006B\u001b!\ry%1E\u0005\u0004\u0005K\u0001%!\u0003)beRLG/[8o\u0011\u0019\u0011IC\ra\u0001%\u0006YA.Z1eKJ,\u0005o\\2i\u0011\u001d\u0011iC\ra\u0001\u0005_\t\u0001\"[:MK\u0006$WM\u001d\t\u0004\u000f\nE\u0012b\u0001B\u001a\u0011\n9!i\\8mK\u0006t\u0007\"CA)eA\u0005\t\u0019\u0001B\u001c!\u0011\tiE!\u000f\n\t\tm\u0012q\n\u0002\u0004\u0019><\u0017!I:fiV\u0004\b+\u0019:uSRLwN\\,ji\"lunY6tI\u0011,g-Y;mi\u0012\u001aTC\u0001B!U\u0011\u00119Da\u0011,\u0005\t\u0015\u0003\u0003\u0002B$\u0005#j!A!\u0013\u000b\t\t-#QJ\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0014I\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005'\u0012IEA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fa\u0006^3ti\u0006\u0003\b/\u001a8e%\u0016\u001cwN\u001d3t\u0003N4u\u000e\u001c7po\u0016\u0014()\u001a7po2{wm\u0015;beR|eMZ:fi\"\u001aA'a9\u0002;Q,7\u000f\u001e'jgR|eMZ:fi&\u001bx\u000e\\1uS>tG*\u001a<fYND3!NAr\u00039!Xm\u001d;HKR\u0014V\r\u001d7jG\u0006D3ANAr\u0003]\"Xm\u001d;BaB,g\u000e\u001a*fG>\u0014Hm\u001d+p\r>dGn\\<fe^KG\u000f\u001b(p%\u0016\u0004H.[2b)\"\u0014xn^:Fq\u000e,\u0007\u000f^5p]\"\u001aq'a9\u0002IQ,7\u000f^'bW\u00164u\u000e\u001c7po\u0016\u0014x+\u001b;i\u001d>dU-\u00193fe&#7\t[1oO\u0016D3\u0001OAr\u0003\u001d#Xm\u001d;G_2dwn^3s\t>,7OT8u\u0015>Lg.S*S+:$\u0018\u000e\\\"bk\u001eDG/\u00169U_>3gm]3u/&$\b.\u001b8DkJ\u0014XM\u001c;MK\u0006$WM]#q_\u000eD\u0007fA\u001d\u0002d\u0006\u0011C/Z:u\t\u0016d\u0017-_3e\r\u0016$8\r[!gi\u0016\u0014\u0018\t\u001d9f]\u0012\u0014VmY8sIND3AOAr\u00035\u0019'/Z1uKJ+7m\u001c:egRA!Q\u000fBA\u0005;\u00139\u000b\u0005\u0003\u0003x\tuTB\u0001B=\u0015\r\u0011YHW\u0001\u0007e\u0016\u001cwN\u001d3\n\t\t}$\u0011\u0010\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\u000f\t\r5\b1\u0001\u0003\u0006\u00069!/Z2pe\u0012\u001c\bC\u0002BD\u0005#\u00139J\u0004\u0003\u0003\n\n5e\u0002BA?\u0005\u0017K\u0011!S\u0005\u0004\u0005\u001fC\u0015a\u00029bG.\fw-Z\u0005\u0005\u0005'\u0013)J\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\u0011y\t\u0013\t\u0005\u0005o\u0012I*\u0003\u0003\u0003\u001c\ne$\u0001D*j[BdWMU3d_J$\u0007b\u0002BPw\u0001\u0007!\u0011U\u0001\u000bE\u0006\u001cXm\u00144gg\u0016$\bcA$\u0003$&\u0019!Q\u0015%\u0003\t1{gn\u001a\u0005\t\u0005S[\u0004\u0013!a\u0001%\u0006!\u0002/\u0019:uSRLwN\u001c'fC\u0012,'/\u00129pG\"\fqc\u0019:fCR,'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t=&f\u0001*\u0003D\u0005Q2M]3bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8bYJ+7m\u001c:egRA!Q\u000fB[\u0005o\u0013I\fC\u0004\u0003\u0004v\u0002\rA!\"\t\u000f\t}U\b1\u0001\u0003\"\"A!\u0011V\u001f\u0011\u0002\u0003\u0007!+\u0001\u0013de\u0016\fG/\u001a+sC:\u001c\u0018m\u0019;j_:\fGNU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0001")
public class PartitionTest {
    private final int brokerId;
    private final TopicPartition topicPartition = new TopicPartition("test-topic", 0);
    private final MockTime time = new MockTime();
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final Metrics metrics = new Metrics();
    private File tmpDir;
    private File logDir1;
    private File logDir2;
    private ReplicaManager replicaManager;
    private LogManager logManager;
    private LogConfig logConfig;
    private QuotaFactory.QuotaManagers quotaManagers;

    public int brokerId() {
        return this.brokerId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public MockTime time() {
        return this.time;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public File logDir1() {
        return this.logDir1;
    }

    public void logDir1_$eq(File x$1) {
        this.logDir1 = x$1;
    }

    public File logDir2() {
        return this.logDir2;
    }

    public void logDir2_$eq(File x$1) {
        this.logDir2 = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public void logConfig_$eq(LogConfig x$1) {
        this.logConfig = x$1;
    }

    public QuotaFactory.QuotaManagers quotaManagers() {
        return this.quotaManagers;
    }

    public void quotaManagers_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManagers = x$1;
    }

    @Before
    public void setup() {
        Properties logProps = this.createLogProperties((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        this.logConfig_$eq(new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2()));
        this.tmpDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logDir1_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        this.logDir2_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        boolean x$12 = false;
        int x$2 = CleanerConfig$.MODULE$.apply$default$1();
        long x$3 = CleanerConfig$.MODULE$.apply$default$2();
        double x$4 = CleanerConfig$.MODULE$.apply$default$3();
        int x$5 = CleanerConfig$.MODULE$.apply$default$4();
        int x$6 = CleanerConfig$.MODULE$.apply$default$5();
        double x$7 = CleanerConfig$.MODULE$.apply$default$6();
        long x$8 = CleanerConfig$.MODULE$.apply$default$7();
        String x$9 = CleanerConfig$.MODULE$.apply$default$9();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir1(), this.logDir2()}))), this.logConfig(), new CleanerConfig(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$12, x$9), this.time()));
        this.logManager().startup();
        Properties brokerProps = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        brokerProps.put(KafkaConfig$.MODULE$.LogDirsProp(), ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir1(), this.logDir2()}))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getAbsolutePath(), Seq$.MODULE$.canBuildFrom())).mkString(","));
        KafkaConfig brokerConfig = KafkaConfig$.MODULE$.fromProps(brokerProps);
        KafkaZkClient kafkaZkClient = (KafkaZkClient)EasyMock.createMock(KafkaZkClient.class);
        this.quotaManagers_$eq(QuotaFactory$.MODULE$.instantiate(brokerConfig, this.metrics(), (Time)this.time(), ""));
        this.replicaManager_$eq(new ReplicaManager(brokerConfig, this.metrics(), (Time)this.time(), kafkaZkClient, (Scheduler)new MockScheduler((Time)this.time()), this.logManager(), new AtomicBoolean(false), this.quotaManagers(), this.brokerTopicStats(), new MetadataCache(this.brokerId()), new LogDirFailureChannel(brokerConfig.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12()));
        EasyMock.expect((Object)kafkaZkClient.getEntityConfigs(EasyMock.anyString(), EasyMock.anyString())).andReturn((Object)logProps).anyTimes();
        EasyMock.expect((Object)kafkaZkClient.conditionalUpdatePath((String)EasyMock.anyObject(), (byte[])EasyMock.anyObject(), BoxesRunTime.unboxToInt((Object)EasyMock.anyObject()), (Option)EasyMock.anyObject())).andReturn((Object)new Tuple2.mcZI.sp(true, 0)).anyTimes();
        EasyMock.replay((Object[])new Object[]{kafkaZkClient});
    }

    /*
     * WARNING - void declaration
     */
    private Properties createLogProperties(scala.collection.immutable.Map<String, String> overrides) {
        void var2_2;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(512));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(999));
        overrides.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Object object = logProps.put(k, v);
            return object;
        });
        return var2_2;
    }

    @After
    public void tearDown() {
        this.brokerTopicStats().close();
        this.metrics().close();
        this.logManager().shutdown();
        Utils.delete((File)this.tmpDir());
        this.logManager().liveLogDirs().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            PartitionTest.$anonfun$tearDown$1(x$1);
            return BoxedUnit.UNIT;
        });
        this.replicaManager().shutdown(false);
        this.quotaManagers().shutdown();
    }

    @Test
    public void testMakeLeaderUpdatesEpochCache() {
        int leaderEpoch = 8;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        LogConfig x$22 = this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, x$22, x$3, x$4);
        log.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())}), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(5), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v3".getBytes()), new SimpleRecord("k4".getBytes(), "v4".getBytes())}), 5, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        Assert.assertEquals((long)4L, (long)log.logEndOffset());
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, log);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)4)), (Object)partition.leaderReplicaIfLocal().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.logEndOffset())));
        EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), leaderEpoch, true);
        Assert.assertEquals((long)4L, (long)epochEndOffset.endOffset());
        Assert.assertEquals((long)leaderEpoch, (long)epochEndOffset.leaderEpoch());
    }

    @Test
    public void testMakeLeaderDoesNotUpdateEpochCacheForOldFormats() {
        int leaderEpoch = 8;
        LogConfig logConfig = new LogConfig((Map)this.createLogProperties((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageFormatVersionProp()), (Object)KAFKA_0_10_2_IV0$.MODULE$.shortVersion())})))), LogConfig$.MODULE$.apply$default$2());
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        LogConfig x$2 = logConfig;
        boolean x$32 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$32, x$4);
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), RecordVersion.V1.value, TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k4".getBytes(), "v4".getBytes()), (List)Nil$.MODULE$)), RecordVersion.V1.value, TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), 5, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        Assert.assertEquals((long)4L, (long)log.logEndOffset());
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, log);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)4)), (Object)partition.leaderReplicaIfLocal().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.logEndOffset())));
        Assert.assertEquals((Object)None$.MODULE$, (Object)log.latestEpoch());
        EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), leaderEpoch, true);
        Assert.assertEquals((long)-1L, (long)epochEndOffset.endOffset());
        Assert.assertEquals((long)-1L, (long)epochEndOffset.leaderEpoch());
    }

    @Test
    public void testMaybeReplaceCurrentWithFutureReplica() {
        CountDownLatch latch = new CountDownLatch(1);
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir1().getAbsolutePath());
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        LogConfig x$2 = this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log1 = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir2().getAbsolutePath());
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = this.topicPartition();
        LogConfig x$6 = this.logConfig();
        boolean x$7 = true;
        boolean x$8 = qual$2.getOrCreateLog$default$3();
        Log log2 = qual$2.getOrCreateLog(x$5, x$6, x$8, x$7);
        int x$9 = this.brokerId();
        TopicPartition x$10 = this.topicPartition();
        MockTime x$11 = this.time();
        Some x$12 = new Some((Object)log1);
        long x$13 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica currentReplica = new Replica(x$9, x$10, (Time)x$11, x$13, (Option)x$12);
        int x$14 = Request$.MODULE$.FutureLocalReplicaId();
        TopicPartition x$15 = this.topicPartition();
        MockTime x$16 = this.time();
        Some x$17 = new Some((Object)log2);
        long x$18 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica futureReplica = new Replica(x$14, x$15, (Time)x$16, x$18, (Option)x$17);
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        partition.addReplicaIfNotExists(futureReplica);
        partition.addReplicaIfNotExists(currentReplica);
        Assert.assertEquals((Object)new Some((Object)currentReplica), (Object)partition.localReplica());
        Assert.assertEquals((Object)new Some((Object)futureReplica), (Object)partition.futureLocalReplica());
        Thread thread1 = new Thread(null, latch, partition){
            private final CountDownLatch latch$1;
            private final Partition partition$1;

            public void run() {
                this.latch$1.await();
                this.partition$1.removeFutureLocalReplica(this.partition$1.removeFutureLocalReplica$default$1());
            }
            {
                this.latch$1 = latch$1;
                this.partition$1 = partition$1;
            }
        };
        Thread thread2 = new Thread(null, latch, partition){
            private final CountDownLatch latch$1;
            private final Partition partition$1;

            public void run() {
                this.latch$1.await();
                this.partition$1.maybeReplaceCurrentWithFutureReplica();
            }
            {
                this.latch$1 = latch$1;
                this.partition$1 = partition$1;
            }
        };
        thread1.start();
        thread2.start();
        latch.countDown();
        thread1.join();
        thread2.join();
        Assert.assertEquals((Object)None$.MODULE$, (Object)partition.futureLocalReplica());
    }

    @Test
    public void testMaybeReplaceCurrentWithFutureReplicaDifferentBaseOffsets() {
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir1().getAbsolutePath());
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        LogConfig x$2 = this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log1 = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        log1.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k1".getBytes(), "v2".getBytes()), new SimpleRecord("k1".getBytes(), "v3".getBytes()), new SimpleRecord("k2".getBytes(), "v4".getBytes()), new SimpleRecord("k2".getBytes(), "v5".getBytes()), new SimpleRecord("k2".getBytes(), "v6".getBytes())}), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4());
        log1.roll(log1.roll$default$1());
        log1.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v7".getBytes()), new SimpleRecord("k4".getBytes(), "v8".getBytes())}), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4());
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir2().getAbsolutePath());
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = this.topicPartition();
        LogConfig x$6 = this.logConfig();
        boolean x$7 = true;
        boolean x$8 = qual$2.getOrCreateLog$default$3();
        Log log2 = qual$2.getOrCreateLog(x$5, x$6, x$8, x$7);
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L, (long)-1L, (int)0);
        builder.appendWithOffset(2L, new SimpleRecord("k1".getBytes(), "v3".getBytes()));
        builder.appendWithOffset(5L, new SimpleRecord("k2".getBytes(), "v6".getBytes()));
        builder.appendWithOffset(6L, new SimpleRecord("k3".getBytes(), "v7".getBytes()));
        builder.appendWithOffset(7L, new SimpleRecord("k4".getBytes(), "v8".getBytes()));
        log2.appendAsFollower(builder.build());
        int x$9 = this.brokerId();
        TopicPartition x$10 = this.topicPartition();
        MockTime x$11 = this.time();
        Some x$12 = new Some((Object)log1);
        long x$13 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica currentReplica = new Replica(x$9, x$10, (Time)x$11, x$13, (Option)x$12);
        int x$14 = Request$.MODULE$.FutureLocalReplicaId();
        TopicPartition x$15 = this.topicPartition();
        MockTime x$16 = this.time();
        Some x$17 = new Some((Object)log2);
        long x$18 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica futureReplica = new Replica(x$14, x$15, (Time)x$16, x$18, (Option)x$17);
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        partition.addReplicaIfNotExists(futureReplica);
        partition.addReplicaIfNotExists(currentReplica);
        Assert.assertEquals((Object)new Some((Object)currentReplica), (Object)partition.localReplica());
        Assert.assertEquals((Object)new Some((Object)futureReplica), (Object)partition.futureLocalReplica());
        Assert.assertTrue((boolean)partition.maybeReplaceCurrentWithFutureReplica());
    }

    @Test
    public void testFetchOffsetSnapshotEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertSnapshotError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertSnapshotError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
        PartitionTest.assertSnapshotError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertSnapshotError$1(Errors.NONE, Optional.empty(), partition);
    }

    @Test
    public void testFetchOffsetSnapshotEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertSnapshotError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertSnapshotError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.empty(), true, partition);
        PartitionTest.assertSnapshotError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertSnapshotError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testOffsetForLeaderEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.NONE, Optional.empty(), partition);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testOffsetForLeaderEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.empty(), true, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testReadRecordEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertReadRecordsError$1(Errors.NONE, Optional.empty(), partition);
        PartitionTest.assertReadRecordsError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertReadRecordsError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertReadRecordsError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testReadRecordEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertReadRecordsError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.empty(), true, partition);
        PartitionTest.assertReadRecordsError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertReadRecordsError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertReadRecordsError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testFetchOffsetForTimestampEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertFetchOffsetError$1(Errors.NONE, Optional.empty(), partition);
        PartitionTest.assertFetchOffsetError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertFetchOffsetError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertFetchOffsetError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testFetchOffsetForTimestampEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertFetchOffsetError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.empty(), true, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testFetchLatestOffsetIncludesLeaderEpoch() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        Option timestampAndOffsetOpt = partition.fetchOffsetForTimestamp(-1L, (Option)None$.MODULE$, Optional.empty(), true);
        Assert.assertTrue((boolean)timestampAndOffsetOpt.isDefined());
        FileRecords.TimestampAndOffset timestampAndOffset = (FileRecords.TimestampAndOffset)timestampAndOffsetOpt.get();
        Assert.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)leaderEpoch)), (Object)timestampAndOffset.leaderEpoch);
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testMonotonicOffsetsAfterLeaderChange() {
        block48: {
            block49: {
                block47: {
                    block45: {
                        block46: {
                            block44: {
                                controllerEpoch = 3;
                                leader = this.brokerId();
                                follower1 = this.brokerId() + 1;
                                follower2 = this.brokerId() + 2;
                                controllerId = this.brokerId() + 3;
                                replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(leader), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower2), (List)Nil$.MODULE$)))).asJava();
                                isr = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(leader), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower2), (List)Nil$.MODULE$))).asJava();
                                leaderEpoch = 8;
                                batch1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord(10L, "k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(11L, "k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
                                batch2 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(20L, "k4".getBytes(), "v2".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(21L, "k5".getBytes(), "v3".getBytes()), (List)Nil$.MODULE$))), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
                                partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
                                Assert.assertTrue((String)"Expected first makeLeader() to return 'leader changed'", (boolean)partition.makeLeader(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, leader, leaderEpoch, isr, 1, replicas, true), 0));
                                Assert.assertEquals((String)"Current leader epoch", (long)leaderEpoch, (long)partition.getLeaderEpoch());
                                Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)})), (Object)partition.inSyncReplicas().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testMonotonicOffsetsAfterLeaderChange$1$adapted(kafka.cluster.Replica ), (Lkafka/cluster/Replica;)Ljava/lang/Object;)(), Set$.MODULE$.canBuildFrom()));
                                leaderReplica = (Replica)partition.getReplica(leader).get();
                                follower1Replica = (Replica)partition.getReplica(follower1).get();
                                follower2Replica = (Replica)partition.getReplica(follower2).get();
                                partition.appendRecordsToLeader(batch1, true, partition.appendRecordsToLeader$default$3());
                                partition.appendRecordsToLeader(batch2, true, partition.appendRecordsToLeader$default$3());
                                Assert.assertEquals((String)"Expected leader's HW not move", (long)leaderReplica.logStartOffset(), (long)leaderReplica.highWatermark().messageOffset());
                                partition.updateReplicaLogReadResult(follower1Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch1, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
                                partition.updateReplicaLogReadResult(follower1Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(2L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch2, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
                                partition.updateReplicaLogReadResult(follower2Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch1, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
                                partition.updateReplicaLogReadResult(follower2Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(2L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch2, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
                                Assert.assertEquals((long)2L, (long)((Replica)partition.localReplica().get()).highWatermark().messageOffset());
                                var23_15 = false;
                                var24_16 = null;
                                var25_17 = PartitionTest.fetchOffsetsForTimestamp$1(-1L, (Option)None$.MODULE$, partition);
                                if (!(var25_17 instanceof Right)) ** GOTO lbl-1000
                                var23_15 = true;
                                var24_16 = (Right)var25_17;
                                var26_18 = (Option)var24_16.value();
                                if (var26_18 instanceof Some) {
                                    var27_19 = (Some)var26_18;
                                    offsetAndTimestamp = (FileRecords.TimestampAndOffset)var27_19.value();
                                    Assert.assertEquals((long)5L, (long)offsetAndTimestamp.offset);
                                    var8_21 = BoxedUnit.UNIT;
                                } else if (var23_15 && None$.MODULE$.equals(var29_24 = (Option)var24_16.value())) {
                                    Assert.fail((String)"Should have seen some offsets");
                                    var8_22 = BoxedUnit.UNIT;
                                } else if (var25_17 instanceof Left) {
                                    Assert.fail((String)"Should not have seen an error");
                                    var8_23 = BoxedUnit.UNIT;
                                } else {
                                    throw new MatchError((Object)var25_17);
                                }
                                var30_25 = false;
                                var31_26 = null;
                                var32_27 = PartitionTest.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), partition);
                                if (!(var32_27 instanceof Right)) ** GOTO lbl-1000
                                var30_25 = true;
                                var31_26 = (Right)var32_27;
                                var33_28 = (Option)var31_26.value();
                                if (var33_28 instanceof Some) {
                                    var34_29 = (Some)var33_28;
                                    offsetAndTimestamp = (FileRecords.TimestampAndOffset)var34_29.value();
                                    Assert.assertEquals((long)2L, (long)offsetAndTimestamp.offset);
                                    var7_31 = BoxedUnit.UNIT;
                                } else if (var30_25 && None$.MODULE$.equals(var36_34 = (Option)var31_26.value())) {
                                    Assert.fail((String)"Should have seen some offsets");
                                    var7_32 = BoxedUnit.UNIT;
                                } else if (var32_27 instanceof Left) {
                                    Assert.fail((String)"Should not have seen an error");
                                    var7_33 = BoxedUnit.UNIT;
                                } else {
                                    throw new MatchError((Object)var32_27);
                                }
                                Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)PartitionTest.fetchOffsetsForTimestamp$1(30L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), partition));
                                Assert.assertTrue((boolean)partition.makeFollower(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, follower2, leaderEpoch + 1, isr, 1, replicas, false), 1));
                                Assert.assertTrue((boolean)partition.makeLeader(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, leader, leaderEpoch + 2, isr, 1, replicas, false), 2));
                                var37_35 = false;
                                var38_36 = null;
                                var39_37 = false;
                                var40_38 = null;
                                var41_39 = PartitionTest.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), partition);
                                if (!(var41_39 instanceof Right)) break block44;
                                var37_35 = true;
                                var38_36 = (Right)var41_39;
                                var42_40 = (Option)var38_36.value();
                                if (!(var42_40 instanceof Some)) break block44;
                                Assert.fail((String)"Should have failed with OffsetNotAvailable");
                                var6_41 = BoxedUnit.UNIT;
                                break block45;
                            }
                            if (!var37_35 || !None$.MODULE$.equals(var43_45 = (Option)var38_36.value())) break block46;
                            Assert.fail((String)"Should have seen an error");
                            var6_42 = BoxedUnit.UNIT;
                            break block45;
                        }
                        if (!(var41_39 instanceof Left)) ** GOTO lbl-1000
                        var39_37 = true;
                        var40_38 = (Left)var41_39;
                        e = (ApiException)var40_38.value();
                        if (e instanceof OffsetNotAvailableException) {
                            var6_43 = BoxedUnit.UNIT;
                        } else if (var39_37 && (e = (ApiException)var40_38.value()) != null) {
                            var46_48 = e;
                            Assert.fail((String)new StringBuilder(42).append("Expected OffsetNotAvailableException, got ").append(var46_48).toString());
                            var6_44 = BoxedUnit.UNIT;
                        } else {
                            throw new MatchError((Object)var41_39);
                        }
                    }
                    var47_49 = false;
                    var48_50 = null;
                    var49_51 = PartitionTest.fetchOffsetsForTimestamp$1(-1L, (Option)None$.MODULE$, partition);
                    if (!(var49_51 instanceof Right)) ** GOTO lbl-1000
                    var47_49 = true;
                    var48_50 = (Right)var49_51;
                    var50_52 = (Option)var48_50.value();
                    if (var50_52 instanceof Some) {
                        var51_53 = (Some)var50_52;
                        offsetAndTimestamp = (FileRecords.TimestampAndOffset)var51_53.value();
                        Assert.assertEquals((long)5L, (long)offsetAndTimestamp.offset);
                        var5_55 = BoxedUnit.UNIT;
                    } else if (var47_49 && None$.MODULE$.equals(var53_58 = (Option)var48_50.value())) {
                        Assert.fail((String)"Should have seen some offsets");
                        var5_56 = BoxedUnit.UNIT;
                    } else if (var49_51 instanceof Left && (e = (ApiException)(var54_59 = (Left)var49_51).value()) != null) {
                        var56_61 = e;
                        Assert.fail((String)new StringBuilder(17).append("Got ApiException ").append(var56_61).toString());
                        var5_57 = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)var49_51);
                    }
                    var57_62 = false;
                    var58_63 = null;
                    var59_64 = PartitionTest.fetchOffsetsForTimestamp$1(-2L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), partition);
                    if (!(var59_64 instanceof Right)) ** GOTO lbl-1000
                    var57_62 = true;
                    var58_63 = (Right)var59_64;
                    var60_65 = (Option)var58_63.value();
                    if (var60_65 instanceof Some) {
                        var61_66 = (Some)var60_65;
                        offsetAndTimestamp = (FileRecords.TimestampAndOffset)var61_66.value();
                        Assert.assertEquals((long)0L, (long)offsetAndTimestamp.offset);
                        var4_68 = BoxedUnit.UNIT;
                    } else if (var57_62 && None$.MODULE$.equals(var63_71 = (Option)var58_63.value())) {
                        Assert.fail((String)"Should have seen some offsets");
                        var4_69 = BoxedUnit.UNIT;
                    } else if (var59_64 instanceof Left && (e = (ApiException)(var64_72 = (Left)var59_64).value()) != null) {
                        var66_74 = e;
                        Assert.fail((String)new StringBuilder(17).append("Got ApiException ").append(var66_74).toString());
                        var4_70 = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)var59_64);
                    }
                    var67_75 = false;
                    var68_76 = null;
                    var69_77 = PartitionTest.fetchOffsetsForTimestamp$1(11L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), partition);
                    if (!(var69_77 instanceof Right)) ** GOTO lbl-1000
                    var67_75 = true;
                    var68_76 = (Right)var69_77;
                    var70_78 = (Option)var68_76.value();
                    if (var70_78 instanceof Some) {
                        var71_79 = (Some)var70_78;
                        offsetAndTimestamp = (FileRecords.TimestampAndOffset)var71_79.value();
                        Assert.assertEquals((long)1L, (long)offsetAndTimestamp.offset);
                        Assert.assertEquals((long)11L, (long)offsetAndTimestamp.timestamp);
                        var3_81 = BoxedUnit.UNIT;
                    } else if (var67_75 && None$.MODULE$.equals(var73_84 = (Option)var68_76.value())) {
                        Assert.fail((String)"Should have seen some offsets");
                        var3_82 = BoxedUnit.UNIT;
                    } else if (var69_77 instanceof Left && (e = (ApiException)(var74_85 = (Left)var69_77).value()) != null) {
                        var76_87 = e;
                        Assert.fail((String)new StringBuilder(17).append("Got ApiException ").append(var76_87).toString());
                        var3_83 = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)var69_77);
                    }
                    var77_88 = false;
                    var78_89 = null;
                    var79_90 = false;
                    var80_91 = null;
                    var81_92 = PartitionTest.fetchOffsetsForTimestamp$1(100L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), partition);
                    if (!(var81_92 instanceof Right)) break block47;
                    var77_88 = true;
                    var78_89 = (Right)var81_92;
                    var82_93 = (Option)var78_89.value();
                    if (!(var82_93 instanceof Some)) break block47;
                    Assert.fail((String)"Should have failed");
                    var2_94 = BoxedUnit.UNIT;
                    break block48;
                }
                if (!var77_88 || !None$.MODULE$.equals(var83_98 = (Option)var78_89.value())) break block49;
                Assert.fail((String)"Should have failed");
                var2_95 = BoxedUnit.UNIT;
                break block48;
            }
            if (!(var81_92 instanceof Left)) ** GOTO lbl-1000
            var79_90 = true;
            var80_91 = (Left)var81_92;
            e = (ApiException)var80_91.value();
            if (e instanceof OffsetNotAvailableException) {
                var2_96 = BoxedUnit.UNIT;
            } else if (var79_90 && (e = (ApiException)var80_91.value()) != null) {
                Assert.fail((String)"Should have seen OffsetNotAvailableException, saw $e");
                var2_97 = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)var81_92);
            }
        }
        partition.updateReplicaLogReadResult(follower1Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        partition.updateReplicaLogReadResult(follower2Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        var86_101 = false;
        var87_102 = null;
        var88_103 = PartitionTest.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), partition);
        if (!(var88_103 instanceof Right)) ** GOTO lbl-1000
        var86_101 = true;
        var87_102 = (Right)var88_103;
        var89_104 = (Option)var87_102.value();
        if (var89_104 instanceof Some) {
            var90_105 = (Some)var89_104;
            offsetAndTimestamp = (FileRecords.TimestampAndOffset)var90_105.value();
            Assert.assertEquals((long)5L, (long)offsetAndTimestamp.offset);
            var1_107 = BoxedUnit.UNIT;
        } else if (var86_101 && None$.MODULE$.equals(var92_110 = (Option)var87_102.value())) {
            Assert.fail((String)"Should have seen some offsets");
            var1_108 = BoxedUnit.UNIT;
        } else if (var88_103 instanceof Left && (e = (ApiException)(var93_111 = (Left)var88_103).value()) != null) {
            var95_113 = e;
            Assert.fail((String)new StringBuilder(17).append("Got ApiException ").append(var95_113).toString());
            var1_109 = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)var88_103);
        }
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)PartitionTest.fetchOffsetsForTimestamp$1(100L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), partition));
    }

    private Partition setupPartitionWithMocks(int leaderEpoch, boolean isLeader, Log log) {
        java.util.List replicas;
        int x$5 = this.brokerId();
        TopicPartition x$6 = this.topicPartition();
        MockTime x$7 = this.time();
        Some x$8 = new Some((Object)log);
        long x$9 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica replica = new Replica(x$5, x$6, (Time)x$7, x$9, (Option)x$8);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.mock(ReplicaManager.class);
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.mock(KafkaZkClient.class);
        Partition partition = new Partition(this.topicPartition(), false, Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), replicaManager, this.logManager(), zkClient);
        EasyMock.replay((Object[])new Object[]{replicaManager, zkClient});
        partition.addReplicaIfNotExists(replica);
        int controllerId = 0;
        int controllerEpoch = 0;
        java.util.List isr = replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId() + 1), (List)Nil$.MODULE$))).asJava();
        if (isLeader) {
            Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)partition.makeLeader(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, this.brokerId(), leaderEpoch, isr, 1, replicas, true), 0));
            Assert.assertEquals((long)leaderEpoch, (long)partition.getLeaderEpoch());
            Assert.assertEquals((Object)new Some((Object)replica), (Object)partition.leaderReplicaIfLocal());
        } else {
            Assert.assertTrue((String)"Expected become follower transition to succeed", (boolean)partition.makeFollower(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, this.brokerId() + 1, leaderEpoch, isr, 1, replicas, true), 0));
            Assert.assertEquals((long)leaderEpoch, (long)partition.getLeaderEpoch());
            Assert.assertEquals((Object)None$.MODULE$, (Object)partition.leaderReplicaIfLocal());
        }
        return partition;
    }

    private Log setupPartitionWithMocks$default$3() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        LogConfig x$2 = this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        return qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
    }

    @Test
    public void testAppendRecordsAsFollowerBelowLogStartOffset() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        LogConfig x$2 = this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        int x$5 = this.brokerId();
        TopicPartition x$6 = this.topicPartition();
        MockTime x$7 = this.time();
        Some x$8 = new Some((Object)log);
        long x$9 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica replica = new Replica(x$5, x$6, (Time)x$7, x$9, (Option)x$8);
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        partition.addReplicaIfNotExists(replica);
        Assert.assertEquals((Object)new Some((Object)replica), (Object)partition.localReplica());
        long initialLogStartOffset = 5L;
        partition.truncateFullyAndStartAt(initialLogStartOffset, false);
        Assert.assertEquals((String)new StringBuilder(50).append("Log end offset after truncate fully and start at ").append(initialLogStartOffset).append(":").toString(), (long)initialLogStartOffset, (long)replica.logEndOffset());
        Assert.assertEquals((String)new StringBuilder(52).append("Log start offset after truncate fully and start at ").append(initialLogStartOffset).append(":").toString(), (long)initialLogStartOffset, (long)replica.logStartOffset());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> partition.appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)Nil$.MODULE$), 3L, this.createRecords$default$3()), false), ClassTag$.MODULE$.apply(UnexpectedAppendOffsetException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 692));
        Assert.assertEquals((String)"Log end offset should not change after failure to append", (long)initialLogStartOffset, (long)replica.logEndOffset());
        long newLogStartOffset = 4L;
        MemoryRecords records = this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)Nil$.MODULE$))), newLogStartOffset, this.createRecords$default$3());
        partition.appendRecordsToFollowerOrFutureReplica(records, false);
        Assert.assertEquals((String)new StringBuilder(59).append("Log end offset after append of 3 records with base offset ").append(newLogStartOffset).append(":").toString(), (long)7L, (long)replica.logEndOffset());
        Assert.assertEquals((String)new StringBuilder(61).append("Log start offset after append of 3 records with base offset ").append(newLogStartOffset).append(":").toString(), (long)newLogStartOffset, (long)replica.logStartOffset());
        partition.appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)Nil$.MODULE$), 7L, this.createRecords$default$3()), false);
        Assert.assertEquals((String)"Log end offset after append of 1 record at offset 7:", (long)8L, (long)replica.logEndOffset());
        Assert.assertEquals((String)"Log start offset not expected to change:", (long)newLogStartOffset, (long)replica.logStartOffset());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> {
            MemoryRecords records2 = this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), 3L, this.createRecords$default$3());
            return partition.appendRecordsToFollowerOrFutureReplica(records2, false);
        }, ClassTag$.MODULE$.apply(UnexpectedAppendOffsetException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 715));
        Assert.assertEquals((String)"Log end offset should not change after failure to append", (long)8L, (long)replica.logEndOffset());
        partition.appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)Nil$.MODULE$), 8L, this.createRecords$default$3()), false);
        Assert.assertEquals((String)"Log end offset after append of 1 record at offset 8:", (long)9L, (long)replica.logEndOffset());
        Assert.assertEquals((String)"Log start offset not expected to change:", (long)newLogStartOffset, (long)replica.logStartOffset());
    }

    @Test
    public void testListOffsetIsolationLevels() {
        java.util.List replicas;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        LogConfig x$2 = this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        int x$5 = this.brokerId();
        TopicPartition x$6 = this.topicPartition();
        MockTime x$7 = this.time();
        Some x$8 = new Some((Object)log);
        long x$9 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica replica = new Replica(x$5, x$6, (Time)x$7, x$9, (Option)x$8);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.mock(ReplicaManager.class);
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.mock(KafkaZkClient.class);
        Partition partition = new Partition(this.topicPartition(), false, Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), replicaManager, this.logManager(), zkClient);
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        java.util.List isr = replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId() + 1), (List)Nil$.MODULE$))).asJava();
        replicaManager.tryCompleteDelayedFetch((DelayedOperationKey)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andVoid();
        EasyMock.replay((Object[])new Object[]{replicaManager, zkClient});
        partition.addReplicaIfNotExists(replica);
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)partition.makeLeader(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, this.brokerId(), leaderEpoch, isr, 1, replicas, true), 0));
        Assert.assertEquals((long)leaderEpoch, (long)partition.getLeaderEpoch());
        Assert.assertEquals((Object)new Some((Object)replica), (Object)partition.leaderReplicaIfLocal());
        MemoryRecords records = this.createTransactionalRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)Nil$.MODULE$))), 0L, this.createTransactionalRecords$default$3());
        partition.appendRecordsToLeader(records, true, partition.appendRecordsToLeader$default$3());
        Assert.assertEquals((long)3L, (long)PartitionTest.fetchLatestOffset$1((Option)None$.MODULE$, (Partition)partition).offset);
        Assert.assertEquals((long)0L, (long)PartitionTest.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), (Partition)partition).offset);
        Assert.assertEquals((long)0L, (long)PartitionTest.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED), (Partition)partition).offset);
        replica.highWatermark_$eq(new LogOffsetMetadata(1L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        Assert.assertEquals((long)3L, (long)PartitionTest.fetchLatestOffset$1((Option)None$.MODULE$, (Partition)partition).offset);
        Assert.assertEquals((long)1L, (long)PartitionTest.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), (Partition)partition).offset);
        Assert.assertEquals((long)0L, (long)PartitionTest.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED), (Partition)partition).offset);
        Assert.assertEquals((long)0L, (long)PartitionTest.fetchEarliestOffset$1((Option)None$.MODULE$, (Partition)partition).offset);
        Assert.assertEquals((long)0L, (long)PartitionTest.fetchEarliestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), (Partition)partition).offset);
        Assert.assertEquals((long)0L, (long)PartitionTest.fetchEarliestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED), (Partition)partition).offset);
    }

    @Test
    public void testGetReplica() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        LogConfig x$2 = this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        int x$5 = this.brokerId();
        TopicPartition x$6 = this.topicPartition();
        MockTime x$7 = this.time();
        Some x$8 = new Some((Object)log);
        long x$9 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica replica = new Replica(x$5, x$6, (Time)x$7, x$9, (Option)x$8);
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        Assert.assertEquals((Object)None$.MODULE$, (Object)partition.localReplica());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> partition.localReplicaOrException(), ClassTag$.MODULE$.apply(ReplicaNotAvailableException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 812));
        partition.addReplicaIfNotExists(replica);
        Assert.assertEquals((Object)new Some((Object)replica), (Object)partition.localReplica());
        Assert.assertEquals((Object)replica, (Object)partition.localReplicaOrException());
    }

    @Test
    public void testAppendRecordsToFollowerWithNoReplicaThrowsException() {
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> partition.appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)Nil$.MODULE$), 0L, this.createRecords$default$3()), false), ClassTag$.MODULE$.apply(ReplicaNotAvailableException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 824));
    }

    @Test
    public void testMakeFollowerWithNoLeaderIdChange() {
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        LeaderAndIsrRequest.PartitionState partitionStateInfo = new LeaderAndIsrRequest.PartitionState(0, 1, 1, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava(), 1, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava(), false);
        partition.makeFollower(0, partitionStateInfo, 0);
        partitionStateInfo = new LeaderAndIsrRequest.PartitionState(0, 1, 4, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava(), 1, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava(), false);
        Assert.assertTrue((boolean)partition.makeFollower(0, partitionStateInfo, 2));
        partitionStateInfo = new LeaderAndIsrRequest.PartitionState(0, 1, 4, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava(), 1, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava(), false);
        Assert.assertFalse((boolean)partition.makeFollower(0, partitionStateInfo, 2));
    }

    @Test
    public void testFollowerDoesNotJoinISRUntilCaughtUpToOffsetWithinCurrentLeaderEpoch() {
        int controllerEpoch = 3;
        int leader = this.brokerId();
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        int controllerId = this.brokerId() + 3;
        java.util.List replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(leader), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower2), (List)Nil$.MODULE$)))).asJava();
        java.util.List isr = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(leader), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower2), (List)Nil$.MODULE$))).asJava();
        int leaderEpoch = 8;
        MemoryRecords batch1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        MemoryRecords batch2 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k4".getBytes(), "v2".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k5".getBytes(), "v3".getBytes()), (List)Nil$.MODULE$))), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        MemoryRecords batch3 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k6".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k7".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        Assert.assertTrue((String)"Expected first makeLeader() to return 'leader changed'", (boolean)partition.makeLeader(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, leader, leaderEpoch, isr, 1, replicas, true), 0));
        Assert.assertEquals((String)"Current leader epoch", (long)leaderEpoch, (long)partition.getLeaderEpoch());
        Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)})), (Object)partition.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.brokerId()), Set$.MODULE$.canBuildFrom()));
        Replica leaderReplica = (Replica)partition.getReplica(leader).get();
        Replica follower1Replica = (Replica)partition.getReplica(follower1).get();
        Replica follower2Replica = (Replica)partition.getReplica(follower2).get();
        long lastOffsetOfFirstBatch = partition.appendRecordsToLeader(batch1, true, partition.appendRecordsToLeader$default$3()).lastOffset();
        partition.appendRecordsToLeader(batch2, true, partition.appendRecordsToLeader$default$3());
        Assert.assertEquals((String)"Expected leader's HW not move", (long)leaderReplica.logStartOffset(), (long)leaderReplica.highWatermark().messageOffset());
        partition.updateReplicaLogReadResult(follower2Replica, this.readResult$2(new FetchDataInfo(new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch1, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        partition.updateReplicaLogReadResult(follower2Replica, this.readResult$2(new FetchDataInfo(new LogOffsetMetadata(lastOffsetOfFirstBatch, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch2, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        Assert.assertEquals((String)"Expected leader's HW", (long)lastOffsetOfFirstBatch, (long)leaderReplica.highWatermark().messageOffset());
        partition.makeFollower(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, follower2, leaderEpoch + 1, isr, 1, replicas, false), 1);
        Assert.assertTrue((String)"Expected makeLeader() to return 'leader changed' after makeFollower()", (boolean)partition.makeLeader(controllerEpoch, new LeaderAndIsrRequest.PartitionState(controllerEpoch, leader, leaderEpoch + 2, isr, 1, replicas, false), 2));
        long currentLeaderEpochStartOffset = leaderReplica.logEndOffset();
        partition.appendRecordsToLeader(batch3, true, partition.appendRecordsToLeader$default$3());
        partition.updateReplicaLogReadResult(follower1Replica, this.readResult$2(new FetchDataInfo(new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch1, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        partition.updateReplicaLogReadResult(follower1Replica, this.readResult$2(new FetchDataInfo(new LogOffsetMetadata(lastOffsetOfFirstBatch, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch2, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)})), (Object)partition.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.brokerId()), Set$.MODULE$.canBuildFrom()));
        partition.updateReplicaLogReadResult(follower1Replica, this.readResult$2(new FetchDataInfo(new LogOffsetMetadata(currentLeaderEpochStartOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch3, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2)})), (Object)partition.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.brokerId()), Set$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testDelayedFetchAfterAppendRecords() {
        java.util.List replicaIds;
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.mock(ReplicaManager.class);
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.mock(KafkaZkClient.class);
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        java.util.List isr = replicaIds = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId() + 1), (List)Nil$.MODULE$))).asJava();
        LogConfig logConfig = new LogConfig((Map)new Properties(), LogConfig$.MODULE$.apply$default$2());
        IndexedSeq topicPartitions = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable & scala.Serializable)i -> PartitionTest.$anonfun$testDelayedFetchAfterAppendRecords$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq logs = (IndexedSeq)topicPartitions.map((Function1 & Serializable & scala.Serializable)tp -> {
            LogManager qual$1 = this.logManager();
            TopicPartition x$1 = tp;
            LogConfig x$2 = logConfig;
            boolean x$3 = qual$1.getOrCreateLog$default$3();
            boolean x$4 = qual$1.getOrCreateLog$default$4();
            return qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq replicas = (IndexedSeq)logs.map((Function1 & Serializable & scala.Serializable)log -> {
            int x$5 = this.brokerId();
            TopicPartition x$6 = log.topicPartition();
            MockTime x$7 = this.time();
            Some x$8 = new Some(log);
            long x$9 = Replica$.MODULE$.$lessinit$greater$default$4();
            return new Replica(x$5, x$6, (Time)x$7, x$9, (Option)x$8);
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq partitions = (IndexedSeq)replicas.map((Function1 & Serializable & scala.Serializable)replica -> {
            TopicPartition tp = replica.topicPartition();
            Partition partition = new Partition(tp, false, Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), replicaManager, this.logManager(), zkClient);
            partition.addReplicaIfNotExists(replica);
            partition.makeLeader(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, this.brokerId(), leaderEpoch, isr, 1, replicaIds, true), 0);
            return partition;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Capture tpKey = EasyMock.newCapture();
        replicaManager.tryCompleteDelayedFetch((DelayedOperationKey)EasyMock.capture((Capture)tpKey));
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, tpKey, topicPartitions, partitions, leaderEpoch){
            private final Capture tpKey$1;
            private final IndexedSeq topicPartitions$1;
            private final IndexedSeq partitions$1;
            private final int leaderEpoch$1;

            public void answer() {
                int anotherPartition = (((TopicPartitionOperationKey)this.tpKey$1.getValue()).partition() + 1) % this.topicPartitions$1.size();
                Partition partition = (Partition)this.partitions$1.apply(anotherPartition);
                partition.fetchOffsetSnapshot(Optional.of(Predef$.MODULE$.int2Integer(this.leaderEpoch$1)), true);
            }
            {
                this.tpKey$1 = tpKey$1;
                this.topicPartitions$1 = topicPartitions$1;
                this.partitions$1 = partitions$1;
                this.leaderEpoch$1 = leaderEpoch$1;
            }
        }).anyTimes();
        EasyMock.replay((Object[])new Object[]{replicaManager, zkClient});
        AtomicBoolean done = new AtomicBoolean();
        ExecutorService executor = Executors.newFixedThreadPool(topicPartitions.size() + 1);
        try {
            try {
                executor.submit(CoreUtils$.MODULE$.runnable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    while (!done.get()) {
                        partitions.foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                            x$8.maybeShrinkIsr(10000L);
                            return BoxedUnit.UNIT;
                        });
                    }
                }));
                IndexedSeq futures = (IndexedSeq)partitions.map((Function1 & Serializable & scala.Serializable)partition -> executor.submit(CoreUtils$.MODULE$.runnable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10000).foreach((Function1 & Serializable & scala.Serializable)x$9 -> partition.appendRecordsToLeader(this.createRecords$1(0L), true, partition.appendRecordsToLeader$default$3())))), IndexedSeq$.MODULE$.canBuildFrom());
                futures.foreach((Function1 & Serializable & scala.Serializable)x$10 -> x$10.get(15L, TimeUnit.SECONDS));
                done.set(true);
            }
            catch (TimeoutException e) {
                String allThreads = TestUtils$.MODULE$.allThreadStackTraces();
                Assert.fail((String)new StringBuilder(53).append("Test timed out with exception ").append(e).append(", thread stack traces: ").append(allThreads).toString());
            }
        }
        finally {
            executor.shutdownNow();
            executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
    }

    public MemoryRecords createRecords(Iterable<SimpleRecord> records, long baseOffset, int partitionLeaderEpoch) {
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(records).asJava())));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.LOG_APPEND_TIME, (long)baseOffset, (long)this.time().milliseconds(), (int)partitionLeaderEpoch);
        records.foreach((Function1 & Serializable & scala.Serializable)x$1 -> builder.append(x$1));
        return builder.build();
    }

    public int createRecords$default$3() {
        return 0;
    }

    public MemoryRecords createTransactionalRecords(Iterable<SimpleRecord> records, long baseOffset, int partitionLeaderEpoch) {
        long producerId = 1L;
        short producerEpoch = (short)0;
        int baseSequence = 0;
        boolean isTransactional = true;
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(records).asJava())));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (CompressionType)CompressionType.NONE, (long)baseOffset, (long)producerId, (short)producerEpoch, (int)baseSequence, (boolean)isTransactional);
        records.foreach((Function1 & Serializable & scala.Serializable)x$1 -> builder.append(x$1));
        return builder.build();
    }

    public int createTransactionalRecords$default$3() {
        return 0;
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(File x$1) {
        Utils.delete((File)x$1);
    }

    private static final void assertSnapshotError$1(Errors expectedError, Optional currentLeaderEpoch, Partition partition$2) {
        Either either = partition$2.fetchOffsetSnapshotOrError(currentLeaderEpoch, true);
        if (either instanceof Left) {
            Assert.assertEquals((Object)Errors.NONE, (Object)expectedError);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Errors error = (Errors)right.value();
            Assert.assertEquals((Object)expectedError, (Object)error);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)either);
        }
    }

    private static final void assertSnapshotError$2(Errors expectedError, Optional currentLeaderEpoch, boolean fetchOnlyLeader, Partition partition$3) {
        Either either = partition$3.fetchOffsetSnapshotOrError(currentLeaderEpoch, fetchOnlyLeader);
        if (either instanceof Left) {
            Assert.assertEquals((Object)expectedError, (Object)Errors.NONE);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Errors error = (Errors)right.value();
            Assert.assertEquals((Object)expectedError, (Object)error);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)either);
        }
    }

    private static final void assertLastOffsetForLeaderError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$4) {
        EpochEndOffset endOffset = partition$4.lastOffsetForLeaderEpoch(currentLeaderEpochOpt, 0, true);
        Assert.assertEquals((Object)error, (Object)endOffset.error());
    }

    private static final void assertLastOffsetForLeaderError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$5) {
        EpochEndOffset endOffset = partition$5.lastOffsetForLeaderEpoch(currentLeaderEpochOpt, 0, fetchOnlyLeader);
        Assert.assertEquals((Object)error, (Object)endOffset.error());
    }

    private static final void assertReadRecordsError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$6) {
        try {
            partition$6.readRecords(0L, currentLeaderEpochOpt, 1024, (FetchIsolation)FetchLogEnd$.MODULE$, true, false);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private static final void assertReadRecordsError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$7) {
        try {
            partition$7.readRecords(0L, currentLeaderEpochOpt, 1024, (FetchIsolation)FetchLogEnd$.MODULE$, fetchOnlyLeader, false);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private static final void assertFetchOffsetError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$8) {
        try {
            partition$8.fetchOffsetForTimestamp(0L, (Option)None$.MODULE$, currentLeaderEpochOpt, true);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private static final void assertFetchOffsetError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$9) {
        try {
            partition$9.fetchOffsetForTimestamp(0L, (Option)None$.MODULE$, currentLeaderEpochOpt, fetchOnlyLeader);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private final LogReadResult readResult$1(FetchDataInfo fetchInfo, Replica leaderReplica) {
        return new LogReadResult(fetchInfo, leaderReplica.highWatermark().messageOffset(), leaderReplica.logStartOffset(), leaderReplica.logEndOffset(), 0L, this.time().milliseconds(), 10240, (Option)None$.MODULE$, LogReadResult$.MODULE$.apply$default$9());
    }

    private static final Either fetchOffsetsForTimestamp$1(long timestamp, Option isolation, Partition partition$10) {
        Left left;
        try {
            left = package$.MODULE$.Right().apply((Object)partition$10.fetchOffsetForTimestamp(timestamp, isolation, Optional.of(Predef$.MODULE$.int2Integer(partition$10.getLeaderEpoch())), true));
        }
        catch (ApiException e) {
            left = package$.MODULE$.Left().apply((Object)e);
        }
        return left;
    }

    private static final FileRecords.TimestampAndOffset fetchLatestOffset$1(Option isolationLevel, Partition partition$12) {
        Option res = partition$12.fetchOffsetForTimestamp(-1L, isolationLevel, Optional.empty(), true);
        Assert.assertTrue((boolean)res.isDefined());
        return (FileRecords.TimestampAndOffset)res.get();
    }

    private static final FileRecords.TimestampAndOffset fetchEarliestOffset$1(Option isolationLevel, Partition partition$12) {
        Option res = partition$12.fetchOffsetForTimestamp(-2L, isolationLevel, Optional.empty(), true);
        Assert.assertTrue((boolean)res.isDefined());
        return (FileRecords.TimestampAndOffset)res.get();
    }

    private final LogReadResult readResult$2(FetchDataInfo fetchInfo, Replica leaderReplica) {
        return new LogReadResult(fetchInfo, leaderReplica.highWatermark().messageOffset(), leaderReplica.logStartOffset(), leaderReplica.logEndOffset(), 0L, this.time().milliseconds(), 10240, (Option)None$.MODULE$, LogReadResult$.MODULE$.apply$default$9());
    }

    public static final /* synthetic */ TopicPartition $anonfun$testDelayedFetchAfterAppendRecords$1(int i) {
        return new TopicPartition("test-topic", i);
    }

    private final MemoryRecords createRecords$1(long baseOffset) {
        .colon.colon records = new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)records).asJava())));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)baseOffset, (long)this.time().milliseconds(), (int)0);
        records.foreach((Function1 & Serializable & scala.Serializable)x$1 -> builder.append(x$1));
        return builder.build();
    }

    public PartitionTest() {
        this.brokerId = 101;
    }

    public static final /* synthetic */ Object $anonfun$testMonotonicOffsetsAfterLeaderChange$1$adapted(Replica x$4) {
        return BoxesRunTime.boxToInteger((int)x$4.brokerId());
    }
}

