/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.api.ConsumerBounceTest$;
import kafka.api.FixedPortTestUtils$;
import kafka.cluster.Replica;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.CommitFailedException;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.GroupMaxSizeReachedException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0001\rEc\u0001B\u001f?\u0001\rCQ\u0001\u0015\u0001\u0005\u0002ECq\u0001\u0016\u0001C\u0002\u0013\u0005Q\u000b\u0003\u0004_\u0001\u0001\u0006IA\u0016\u0005\b?\u0002\u0011\r\u0011\"\u0001a\u0011\u00199\u0007\u0001)A\u0005C\"9\u0001\u000e\u0001b\u0001\n\u0003I\u0007BB;\u0001A\u0003%!\u000eC\u0004w\u0001\t\u0007I\u0011\u00011\t\r]\u0004\u0001\u0015!\u0003b\u0011\u001dA\bA1A\u0005\u0002\u0001Da!\u001f\u0001!\u0002\u0013\t\u0007b\u0002>\u0001\u0005\u0004%\ta\u001f\u0005\b\u0003\u0013\u0001\u0001\u0015!\u0003}\u0011\u001d\tY\u0001\u0001C!\u0003\u001bAq!!\f\u0001\t\u0013\ty\u0003C\u0005\u0002B\u0001\t\n\u0011\"\u0003\u0002D!9\u0011\u0011\f\u0001\u0005B\u0005m\u0003bBA9\u0001\u0011\u0005\u00131\f\u0005\b\u0003w\u0002A\u0011AA.\u0011\u001d\ti\t\u0001C\u0001\u0003\u001fCq!!&\u0001\t\u0003\tY\u0006C\u0004\u0002\u001a\u0002!\t!a'\t\u000f\u0005}\u0005\u0001\"\u0001\u0002\\!9\u00111\u0015\u0001\u0005\u0002\u0005m\u0003bBAT\u0001\u0011%\u0011\u0011\u0016\u0005\b\u0003g\u0003A\u0011BA[\u0011\u001d\t\t\r\u0001C\u0005\u0003\u0007Dq!!3\u0001\t\u0013\tY\rC\u0004\u0002X\u0002!\t!a\u0017\t\u000f\u0005m\u0007\u0001\"\u0001\u0002\\!9\u0011q\u001c\u0001\u0005\n\u0005\u0005\b\"\u0003B\u0010\u0001E\u0005I\u0011BA\"\u0011\u001d\u0011\t\u0003\u0001C\u0001\u0005GA\u0011Ba\u0017\u0001#\u0003%\tA!\u0018\t\u0013\t\u0005\u0004!%A\u0005\u0002\t\r\u0004\"\u0003B4\u0001E\u0005I\u0011AA\"\u0011%\u0011I\u0007AI\u0001\n\u0003\u0011Y\u0007C\u0004\u0003p\u0001!\tA!\u001d\t\u000f\t5\u0005\u0001\"\u0001\u0002\\!9!\u0011\u0013\u0001\u0005\n\tM\u0005b\u0002BS\u0001\u0011%!q\u0015\u0005\b\u0005W\u0003A\u0011\u0002BW\u0011\u001d\u00119\f\u0001C\u0005\u0005sC\u0011B!1\u0001#\u0003%IAa1\t\u000f\t\u001d\u0007\u0001\"\u0003\u0003J\"I!\u0011\u001b\u0001\u0012\u0002\u0013%!1\u0019\u0005\b\u0005'\u0004A\u0011\u0002Bk\u0011\u001d\u0011i\u000f\u0001C\u0005\u0005_Dqa!\u0001\u0001\t\u0013\u0019\u0019A\u0002\u0004\u0004\f\u0001!1Q\u0002\u0005\n\u0003'\u0013$Q1A\u0005\u0002\u0001D\u0011b!\u00063\u0005\u0003\u0005\u000b\u0011B1\t\rA\u0013D\u0011AB\f\u0011!\u0019yB\ra\u0001\n\u0003\u0001\u0007\"CB\u0011e\u0001\u0007I\u0011AB\u0012\u0011\u001d\u0019IC\rQ!\n\u0005Dqaa\u000b3\t\u0003\nY\u0006C\u0004\u0004.\u0001!Iaa\f\t\u0013\r%\u0003!%A\u0005\n\u0005\r\u0003\"CB&\u0001E\u0005I\u0011BB'\u0005I\u0019uN\\:v[\u0016\u0014(i\\;oG\u0016$Vm\u001d;\u000b\u0005}\u0002\u0015aA1qS*\t\u0011)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001!%\n\u0005\u0002F\u00116\taI\u0003\u0002H\u0001\u000611/\u001a:wKJL!!\u0013$\u0003\u001f\t\u000b7/\u001a*fcV,7\u000f\u001e+fgR\u0004\"a\u0013(\u000e\u00031S!!\u0014!\u0002\u000bU$\u0018\u000e\\:\n\u0005=c%a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003I\u0003\"a\u0015\u0001\u000e\u0003y\nQ\u0001^8qS\u000e,\u0012A\u0016\t\u0003/rk\u0011\u0001\u0017\u0006\u00033j\u000bA\u0001\\1oO*\t1,\u0001\u0003kCZ\f\u0017BA/Y\u0005\u0019\u0019FO]5oO\u00061Ao\u001c9jG\u0002\nA\u0001]1siV\t\u0011\r\u0005\u0002cK6\t1MC\u0001e\u0003\u0015\u00198-\u00197b\u0013\t17MA\u0002J]R\fQ\u0001]1si\u0002\n!\u0001\u001e9\u0016\u0003)\u0004\"a[:\u000e\u00031T!!\u001c8\u0002\r\r|W.\\8o\u0015\t\tuN\u0003\u0002qc\u00061\u0011\r]1dQ\u0016T\u0011A]\u0001\u0004_J<\u0017B\u0001;m\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f1\u0001\u001e9!\u00031i\u0017\r_$s_V\u00048+\u001b>f\u00035i\u0017\r_$s_V\u00048+\u001b>fA\u0005\u0019rM]1dK\u001a,Hn\u00117pg\u0016$\u0016.\\3Ng\u0006!rM]1dK\u001a,Hn\u00117pg\u0016$\u0016.\\3Ng\u0002\n\u0001\"\u001a=fGV$xN]\u000b\u0002yB\u0019Q0!\u0002\u000e\u0003yT1a`A\u0001\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0003\u0007Q\u0016\u0001B;uS2L1!a\u0002\u007f\u0005a\u00196\r[3ek2,G-\u0012=fGV$xN]*feZL7-Z\u0001\nKb,7-\u001e;pe\u0002\nqbZ3oKJ\fG/Z\"p]\u001aLwm]\u000b\u0003\u0003\u001f\u0001b!!\u0005\u0002\"\u0005\u001db\u0002BA\n\u0003;qA!!\u0006\u0002\u001c5\u0011\u0011q\u0003\u0006\u0004\u00033\u0011\u0015A\u0002\u001fs_>$h(C\u0001e\u0013\r\tybY\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019#!\n\u0003\u0007M+\u0017OC\u0002\u0002 \r\u00042!RA\u0015\u0013\r\tYC\u0012\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u000bhK:,'/\u0019;f\u0017\u000647.Y\"p]\u001aLwm\u001d\u000b\u0005\u0003\u001f\t\t\u0004\u0003\u0005w\u001fA\u0005\t\u0019AA\u001a!\u0011\t)$!\u0010\u000f\t\u0005]\u0012\u0011\b\t\u0004\u0003+\u0019\u0017bAA\u001eG\u00061\u0001K]3eK\u001aL1!XA \u0015\r\tYdY\u0001\u001fO\u0016tWM]1uK.\u000bgm[1D_:4\u0017nZ:%I\u00164\u0017-\u001e7uIE*\"!!\u0012+\t\u0005M\u0012qI\u0016\u0003\u0003\u0013\u0002B!a\u0013\u0002V5\u0011\u0011Q\n\u0006\u0005\u0003\u001f\n\t&A\u0005v]\u000eDWmY6fI*\u0019\u00111K2\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002X\u00055#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006)1/\u001a;VaR\u0011\u0011Q\f\t\u0004E\u0006}\u0013bAA1G\n!QK\\5uQ\r\t\u0012Q\r\t\u0005\u0003O\ni'\u0004\u0002\u0002j)\u0019\u00111N9\u0002\u000b),h.\u001b;\n\t\u0005=\u0014\u0011\u000e\u0002\u0007\u0005\u00164wN]3\u0002\u0011Q,\u0017M\u001d#po:D3AEA;!\u0011\t9'a\u001e\n\t\u0005e\u0014\u0011\u000e\u0002\u0006\u0003\u001a$XM]\u0001\"i\u0016\u001cHoQ8ogVl\u0007\u000f^5p]^KG\u000f\u001b\"s_.,'OR1jYV\u0014Xm\u001d\u0015\u0004'\u0005}\u0004\u0003BA4\u0003\u0003KA!a!\u0002j\t1\u0011j\u001a8pe\u0016D3aEAD!\u0011\t9'!#\n\t\u0005-\u0015\u0011\u000e\u0002\u0005)\u0016\u001cH/A\rd_:\u001cX/\\3XSRD'I]8lKJ4\u0015-\u001b7ve\u0016\u001cH\u0003BA/\u0003#Ca!a%\u0015\u0001\u0004\t\u0017\u0001\u00038v[&#XM]:\u0002GQ,7\u000f^*fK.\fe\u000eZ\"p[6LGoV5uQ\n\u0013xn[3s\r\u0006LG.\u001e:fg\"\u001aQ#a\"\u0002?M,Wm[!oI\u000e{W.\\5u/&$\bN\u0011:pW\u0016\u0014h)Y5mkJ,7\u000f\u0006\u0003\u0002^\u0005u\u0005BBAJ-\u0001\u0007\u0011-A\u0011uKN$8+\u001e2tGJL'-Z,iK:$v\u000e]5d+:\fg/Y5mC\ndW\rK\u0002\u0018\u0003\u000f\u000b\u0011\u0002^3ti\u000ecwn]3)\u0007a\t9)\u0001\ndQ\u0016\u001c7n\u00117pg\u0016<un\u001c3QCRDGCBA/\u0003W\u000by\u000b\u0003\u0004\u0002.f\u0001\r!Y\u0001\u000b]Vl'+Z2pe\u0012\u001c\bbBAY3\u0001\u0007\u00111G\u0001\bOJ|W\u000f]%e\u0003\u0001\u001a\u0007.Z2l\u00072|7/Z,ji\"\u001cun\u001c:eS:\fGo\u001c:GC&dWO]3\u0015\u0011\u0005u\u0013qWA]\u0003{Ca!!,\u001b\u0001\u0004\t\u0007bBA^5\u0001\u0007\u00111G\u0001\rIft\u0017-\\5d\u000fJ|W\u000f\u001d\u0005\b\u0003\u007fS\u0002\u0019AA\u001a\u0003-i\u0017M\\;bY\u001e\u0013x.\u001e9\u0002\u001f\u0019Lg\u000eZ\"p_J$\u0017N\\1u_J$2!YAc\u0011\u001d\t9m\u0007a\u0001\u0003g\tQa\u001a:pkB\fAd\u00195fG.\u001cEn\\:f/&$\bn\u00117vgR,'OR1jYV\u0014X\r\u0006\u0005\u0002^\u00055\u0017qZAj\u0011\u0019\ti\u000b\ba\u0001C\"9\u0011\u0011\u001b\u000fA\u0002\u0005M\u0012AB4s_V\u0004\u0018\u0007C\u0004\u0002Vr\u0001\r!a\r\u0002\r\u001d\u0014x.\u001e93\u0003\u0019#Xm\u001d;S_2d\u0017N\\4Ce>\\WM\u001d*fgR\f'\u000f^:XSRD7+\\1mY\u0016\u0014X*\u0019=He>,\boU5{K\u000e{gNZ5h\t&\u001c(/\u001e9ug\nKwm\u0012:pkBD3!HAD\u0003a\"Xm\u001d;D_:\u001cX/\\3s%\u0016\u001cW-\u001b<fg\u001a\u000bG/\u00197Fq\u000e,\u0007\u000f^5p]^CWM\\$s_V\u0004\b+Y:tKNl\u0015\r_*ju\u0016D3AHAD\u0003i\u0019'/Z1uK\u000e{gn];nKJ\u001cx+\u001b;i\u000fJ|W\u000f]%e))\t\u0019Oa\u0004\u0003\u0012\tU!Q\u0004\t\u0007\u0003K\fy/a=\u000e\u0005\u0005\u001d(\u0002BAu\u0003W\fq!\\;uC\ndWMC\u0002\u0002n\u000e\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t0a:\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\t\u0003k\fyPa\u0001\u0003\u00045\u0011\u0011q\u001f\u0006\u0005\u0003s\fY0\u0001\u0005d_:\u001cX/\\3s\u0015\r\tiP\\\u0001\bG2LWM\u001c;t\u0013\u0011\u0011\t!a>\u0003\u001b-\u000bgm[1D_:\u001cX/\\3s!\u0015\u0011'Q\u0001B\u0005\u0013\r\u00119a\u0019\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004E\n-\u0011b\u0001B\u0007G\n!!)\u001f;f\u0011\u001d\t\tl\ba\u0001\u0003gAaAa\u0005 \u0001\u0004\t\u0017!D2p]N,X.\u001a:D_VtG\u000f\u0003\u0004{?\u0001\u0007!q\u0003\t\u0004{\ne\u0011b\u0001B\u000e}\nyQ\t_3dkR|'oU3sm&\u001cW\r\u0003\u0005U?A\u0005\t\u0019AA\u001a\u0003\u0011\u001a'/Z1uK\u000e{gn];nKJ\u001cx+\u001b;i\u000fJ|W\u000f]%eI\u0011,g-Y;mi\u0012\"\u0014\u0001E:vEN\u001c'/\u001b2f\u0003:$\u0007k\u001c7m)9\u0011)C!\r\u00034\tU\"Q\tB+\u0005/\u0002R! B\u0014\u0005WI1A!\u000b\u007f\u0005\u00191U\u000f^;sKB\u0019!M!\f\n\u0007\t=2MA\u0002B]fDq!!?\"\u0001\u0004\t\u0019\u0010\u0003\u0004{C\u0001\u0007!q\u0003\u0005\n\u0005o\t\u0003\u0013!a\u0001\u0005s\tqB]3w_.,7+Z7ba\"|'/\u001a\t\u0006E\nm\"qH\u0005\u0004\u0005{\u0019'AB(qi&|g\u000eE\u0002~\u0005\u0003J1Aa\u0011\u007f\u0005%\u0019V-\\1qQ>\u0014X\rC\u0005\u0003H\u0005\u0002\n\u00111\u0001\u0003J\u0005YqN\\#yG\u0016\u0004H/[8o!\u001d\u0011'1\nB(\u0003;J1A!\u0014d\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0002\u0012\tE\u0013\u0002\u0002B*\u0003K\u0011\u0011\"\u0012=dKB$\u0018n\u001c8\t\u0011Q\u000b\u0003\u0013!a\u0001\u0003gA\u0001B!\u0017\"!\u0003\u0005\r!Y\u0001\fa>dG\u000eV5nK>,H/\u0001\u000etk\n\u001c8M]5cK\u0006sG\rU8mY\u0012\"WMZ1vYR$3'\u0006\u0002\u0003`)\"!\u0011HA$\u0003i\u0019XOY:de&\u0014W-\u00118e!>dG\u000e\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011)G\u000b\u0003\u0003J\u0005\u001d\u0013AG:vEN\u001c'/\u001b2f\u0003:$\u0007k\u001c7mI\u0011,g-Y;mi\u0012*\u0014AG:vEN\u001c'/\u001b2f\u0003:$\u0007k\u001c7mI\u0011,g-Y;mi\u00122TC\u0001B7U\r\t\u0017qI\u0001\u0011o\u0006LGOR8s%\u0016\u0014\u0017\r\\1oG\u0016$\"\"!\u0018\u0003t\tu$\u0011\u0011BB\u0011\u001d\u0011)H\na\u0001\u0005o\n\u0011\u0002^5nK>,H/T:\u0011\u0007\t\u0014I(C\u0002\u0003|\r\u0014A\u0001T8oO\"9!q\u0010\u0014A\u0002\t\u0015\u0012A\u00024viV\u0014X\r\u0003\u0004{M\u0001\u0007!q\u0003\u0005\b\u0005\u000b3\u0003\u0019\u0001BD\u00039yG\u000f[3s\u0007>t7/^7feN\u0004RA\u0019BE\u0003gL1Aa#d\u0005)a$/\u001a9fCR,GMP\u0001\u0019i\u0016\u001cHo\u00117pg\u0016$UO]5oOJ+'-\u00197b]\u000e,\u0007fA\u0014\u0002\b\u0006I2\r[3dW\u000ecwn]3EkJLgn\u001a*fE\u0006d\u0017M\\2f))\tiF!&\u0003\u0018\ne%1\u0014\u0005\b\u0003cC\u0003\u0019AA\u001a\u0011\u0019!\u0006\u00061\u0001\u00024!1!\u0010\u000ba\u0001\u0005/AqA!()\u0001\u0004\u0011y*A\u000ece>\\WM]:Bm\u0006LG.\u00192mK\u0012+(/\u001b8h\u00072|7/\u001a\t\u0004E\n\u0005\u0016b\u0001BRG\n9!i\\8mK\u0006t\u0017!G2sK\u0006$XmQ8ogVlWM],ji\"<%o\\;q\u0013\u0012$B!a=\u0003*\"9\u0011\u0011W\u0015A\u0002\u0005M\u0012\u0001G2sK\u0006$XmQ8ogVlWM]!oIJ+7-Z5wKRA\u00111\u001fBX\u0005c\u0013)\fC\u0004\u00022*\u0002\r!a\r\t\u000f\tM&\u00061\u0001\u0003 \u0006aQ.\u00198vC2\f5o]5h]\"1\u0011Q\u0016\u0016A\u0002\u0005\faB]3dK&4XMU3d_J$7\u000f\u0006\u0005\u0003x\tm&Q\u0018B`\u0011\u001d\tIp\u000ba\u0001\u0003gDa!!,,\u0001\u0004\t\u0007\"\u0003B;WA\u0005\t\u0019\u0001B<\u0003a\u0011XmY3jm\u0016\u0014VmY8sIN$C-\u001a4bk2$HeM\u000b\u0003\u0005\u000bTCAa\u001e\u0002H\u0005\u0019\"/Z2fSZ,W\t_1diJ+7m\u001c:egRA\u0011Q\fBf\u0005\u001b\u0014y\rC\u0004\u0002z6\u0002\r!a=\t\r\u00055V\u00061\u0001b\u0011%\u0011)(\fI\u0001\u0002\u0004\u00119(A\u000fsK\u000e,\u0017N^3Fq\u0006\u001cGOU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003A\u0011XmY3jm\u0016\fe\u000eZ\"p[6LG\u000f\u0006\u0005\u0002^\t]'\u0011\u001cBn\u0011\u001d\tIp\fa\u0001\u0003gDa!!,0\u0001\u0004\t\u0007b\u0002B;_\u0001\u0007!q\u000f\u0015\u0006_\t}'1\u001e\t\u0006E\n\u0005(Q]\u0005\u0004\u0005G\u001c'A\u0002;ie><8\u000f\u0005\u0003\u0002v\n\u001d\u0018\u0002\u0002Bu\u0003o\u0014QcQ8n[&$h)Y5mK\u0012,\u0005pY3qi&|gn\t\u0002\u0003f\u000612/\u001e2nSR\u001cEn\\:f\u0003:$g+\u00197jI\u0006$X\r\u0006\u0006\u0003&\tE(1\u001fB|\u0005{Dq!!?1\u0001\u0004\t\u0019\u0010C\u0004\u0003vB\u0002\rAa\u001e\u0002\u001d\rdwn]3US6,w.\u001e;Ng\"9!\u0011 \u0019A\u0002\tm\u0018AD7j]\u000ecwn]3US6,Wj\u001d\t\u0006E\nm\"q\u000f\u0005\b\u0005\u007f\u0004\u0004\u0019\u0001B~\u00039i\u0017\r_\"m_N,G+[7f\u001bN\f\u0001c\u00195fG.\u001cEn\\:fIN#\u0018\r^3\u0015\r\u0005u3QAB\u0004\u0011\u001d\t\t,\ra\u0001\u0003gAaa!\u00032\u0001\u0004\t\u0017\u0001E2p[6LG\u000f^3e%\u0016\u001cwN\u001d3t\u0005U\u0011u.\u001e8dK\n\u0013xn[3s'\u000eDW\rZ;mKJ\u001c2AMB\b!\rY5\u0011C\u0005\u0004\u0007'a%AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012\f\u0011B\\;n\u0013R,'o\u001d\u0011\u0015\t\re1Q\u0004\t\u0004\u00077\u0011T\"\u0001\u0001\t\r\u0005MU\u00071\u0001b\u0003\u0011IG/\u001a:\u0002\u0011%$XM]0%KF$B!!\u0018\u0004&!A1qE\u001c\u0002\u0002\u0003\u0007\u0011-A\u0002yIE\nQ!\u001b;fe\u0002\na\u0001Z8X_J\\\u0017aC:f]\u0012\u0014VmY8sIN$\"\"!\u0018\u00042\r}2\u0011IB\"\u0011\u001d\u0019\u0019D\u000fa\u0001\u0007k\t\u0001\u0002\u001d:pIV\u001cWM\u001d\t\t\u0007o\u0019YDa\u0001\u0003\u00045\u00111\u0011\b\u0006\u0005\u0007g\tY0\u0003\u0003\u0004>\re\"!D&bM.\f\u0007K]8ek\u000e,'\u000f\u0003\u0004\u0002.j\u0002\r!\u0019\u0005\t)j\u0002\n\u00111\u0001\u00024!I1Q\t\u001e\u0011\u0002\u0003\u00071qI\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\u0011\t\t\u0014Y$Y\u0001\u0016g\u0016tGMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003U\u0019XM\u001c3SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIQ*\"aa\u0014+\t\r\u001d\u0013q\t")
public class ConsumerBounceTest
extends BaseRequestTest {
    private final String topic;
    private final int part;
    private final TopicPartition tp = new TopicPartition(this.topic(), this.part());
    private final int maxGroupSize;
    private final int gracefulCloseTimeMs;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(2);

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public int maxGroupSize() {
        return this.maxGroupSize;
    }

    public int gracefulCloseTimeMs() {
        return this.gracefulCloseTimeMs;
    }

    public ScheduledExecutorService executor() {
        return this.executor;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return this.generateKafkaConfigs(this.generateKafkaConfigs$default$1());
    }

    private Seq<KafkaConfig> generateKafkaConfigs(String maxGroupSize) {
        Properties properties = new Properties();
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.put(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "10");
        properties.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        properties.put(KafkaConfig$.MODULE$.GroupMaxSizeProp(), maxGroupSize);
        properties.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
        properties.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), "false");
        return (Seq)FixedPortTestUtils$.MODULE$.createBrokerConfigs(this.numBrokers(), this.zkConnect(), false, FixedPortTestUtils$.MODULE$.createBrokerConfigs$default$4()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, properties), Seq$.MODULE$.canBuildFrom());
    }

    private String generateKafkaConfigs$default$1() {
        return ((Object)BoxesRunTime.boxToInteger((int)this.maxGroupSize())).toString();
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createTopic(this.topic(), 1, this.numBrokers(), this.createTopic$default$4());
    }

    @Override
    @After
    public void tearDown() {
        try {
            this.executor().shutdownNow();
            Assert.assertTrue((String)"Executor did not terminate", (boolean)this.executor().awaitTermination(5000L, TimeUnit.MILLISECONDS));
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    @Ignore
    public void testConsumptionWithBrokerFailures() {
        this.consumeWithBrokerFailures(10);
    }

    public void consumeWithBrokerFailures(int numIters) {
        int numRecords = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.sendRecords$default$3(), this.sendRecords$default$4());
        LongRef consumed = LongRef.create((long)0L);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe(Collections.singletonList(this.topic()));
        BounceBrokerScheduler scheduler = new BounceBrokerScheduler(this, numIters);
        scheduler.start();
        while (scheduler.isRunning()) {
            Iterable records = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)consumer.poll(100L)).asScala();
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(consumer.assignment()).asScala());
            records.foreach((Function1 & Serializable & scala.Serializable)record -> {
                ConsumerBounceTest.$anonfun$consumeWithBrokerFailures$1(consumed, record);
                return BoxedUnit.UNIT;
            });
            if (!records.nonEmpty()) continue;
            consumer.commitSync();
            Assert.assertEquals((long)consumer.position(this.tp()), (long)consumer.committed(this.tp()).offset());
            if (consumer.position(this.tp()) != (long)numRecords) continue;
            consumer.seekToBeginning(Collections.emptyList());
            consumed.elem = 0L;
        }
        scheduler.shutdown();
    }

    @Test
    public void testSeekAndCommitWithBrokerFailures() {
        this.seekAndCommitWithBrokerFailures(5);
    }

    public void seekAndCommitWithBrokerFailures(int numIters) {
        int numRecords = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.sendRecords$default$3(), this.sendRecords$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign(Collections.singletonList(this.tp()));
        consumer.seek(this.tp(), 0L);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.servers().forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)ConsumerBounceTest.$anonfun$seekAndCommitWithBrokerFailures$2(this, numRecords, server))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to update high watermark for followers after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        BounceBrokerScheduler scheduler = new BounceBrokerScheduler(this, numIters);
        scheduler.start();
        while (scheduler.isRunning()) {
            int coin = TestUtils$.MODULE$.random().nextInt(3);
            if (coin == 0) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Seeking to end of log");
                consumer.seekToEnd(Collections.emptyList());
                Assert.assertEquals((long)numRecords, (long)consumer.position(this.tp()));
                continue;
            }
            if (coin == 1) {
                long pos = TestUtils$.MODULE$.random().nextInt(numRecords);
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("Seeking to ").append(pos).toString());
                consumer.seek(this.tp(), pos);
                Assert.assertEquals((long)pos, (long)consumer.position(this.tp()));
                continue;
            }
            if (coin != 2) continue;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Committing offset.");
            consumer.commitSync();
            Assert.assertEquals((long)consumer.position(this.tp()), (long)consumer.committed(this.tp()).offset());
        }
    }

    @Test
    public void testSubscribeWhenTopicUnavailable() {
        int numRecords = 1000;
        String newtopic = "newtopic";
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe(Collections.singleton(newtopic));
        this.executor().schedule(new Runnable(this, newtopic){
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final String newtopic$1;

            public void run() {
                this.$outer.createTopic(this.newtopic$1, this.$outer.numBrokers(), this.$outer.numBrokers(), this.$outer.createTopic$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newtopic$1 = newtopic$1;
            }
        }, 2L, TimeUnit.SECONDS);
        consumer.poll(0L);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords$1(numRecords, newtopic, producer);
        this.kafka$api$ConsumerBounceTest$$receiveRecords(consumer, numRecords, 10000L);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            this.killBroker(server.config().brokerId());
            return BoxedUnit.UNIT;
        });
        Thread.sleep(500L);
        this.restartDeadBrokers();
        Future<?> future = this.executor().submit(new Runnable(this, consumer, numRecords){
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final KafkaConsumer consumer$1;
            private final int numRecords$2;

            public void run() {
                this.$outer.kafka$api$ConsumerBounceTest$$receiveRecords((KafkaConsumer<byte[], byte[]>)this.consumer$1, this.numRecords$2, 10000L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumer$1 = consumer$1;
                this.numRecords$2 = numRecords$2;
            }
        });
        this.sendRecords$1(numRecords, newtopic, producer);
        future.get();
    }

    @Test
    public void testClose() {
        int numRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.sendRecords$default$3(), this.sendRecords$default$4());
        this.checkCloseGoodPath(numRecords, "group1");
        this.checkCloseWithCoordinatorFailure(numRecords, "group2", "group3");
        this.checkCloseWithClusterFailure(numRecords, "group4", "group5");
    }

    private void checkCloseGoodPath(int numRecords, String groupId) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerAndReceive(groupId, false, numRecords);
        Future<Object> future = this.submitCloseAndValidate(consumer, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.gracefulCloseTimeMs())));
        future.get();
        this.checkClosedState(groupId, numRecords);
    }

    private void checkCloseWithCoordinatorFailure(int numRecords, String dynamicGroup, String manualGroup) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerAndReceive(dynamicGroup, false, numRecords);
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerAndReceive(manualGroup, true, numRecords);
        this.killBroker(this.findCoordinator(dynamicGroup));
        this.killBroker(this.findCoordinator(manualGroup));
        Future<Object> future1 = this.submitCloseAndValidate(consumer1, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.gracefulCloseTimeMs())));
        Future<Object> future2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.gracefulCloseTimeMs())));
        future1.get();
        future2.get();
        this.restartDeadBrokers();
        this.checkClosedState(dynamicGroup, 0);
        this.checkClosedState(manualGroup, numRecords);
    }

    private int findCoordinator(String group) {
        FindCoordinatorRequest request = (FindCoordinatorRequest)new FindCoordinatorRequest.Builder(FindCoordinatorRequest.CoordinatorType.GROUP, group).build();
        ByteBuffer resp = this.connectAndSend((AbstractRequest)request, ApiKeys.FIND_COORDINATOR, this.connectAndSend$default$3(), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        FindCoordinatorResponse response = FindCoordinatorResponse.parse((ByteBuffer)resp, (short)ApiKeys.FIND_COORDINATOR.latestVersion());
        return response.node().id();
    }

    private void checkCloseWithClusterFailure(int numRecords, String group1, String group2) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerAndReceive(group1, false, numRecords);
        int requestTimeout = 6000;
        this.consumerConfig().setProperty("session.timeout.ms", "5000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("request.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)requestTimeout)).toString());
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerAndReceive(group2, true, numRecords);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            this.killBroker(server.config().brokerId());
            return BoxedUnit.UNIT;
        });
        int closeTimeout = 2000;
        Future<Object> future1 = this.submitCloseAndValidate(consumer1, closeTimeout, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)closeTimeout)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)closeTimeout)));
        Future<Object> future2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)requestTimeout)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)requestTimeout)));
        future1.get();
        future2.get();
    }

    @Test
    public void testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup() {
        String topic = "group-max-size-test";
        int maxGroupSize = 2;
        int consumerCount = maxGroupSize + 1;
        IntRef recordsProduced = IntRef.create((int)(maxGroupSize * 100));
        int partitionCount = consumerCount * 2;
        if (recordsProduced.elem % partitionCount != 0) {
            recordsProduced.elem += partitionCount - recordsProduced.elem % partitionCount;
        }
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(consumerCount * 2);
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.createTopic(topic, partitionCount, this.numBrokers(), this.createTopic$default$4());
        ArrayBuffer<KafkaConsumer<byte[], byte[]>> stableConsumers = this.createConsumersWithGroupId("group2", consumerCount, executor, topic);
        this.sendRecords(producer, recordsProduced.elem, topic, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)partitionCount)));
        stableConsumers.foreach((Function1 & Serializable & scala.Serializable)cons -> {
            this.receiveAndCommit((KafkaConsumer<byte[], byte[]>)cons, recordsProduced.elem / consumerCount, 10000L);
            return BoxedUnit.UNIT;
        });
        Seq<KafkaConfig> newConfigs = this.generateKafkaConfigs(((Object)BoxesRunTime.boxToInteger((int)maxGroupSize)).toString());
        AtomicBoolean kickedConsumerOut = new AtomicBoolean(false);
        ObjectRef kickedOutConsumerIdx = ObjectRef.create((Object)None$.MODULE$);
        ReentrantLock lock = new ReentrantLock();
        Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.servers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)broker -> {
            this.killBroker(broker);
            this.sendRecords((KafkaProducer<byte[], byte[]>)producer, recordsProduced$1.elem, topic, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)partitionCount)));
            IntRef successfulConsumes = IntRef.create((int)0);
            ArrayBuffer consumeFutures = new ArrayBuffer();
            ExecutionContextExecutor executorContext = ExecutionContext$.MODULE$.fromExecutor((Executor)executor);
            stableConsumers.indices().foreach((Function1 & Serializable & scala.Serializable)idx -> ConsumerBounceTest.$anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$4(this, stableConsumers, recordsProduced, consumerCount, lock, successfulConsumes, kickedConsumerOut, kickedOutConsumerIdx, executorContext, consumeFutures, BoxesRunTime.unboxToInt((Object)idx)));
            Await$.MODULE$.result((Awaitable)Future$.MODULE$.sequence((TraversableOnce)consumeFutures, ArrayBuffer$.MODULE$.canBuildFrom(), (ExecutionContext)executorContext), Duration$.MODULE$.apply("12sec"));
            if (kickedConsumerOut.get()) {
                Assert.assertEquals((long)maxGroupSize, (long)successfulConsumes.elem);
                throw Breaks$.MODULE$.break();
            }
            KafkaConfig config = (KafkaConfig)newConfigs.apply(broker);
            this.servers().update(broker, (Object)TestUtils$.MODULE$.createServer(config, this.brokerTime(config.brokerId())));
            this.restartDeadBrokers();
        }));
        if (!kickedConsumerOut.get()) {
            throw this.fail(new StringBuilder(48).append("Should have received an ").append(GroupMaxSizeReachedException.class).append(" during the cluster roll").toString(), new Position("ConsumerBounceTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 371));
        }
        stableConsumers.remove(BoxesRunTime.unboxToInt((Object)((Option)kickedOutConsumerIdx.elem).get()));
        this.sendRecords(producer, recordsProduced.elem, topic, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)partitionCount)));
        stableConsumers.foreach((Function1 & Serializable & scala.Serializable)cons -> {
            this.receiveAndCommit((KafkaConsumer<byte[], byte[]>)cons, recordsProduced.elem / maxGroupSize, 10000L);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize() {
        String topic = "group-max-size-test";
        String groupId = "group1";
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(this.maxGroupSize() * 2);
        this.createTopic(topic, this.maxGroupSize(), this.numBrokers(), this.createTopic$default$4());
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        ArrayBuffer<KafkaConsumer<byte[], byte[]>> stableConsumers = this.createConsumersWithGroupId(groupId, this.maxGroupSize(), executor, topic);
        KafkaConsumer<byte[], byte[]> newConsumer = this.createConsumerWithGroupId(groupId);
        BooleanRef failedRebalance = BooleanRef.create((boolean)false);
        ObjectRef exception = ObjectRef.create(null);
        KafkaConsumer<byte[], byte[]> x$1 = newConsumer;
        ScheduledExecutorService x$2 = executor;
        Function1 & Serializable & scala.Serializable x$3 = (Function1 & Serializable & scala.Serializable)e -> {
            ConsumerBounceTest.$anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$1(failedRebalance, exception, e);
            return BoxedUnit.UNIT;
        };
        Option<Semaphore> x$4 = this.subscribeAndPoll$default$3();
        String x$5 = this.subscribeAndPoll$default$5();
        int x$6 = this.subscribeAndPoll$default$6();
        this.waitForRebalance(5000L, this.subscribeAndPoll(x$1, x$2, x$4, (Function1<Exception, BoxedUnit>)x$3, x$5, x$6), executor, (Seq<KafkaConsumer<byte[], byte[]>>)stableConsumers);
        Assert.assertTrue((String)"Rebalance did not fail as expected", (boolean)failedRebalance.elem);
        Assert.assertTrue((boolean)((Exception)exception.elem instanceof GroupMaxSizeReachedException));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.maxGroupSize() * 100, topic, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.maxGroupSize())));
        stableConsumers.foreach((Function1 & Serializable & scala.Serializable)cons -> {
            this.receiveExactRecords((KafkaConsumer<byte[], byte[]>)cons, 100, 10000L);
            return BoxedUnit.UNIT;
        });
    }

    private ArrayBuffer<KafkaConsumer<byte[], byte[]>> createConsumersWithGroupId(String groupId, int consumerCount, ExecutorService executor, String topic) {
        ArrayBuffer stableConsumers = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), consumerCount).foreach((Function1 & Serializable & scala.Serializable)_ -> ConsumerBounceTest.$anonfun$createConsumersWithGroupId$1(this, groupId, executor, topic, stableConsumers, BoxesRunTime.unboxToInt((Object)_)));
        return stableConsumers;
    }

    private String createConsumersWithGroupId$default$4() {
        return this.topic();
    }

    public Future<Object> subscribeAndPoll(KafkaConsumer<byte[], byte[]> consumer, ExecutorService executor, Option<Semaphore> revokeSemaphore, Function1<Exception, BoxedUnit> onException, String topic, int pollTimeout) {
        return executor.submit(CoreUtils$.MODULE$.runnable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try {
                consumer.subscribe(Collections.singletonList(topic));
                consumer.poll(Duration.ofMillis(pollTimeout));
            }
            catch (Exception e) {
                onException.apply((Object)e);
            }
        }), BoxesRunTime.boxToInteger((int)0));
    }

    public Option<Semaphore> subscribeAndPoll$default$3() {
        return None$.MODULE$;
    }

    public Function1<Exception, BoxedUnit> subscribeAndPoll$default$4() {
        return (Function1 & Serializable & scala.Serializable)e -> {
            throw e;
        };
    }

    public String subscribeAndPoll$default$5() {
        return this.topic();
    }

    public int subscribeAndPoll$default$6() {
        return 1000;
    }

    public void waitForRebalance(long timeoutMs, Future<Object> future, ExecutorService executor, Seq<KafkaConsumer<byte[], byte[]>> otherConsumers) {
        long startMs = System.currentTimeMillis();
        ExecutionContextExecutor executorContext = ExecutionContext$.MODULE$.fromExecutor((Executor)executor);
        while (System.currentTimeMillis() < startMs + timeoutMs && !future.isDone()) {
            Seq consumeFutures = (Seq)otherConsumers.map((Function1 & Serializable & scala.Serializable)consumer -> Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> consumer.poll(Duration.ofMillis(1000L)), (ExecutionContext)executorContext), Seq$.MODULE$.canBuildFrom());
            Await$.MODULE$.result((Awaitable)Future$.MODULE$.sequence((TraversableOnce)consumeFutures, Seq$.MODULE$.canBuildFrom(), (ExecutionContext)executorContext), Duration$.MODULE$.apply("1500ms"));
        }
        Assert.assertTrue((String)"Rebalance did not complete in time", (boolean)future.isDone());
    }

    @Test
    public void testCloseDuringRebalance() {
        String topic = "closetest";
        this.createTopic(topic, 10, this.numBrokers(), this.createTopic$default$4());
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.checkCloseDuringRebalance("group1", topic, this.executor(), true);
    }

    private void checkCloseDuringRebalance(String groupId, String topic, ExecutorService executor, boolean brokersAvailableDuringClose) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerWithGroupId(groupId);
        ConsumerBounceTest.waitForRebalance$1(2000L, ConsumerBounceTest.subscribeAndPoll$1(consumer1, ConsumerBounceTest.subscribeAndPoll$default$2$1(), executor, topic), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[0]));
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerWithGroupId(groupId);
        ConsumerBounceTest.waitForRebalance$1(2000L, ConsumerBounceTest.subscribeAndPoll$1(consumer2, ConsumerBounceTest.subscribeAndPoll$default$2$1(), executor, topic), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[]{consumer1}));
        Future rebalanceFuture = this.createConsumerToRebalance$1(groupId, executor, topic);
        Future<Object> closeFuture1 = this.submitCloseAndValidate(consumer1, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.gracefulCloseTimeMs())));
        ConsumerBounceTest.waitForRebalance$1(2000L, rebalanceFuture, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[]{consumer2}));
        this.createConsumerToRebalance$1(groupId, executor, topic);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            this.killBroker(server.config().brokerId());
            return BoxedUnit.UNIT;
        });
        Future<Object> closeFuture2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        closeFuture1.get(2000L, TimeUnit.MILLISECONDS);
        closeFuture2.get(2000L, TimeUnit.MILLISECONDS);
    }

    private KafkaConsumer<byte[], byte[]> createConsumerWithGroupId(String groupId) {
        this.consumerConfig().setProperty("group.id", groupId);
        return this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
    }

    private KafkaConsumer<byte[], byte[]> createConsumerAndReceive(String groupId, boolean manualAssign, int numRecords) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerWithGroupId(groupId);
        if (manualAssign) {
            consumer.assign(Collections.singleton(this.tp()));
        } else {
            consumer.subscribe(Collections.singleton(this.topic()));
        }
        this.receiveExactRecords(consumer, numRecords, this.receiveExactRecords$default$3());
        return consumer;
    }

    public long kafka$api$ConsumerBounceTest$$receiveRecords(KafkaConsumer<byte[], byte[]> consumer, int numRecords, long timeoutMs) {
        long received;
        long endTimeMs = System.currentTimeMillis() + timeoutMs;
        for (received = 0L; received < (long)numRecords && System.currentTimeMillis() < endTimeMs; received += (long)consumer.poll(Duration.ofMillis(100L)).count()) {
        }
        return received;
    }

    private long receiveRecords$default$3() {
        return 60000L;
    }

    private void receiveExactRecords(KafkaConsumer<byte[], byte[]> consumer, int numRecords, long timeoutMs) {
        long received = this.kafka$api$ConsumerBounceTest$$receiveRecords(consumer, numRecords, timeoutMs);
        Assert.assertEquals((long)numRecords, (long)received);
    }

    private long receiveExactRecords$default$3() {
        return 60000L;
    }

    private void receiveAndCommit(KafkaConsumer<byte[], byte[]> consumer, int numRecords, long timeoutMs) throws CommitFailedException {
        long received = this.kafka$api$ConsumerBounceTest$$receiveRecords(consumer, numRecords, timeoutMs);
        Assert.assertTrue((String)new StringBuilder(29).append("Received ").append(received).append(", expected at least ").append(numRecords).toString(), ((long)numRecords <= received ? 1 : 0) != 0);
        consumer.commitSync();
    }

    private Future<Object> submitCloseAndValidate(KafkaConsumer<byte[], byte[]> consumer, long closeTimeoutMs, Option<Object> minCloseTimeMs, Option<Object> maxCloseTimeMs) {
        return this.executor().submit(CoreUtils$.MODULE$.runnable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int closeGraceTimeMs = 2000;
            long startNanos = System.nanoTime();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Closing consumer with timeout ").append(closeTimeoutMs).append(" ms.").toString());
            consumer.close(closeTimeoutMs, TimeUnit.MILLISECONDS);
            long timeTakenMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
            maxCloseTimeMs.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)ms -> Assert.assertTrue((String)new StringBuilder(20).append("Close took too long ").append(timeTakenMs).toString(), (timeTakenMs < ms + (long)closeGraceTimeMs ? 1 : 0) != 0));
            minCloseTimeMs.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)ms -> Assert.assertTrue((String)new StringBuilder(27).append("Close finished too quickly ").append(timeTakenMs).toString(), (timeTakenMs >= ms ? 1 : 0) != 0));
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("consumer.close() completed in ").append(timeTakenMs).append(" ms.").toString());
        }), BoxesRunTime.boxToInteger((int)0));
    }

    private void checkClosedState(String groupId, int committedRecords) {
        Semaphore assignSemaphore = new Semaphore(0);
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerWithGroupId(groupId);
        consumer.subscribe(Collections.singletonList(this.topic()), new ConsumerRebalanceListener(null, assignSemaphore){
            private final Semaphore assignSemaphore$1;

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.assignSemaphore$1.release();
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.assignSemaphore$1 = assignSemaphore$1;
            }
        });
        consumer.poll(3000L);
        Assert.assertTrue((String)"Assignment did not complete on time", (boolean)assignSemaphore.tryAcquire(1L, TimeUnit.SECONDS));
        if (committedRecords > 0) {
            Assert.assertEquals((long)committedRecords, (long)consumer.committed(this.tp()).offset());
        }
        consumer.close();
    }

    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, String topic, Option<Object> numPartitions) {
        IntRef partitionIndex = IntRef.create((int)0);
        IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(this.getPartition$1(numPartitions, partitionIndex)), (Object)((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))).toString().getBytes(), (Object)((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))).toString().getBytes())), IndexedSeq$.MODULE$.canBuildFrom());
        futures.map((Function1 & Serializable & scala.Serializable)x$2 -> (RecordMetadata)x$2.get(), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private String sendRecords$default$3() {
        return this.topic();
    }

    private Option<Object> sendRecords$default$4() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$consumeWithBrokerFailures$1(LongRef consumed$1, ConsumerRecord record) {
        Assert.assertEquals((long)consumed$1.elem, (long)record.offset());
        ++consumed$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$seekAndCommitWithBrokerFailures$2(ConsumerBounceTest $this, int numRecords$1, KafkaServer server) {
        return ((Replica)server.replicaManager().localReplica($this.tp()).get()).highWatermark().messageOffset() == (long)numRecords$1;
    }

    public static final /* synthetic */ void $anonfun$testSubscribeWhenTopicUnavailable$2(IntRef remainingRecords$1, Future future) {
        try {
            future.get();
            --remainingRecords$1.elem;
        }
        catch (Exception exception) {}
    }

    private final void sendRecords$1(int numRecords, String topic, KafkaProducer producer$1) {
        IntRef remainingRecords = IntRef.create((int)numRecords);
        long endTimeMs = System.currentTimeMillis() + 20000L;
        while (remainingRecords.elem > 0 && System.currentTimeMillis() < endTimeMs) {
            IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), remainingRecords.elem).map((Function1 & Serializable & scala.Serializable)i -> producer$1.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(this.part()), (Object)((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))).toString().getBytes(), (Object)((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))).toString().getBytes())), IndexedSeq$.MODULE$.canBuildFrom());
            futures.map((Function1 & Serializable & scala.Serializable)future -> {
                ConsumerBounceTest.$anonfun$testSubscribeWhenTopicUnavailable$2(remainingRecords, future);
                return BoxedUnit.UNIT;
            }, IndexedSeq$.MODULE$.canBuildFrom());
        }
        Assert.assertEquals((long)0L, (long)remainingRecords.elem);
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$4(ConsumerBounceTest $this, ArrayBuffer stableConsumers$1, IntRef recordsProduced$1, int consumerCount$1, ReentrantLock lock$1, IntRef successfulConsumes$1, AtomicBoolean kickedConsumerOut$1, ObjectRef kickedOutConsumerIdx$1, ExecutionContextExecutor executorContext$1, ArrayBuffer consumeFutures$1, int idx) {
        KafkaConsumer currentConsumer = (KafkaConsumer)stableConsumers$1.apply(idx);
        scala.concurrent.Future consumeFuture = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try {
                $this.receiveAndCommit((KafkaConsumer<byte[], byte[]>)currentConsumer, recordsProduced$1.elem / consumerCount$1, 10000L);
                CoreUtils$.MODULE$.inLock((Lock)lock$1, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ++successfulConsumes$1.elem);
            }
            catch (Throwable e) {
                if (!(e instanceof GroupMaxSizeReachedException)) {
                    throw e;
                }
                if (!kickedConsumerOut$1.compareAndSet(false, true)) {
                    throw $this.fail(new StringBuilder(23).append("Received more than one ").append(GroupMaxSizeReachedException.class).toString(), new Position("ConsumerBounceTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
                }
                kickedOutConsumerIdx$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)idx));
            }
        }, (ExecutionContext)executorContext$1);
        return consumeFutures$1.$plus$eq((Object)consumeFuture);
    }

    public static final /* synthetic */ void $anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$1(BooleanRef failedRebalance$1, ObjectRef exception$1, Exception e) {
        failedRebalance$1.elem = true;
        exception$1.elem = e;
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$createConsumersWithGroupId$1(ConsumerBounceTest $this, String groupId$1, ExecutorService executor$2, String topic$3, ArrayBuffer stableConsumers$2, int _) {
        KafkaConsumer<byte[], byte[]> newConsumer;
        KafkaConsumer<byte[], byte[]> x$1 = newConsumer = $this.createConsumerWithGroupId(groupId$1);
        ExecutorService x$2 = executor$2;
        String x$3 = topic$3;
        Option<Semaphore> x$4 = $this.subscribeAndPoll$default$3();
        Function1<Exception, BoxedUnit> x$5 = $this.subscribeAndPoll$default$4();
        int x$6 = $this.subscribeAndPoll$default$6();
        $this.waitForRebalance(5000L, $this.subscribeAndPoll(x$1, x$2, x$4, x$5, x$3, x$6), executor$2, (Seq<KafkaConsumer<byte[], byte[]>>)stableConsumers$2);
        return stableConsumers$2.$plus$eq(newConsumer);
    }

    private static final Future subscribeAndPoll$1(KafkaConsumer consumer, Option revokeSemaphore, ExecutorService executor$3, String topic$5) {
        return executor$3.submit(CoreUtils$.MODULE$.runnable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            consumer.subscribe(Collections.singletonList(topic$5), new ConsumerRebalanceListener(null, revokeSemaphore){
                private final Option revokeSemaphore$1;

                public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                }

                public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                    this.revokeSemaphore$1.foreach((Function1 & Serializable & scala.Serializable)s -> {
                        $anon$3.$anonfun$onPartitionsRevoked$1(s);
                        return BoxedUnit.UNIT;
                    });
                }

                public static final /* synthetic */ void $anonfun$onPartitionsRevoked$1(Semaphore s) {
                    s.release();
                }
                {
                    this.revokeSemaphore$1 = revokeSemaphore$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onPartitionsRevoked$1$adapted(java.util.concurrent.Semaphore )}, serializedLambda);
                }
            });
            consumer.poll(0L);
        }), BoxesRunTime.boxToInteger((int)0));
    }

    private static final Option subscribeAndPoll$default$2$1() {
        return None$.MODULE$;
    }

    private static final void waitForRebalance$1(long timeoutMs, Future future, Seq otherConsumers) {
        long startMs = System.currentTimeMillis();
        while (System.currentTimeMillis() < startMs + timeoutMs && !future.isDone()) {
            otherConsumers.foreach((Function1 & Serializable & scala.Serializable)consumer -> consumer.poll(100L));
        }
        Assert.assertTrue((String)"Rebalance did not complete in time", (boolean)future.isDone());
    }

    private final Future createConsumerToRebalance$1(String groupId$2, ExecutorService executor$3, String topic$5) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerWithGroupId(groupId$2);
        Semaphore rebalanceSemaphore = new Semaphore(0);
        Future future = ConsumerBounceTest.subscribeAndPoll$1(consumer, (Option)new Some((Object)rebalanceSemaphore), executor$3, topic$5);
        Assert.assertTrue((String)"Rebalance not triggered", (boolean)rebalanceSemaphore.tryAcquire(2000L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((String)"Rebalance completed too early", (boolean)future.isDone());
        return future;
    }

    private final int getPartition$1(Option numPartitions$1, IntRef partitionIndex$1) {
        int n;
        Option option = numPartitions$1;
        if (option instanceof Some) {
            Some some = (Some)option;
            int partitions = BoxesRunTime.unboxToInt((Object)some.value());
            int nextPart = partitionIndex$1.elem % partitions;
            ++partitionIndex$1.elem;
            n = nextPart;
        } else if (None$.MODULE$.equals(option)) {
            n = this.part();
        } else {
            throw new MatchError((Object)option);
        }
        return n;
    }

    public ConsumerBounceTest() {
        this.topic = "topic";
        this.part = 0;
        this.maxGroupSize = 5;
        this.gracefulCloseTimeMs = 1000;
    }

    public class BounceBrokerScheduler
    extends ShutdownableThread {
        private final int numIters;
        private int iter;
        public final /* synthetic */ ConsumerBounceTest $outer;

        public int numIters() {
            return this.numIters;
        }

        public int iter() {
            return this.iter;
        }

        public void iter_$eq(int x$1) {
            this.iter = x$1;
        }

        public void doWork() {
            this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().killRandomBroker();
            Thread.sleep(500L);
            this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().restartDeadBrokers();
            this.iter_$eq(this.iter() + 1);
            if (this.iter() == this.numIters()) {
                this.initiateShutdown();
            } else {
                Thread.sleep(500L);
            }
        }

        public /* synthetic */ ConsumerBounceTest kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer() {
            return this.$outer;
        }

        public BounceBrokerScheduler(ConsumerBounceTest $outer, int numIters) {
            this.numIters = numIters;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("daemon-bounce-broker", false);
            this.iter = 0;
        }
    }
}

