/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareTest;
import kafka.admin.ReplicaDistributions;
import kafka.admin.TopicCommand;
import kafka.server.ConfigType$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.DeleteTopicsTopicZNode$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.scalactic.source.Position;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001\u0002\u0015*\u00019BQa\u0010\u0001\u0005\u0002\u0001C\u0011B\u0011\u0001A\u0002\u0003\u0007I\u0011B\"\t\u0013I\u0003\u0001\u0019!a\u0001\n\u0013\u0019\u0006\"\u0003/\u0001\u0001\u0004\u0005\t\u0015)\u0003E\u0011%i\u0006\u00011AA\u0002\u0013%a\fC\u0005h\u0001\u0001\u0007\t\u0019!C\u0005Q\"I!\u000e\u0001a\u0001\u0002\u0003\u0006Ka\u0018\u0005\bW\u0002\u0011\r\u0011\"\u0003m\u0011\u00199\b\u0001)A\u0005[\")\u0001\u0010\u0001C\u0001Y\")a\u0010\u0001C\u0001\u007f\"1\u0011\u0011\u0002\u0001\u0005\u0002}Da!a\u0005\u0001\t\u0003y\bBBA\u000f\u0001\u0011\u0005q\u0010\u0003\u0004\u0002\"\u0001!\ta \u0005\u0007\u0003K\u0001A\u0011A@\t\r\u0005%\u0002\u0001\"\u0001\u0000\u0011\u0019\ti\u0003\u0001C\u0001\u007f\"1\u0011\u0011\u0007\u0001\u0005\u0002}Da!!\u000e\u0001\t\u0003y\bBBA\u001d\u0001\u0011\u0005q\u0010\u0003\u0004\u0002>\u0001!\ta \u0005\u0007\u0003\u0003\u0002A\u0011A@\t\r\u0005\u0015\u0003\u0001\"\u0001\u0000\u0011\u0019\tI\u0005\u0001C\u0001\u007f\"1\u0011Q\n\u0001\u0005\u0002}Da!!\u0015\u0001\t\u0003y\bBBA+\u0001\u0011\u0005q\u0010\u0003\u0004\u0002Z\u0001!\ta \u0005\u0007\u0003;\u0002A\u0011A@\t\r\u0005\u0005\u0004\u0001\"\u0001\u0000\u0011\u0019\t)\u0007\u0001C\u0001\u007f\"1\u0011\u0011\u000e\u0001\u0005\u0002}Da!!\u001c\u0001\t\u0003y\bBBA9\u0001\u0011\u0005q\u0010\u0003\u0004\u0002v\u0001!\ta \u0005\u0007\u0003s\u0002A\u0011A@\t\r\u0005u\u0004\u0001\"\u0001\u0000\u0011\u0019\t\t\t\u0001C\u0001\u007f\n\u0001Bk\u001c9jG\u000e{W.\\1oIR+7\u000f\u001e\u0006\u0003U-\nQ!\u00193nS:T\u0011\u0001L\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001q&N\u001e\u0011\u0005A\u001aT\"A\u0019\u000b\u0005IZ\u0013A\u0001>l\u0013\t!\u0014G\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o\u001d\t\u0003mej\u0011a\u000e\u0006\u0003q-\nQ!\u001e;jYNL!AO\u001c\u0003\u000f1{wmZ5oOB\u0011A(P\u0007\u0002S%\u0011a(\u000b\u0002\u000e%\u0006\u001c7.Q<be\u0016$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005\t\u0005C\u0001\u001f\u0001\u00031!x\u000e]5d'\u0016\u0014h/[2f+\u0005!\u0005CA#P\u001d\t1UJ\u0004\u0002H\u0019:\u0011\u0001jS\u0007\u0002\u0013*\u0011!*L\u0001\u0007yI|w\u000e\u001e \n\u00031J!AK\u0016\n\u00059K\u0013\u0001\u0004+pa&\u001c7i\\7nC:$\u0017B\u0001)R\u0005UQvn\\6fKB,'\u000fV8qS\u000e\u001cVM\u001d<jG\u0016T!AT\u0015\u0002!Q|\u0007/[2TKJ4\u0018nY3`I\u0015\fHC\u0001+[!\t)\u0006,D\u0001W\u0015\u00059\u0016!B:dC2\f\u0017BA-W\u0005\u0011)f.\u001b;\t\u000fm\u001b\u0011\u0011!a\u0001\t\u0006\u0019\u0001\u0010J\u0019\u0002\u001bQ|\u0007/[2TKJ4\u0018nY3!\u00035!Xm\u001d;U_BL7MT1nKV\tq\f\u0005\u0002aI:\u0011\u0011M\u0019\t\u0003\u0011ZK!a\u0019,\u0002\rA\u0013X\rZ3g\u0013\t)gM\u0001\u0004TiJLgn\u001a\u0006\u0003GZ\u000b\u0011\u0003^3tiR{\u0007/[2OC6,w\fJ3r)\t!\u0016\u000eC\u0004\\\r\u0005\u0005\t\u0019A0\u0002\u001dQ,7\u000f\u001e+pa&\u001cg*Y7fA\u0005Iq\f^3ti:\u000bW.Z\u000b\u0002[B\u0011a.^\u0007\u0002_*\u0011\u0001/]\u0001\u0006eVdWm\u001d\u0006\u0003eN\fQA[;oSRT\u0011\u0001^\u0001\u0004_J<\u0017B\u0001<p\u0005!!Vm\u001d;OC6,\u0017AC0uKN$h*Y7fA\u0005AA/Z:u\u001d\u0006lW\r\u000b\u0002\u000buB\u00111\u0010`\u0007\u0002c&\u0011Q0\u001d\u0002\u0005%VdW-A\u0003tKR,\b\u000fF\u0001UQ\rY\u00111\u0001\t\u0004w\u0006\u0015\u0011bAA\u0004c\n1!)\u001a4pe\u0016\f\u0001\u0002^3be\u0012|wO\u001c\u0015\u0004\u0019\u00055\u0001cA>\u0002\u0010%\u0019\u0011\u0011C9\u0003\u000b\u00053G/\u001a:\u0002\u0015Q,7\u000f^\"sK\u0006$X\rK\u0002\u000e\u0003/\u00012a_A\r\u0013\r\tY\"\u001d\u0002\u0005)\u0016\u001cH/A\u000buKN$8I]3bi\u0016<\u0016\u000e\u001e5D_:4\u0017nZ:)\u00079\t9\"A\u000buKN$8I]3bi\u0016LeMT8u\u000bbL7\u000f^:)\u0007=\t9\"A\u0010uKN$8I]3bi\u0016<\u0016\u000e\u001e5SKBd\u0017nY1BgNLwM\\7f]RD3\u0001EA\f\u0003\u0019\"Xm\u001d;De\u0016\fG/Z,ji\"LeN^1mS\u0012\u0014V\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\u0015\u0004#\u0005]\u0011a\n;fgR\u001c%/Z1uK^KG\u000f\u001b(fO\u0006$\u0018N^3SKBd\u0017nY1uS>tg)Y2u_JD3AEA\f\u0003\u0011\"Xm\u001d;De\u0016\fG/Z,ji\"tUmZ1uSZ,\u0007+\u0019:uSRLwN\\\"pk:$\bfA\n\u0002\u0018\u0005YB/Z:u\u0013:4\u0018\r\\5e)>\u0004\u0018n\u0019'fm\u0016d7i\u001c8gS\u001eD3\u0001FA\f\u00039!Xm\u001d;MSN$Hk\u001c9jGND3!FA\f\u0003m!Xm\u001d;MSN$Hk\u001c9jGN<\u0016\u000e\u001e5XQ&$X\r\\5ti\"\u001aa#a\u0006\u0002CQ,7\u000f\u001e'jgR$v\u000e]5dg^KG\u000f[#yG2,H-Z%oi\u0016\u0014h.\u00197)\u0007]\t9\"A\fuKN$\u0018\t\u001c;feB\u000b'\u000f^5uS>t7i\\;oi\"\u001a\u0001$a\u0006\u0002'Q,7\u000f^!mi\u0016\u0014\u0018i]:jO:lWM\u001c;)\u0007e\t9\"\u0001\u0012uKN$\u0018\t\u001c;fe^KG\u000f[%om\u0006d\u0017\u000e\u001a)beRLG/[8o\u0007>,h\u000e\u001e\u0015\u00045\u0005]\u0011!\u0005;fgR\fE\u000e^3s\u0013\u001a,\u00050[:ug\"\u001a1$a\u0006\u0002!Q,7\u000f^!mi\u0016\u00148i\u001c8gS\u001e\u001c\bf\u0001\u000f\u0002\u0018\u0005yC/Z:u\u0007>tg-[4Qe\u0016\u001cXM\u001d<bi&|g.Q2s_N\u001c\b+\u0019:uSRLwN\\!mi\u0016\u0014\u0018\r^5p]\"\u001aQ$a\u0006\u0002#Q,7\u000f\u001e+pa&\u001cG)\u001a7fi&|g\u000eK\u0002\u001f\u0003/\t!\u0003^3ti\u0012+G.\u001a;f\u0013\u001a,\u00050[:ug\"\u001aq$a\u0006\u0002/Q,7\u000f\u001e#fY\u0016$X-\u00138uKJt\u0017\r\u001c+pa&\u001c\u0007f\u0001\u0011\u0002\u0018\u0005aB/Z:u\t\u0016\u001c8M]5cK&3Gk\u001c9jG:{G/\u0012=jgR\u001c\bfA\u0011\u0002\u0018\u0005\tC/Z:u\u0007J,\u0017\r^3BYR,'\u000fV8qS\u000e<\u0016\u000e\u001e5SC\u000e\\\u0017i^1sK\"\u001a!%a\u0006\u0002\u0019Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3)\u0007\r\n9\"A\u0012uKN$H)Z:de&\u0014WMU3q_J$xJ^3se&$G-\u001a8D_:4\u0017nZ:)\u0007\u0011\n9\"\u0001\u0016uKN$H)Z:de&\u0014W-\u00118e\u0019&\u001cH\u000fV8qS\u000e\u001cX*\u0019:lK\u00124uN\u001d#fY\u0016$\u0018n\u001c8)\u0007\u0015\n9\"\u0001\u0018uKN$H)Z:de&\u0014W-\u00118e\u0019&\u001cH\u000fV8qS\u000e\u001cx+\u001b;i_V$\u0018J\u001c;fe:\fG\u000eV8qS\u000e\u001c\bf\u0001\u0014\u0002\u0018\u0005iC/Z:u)>\u0004\u0018nY(qKJ\fG/[8og^KG\u000f\u001b*fO\u0016D8+_7c_2Le\u000eV8qS\u000et\u0015-\\3)\u0007\u001d\n9\u0002")
public class TopicCommandTest
extends ZooKeeperTestHarness
implements RackAwareTest {
    private TopicCommand.ZookeeperTopicService topicService;
    private String testTopicName;
    private final TestName _testName;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest.checkReplicaDistribution$(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest.checkReplicaDistribution$default$6$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest.checkReplicaDistribution$default$7$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest.checkReplicaDistribution$default$8$(this);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest.getReplicaDistribution$(this, assignment, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest.toBrokerMetadata$(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest.toBrokerMetadata$default$2$(this);
    }

    private TopicCommand.ZookeeperTopicService topicService() {
        return this.topicService;
    }

    private void topicService_$eq(TopicCommand.ZookeeperTopicService x$1) {
        this.topicService = x$1;
    }

    private String testTopicName() {
        return this.testTopicName;
    }

    private void testTopicName_$eq(String x$1) {
        this.testTopicName = x$1;
    }

    private TestName _testName() {
        return this._testName;
    }

    @Rule
    public TestName testName() {
        return this._testName();
    }

    @Before
    public void setup() {
        this.topicService_$eq(new TopicCommand.ZookeeperTopicService(this.zkClient()));
        this.testTopicName_$eq(new StringBuilder(1).append(this.testName().getMethodName()).append("-").append(Random$.MODULE$.alphanumeric().take(10).mkString()).toString());
    }

    @After
    public void teardown() {
        block0: {
            if (this.topicService() == null) break block0;
            this.topicService().close();
        }
    }

    @Test
    public void testCreate() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "1", "--topic", this.testTopicName()})));
        Assert.assertTrue((boolean)this.zkClient().getAllTopicsInCluster().contains((Object)this.testTopicName()));
    }

    @Test
    public void testCreateWithConfigs() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName());
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", configResource.name(), "--config", "delete.retention.ms=1000"})));
        Properties configs = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)1000), (Object)Integer.valueOf(configs.getProperty("delete.retention.ms")));
    }

    @Test
    public void testCreateIfNotExists() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        int numPartitions = 1;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString(), "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.topicService().createTopic(createOpts);
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(createOpts), ClassTag$.MODULE$.apply(TopicExistsException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        TopicCommand.TopicCommandOptions createNotExistsOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString(), "--replication-factor", "1", "--topic", this.testTopicName(), "--if-not-exists"}));
        this.topicService().createTopic(createNotExistsOpts);
    }

    @Test
    public void testCreateWithReplicaAssignment() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--replica-assignment", "5:4,3:2,1:0", "--topic", this.testTopicName()}));
        this.topicService().createTopic(createOpts);
        Seq replicas0 = this.zkClient().getReplicasForPartition(new TopicPartition(this.testTopicName(), 0));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 4})), (Object)replicas0);
        Seq replicas1 = this.zkClient().getReplicasForPartition(new TopicPartition(this.testTopicName(), 1));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2})), (Object)replicas1);
        Seq replicas2 = this.zkClient().getReplicasForPartition(new TopicPartition(this.testTopicName(), 2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})), (Object)replicas2);
    }

    @Test
    public void testCreateWithInvalidReplicationFactor() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", ((Object)BoxesRunTime.boxToInteger((int)32768)).toString(), "--topic", this.testTopicName()}))), ClassTag$.MODULE$.apply(InvalidReplicationFactorException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
    }

    @Test
    public void testCreateWithNegativeReplicationFactor() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "-1", "--topic", this.testTopicName()}))), ClassTag$.MODULE$.apply(InvalidReplicationFactorException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
    }

    @Test
    public void testCreateWithNegativePartitionCount() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "-1", "--replication-factor", "1", "--topic", this.testTopicName()}))), ClassTag$.MODULE$.apply(InvalidPartitionsException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
    }

    @Test
    public void testInvalidTopicLevelConfig() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName(), "--config", "message.timestamp.type=boom"}));
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(createOpts), ClassTag$.MODULE$.apply(ConfigException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
        TopicCommand.TopicCommandOptions createOpts2 = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName(), "--config", "message.format.version=boom"}));
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(createOpts2), ClassTag$.MODULE$.apply(ConfigException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
    }

    @Test
    public void testListTopics() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        String topic = "testTopic";
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)))));
        Assert.assertTrue((boolean)output.contains(this.testTopicName()));
    }

    @Test
    public void testListTopicsWithWhitelist() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        String topic1 = "kafka.testTopic1";
        String topic2 = "kafka.testTopic2";
        String topic3 = "oooof.testTopic1";
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = topic1;
        int x$2 = 2;
        int x$3 = 2;
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        AdminZkClient qual$2 = this.adminZkClient();
        String x$6 = topic2;
        int x$7 = 2;
        int x$8 = 2;
        Properties x$9 = qual$2.createTopic$default$4();
        RackAwareMode x$10 = qual$2.createTopic$default$5();
        qual$2.createTopic(x$6, x$7, x$8, x$9, x$10);
        AdminZkClient qual$3 = this.adminZkClient();
        String x$11 = topic3;
        int x$12 = 2;
        int x$13 = 2;
        Properties x$14 = qual$3.createTopic$default$4();
        RackAwareMode x$15 = qual$3.createTopic$default$5();
        qual$3.createTopic(x$11, x$12, x$13, x$14, x$15);
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "kafka.*"}))));
        Assert.assertTrue((boolean)output.contains(topic1));
        Assert.assertTrue((boolean)output.contains(topic2));
        Assert.assertFalse((boolean)output.contains(topic3));
    }

    @Test
    public void testListTopicsWithExcludeInternal() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = this.testTopicName();
        int x$2 = 2;
        int x$3 = 2;
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        AdminZkClient qual$2 = this.adminZkClient();
        String x$6 = "__consumer_offsets";
        int x$7 = 2;
        int x$8 = 2;
        Properties x$9 = qual$2.createTopic$default$4();
        RackAwareMode x$10 = qual$2.createTopic$default$5();
        qual$2.createTopic(x$6, x$7, x$8, x$9, x$10);
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--exclude-internal"}))));
        Assert.assertTrue((boolean)output.contains(this.testTopicName()));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    @Test
    public void testAlterPartitionCount() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = this.testTopicName();
        int x$2 = 2;
        int x$3 = 2;
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "3"})));
        Assert.assertEquals((long)3L, (long)((SeqLike)this.zkClient().getPartitionsForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()}))).apply((Object)this.testTopicName())).size());
    }

    @Test
    public void testAlterAssignment() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = this.testTopicName();
        int x$2 = 2;
        int x$3 = 2;
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "3"})));
        Seq replicas0 = this.zkClient().getReplicasForPartition(new TopicPartition(this.testTopicName(), 2));
        Assert.assertEquals((long)3L, (long)((SeqLike)this.zkClient().getPartitionsForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()}))).apply((Object)this.testTopicName())).size());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2})), (Object)replicas0);
    }

    @Test
    public void testAlterWithInvalidPartitionCount() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "-1", "--topic", this.testTopicName()}))), ClassTag$.MODULE$.apply(InvalidPartitionsException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
    }

    @Test
    public void testAlterIfExists() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "1"}));
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().alterTopic(alterOpts), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
        TopicCommand.TopicCommandOptions alterExistsOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "1", "--if-exists"}));
        this.topicService().alterTopic(alterExistsOpts);
    }

    @Test
    public void testAlterConfigs() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--config", "cleanup.policy=compact"})));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}))));
        Assert.assertTrue((String)"The output should contain the modified config", (boolean)output.contains("Configs:cleanup.policy=compact"));
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--config", "cleanup.policy=delete"})));
        String output2 = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}))));
        Assert.assertTrue((String)"The output should contain the modified config", (boolean)output2.contains("Configs:cleanup.policy=delete"));
    }

    @Test
    public void testConfigPreservationAcrossPartitionAlteration() {
        int numPartitionsOriginal = 1;
        String cleanupKey = "cleanup.policy";
        String cleanupVal = "compact";
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsOriginal)).toString(), "--replication-factor", "1", "--config", new StringBuilder(1).append(cleanupKey).append("=").append(cleanupVal).toString(), "--topic", this.testTopicName()}));
        this.topicService().createTopic(createOpts);
        Properties props = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assert.assertTrue((String)new StringBuilder(40).append("Properties after creation don't contain ").append(cleanupKey).toString(), (boolean)props.containsKey(cleanupKey));
        Assert.assertTrue((String)"Properties after creation have incorrect value", (boolean)props.getProperty(cleanupKey).equals(cleanupVal));
        this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        int numPartitionsModified = 3;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsModified)).toString(), "--topic", this.testTopicName()}));
        this.topicService().alterTopic(alterOpts);
        Properties newProps = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assert.assertTrue((String)new StringBuilder(34).append("Updated properties do not contain ").append(cleanupKey).toString(), (boolean)newProps.containsKey(cleanupKey));
        Assert.assertTrue((String)"Updated properties have incorrect value", (boolean)newProps.getProperty(cleanupKey).equals(cleanupVal));
    }

    @Test
    public void testTopicDeletion() {
        int numPartitionsOriginal = 1;
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsOriginal)).toString(), "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.topicService().createTopic(createOpts);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}));
        String deletePath = DeleteTopicsTopicZNode$.MODULE$.path(this.testTopicName());
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deletePath));
        this.topicService().deleteTopic(deleteOpts);
        Assert.assertTrue((String)"Delete path for topic should exist after deletion.", (boolean)this.zkClient().pathExists(deletePath));
        TopicCommand.TopicCommandOptions createOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsOriginal)).toString(), "--replication-factor", "1", "--topic", "__consumer_offsets"}));
        this.topicService().createTopic(createOffsetTopicOpts);
        TopicCommand.TopicCommandOptions deleteOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "__consumer_offsets"}));
        String deleteOffsetTopicPath = DeleteTopicsTopicZNode$.MODULE$.path("__consumer_offsets");
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deleteOffsetTopicPath));
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().deleteTopic(deleteOffsetTopicOpts), ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 365));
        Assert.assertFalse((String)"Delete path for topic shouldn't exist after deletion.", (boolean)this.zkClient().pathExists(deleteOffsetTopicPath));
    }

    @Test
    public void testDeleteIfExists() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}));
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().deleteTopic(deleteOpts), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379));
        TopicCommand.TopicCommandOptions deleteExistsOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--if-exists"}));
        this.topicService().deleteTopic(deleteExistsOpts);
    }

    @Test
    public void testDeleteInternalTopic() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"}));
        this.topicService().createTopic(createOffsetTopicOpts);
        TopicCommand.TopicCommandOptions deleteOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "__consumer_offsets"}));
        String deleteOffsetTopicPath = DeleteTopicsTopicZNode$.MODULE$.path("__consumer_offsets");
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deleteOffsetTopicPath));
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().deleteTopic(deleteOffsetTopicOpts), ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
    }

    @Test
    public void testDescribeIfTopicNotExists() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions describeOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}));
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(describeOpts), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 415));
        TopicCommand.TopicCommandOptions describeOptsWithExists = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--if-exists"}));
        this.topicService().describeTopic(describeOptsWithExists);
    }

    @Test
    public void testCreateAlterTopicWithRackAware() {
        scala.collection.immutable.Map rackInfo = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        TestUtils$.MODULE$.createBrokersInZk(this.toBrokerMetadata((Map<Object, String>)rackInfo, this.toBrokerMetadata$default$2()), this.zkClient());
        int numPartitions = 18;
        int replicationFactor = 3;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString(), "--replication-factor", ((Object)BoxesRunTime.boxToInteger((int)replicationFactor)).toString(), "--topic", this.testTopicName()}));
        this.topicService().createTopic(createOpts);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)this.zkClient().getReplicaAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()}))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            Seq replicas = (Seq)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)replicas);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
        int alteredNumPartitions = 36;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)alteredNumPartitions)).toString(), "--topic", this.testTopicName()}));
        this.topicService().alterTopic(alterOpts);
        assignment = (scala.collection.immutable.Map)this.zkClient().getReplicaAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()}))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            Seq replicas = (Seq)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)replicas);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), alteredNumPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @Test
    public void testDescribe() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = this.testTopicName();
        int x$2 = 2;
        int x$3 = 2;
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}))));
        String[] rows = output.split("\n");
        Assert.assertEquals((long)3L, (long)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rows)).size());
        rows[0].startsWith("Topic:testTopic\tPartitionCount:2");
    }

    @Test
    public void testDescribeReportOverriddenConfigs() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        String config = "file.delete.delay.ms=1000";
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName());
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", configResource.name(), "--config", config})));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)))));
        Assert.assertTrue((boolean)output.contains(config));
    }

    @Test
    public void testDescribeAndListTopicsMarkedForDeletion() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        String markedForDeletionDescribe = "MarkedForDeletion";
        String markedForDeletionList = "marked for deletion";
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.topicService().createTopic(createOpts);
        TestUtils$.MODULE$.deleteBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.topicService().deleteTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()})));
        String outputWithConfig = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.describeTopicsWithConfig$1());
        Assert.assertTrue((outputWithConfig.contains(this.testTopicName()) && outputWithConfig.contains(markedForDeletionDescribe) ? 1 : 0) != 0);
        String outputNoConfig = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.describeTopicsNoConfig$1());
        Assert.assertTrue((outputNoConfig.contains(this.testTopicName()) && outputNoConfig.contains(markedForDeletionDescribe) ? 1 : 0) != 0);
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.listTopics$1());
        Assert.assertTrue((output.contains(this.testTopicName()) && output.contains(markedForDeletionList) ? 1 : 0) != 0);
    }

    @Test
    public void testDescribeAndListTopicsWithoutInternalTopics() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"})));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--describe", "--exclude-internal"}))));
        Assert.assertTrue((boolean)output.contains(this.testTopicName()));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
        output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--list", "--exclude-internal"}))));
        Assert.assertTrue((boolean)output.contains(this.testTopicName()));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    @Test
    public void testTopicOperationsWithRegexSymbolInTopicName() {
        String topic1 = "test.topic";
        String topic2 = "test-topic";
        String escapedTopic = "\"test\\.topic\"";
        String unescapedTopic = "test.topic";
        int numPartitionsOriginal = 1;
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsOriginal)).toString(), "--replication-factor", "1", "--topic", topic1}));
        this.topicService().createTopic(createOpts);
        TopicCommand.TopicCommandOptions createOpts2 = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsOriginal)).toString(), "--replication-factor", "1", "--topic", topic2}));
        this.topicService().createTopic(createOpts2);
        TopicCommand.TopicCommandOptions escapedCommandOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", escapedTopic}));
        TopicCommand.TopicCommandOptions unescapedCommandOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", unescapedTopic}));
        Assert.assertFalse((boolean)TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(escapedCommandOpts)).contains(topic2));
        Assert.assertTrue((boolean)TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(unescapedCommandOpts)).contains(topic2));
        Assert.assertFalse((boolean)TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().deleteTopic(escapedCommandOpts)).contains(topic2));
        Assert.assertTrue((boolean)TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().deleteTopic(unescapedCommandOpts)).contains(topic2));
    }

    private final void describeTopicsWithConfig$1() {
        this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--describe"})));
    }

    private final void describeTopicsNoConfig$1() {
        this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--describe", "--unavailable-partitions"})));
    }

    private final void listTopics$1() {
        this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--list"})));
    }

    public TopicCommandTest() {
        RackAwareTest.$init$(this);
        this._testName = new TestName();
    }
}

