/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignPartitionsCommandTest;
import kafka.admin.ReassignmentCompleted$;
import kafka.log.LogConfig$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.easymock.Capture;
import org.easymock.CaptureType;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%g\u0001B\u0011#\u0001\u001dBQ\u0001\u000e\u0001\u0005\u0002UBq\u0001\u000f\u0001A\u0002\u0013\u0005\u0011\bC\u0004O\u0001\u0001\u0007I\u0011A(\t\rY\u0003\u0001\u0015)\u0003;\u0011\u001d9\u0006\u00011A\u0005\u0002aCq\u0001\u0018\u0001A\u0002\u0013\u0005Q\f\u0003\u0004`\u0001\u0001\u0006K!\u0017\u0005\u0006A\u0002!\t%\u0019\u0005\u0006W\u0002!\t!\u0019\u0005\u0006a\u0002!\t!\u0019\u0005\u0006e\u0002!\t!\u0019\u0005\u0006i\u0002!\t!\u0019\u0005\u0006m\u0002!\t!\u0019\u0005\u0006q\u0002!\t!\u0019\u0005\u0006u\u0002!\t!\u0019\u0005\u0006y\u0002!\t!\u0019\u0005\u0006}\u0002!\t!\u0019\u0005\u0007\u0003\u0003\u0001A\u0011A1\t\r\u0005\u0015\u0001\u0001\"\u0001b\u0011\u0019\tI\u0001\u0001C\u0001C\"1\u0011Q\u0002\u0001\u0005\u0002\u0005Da!!\u0005\u0001\t\u0003\t\u0007BBA\u000b\u0001\u0011\u0005\u0011\r\u0003\u0004\u0002\u001a\u0001!\t!\u0019\u0005\u0007\u0003;\u0001A\u0011A1\t\u000f\u0005\u0005\u0002\u0001\"\u0003\u0002$!9\u00111\n\u0001\u0005\u0002\u00055\u0003BBA6\u0001\u0011\u0005\u0011\rC\u0004\u0002v\u0001!\t!a\u001e\t\u0013\u0005\u0005\u0006!%A\u0005\u0002\u0005\r\u0006\"CA]\u0001E\u0005I\u0011AA^\u0011\u001d\ty\f\u0001C\u0001\u0003\u0003\u0014QDU3bgNLwM\u001c)beRLG/[8og\u000e{W.\\1oIR+7\u000f\u001e\u0006\u0003G\u0011\nQ!\u00193nS:T\u0011!J\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001F\f\t\u0003S1j\u0011A\u000b\u0006\u0003W\u0011\n!A_6\n\u00055R#\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u00020e5\t\u0001G\u0003\u00022I\u0005)Q\u000f^5mg&\u00111\u0007\r\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\ta\u0007\u0005\u00028\u00015\t!%A\u0004tKJ4XM]:\u0016\u0003i\u00022aO#I\u001d\ta$I\u0004\u0002>\u00016\taH\u0003\u0002@M\u00051AH]8pizJ\u0011!Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0007\u0012\u000bq\u0001]1dW\u0006<WMC\u0001B\u0013\t1uIA\u0002TKFT!a\u0011#\u0011\u0005%cU\"\u0001&\u000b\u0005-#\u0013AB:feZ,'/\u0003\u0002N\u0015\nY1*\u00194lCN+'O^3s\u0003-\u0019XM\u001d<feN|F%Z9\u0015\u0005A#\u0006CA)S\u001b\u0005!\u0015BA*E\u0005\u0011)f.\u001b;\t\u000fU\u001b\u0011\u0011!a\u0001u\u0005\u0019\u0001\u0010J\u0019\u0002\u0011M,'O^3sg\u0002\nQaY1mYN,\u0012!\u0017\t\u0003#jK!a\u0017#\u0003\u0007%sG/A\u0005dC2d7o\u0018\u0013fcR\u0011\u0001K\u0018\u0005\b+\u001a\t\t\u00111\u0001Z\u0003\u0019\u0019\u0017\r\u001c7tA\u0005AA/Z1s\t><h\u000eF\u0001QQ\tA1\r\u0005\u0002eS6\tQM\u0003\u0002gO\u0006)!.\u001e8ji*\t\u0001.A\u0002pe\u001eL!A[3\u0003\u000b\u00053G/\u001a:\u00021MDw.\u001e7e\r&tG-T8wS:<'+\u001a9mS\u000e\f7\u000f\u000b\u0002\n[B\u0011AM\\\u0005\u0003_\u0016\u0014A\u0001V3ti\u000614\u000f[8vY\u00124\u0015N\u001c3N_ZLgn\u001a*fa2L7-Y:XQ\u0016t\u0007K]8q_N,G-S:Tk\n\u001cX\r^(g\u000bbL7\u000f^5oO\"\u0012!\"\\\u0001+g\"|W\u000f\u001c3GS:$Wj\u001c<j]\u001e\u0014V\r\u001d7jG\u0006\u001cX*\u001e7uSBdW\rU1si&$\u0018n\u001c8tQ\tYQ.\u0001\u0014tQ>,H\u000e\u001a$j]\u0012luN^5oOJ+\u0007\u000f\\5dCNlU\u000f\u001c;ja2,Gk\u001c9jGND#\u0001D7\u0002gMDw.\u001e7e\r&tG-T8wS:<'+\u001a9mS\u000e\f7/T;mi&\u0004H.\u001a+pa&\u001c7/\u00118e!\u0006\u0014H/\u001b;j_:\u001c\bFA\u0007n\u0003)\u001a\bn\\;mI\u001aKg\u000e\u001a+x_6{g/\u001b8h%\u0016\u0004H.[2bg&s7+Y7f!\u0006\u0014H/\u001b;j_:D#AD7\u0002yMDw.\u001e7e\u001d>$xJ^3soJLG/Z#oi&$\u0018pQ8oM&<7o\u00165f]V\u0003H-\u0019;j]\u001e$\u0006N]8ui2,GMU3qY&\u001c\u0017m\u001d\u0015\u0003\u001f5\f1c\u001d5pk2$7+\u001a;Rk>$\u0018\rT5nSRD#\u0001E7\u0002-MDw.\u001e7e+B$\u0017\r^3Rk>$\u0018\rT5nSRD#!E7\u0002iMDw.\u001e7e\u001d>$xJ^3soJLG/Z#ySN$\u0018N\\4Qe>\u0004XM\u001d;jKN<\u0006.\u001a8MS6LG/S:BI\u0012,G\r\u000b\u0002\u0013[\u000693\u000f[8vY\u0012\u0014V-\\8wKRC'o\u001c;uY\u0016d\u0015.\\5u\rJ|W.\u00117m\u0005J|7.\u001a:tQ\t\u0019R.\u0001\u001dtQ>,H\u000e\u001a*f[>4X\r\u00165s_R$H.\u001a*fa2L7-\u0019'jgR\u0014\u0015m]3e\u001f:\u0004&o\u001c9pg\u0016$\u0017i]:jO:lWM\u001c;)\u0005Qi\u0017\u0001\r;fgR\u0004\u0016M\u001d;ji&|gNU3bgNLwM\\7f]R<\u0016\u000e\u001e5MK\u0006$WM]%o\u001d\u0016<(+\u001a9mS\u000e\f7\u000f\u000b\u0002\u0016[\u0006\u0019D/Z:u!\u0006\u0014H/\u001b;j_:\u0014V-Y:tS\u001etW.\u001a8u/&$\b\u000eT3bI\u0016\u0014hj\u001c;J]:+wOU3qY&\u001c\u0017m\u001d\u0015\u0003-5\fq\u0006^3tiB\u000b'\u000f^5uS>t'+Z1tg&<g.\\3oi:{gn\u0014<fe2\f\u0007\u000f]5oOJ+\u0007\u000f\\5dCND#aF7\u0002GQ,7\u000f\u001e*fCN\u001c\u0018n\u001a8j]\u001etuN\\#ySN$\u0018N\\4QCJ$\u0018\u000e^5p]\"\u0012\u0001$\\\u00010i\u0016\u001cHOU3tk6,\u0007+\u0019:uSRLwN\u001c*fCN\u001c\u0018n\u001a8nK:$H\u000b[1u/\u0006\u001c8i\\7qY\u0016$X\r\u001a\u0015\u000335\f!dZ3u\u0005J|7.\u001a:t/&$\b\u000eU1si&$\u0018n\u001c8ESJ$\u0002\"!\n\u00026\u0005u\u0012q\t\t\u0006\u0003O\ty#\u0017\b\u0005\u0003S\tY\u0003\u0005\u0002>\t&\u0019\u0011Q\u0006#\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t$a\r\u0003\u0007M+GOC\u0002\u0002.\u0011Ca\u0001\u000f\u000eA\u0002\u0005]\u0002\u0003B\u001e\u0002:!K1!a\u000fH\u0005!IE/\u001a:bE2,\u0007bBA 5\u0001\u0007\u0011\u0011I\u0001\u0006i>\u0004\u0018n\u0019\t\u0005\u0003O\t\u0019%\u0003\u0003\u0002F\u0005M\"AB*ue&tw\r\u0003\u0004\u0002Ji\u0001\r!W\u0001\fa\u0006\u0014H/\u001b;j_:LE-\u0001\u0002jgV!\u0011qJA+)\u0011\t\t&a\u001a\u0011\t\u0005M\u0013Q\u000b\u0007\u0001\t\u001d\t9f\u0007b\u0001\u00033\u0012\u0011\u0001V\t\u0005\u00037\n\t\u0007E\u0002R\u0003;J1!a\u0018E\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!UA2\u0013\r\t)\u0007\u0012\u0002\u0004\u0003:L\bbBA57\u0001\u0007\u0011\u0011K\u0001\u0002m\u0006)1/\u001a;va\"\u001aA$a\u001c\u0011\u0007\u0011\f\t(C\u0002\u0002t\u0015\u0014aAQ3g_J,\u0017\u0001D:uk\nT6j\u00117jK:$HCBA=\u0003\u007f\ni\nE\u0002*\u0003wJ1!! +\u00055Y\u0015MZ6b5.\u001cE.[3oi\"I\u0011\u0011Q\u000f\u0011\u0002\u0003\u0007\u00111Q\u0001\u0013KbL7\u000f^5oO\u0006\u001b8/[4o[\u0016tG\u000f\u0005\u0005\u0002(\u0005\u0015\u0015\u0011RAN\u0013\u0011\t9)a\r\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002\f\u0006]UBAAG\u0015\u0011\ty)!%\u0002\r\r|W.\\8o\u0015\r)\u00131\u0013\u0006\u0004\u0003+;\u0017AB1qC\u000eDW-\u0003\u0003\u0002\u001a\u00065%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0004w\u0015K\u0006\"CAP;A\u0005\t\u0019AAN\u0003\u001d\u0011'o\\6feN\fac\u001d;vEj[5\t\\5f]R$C-\u001a4bk2$H%M\u000b\u0003\u0003KSC!a!\u0002(.\u0012\u0011\u0011\u0016\t\u0005\u0003W\u000b),\u0004\u0002\u0002.*!\u0011qVAY\u0003%)hn\u00195fG.,GMC\u0002\u00024\u0012\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t9,!,\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\ftiV\u0014'lS\"mS\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tiL\u000b\u0003\u0002\u001c\u0006\u001d\u0016\u0001\u0004;p%\u0016\u0004H.[2b'\u0016$H\u0003BAb\u0003\u000b\u0004b!a\n\u00020\u0005\u0005\u0003bBAdA\u0001\u0007\u0011\u0011M\u0001\u0018i\"\u0014x\u000e\u001e;mK\u0012\u0014V\r\u001d7jG\u0006\u001c8\u000b\u001e:j]\u001e\u0004")
public class ReassignPartitionsCommandTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    private int calls = 0;

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public int calls() {
        return this.calls;
    }

    public void calls_$eq(int x$1) {
        this.calls = x$1;
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void shouldFindMovingReplicas() {
        Tuple2 control = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})));
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null, null, null, null);
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), control}));
        scala.collection.immutable.Map proposed = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), control}));
        public class Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$1
        extends AdminZkClient {
            private final KafkaZkClient zkClient;
            private final /* synthetic */ ReassignPartitionsCommandTest $outer;

            public KafkaZkClient zkClient() {
                return this.zkClient;
            }

            public void changeTopicConfig(String topic, Properties configChange) {
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:102"})), this.$outer.toReplicaSet(configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp())));
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:100", "0:101"})), this.$outer.toReplicaSet(configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp())));
                this.$outer.calls_$eq(this.$outer.calls() + 1);
            }

            public Properties fetchEntityConfig(String entityType, String entityName) {
                return new Properties();
            }

            public Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$1(ReassignPartitionsCommandTest $outer, KafkaZkClient zkClient) {
                this.zkClient = zkClient;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(zkClient);
            }
        }
        Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$1 admin = new Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$1(this, this.zkClient());
        assigner.assignThrottledReplicas((Map)existing, (Map)proposed, (AdminZkClient)admin);
        Assert.assertEquals((long)1L, (long)this.calls());
    }

    @Test
    public void shouldFindMovingReplicasWhenProposedIsSubsetOfExisting() {
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null, null, null, null);
        scala.collection.immutable.Map existingSuperset = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic3", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 102})))}));
        scala.collection.immutable.Map proposedSubset = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 102})))}));
        public class Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$2
        extends AdminZkClient {
            private final KafkaZkClient zkClient;
            private final /* synthetic */ ReassignPartitionsCommandTest $outer;

            public KafkaZkClient zkClient() {
                return this.zkClient;
            }

            public void changeTopicConfig(String topic, Properties configChange) {
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:102", "2:102"})), this.$outer.toReplicaSet(configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp())));
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:100", "0:101", "2:100", "2:101"})), this.$outer.toReplicaSet(configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp())));
                Assert.assertEquals((Object)"topic1", (Object)topic);
                this.$outer.calls_$eq(this.$outer.calls() + 1);
            }

            public Properties fetchEntityConfig(String entityType, String entityName) {
                return new Properties();
            }

            public Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$2(ReassignPartitionsCommandTest $outer, KafkaZkClient zkClient) {
                this.zkClient = zkClient;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(zkClient);
            }
        }
        Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$2 admin = new Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$2(this, this.zkClient());
        assigner.assignThrottledReplicas((Map)existingSuperset, (Map)proposedSubset, (AdminZkClient)admin);
        Assert.assertEquals((long)1L, (long)this.calls());
    }

    @Test
    public void shouldFindMovingReplicasMultiplePartitions() {
        Tuple2 control = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})));
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null, null, null, null);
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), control}));
        scala.collection.immutable.Map proposed = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), control}));
        public class Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$3
        extends AdminZkClient {
            private final KafkaZkClient zkClient;
            private final /* synthetic */ ReassignPartitionsCommandTest $outer;

            public KafkaZkClient zkClient() {
                return this.zkClient;
            }

            public void changeTopicConfig(String topic, Properties configChange) {
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:102", "1:102"})), this.$outer.toReplicaSet(configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp())));
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:100", "0:101", "1:100", "1:101"})), this.$outer.toReplicaSet(configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp())));
                this.$outer.calls_$eq(this.$outer.calls() + 1);
            }

            public Properties fetchEntityConfig(String entityType, String entityName) {
                return new Properties();
            }

            public Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$3(ReassignPartitionsCommandTest $outer, KafkaZkClient zkClient) {
                this.zkClient = zkClient;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(zkClient);
            }
        }
        Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$3 admin = new Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$3(this, this.zkClient());
        assigner.assignThrottledReplicas((Map)existing, (Map)proposed, (AdminZkClient)admin);
        Assert.assertEquals((long)1L, (long)this.calls());
    }

    @Test
    public void shouldFindMovingReplicasMultipleTopics() {
        Tuple2 control = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})));
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null, null, null, null);
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), control}));
        scala.collection.immutable.Map proposed = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102}))), control}));
        public class Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$4
        extends AdminZkClient {
            private final KafkaZkClient zkClient;
            private final /* synthetic */ ReassignPartitionsCommandTest $outer;

            public KafkaZkClient zkClient() {
                return this.zkClient;
            }

            public void changeTopicConfig(String topic, Properties configChange) {
                String string = topic;
                if ("topic1".equals(string)) {
                    Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:100", "0:101"})), this.$outer.toReplicaSet(configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp())));
                    Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:102"})), this.$outer.toReplicaSet(configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp())));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if ("topic2".equals(string)) {
                    Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:101", "0:102"})), this.$outer.toReplicaSet(configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp())));
                    Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:100"})), this.$outer.toReplicaSet(configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp())));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw this.$outer.fail(new StringBuilder(17).append("Unexpected topic ").append(topic).toString(), new Position("ReassignPartitionsCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
                }
                this.$outer.calls_$eq(this.$outer.calls() + 1);
            }

            public Properties fetchEntityConfig(String entityType, String entityName) {
                return new Properties();
            }

            public Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$4(ReassignPartitionsCommandTest $outer, KafkaZkClient zkClient) {
                this.zkClient = zkClient;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(zkClient);
            }
        }
        Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$4 admin = new Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$4(this, this.zkClient());
        assigner.assignThrottledReplicas((Map)existing, (Map)proposed, (AdminZkClient)admin);
        Assert.assertEquals((long)2L, (long)this.calls());
    }

    @Test
    public void shouldFindMovingReplicasMultipleTopicsAndPartitions() {
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null, null, null, null);
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102})))}));
        scala.collection.immutable.Map proposed = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 100})))}));
        public class Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$5
        extends AdminZkClient {
            private final KafkaZkClient zkClient;
            private final /* synthetic */ ReassignPartitionsCommandTest $outer;

            public KafkaZkClient zkClient() {
                return this.zkClient;
            }

            public void changeTopicConfig(String topic, Properties configChange) {
                String string = topic;
                if ("topic1".equals(string)) {
                    Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:102", "1:102"})), this.$outer.toReplicaSet(configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp())));
                    Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:100", "0:101", "1:100", "1:101"})), this.$outer.toReplicaSet(configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp())));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if ("topic2".equals(string)) {
                    Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:100", "1:100"})), this.$outer.toReplicaSet(configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp())));
                    Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:101", "0:102", "1:101", "1:102"})), this.$outer.toReplicaSet(configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp())));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw this.$outer.fail(new StringBuilder(17).append("Unexpected topic ").append(topic).toString(), new Position("ReassignPartitionsCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
                }
                this.$outer.calls_$eq(this.$outer.calls() + 1);
            }

            public Properties fetchEntityConfig(String entityType, String entityName) {
                return new Properties();
            }

            public Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$5(ReassignPartitionsCommandTest $outer, KafkaZkClient zkClient) {
                this.zkClient = zkClient;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(zkClient);
            }
        }
        Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$5 admin = new Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$5(this, this.zkClient());
        assigner.assignThrottledReplicas((Map)existing, (Map)proposed, (AdminZkClient)admin);
        Assert.assertEquals((long)2L, (long)this.calls());
    }

    @Test
    public void shouldFindTwoMovingReplicasInSamePartition() {
        Tuple2 control = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})));
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null, null, null, null);
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 102, 103}))), control}));
        scala.collection.immutable.Map proposed = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 104, 105}))), control}));
        public class Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$6
        extends AdminZkClient {
            private final KafkaZkClient zkClient;
            private final /* synthetic */ ReassignPartitionsCommandTest $outer;

            public KafkaZkClient zkClient() {
                return this.zkClient;
            }

            public void changeTopicConfig(String topic, Properties configChange) {
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:104", "0:105"})), this.$outer.toReplicaSet(configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp())));
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:100", "0:101", "0:102", "0:103"})), this.$outer.toReplicaSet(configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp())));
                this.$outer.calls_$eq(this.$outer.calls() + 1);
            }

            public Properties fetchEntityConfig(String entityType, String entityName) {
                return new Properties();
            }

            public Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$6(ReassignPartitionsCommandTest $outer, KafkaZkClient zkClient) {
                this.zkClient = zkClient;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(zkClient);
            }
        }
        Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$6 admin = new Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$6(this, this.zkClient());
        assigner.assignThrottledReplicas((Map)existing, (Map)proposed, (AdminZkClient)admin);
        Assert.assertEquals((long)1L, (long)this.calls());
    }

    @Test
    public void shouldNotOverwriteEntityConfigsWhenUpdatingThrottledReplicas() {
        Tuple2 control = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})));
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null, null, null, null);
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), control}));
        scala.collection.immutable.Map proposed = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), control}));
        Properties existingProperties = CoreUtils$.MODULE$.propsWith("some-key", "some-value");
        public class Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$7
        extends AdminZkClient {
            private final KafkaZkClient zkClient;
            private final /* synthetic */ ReassignPartitionsCommandTest $outer;
            private final Properties existingProperties$1;

            public KafkaZkClient zkClient() {
                return this.zkClient;
            }

            public void changeTopicConfig(String topic, Properties configChange) {
                Assert.assertEquals((Object)"some-value", (Object)configChange.getProperty("some-key"));
                this.$outer.calls_$eq(this.$outer.calls() + 1);
            }

            public Properties fetchEntityConfig(String entityType, String entityName) {
                return this.existingProperties$1;
            }

            public Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$7(ReassignPartitionsCommandTest $outer, KafkaZkClient zkClient, Properties existingProperties$1) {
                this.zkClient = zkClient;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.existingProperties$1 = existingProperties$1;
                super(zkClient);
            }
        }
        Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$7 admin = new Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$7(this, this.zkClient(), existingProperties);
        assigner.assignThrottledReplicas((Map)existing, (Map)proposed, (AdminZkClient)admin);
        Assert.assertEquals((long)1L, (long)this.calls());
    }

    @Test
    public void shouldSetQuotaLimit() {
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}));
        scala.collection.mutable.Map proposed = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102})))}));
        KafkaZkClient zk = this.stubZKClient((scala.collection.immutable.Map<TopicPartition, Seq<Object>>)existing, this.stubZKClient$default$2());
        AdminZkClient admin = (AdminZkClient)EasyMock.createMock(AdminZkClient.class);
        Capture propsCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(zk, (Option)None$.MODULE$, (Map)proposed, (Map)Predef$.MODULE$.Map().empty(), admin);
        EasyMock.expect((Object)admin.fetchEntityConfig(EasyMock.anyString(), EasyMock.anyString())).andStubReturn((Object)new Properties());
        admin.changeBrokerConfig((Seq)((List)EasyMock.anyObject()), (Properties)EasyMock.capture((Capture)propsCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.replay((Object[])new Object[]{admin});
        assigner.maybeLimit(new ReassignPartitionsCommand.Throttle(1000L, ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$2(), ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$3()));
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(propsCapture.getValues()).asScala()).foreach((Function1 & Serializable & scala.Serializable)actual -> {
            ReassignPartitionsCommandTest.$anonfun$shouldSetQuotaLimit$1(actual);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)3L, (long)propsCapture.getValues().size());
    }

    @Test
    public void shouldUpdateQuotaLimit() {
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}));
        scala.collection.mutable.Map proposed = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102})))}));
        KafkaZkClient zk = this.stubZKClient((scala.collection.immutable.Map<TopicPartition, Seq<Object>>)existing, this.stubZKClient$default$2());
        AdminZkClient admin = (AdminZkClient)EasyMock.createMock(AdminZkClient.class);
        Capture propsCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(zk, (Option)None$.MODULE$, (Map)proposed, (Map)Predef$.MODULE$.Map().empty(), admin);
        admin.changeBrokerConfig((Seq)((List)EasyMock.anyObject()), (Properties)EasyMock.capture((Capture)propsCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        Properties existingConfigs = CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)"10"), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)"100")}));
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Broker()), this.is("100"))).andReturn((Object)TestUtils$.MODULE$.copyOf(existingConfigs));
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Broker()), this.is("101"))).andReturn((Object)TestUtils$.MODULE$.copyOf(existingConfigs));
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Broker()), this.is("102"))).andReturn((Object)TestUtils$.MODULE$.copyOf(existingConfigs));
        EasyMock.replay((Object[])new Object[]{admin});
        assigner.maybeLimit(new ReassignPartitionsCommand.Throttle(1000L, ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$2(), ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$3()));
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(propsCapture.getValues()).asScala()).foreach((Function1 & Serializable & scala.Serializable)actual -> {
            ReassignPartitionsCommandTest.$anonfun$shouldUpdateQuotaLimit$1(actual);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)3L, (long)propsCapture.getValues().size());
    }

    @Test
    public void shouldNotOverwriteExistingPropertiesWhenLimitIsAdded() {
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}));
        scala.collection.mutable.Map proposed = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102})))}));
        KafkaZkClient zk = this.stubZKClient((scala.collection.immutable.Map<TopicPartition, Seq<Object>>)existing, this.stubZKClient$default$2());
        AdminZkClient admin = (AdminZkClient)EasyMock.createMock(AdminZkClient.class);
        Capture propsCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(zk, (Option)None$.MODULE$, (Map)proposed, (Map)Predef$.MODULE$.Map().empty(), admin);
        admin.changeBrokerConfig((Seq)((List)EasyMock.anyObject()), (Properties)EasyMock.capture((Capture)propsCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Broker()), EasyMock.anyString())).andReturn((Object)CoreUtils$.MODULE$.propsWith("useful.key", "useful.value")).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{admin});
        assigner.maybeLimit(new ReassignPartitionsCommand.Throttle(1000L, ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$2(), ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$3()));
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(propsCapture.getValues()).asScala()).foreach((Function1 & Serializable & scala.Serializable)actual -> {
            ReassignPartitionsCommandTest.$anonfun$shouldNotOverwriteExistingPropertiesWhenLimitIsAdded$1(actual);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)3L, (long)propsCapture.getValues().size());
    }

    @Test
    public void shouldRemoveThrottleLimitFromAllBrokers() {
        Seq brokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 102}));
        scala.collection.mutable.Map status = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)ReassignmentCompleted$.MODULE$)}));
        Properties existingBrokerConfigs = CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)"10"), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)"100"), new Tuple2((Object)"useful.key", (Object)"value")}));
        Seq x$1 = brokers;
        scala.collection.immutable.Map<TopicPartition, Seq<Object>> x$2 = this.stubZKClient$default$1();
        KafkaZkClient zk = this.stubZKClient(x$2, (Seq<Object>)x$1);
        AdminZkClient admin = (AdminZkClient)EasyMock.createMock(AdminZkClient.class);
        Capture propsCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Topic()), EasyMock.anyString())).andStubReturn((Object)new Properties());
        admin.changeBrokerConfig((Seq)EasyMock.anyObject(), (Properties)EasyMock.capture((Capture)propsCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Broker()), this.is("100"))).andReturn((Object)TestUtils$.MODULE$.copyOf(existingBrokerConfigs));
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Broker()), this.is("101"))).andReturn((Object)TestUtils$.MODULE$.copyOf(existingBrokerConfigs));
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Broker()), this.is("102"))).andReturn((Object)TestUtils$.MODULE$.copyOf(existingBrokerConfigs));
        EasyMock.replay((Object[])new Object[]{admin});
        ReassignPartitionsCommand$.MODULE$.removeThrottle(zk, (Map)status, (Map)Predef$.MODULE$.Map().empty(), admin);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(propsCapture.getValues()).asScala()).foreach((Function1 & Serializable & scala.Serializable)capture -> {
            ReassignPartitionsCommandTest.$anonfun$shouldRemoveThrottleLimitFromAllBrokers$1(capture);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)3L, (long)propsCapture.getValues().size());
    }

    @Test
    public void shouldRemoveThrottleReplicaListBasedOnProposedAssignment() {
        scala.collection.mutable.Map status = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)ReassignmentCompleted$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 0)), (Object)ReassignmentCompleted$.MODULE$)}));
        Properties existingConfigs = CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), (Object)"1:100:2:100"), new Tuple2((Object)LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), (Object)"1:101,2:101"), new Tuple2((Object)"useful.key", (Object)"value")}));
        Seq x$1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}));
        scala.collection.immutable.Map<TopicPartition, Seq<Object>> x$2 = this.stubZKClient$default$1();
        KafkaZkClient zk = this.stubZKClient(x$2, (Seq<Object>)x$1);
        AdminZkClient admin = (AdminZkClient)EasyMock.createMock(AdminZkClient.class);
        Capture propsCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Broker()), EasyMock.anyString())).andStubReturn((Object)new Properties());
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Topic()), this.is("topic1"))).andStubReturn((Object)TestUtils$.MODULE$.copyOf(existingConfigs));
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Topic()), this.is("topic2"))).andStubReturn((Object)TestUtils$.MODULE$.copyOf(existingConfigs));
        admin.changeTopicConfig(this.is("topic1"), (Properties)EasyMock.capture((Capture)propsCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        admin.changeTopicConfig(this.is("topic2"), (Properties)EasyMock.capture((Capture)propsCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{admin});
        ReassignPartitionsCommand$.MODULE$.removeThrottle(zk, (Map)status, (Map)Predef$.MODULE$.Map().empty(), admin);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(propsCapture.getValues()).asScala()).foreach((Function1 & Serializable & scala.Serializable)actual -> {
            ReassignPartitionsCommandTest.$anonfun$shouldRemoveThrottleReplicaListBasedOnProposedAssignment$1(actual);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)2L, (long)propsCapture.getValues().size());
    }

    @Test
    public void testPartitionReassignmentWithLeaderInNewReplicas() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        this.servers_$eq((Seq<KafkaServer>)((Seq)TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1 & Serializable & scala.Serializable)b -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, this.servers());
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3}));
        int partitionToBeReassigned = 0;
        TopicPartition topicAndPartition = new TopicPartition(topic, partitionToBeReassigned);
        KafkaZkClient x$1 = this.zkClient();
        None$ x$2 = None$.MODULE$;
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)}));
        AdminZkClient x$4 = this.adminZkClient();
        Map x$5 = ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4();
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(x$1, (Option)x$2, (Map)x$3, x$5, x$4);
        Assert.assertTrue((String)"Partition reassignment attempt failed for [test, 0]", (boolean)reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1(), reassignPartitionsCommand.reassignPartitions$default$2()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Object object = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.zkClient(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)}))).getOrElse((Object)topicAndPartition, (Function0 & Serializable & scala.Serializable)() -> this.fail(new StringBuilder(38).append("Failed to get reassignment status for ").append(topicAndPartition).toString(), new Position("ReassignPartitionsCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 443)));
            ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
            return !(object != null ? !object.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Partition reassignment should complete", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Seq assignedReplicas = this.zkClient().getReplicasForPartition(new TopicPartition(topic, partitionToBeReassigned));
        TestUtils$.MODULE$.checkForPhantomInSyncReplicas(this.zkClient(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas);
        Assert.assertEquals((String)"Partition should have been reassigned to 0, 2, 3", (Object)newReplicas, (Object)assignedReplicas);
        TestUtils$.MODULE$.ensureNoUnderReplicatedPartitions(this.zkClient(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas, this.servers());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Set<Object> set = this.getBrokersWithPartitionDir((Iterable<KafkaServer>)this.servers(), topic, 0);
            Set set2 = newReplicas.toSet();
            return !(set != null ? !set.equals((Object)set2) : set2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "New replicas should exist on brokers", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testPartitionReassignmentWithLeaderNotInNewReplicas() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        this.servers_$eq((Seq<KafkaServer>)((Seq)TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1 & Serializable & scala.Serializable)b -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, this.servers());
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        int partitionToBeReassigned = 0;
        TopicPartition topicAndPartition = new TopicPartition(topic, partitionToBeReassigned);
        KafkaZkClient x$1 = this.zkClient();
        None$ x$2 = None$.MODULE$;
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)}));
        AdminZkClient x$4 = this.adminZkClient();
        Map x$5 = ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4();
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(x$1, (Option)x$2, (Map)x$3, x$5, x$4);
        Assert.assertTrue((String)"Partition reassignment failed for test, 0", (boolean)reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1(), reassignPartitionsCommand.reassignPartitions$default$2()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Object object = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.zkClient(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)}))).getOrElse((Object)topicAndPartition, (Function0 & Serializable & scala.Serializable)() -> this.fail(new StringBuilder(38).append("Failed to get reassignment status for ").append(topicAndPartition).toString(), new Position("ReassignPartitionsCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 472)));
            ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
            return !(object != null ? !object.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Partition reassignment should complete", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Seq assignedReplicas = this.zkClient().getReplicasForPartition(new TopicPartition(topic, partitionToBeReassigned));
        Assert.assertEquals((String)"Partition should have been reassigned to 0, 2, 3", (Object)newReplicas, (Object)assignedReplicas);
        TestUtils$.MODULE$.checkForPhantomInSyncReplicas(this.zkClient(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas);
        TestUtils$.MODULE$.ensureNoUnderReplicatedPartitions(this.zkClient(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas, this.servers());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Set<Object> set = this.getBrokersWithPartitionDir((Iterable<KafkaServer>)this.servers(), topic, 0);
            Set set2 = newReplicas.toSet();
            return !(set != null ? !set.equals((Object)set2) : set2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "New replicas should exist on brokers", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testPartitionReassignmentNonOverlappingReplicas() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
        String topic = "test";
        this.servers_$eq((Seq<KafkaServer>)((Seq)TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1 & Serializable & scala.Serializable)b -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, this.servers());
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}));
        int partitionToBeReassigned = 0;
        TopicPartition topicAndPartition = new TopicPartition(topic, partitionToBeReassigned);
        KafkaZkClient x$1 = this.zkClient();
        None$ x$2 = None$.MODULE$;
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)}));
        AdminZkClient x$4 = this.adminZkClient();
        Map x$5 = ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4();
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(x$1, (Option)x$2, (Map)x$3, x$5, x$4);
        Assert.assertTrue((String)"Partition reassignment failed for test, 0", (boolean)reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1(), reassignPartitionsCommand.reassignPartitions$default$2()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Object object = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.zkClient(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)}))).getOrElse((Object)topicAndPartition, (Function0 & Serializable & scala.Serializable)() -> this.fail(new StringBuilder(38).append("Failed to get reassignment status for ").append(topicAndPartition).toString(), new Position("ReassignPartitionsCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 500)));
            ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
            return !(object != null ? !object.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Partition reassignment should complete", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Seq assignedReplicas = this.zkClient().getReplicasForPartition(new TopicPartition(topic, partitionToBeReassigned));
        Assert.assertEquals((String)"Partition should have been reassigned to 2, 3", (Object)newReplicas, (Object)assignedReplicas);
        TestUtils$.MODULE$.checkForPhantomInSyncReplicas(this.zkClient(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas);
        TestUtils$.MODULE$.ensureNoUnderReplicatedPartitions(this.zkClient(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas, this.servers());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Set<Object> set = this.getBrokersWithPartitionDir((Iterable<KafkaServer>)this.servers(), topic, 0);
            Set set2 = newReplicas.toSet();
            return !(set != null ? !set.equals((Object)set2) : set2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "New replicas should exist on brokers", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testReassigningNonExistingPartition() {
        String topic = "test";
        this.servers_$eq((Seq<KafkaServer>)((Seq)TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1 & Serializable & scala.Serializable)b -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}));
        int partitionToBeReassigned = 0;
        TopicPartition topicAndPartition = new TopicPartition(topic, partitionToBeReassigned);
        KafkaZkClient x$1 = this.zkClient();
        None$ x$2 = None$.MODULE$;
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)}));
        AdminZkClient x$4 = this.adminZkClient();
        Map x$5 = ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4();
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(x$1, (Option)x$2, (Map)x$3, x$5, x$4);
        Assert.assertFalse((String)"Partition reassignment failed for test, 0", (boolean)reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1(), reassignPartitionsCommand.reassignPartitions$default$2()));
        Map reassignedPartitions = this.zkClient().getPartitionReassignment();
        Assert.assertFalse((String)"Partition should not be reassigned", (boolean)reassignedPartitions.contains((Object)topicAndPartition));
    }

    @Test
    public void testResumePartitionReassignmentThatWasCompleted() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
        String topic = "test";
        this.adminZkClient().createTopicWithAssignment(topic, new Properties(), (Map)expectedReplicaAssignment);
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        int partitionToBeReassigned = 0;
        TopicPartition topicAndPartition = new TopicPartition(topic, partitionToBeReassigned);
        KafkaZkClient x$1 = this.zkClient();
        None$ x$2 = None$.MODULE$;
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)}));
        AdminZkClient x$4 = this.adminZkClient();
        Map x$5 = ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4();
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(x$1, (Option)x$2, (Map)x$3, x$5, x$4);
        reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1(), reassignPartitionsCommand.reassignPartitions$default$2());
        this.servers_$eq((Seq<KafkaServer>)((Seq)TestUtils$.MODULE$.createBrokerConfigs(2, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1 & Serializable & scala.Serializable)b -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !this.zkClient().reassignPartitionsInProgress(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Partition reassignment should complete", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Seq assignedReplicas = this.zkClient().getReplicasForPartition(new TopicPartition(topic, partitionToBeReassigned));
        Assert.assertEquals((String)"Partition should have been reassigned to 0, 1", (Object)newReplicas, (Object)assignedReplicas);
        TestUtils$.MODULE$.checkForPhantomInSyncReplicas(this.zkClient(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas);
        TestUtils$.MODULE$.ensureNoUnderReplicatedPartitions(this.zkClient(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas, this.servers());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Set<Object> set = this.getBrokersWithPartitionDir((Iterable<KafkaServer>)this.servers(), topic, 0);
            Set set2 = newReplicas.toSet();
            return !(set != null ? !set.equals((Object)set2) : set2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "New replicas should exist on brokers", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private Set<Object> getBrokersWithPartitionDir(Iterable<KafkaServer> servers, String topic, int partitionId) {
        return ((TraversableOnce)((TraversableLike)servers.filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommandTest.$anonfun$getBrokersWithPartitionDir$1(topic, partitionId, server)))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)ReassignPartitionsCommandTest.$anonfun$getBrokersWithPartitionDir$2(x$1)), Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    public <T> T is(T v) {
        return (T)EasyMock.eq(v);
    }

    @Before
    public void setup() {
        this.calls_$eq(0);
    }

    /*
     * WARNING - void declaration
     */
    public KafkaZkClient stubZKClient(scala.collection.immutable.Map<TopicPartition, Seq<Object>> existingAssignment, Seq<Object> brokers) {
        void var3_3;
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createMock(KafkaZkClient.class);
        EasyMock.expect((Object)zkClient.getReplicaAssignmentForTopics((Set)EasyMock.anyObject())).andStubReturn(existingAssignment);
        EasyMock.expect((Object)zkClient.getAllBrokersInCluster()).andStubReturn(brokers.map((Function1 & Serializable & scala.Serializable)x$2 -> TestUtils$.MODULE$.createBroker(BoxesRunTime.unboxToInt((Object)x$2), "", 1, TestUtils$.MODULE$.createBroker$default$4()), Seq$.MODULE$.canBuildFrom()));
        EasyMock.replay((Object[])new Object[]{zkClient});
        return var3_3;
    }

    public scala.collection.immutable.Map<TopicPartition, Seq<Object>> stubZKClient$default$1() {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public Seq<Object> stubZKClient$default$2() {
        return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public Set<String> toReplicaSet(Object throttledReplicasString) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])throttledReplicasString.toString().split(","))).toSet();
    }

    public static final /* synthetic */ void $anonfun$shouldSetQuotaLimit$1(Properties actual) {
        Assert.assertEquals((Object)"1000", (Object)actual.getProperty(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp()));
        Assert.assertEquals((Object)"1000", (Object)actual.getProperty(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp()));
    }

    public static final /* synthetic */ void $anonfun$shouldUpdateQuotaLimit$1(Properties actual) {
        Assert.assertEquals((Object)"1000", (Object)actual.getProperty(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp()));
        Assert.assertEquals((Object)"1000", (Object)actual.getProperty(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp()));
    }

    public static final /* synthetic */ void $anonfun$shouldNotOverwriteExistingPropertiesWhenLimitIsAdded$1(Properties actual) {
        Assert.assertEquals((Object)"useful.value", (Object)actual.getProperty("useful.key"));
        Assert.assertEquals((Object)"1000", (Object)actual.getProperty(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp()));
        Assert.assertEquals((Object)"1000", (Object)actual.getProperty(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp()));
    }

    public static final /* synthetic */ void $anonfun$shouldRemoveThrottleLimitFromAllBrokers$1(Properties capture) {
        Assert.assertEquals((Object)"value", (Object)capture.get("useful.key"));
        Assert.assertNull((Object)capture.get(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp()));
        Assert.assertNull((Object)capture.get(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp()));
    }

    public static final /* synthetic */ void $anonfun$shouldRemoveThrottleReplicaListBasedOnProposedAssignment$1(Properties actual) {
        Assert.assertEquals((Object)"value", (Object)actual.getProperty("useful.key"));
        Assert.assertNull((Object)actual.getProperty(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
        Assert.assertNull((Object)actual.getProperty(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp()));
    }

    public static final /* synthetic */ boolean $anonfun$getBrokersWithPartitionDir$1(String topic$5, int partitionId$1, KafkaServer server) {
        return new File((String)server.config().logDirs().head(), new StringBuilder(1).append(topic$5).append("-").append(partitionId$1).toString()).exists();
    }

    public static final /* synthetic */ int $anonfun$getBrokersWithPartitionDir$2(KafkaServer x$1) {
        return x$1.config().brokerId();
    }
}

