/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.admin.PreferredReplicaLeaderElectionCommand;
import kafka.admin.PreferredReplicaLeaderElectionCommand$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001A3A\u0001C\u0005\u0001\u001d!)1\u0004\u0001C\u00019!9q\u0004\u0001a\u0001\n\u0003\u0001\u0003bB\u001b\u0001\u0001\u0004%\tA\u000e\u0005\u0007{\u0001\u0001\u000b\u0015B\u0011\t\u000by\u0002A\u0011I \t\u000b%\u0003A\u0011A \t\u000b9\u0003A\u0011A \u0003GA\u0013XMZ3se\u0016$'+\u001a9mS\u000e\fW\t\\3di&|gnQ8n[\u0006tG\rV3ti*\u0011!bC\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0002\u0019\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\u0010+A\u0011\u0001cE\u0007\u0002#)\u0011!cC\u0001\u0003u.L!\u0001F\t\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t!\t1\u0012$D\u0001\u0018\u0015\tA2\"A\u0003vi&d7/\u0003\u0002\u001b/\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\n\u0003\u001d\u0019XM\u001d<feN,\u0012!\t\t\u0004E1zcBA\u0012*\u001d\t!s%D\u0001&\u0015\t1S\"\u0001\u0004=e>|GOP\u0005\u0002Q\u0005)1oY1mC&\u0011!fK\u0001\ba\u0006\u001c7.Y4f\u0015\u0005A\u0013BA\u0017/\u0005\r\u0019V-\u001d\u0006\u0003U-\u0002\"\u0001M\u001a\u000e\u0003ER!AM\u0006\u0002\rM,'O^3s\u0013\t!\u0014GA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\u0018aC:feZ,'o]0%KF$\"aN\u001e\u0011\u0005aJT\"A\u0016\n\u0005iZ#\u0001B+oSRDq\u0001P\u0002\u0002\u0002\u0003\u0007\u0011%A\u0002yIE\n\u0001b]3sm\u0016\u00148\u000fI\u0001\ti\u0016\f'\u000fR8x]R\tq\u0007\u000b\u0002\u0006\u0003B\u0011!iR\u0007\u0002\u0007*\u0011A)R\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\r\u0006\u0019qN]4\n\u0005!\u001b%!B!gi\u0016\u0014\u0018\u0001\b;fgR\u0004&/\u001a4feJ,GMU3qY&\u001c\u0017MS:p]\u0012\u000bG/\u0019\u0015\u0003\r-\u0003\"A\u0011'\n\u00055\u001b%\u0001\u0002+fgR\f\u0011\u0005^3ti\n\u000b7/[2Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dC\u0016cWm\u0019;j_:D#aB&")
public class PreferredReplicaElectionCommandTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testPreferredReplicaJsonData() {
        Set partitionsForPreferredReplicaElection = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test", 1), new TopicPartition("test2", 1)}));
        PreferredReplicaLeaderElectionCommand$.MODULE$.writePreferredReplicaElectionData(this.zkClient(), partitionsForPreferredReplicaElection);
        scala.collection.immutable.Set partitionsUndergoingPreferredReplicaElection = this.zkClient().getPreferredReplicaElection();
        Assert.assertEquals((String)"Preferred replica election ser-de failed", (Object)partitionsForPreferredReplicaElection, (Object)partitionsUndergoingPreferredReplicaElection);
    }

    @Test
    public void testBasicPreferredReplicaElection() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        int partition = 1;
        int preferredReplica = 0;
        Map brokerRack = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2")}));
        int x$1 = 3;
        String x$2 = this.zkConnect();
        boolean x$3 = false;
        Map x$4 = brokerRack;
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfigs$default$5();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfigs$default$6();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfigs$default$7();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        int x$13 = TestUtils$.MODULE$.createBrokerConfigs$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        Seq serverConfigs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$1, x$2, x$3, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, (Map<Object, String>)x$4, x$13, x$14).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
        this.adminZkClient().createTopicWithAssignment(topic, new Properties(), expectedReplicaAssignment);
        this.servers_$eq((Seq<KafkaServer>)((Seq)serverConfigs.reverseMap((Function1 & Serializable & scala.Serializable)s -> TestUtils$.MODULE$.createServer((KafkaConfig)s, TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        KafkaZkClient x$15 = this.zkClient();
        String x$16 = topic;
        int x$17 = partition;
        None$ x$18 = None$.MODULE$;
        long x$19 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$20 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        int currentLeader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$15, x$16, x$17, x$19, (Option<Object>)x$18, x$20);
        PreferredReplicaLeaderElectionCommand preferredReplicaElection = new PreferredReplicaLeaderElectionCommand(this.zkClient(), (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic, partition)})));
        preferredReplicaElection.moveLeaderToPreferredReplica();
        KafkaZkClient x$21 = this.zkClient();
        String x$22 = topic;
        int x$23 = partition;
        Some x$24 = new Some((Object)BoxesRunTime.boxToInteger((int)currentLeader));
        long x$25 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$26 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        int newLeader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$21, x$22, x$23, x$25, (Option<Object>)x$24, x$26);
        Assert.assertEquals((String)"Preferred replica election failed", (long)preferredReplica, (long)newLeader);
    }
}

