/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Properties;
import kafka.admin.RackAwareMode;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignmentFailed$;
import kafka.admin.TopicCommand;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogManager;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionZNode$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005}f\u0001B\u000f\u001f\u0001\rBQA\u000b\u0001\u0005\u0002-BqA\f\u0001A\u0002\u0013\u0005q\u0006C\u0004E\u0001\u0001\u0007I\u0011A#\t\r1\u0003\u0001\u0015)\u00031\u0011\u001di\u0005A1A\u0005\u00029Ca!\u0018\u0001!\u0002\u0013y\u0005\"\u00020\u0001\t\u0003z\u0006\"B5\u0001\t\u0003y\u0006\"\u00028\u0001\t\u0003y\u0006\"\u00029\u0001\t\u0003y\u0006\"\u0002:\u0001\t\u0003y\u0006\"\u0002;\u0001\t\u0013)\b\"B=\u0001\t\u0013y\u0006\"\u0002>\u0001\t\u0013Y\bBBA\u0015\u0001\u0011\u0005q\f\u0003\u0004\u0002.\u0001!\ta\u0018\u0005\u0007\u0003c\u0001A\u0011A0\t\r\u0005U\u0002\u0001\"\u0001`\u0011\u0019\tI\u0004\u0001C\u0001?\"1\u0011Q\b\u0001\u0005\u0002}Ca!!\u0011\u0001\t\u0003y\u0006bBA#\u0001\u0011%\u0011q\t\u0005\n\u0003?\u0002\u0011\u0013!C\u0005\u0003CB\u0011\"a\u001e\u0001#\u0003%I!!\u001f\t\u000f\u0005\u0015\u0003\u0001\"\u0003\u0002~!9\u0011\u0011\u0014\u0001\u0005\n\u0005m\u0005BBA\\\u0001\u0011\u0005q\f\u0003\u0004\u0002<\u0002!\ta\u0018\u0002\u0010\t\u0016dW\r^3U_BL7\rV3ti*\u0011q\u0004I\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0002C\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001%!\t)\u0003&D\u0001'\u0015\t9\u0003%\u0001\u0002{W&\u0011\u0011F\n\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005a\u0003CA\u0017\u0001\u001b\u0005q\u0012aB:feZ,'o]\u000b\u0002aA\u0019\u0011g\u000f \u000f\u0005IBdBA\u001a7\u001b\u0005!$BA\u001b#\u0003\u0019a$o\\8u}%\tq'A\u0003tG\u0006d\u0017-\u0003\u0002:u\u00059\u0001/Y2lC\u001e,'\"A\u001c\n\u0005qj$aA*fc*\u0011\u0011H\u000f\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003\u0002\naa]3sm\u0016\u0014\u0018BA\"A\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002\u0017M,'O^3sg~#S-\u001d\u000b\u0003\r*\u0003\"a\u0012%\u000e\u0003iJ!!\u0013\u001e\u0003\tUs\u0017\u000e\u001e\u0005\b\u0017\u000e\t\t\u00111\u00011\u0003\rAH%M\u0001\tg\u0016\u0014h/\u001a:tA\u0005IR\r\u001f9fGR,GMU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u+\u0005y\u0005\u0003\u0002)V/jk\u0011!\u0015\u0006\u0003%N\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0005QS\u0014AC2pY2,7\r^5p]&\u0011a+\u0015\u0002\u0004\u001b\u0006\u0004\bCA$Y\u0013\tI&HA\u0002J]R\u00042\u0001U.X\u0013\ta\u0016K\u0001\u0003MSN$\u0018AG3ya\u0016\u001cG/\u001a3SKBd\u0017nY1BgNLwM\\7f]R\u0004\u0013\u0001\u0003;fCJ$un\u001e8\u0015\u0003\u0019C#aB1\u0011\u0005\t<W\"A2\u000b\u0005\u0011,\u0017!\u00026v]&$(\"\u00014\u0002\u0007=\u0014x-\u0003\u0002iG\n)\u0011I\u001a;fe\u0006\u0019C/Z:u\t\u0016dW\r^3U_BL7mV5uQ\u0006cG.\u00117jm\u0016\u0014V\r\u001d7jG\u0006\u001c\bF\u0001\u0005l!\t\u0011G.\u0003\u0002nG\n!A+Z:u\u0003)\"Xm\u001d;SKN,X.\u001a#fY\u0016$X\rV8qS\u000e<\u0016\u000e\u001e5SK\u000e|g/\u001a:fI\u001a{G\u000e\\8xKJD#!C6\u0002SQ,7\u000f\u001e*fgVlW\rR3mKR,Gk\u001c9jG>s7i\u001c8ue>dG.\u001a:GC&dwN^3sQ\tQ1.\u0001\u0016uKN$\b+\u0019:uSRLwN\u001c*fCN\u001c\u0018n\u001a8nK:$H)\u001e:j]\u001e$U\r\\3uKR{\u0007/[2)\u0005-Y\u0017!D4fi\u000e{g\u000e\u001e:pY2,'\u000fF\u0001w!\u00119uOP,\n\u0005aT$A\u0002+va2,''\u0001\ff]N,(/Z\"p]R\u0014x\u000e\u001c7fe\u0016C\u0018n\u001d;t\u0003q9W\r^!mYJ+\u0007\u000f\\5dCN4%o\\7BgNLwM\\7f]R$R\u0001`A\u000b\u0003?\u0001R!`A\u0002\u0003\u0013q!A`@\u0011\u0005MR\u0014bAA\u0001u\u00051\u0001K]3eK\u001aLA!!\u0002\u0002\b\t\u00191+\u001a;\u000b\u0007\u0005\u0005!\b\u0005\u0003\u0002\f\u0005EQBAA\u0007\u0015\r\ty\u0001I\u0001\u000bG>tGO]8mY\u0016\u0014\u0018\u0002BA\n\u0003\u001b\u00111\u0003U1si&$\u0018n\u001c8B]\u0012\u0014V\r\u001d7jG\u0006Dq!a\u0006\u000f\u0001\u0004\tI\"A\u0003u_BL7\rE\u0002~\u00037IA!!\b\u0002\b\t11\u000b\u001e:j]\u001eDq!!\t\u000f\u0001\u0004\t\u0019#\u0001\u0006bgNLwM\\7f]R\u0004b!`A\u0013/\u0006\u001d\u0012b\u0001,\u0002\bA\u0019\u0011gO,\u0002WQ,7\u000f^%oGJ,\u0017m]3QCJ$\u0018\u000e^5p]\u000e{WO\u001c;EkJLgn\u001a#fY\u0016$X\rV8qS\u000eD#aD6\u0002CQ,7\u000f\u001e#fY\u0016$X\rV8qS\u000e$UO]5oO\u0006#G\rU1si&$\u0018n\u001c8)\u0005AY\u0017!\t;fgR\fE\r\u001a)beRLG/[8o\tV\u0014\u0018N\\4EK2,G/\u001a+pa&\u001c\u0007FA\tl\u0003y!Xm\u001d;SK\u000e\u0014X-\u0019;f)>\u0004\u0018nY!gi\u0016\u0014H)\u001a7fi&|g\u000e\u000b\u0002\u0013W\u0006QB/Z:u\t\u0016dW\r^3O_:,\u00050[:uS:<Gk\u001c9jG\"\u00121c[\u0001\u001bi\u0016\u001cH\u000fR3mKR,Gk\u001c9jG^KG\u000f[\"mK\u0006tWM\u001d\u0015\u0003)-\fQ\u0005^3ti\u0012+G.\u001a;f)>\u0004\u0018nY!me\u0016\fG-_'be.,G-Q:EK2,G/\u001a3)\u0005UY\u0017!G2sK\u0006$X\rV3tiR{\u0007/[2B]\u0012\u001cE.^:uKJ$r\u0001MA%\u0003\u0017\n)\u0006C\u0004\u0002\u0018Y\u0001\r!!\u0007\t\u0013\u00055c\u0003%AA\u0002\u0005=\u0013A\u00053fY\u0016$X\rV8qS\u000e,e.\u00192mK\u0012\u00042aRA)\u0013\r\t\u0019F\u000f\u0002\b\u0005>|G.Z1o\u0011%\t9F\u0006I\u0001\u0002\u0004\tI&A\tsKBd\u0017nY1BgNLwM\\7f]R\u0004b!`A\u0013/\u0006m\u0003\u0003B\u0019\u0002^]K!\u0001X\u001f\u0002G\r\u0014X-\u0019;f)\u0016\u001cH\u000fV8qS\u000e\fe\u000eZ\"mkN$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\r\u0016\u0005\u0003\u001f\n)g\u000b\u0002\u0002hA!\u0011\u0011NA:\u001b\t\tYG\u0003\u0003\u0002n\u0005=\u0014!C;oG\",7m[3e\u0015\r\t\tHO\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA;\u0003W\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\r\u001a'/Z1uKR+7\u000f\u001e+pa&\u001c\u0017I\u001c3DYV\u001cH/\u001a:%I\u00164\u0017-\u001e7uIM*\"!a\u001f+\t\u0005e\u0013Q\r\u000b\ba\u0005}\u0014\u0011QAL\u0011\u001d\t9\"\u0007a\u0001\u00033Aq!a!\u001a\u0001\u0004\t))A\u0007ce>\\WM]\"p]\u001aLwm\u001d\t\u0005cm\n9\t\u0005\u0003\u0002\n\u0006MUBAAF\u0015\u0011\ti)a$\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003#\u000bAA[1wC&!\u0011QSAF\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\b\u0003/J\u0002\u0019AA-\u0003%9(/\u001b;f\tV\u00048\u000f\u0006\u0005\u0002\u001e\u0006\u0005\u0016QUAU!\u0011\t4(a(\u0011\t\u001d;xk\u0016\u0005\u0007\u0003GS\u0002\u0019A,\u0002\u000f9,XnS3zg\"1\u0011q\u0015\u000eA\u0002]\u000bqA\\;n\tV\u00048\u000fC\u0004\u0002,j\u0001\r!!,\u0002\u00071|w\r\u0005\u0003\u00020\u0006MVBAAY\u0015\r\tY\u000bI\u0005\u0005\u0003k\u000b\tLA\u0002M_\u001e\fa\u0003^3ti\u0012K7/\u00192mK\u0012+G.\u001a;f)>\u0004\u0018n\u0019\u0015\u00037-\f\u0011\u0005^3ti\u0012+G.\u001a;j]\u001e\u0004\u0016M\u001d;jC2d\u0017\u0010R3mKR,G\rV8qS\u000eD#\u0001H6")
public class DeleteTopicTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final scala.collection.immutable.Map<Object, List<Object>> expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public scala.collection.immutable.Map<Object, List<Object>> expectedReplicaAssignment() {
        return this.expectedReplicaAssignment;
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testDeleteTopicWithAllAliveReplicas() {
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
    }

    @Test
    public void testResumeDeleteTopicWithRecoveredFollower() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower = (KafkaServer)((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$1(leaderIdOpt, s)))).last();
        follower.shutdown();
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$3(follower, s)))).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$4(topicPartition, x$1))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Replicas 0,1 have not deleted log.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.zkClient().isTopicMarkedForDeletion(topic), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Admin path /admin/delete_topic/test path deleted even when a follower replica is down", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
    }

    @Test
    public void testResumeDeleteTopicOnControllerFailover() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        int controllerId = BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fail("Controller doesn't exist", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83))));
        KafkaServer controller = (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicOnControllerFailover$2(controllerId, s)))).head();
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        KafkaServer follower = (KafkaServer)((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicOnControllerFailover$3(leaderIdOpt, controllerId, s)))).last();
        follower.shutdown();
        this.adminZkClient().deleteTopic(topic);
        controller.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.zkClient().isTopicMarkedForDeletion(topic), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Admin path /admin/delete_topic/test path deleted even when a replica is down", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        controller.startup();
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
    }

    @Test
    public void testPartitionReassignmentDuringDeleteTopic() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14());
        brokerConfigs.foreach((Function1 & Serializable & scala.Serializable)p -> p.setProperty("delete.topic.enable", "true"));
        Seq allServers = (Seq)brokerConfigs.map((Function1 & Serializable & scala.Serializable)b -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom());
        this.servers_$eq((Seq<KafkaServer>)allServers);
        Seq servers = (Seq)allServers.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$3(expectedReplicaAssignment, s)));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, (Seq<KafkaServer>)servers);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> servers.forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$5(topicPartition, x$2))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Replicas for topic test not created.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower = (KafkaServer)((TraversableLike)servers.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$7(leaderIdOpt, s)))).last();
        follower.shutdown();
        this.adminZkClient().deleteTopic(topic);
        Seq oldAssignedReplicas = this.zkClient().getReplicasForPartition(new TopicPartition(topic, 0));
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        KafkaZkClient x$3 = this.zkClient();
        None$ x$4 = None$.MODULE$;
        scala.collection.immutable.Map x$5 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)newReplicas)}));
        AdminZkClient x$6 = this.adminZkClient();
        Map x$7 = ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4();
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(x$3, (Option)x$4, (Map)x$5, x$7, x$6);
        Assert.assertTrue((String)"Partition reassignment should fail for [test,0]", (boolean)reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1(), reassignPartitionsCommand.reassignPartitions$default$2()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Object object = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.zkClient(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)newReplicas)}))).getOrElse((Object)topicPartition, (Function0 & Serializable & scala.Serializable)() -> this.fail(new StringBuilder(38).append("Failed to get reassignment status for ").append(topicPartition).toString(), new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137)));
            ReassignmentFailed$ reassignmentFailed$ = ReassignmentFailed$.MODULE$;
            return !(object != null ? !object.equals(reassignmentFailed$) : reassignmentFailed$ != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Partition reassignment shouldn't complete.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        int controllerId = BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fail("Controller doesn't exist", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139))));
        KafkaServer controller = (KafkaServer)((IterableLike)servers.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$12(controllerId, s)))).head();
        Assert.assertFalse((String)"Partition reassignment should fail", (boolean)controller.kafkaController().controllerContext().partitionsBeingReassigned().contains((Object)topicPartition));
        Seq assignedReplicas = this.zkClient().getReplicasForPartition(new TopicPartition(topic, 0));
        Assert.assertEquals((String)"Partition should not be reassigned to 0, 1, 2", (Object)oldAssignedReplicas, (Object)assignedReplicas);
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, (Seq<KafkaServer>)servers);
    }

    private Tuple2<KafkaServer, Object> getController() {
        int controllerId = BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fail("Controller doesn't exist", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150))));
        KafkaServer controller = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$getController$2(controllerId, s))).get();
        return new Tuple2((Object)controller, (Object)BoxesRunTime.boxToInteger((int)controllerId));
    }

    private void ensureControllerExists() {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            try {
                this.getController();
                bl = true;
            }
            catch (Throwable throwable) {
                bl = false;
            }
            return bl;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Controller should eventually exist", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private scala.collection.immutable.Set<PartitionAndReplica> getAllReplicasFromAssignment(String topic, scala.collection.immutable.Map<Object, Seq<Object>> assignment) {
        return ((TraversableOnce)assignment.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int partition = tuple2._1$mcI$sp();
            Seq replicas = (Seq)tuple2._2();
            Seq seq = (Seq)replicas.map((Function1 & Serializable & scala.Serializable)r -> DeleteTopicTest.$anonfun$getAllReplicasFromAssignment$2(topic, partition, BoxesRunTime.unboxToInt((Object)r)), Seq$.MODULE$.canBuildFrom());
            return seq;
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    @Test
    public void testIncreasePartitionCountDuringDeleteTopic() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14());
        brokerConfigs.foreach((Function1 & Serializable & scala.Serializable)p -> p.setProperty("delete.topic.enable", "true"));
        Seq allServers = (Seq)brokerConfigs.map((Function1 & Serializable & scala.Serializable)b -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom());
        this.servers_$eq((Seq<KafkaServer>)allServers);
        Seq servers = (Seq)allServers.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$3(expectedReplicaAssignment, s)));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, (Seq<KafkaServer>)servers);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> servers.forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$5(topicPartition, x$3))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Replicas for topic test not created.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(topicPartition);
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower = (KafkaServer)((TraversableLike)servers.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$7(leaderIdOpt, s)))).last();
        follower.shutdown();
        this.adminZkClient().deleteTopic(topic);
        this.ensureControllerExists();
        Tuple2<KafkaServer, Object> tuple2 = this.getController();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        KafkaServer controller = (KafkaServer)tuple2._1();
        int controllerId = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)controller, (Object)BoxesRunTime.boxToInteger((int)controllerId));
        Tuple2 tuple23 = tuple22;
        KafkaServer controller2 = (KafkaServer)tuple23._1();
        int controllerId2 = tuple23._2$mcI$sp();
        scala.collection.immutable.Set<PartitionAndReplica> allReplicasForTopic = this.getAllReplicasFromAssignment(topic, (scala.collection.immutable.Map<Object, Seq<Object>>)expectedReplicaAssignment);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Set replicasInDeletionSuccessful = controller2.kafkaController().replicaStateMachine().replicasInState(topic, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
            scala.collection.immutable.Set offlineReplicas = controller2.kafkaController().replicaStateMachine().replicasInState(topic, (ReplicaState)OfflineReplica$.MODULE$);
            scala.collection.immutable.Set set = allReplicasForTopic;
            Set set2 = replicasInDeletionSuccessful.union((GenSet)offlineReplicas);
            return !(set != null ? !set.equals(set2) : set2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(95).append("Not all replicas for topic ").append(topic).append(" are in states of either ReplicaDeletionSuccessful or OfflineReplica").toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        TopicCommand.TopicCommandOptions topicCommandOptions = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--alter", "--topic", topic, "--partitions", "2"}));
        new TopicCommand.ZookeeperTopicService(this.zkClient()).alterTopic(topicCommandOptions);
        int previousControllerId = controllerId2;
        controller2.shutdown();
        this.ensureControllerExists();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2<KafkaServer, Object> tuple2 = this.getController();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            KafkaServer newController = (KafkaServer)tuple2._1();
            int newControllerId = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)newController, (Object)BoxesRunTime.boxToInteger((int)newControllerId));
            Tuple2 tuple23 = tuple22;
            KafkaServer newController2 = (KafkaServer)tuple23._1();
            int newControllerId2 = tuple23._2$mcI$sp();
            return newControllerId2 != previousControllerId;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The new controller should not have the failed controller id", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        follower.startup();
        controller2.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 2, (Seq<KafkaServer>)servers);
    }

    @Test
    public void testDeleteTopicDuringAddPartition() {
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower = (KafkaServer)((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$1(leaderIdOpt, x$6)))).last();
        TopicPartition newPartition = new TopicPartition(topic, 1);
        AdminZkClient qual$1 = this.adminZkClient();
        RackAwareMode x$1 = qual$1.getBrokerMetadatas$default$1();
        Option x$2 = qual$1.getBrokerMetadatas$default$2();
        Seq brokers = qual$1.getBrokerMetadatas(x$1, x$2);
        follower.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.zkClient().getBroker(follower.config().brokerId()).isEmpty(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Follower ").append(follower.config().brokerId()).append(" was not removed from ZK").toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        AdminZkClient qual$2 = this.adminZkClient();
        String x$3 = topic;
        scala.collection.immutable.Map<Object, List<Object>> x$4 = this.expectedReplicaAssignment();
        Seq x$5 = brokers;
        int x$62 = 2;
        Some x$7 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})));
        boolean x$8 = qual$2.addPartitions$default$6();
        qual$2.addPartitions(x$3, x$4, x$5, x$62, (Option)x$7, x$8);
        this.adminZkClient().deleteTopic(topic);
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.servers().forall((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$5(newPartition, x$7))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Replica logs not for new partition [test,1] not deleted after delete topic is complete.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testAddPartitionDuringDeleteTopic() {
        this.zkClient().createTopLevelPaths();
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        AdminZkClient qual$1 = this.adminZkClient();
        RackAwareMode x$1 = qual$1.getBrokerMetadatas$default$1();
        Option x$2 = qual$1.getBrokerMetadatas$default$2();
        Seq brokers = qual$1.getBrokerMetadatas(x$1, x$2);
        this.adminZkClient().deleteTopic(topic);
        TopicPartition newPartition = new TopicPartition(topic, 1);
        AdminZkClient qual$2 = this.adminZkClient();
        String x$3 = topic;
        scala.collection.immutable.Map<Object, List<Object>> x$4 = this.expectedReplicaAssignment();
        Seq x$5 = brokers;
        int x$6 = 2;
        Some x$7 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})));
        boolean x$82 = qual$2.addPartitions$default$6();
        qual$2.addPartitions(x$3, x$4, x$5, x$6, (Option)x$7, x$82);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
        Assert.assertTrue((String)"Replica logs not deleted after delete topic is complete", (boolean)this.servers().forall((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testAddPartitionDuringDeleteTopic$1(newPartition, x$8))));
    }

    @Test
    public void testRecreateTopicAfterDeletion() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, this.servers());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.servers().forall((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testRecreateTopicAfterDeletion$2(topicPartition, x$9))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Replicas for topic test not created.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testDeleteNonExistingTopic() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        try {
            this.adminZkClient().deleteTopic("test2");
            throw this.fail("Expected UnknownTopicOrPartitionException", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
        }
        catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
            TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), "test2", 1, this.servers());
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.servers().forall((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDeleteNonExistingTopic$2(topicPartition, x$10))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Replicas for topic test not created", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            Assert.assertTrue((String)"Topic test mistakenly deleted", (boolean)this.zkClient().topicExists(topic));
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topic, 0, 1000L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
            return;
        }
    }

    @Test
    public void testDeleteTopicWithCleaner() {
        String topicName = "test";
        TopicPartition topicPartition = new TopicPartition(topicName, 0);
        String topic = topicPartition.topic();
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14());
        ((Properties)brokerConfigs.head()).setProperty("delete.topic.enable", "true");
        ((Properties)brokerConfigs.head()).setProperty("log.cleaner.enable", "true");
        ((Properties)brokerConfigs.head()).setProperty("log.cleanup.policy", "compact");
        ((Properties)brokerConfigs.head()).setProperty("log.segment.bytes", "100");
        ((Properties)brokerConfigs.head()).setProperty("log.cleaner.dedupe.buffer.size", "1048577");
        this.servers_$eq(this.createTestTopicAndCluster(topic, brokerConfigs, this.expectedReplicaAssignment()));
        KafkaServer server = (KafkaServer)this.servers().head();
        LogManager qual$1 = server.logManager();
        TopicPartition x$1 = topicPartition;
        boolean x$2 = qual$1.getLog$default$2();
        Log log = (Log)qual$1.getLog(x$1, x$2).get();
        this.writeDups(100, 3, log);
        LogCleaner qual$2 = server.logManager().cleaner();
        TopicPartition x$3 = new TopicPartition(topicName, 0);
        long x$4 = 0L;
        long x$5 = qual$2.awaitCleaned$default$3();
        qual$2.awaitCleaned(x$3, x$4, x$5);
        this.adminZkClient().deleteTopic("test");
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), "test", 1, this.servers());
    }

    @Test
    public void testDeleteTopicAlreadyMarkedAsDeleted() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        try {
            this.adminZkClient().deleteTopic(topic);
            this.adminZkClient().deleteTopic(topic);
            throw this.fail("Expected TopicAlreadyMarkedForDeletionException", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 355));
        }
        catch (TopicAlreadyMarkedForDeletionException topicAlreadyMarkedForDeletionException) {
            TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
            return;
        }
    }

    private Seq<KafkaServer> createTestTopicAndCluster(String topic, boolean deleteTopicEnabled, scala.collection.immutable.Map<Object, List<Object>> replicaAssignment) {
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14());
        brokerConfigs.foreach((Function1 & Serializable & scala.Serializable)x$11 -> x$11.setProperty("delete.topic.enable", ((Object)BoxesRunTime.boxToBoolean((boolean)deleteTopicEnabled)).toString()));
        return this.createTestTopicAndCluster(topic, brokerConfigs, replicaAssignment);
    }

    private Seq<KafkaServer> createTestTopicAndCluster(String topic, Seq<Properties> brokerConfigs, scala.collection.immutable.Map<Object, List<Object>> replicaAssignment) {
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq servers = (Seq)brokerConfigs.map((Function1 & Serializable & scala.Serializable)b -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)this.expectedReplicaAssignment(), (Seq<KafkaServer>)servers);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> servers.forall((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$createTestTopicAndCluster$4(topicPartition, x$12))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Replicas for topic test not created", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        return servers;
    }

    private boolean createTestTopicAndCluster$default$2() {
        return true;
    }

    private scala.collection.immutable.Map<Object, List<Object>> createTestTopicAndCluster$default$3() {
        return this.expectedReplicaAssignment();
    }

    private Seq<Tuple2<Object, Object>> writeDups(int numKeys, int numDups, Log log) {
        IntRef counter = IntRef.create((int)0);
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable & scala.Serializable)_ -> DeleteTopicTest.$anonfun$writeDups$1(numKeys, counter, log, BoxesRunTime.unboxToInt((Object)_)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testDisableDeleteTopic() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, false, this.createTestTopicAndCluster$default$3()));
        this.adminZkClient().deleteTopic("test");
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !this.zkClient().isTopicMarkedForDeletion(topic), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Admin path /admin/delete_topic/%s path not deleted even if deleteTopic is disabled")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertTrue((boolean)this.servers().forall((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDisableDeleteTopic$3(topicPartition, x$13))));
        Assert.assertTrue((String)"Topic path disappeared", (boolean)this.zkClient().topicExists(topic));
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assert.assertTrue((String)"Leader should exist for topic test", (boolean)leaderIdOpt.isDefined());
    }

    @Test
    public void testDeletingPartiallyDeletedTopic() {
        scala.collection.immutable.Map replicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, true, (scala.collection.immutable.Map<Object, List<Object>>)replicaAssignment));
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
            x$14.shutdown();
            return BoxedUnit.UNIT;
        });
        KafkaZkClient qual$1 = this.zkClient();
        String x$1 = TopicPartitionZNode$.MODULE$.path(new TopicPartition(topic, 0));
        int x$2 = qual$1.deleteRecursive$default$2();
        qual$1.deleteRecursive(x$1, x$2);
        this.adminZkClient().deleteTopic(topic);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
            x$15.startup();
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.servers().exists((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDeletingPartiallyDeletedTopic$4(x$16))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No controller is elected", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 2, this.servers());
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$1(Option leaderIdOpt$1, KafkaServer s) {
        return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$1.get());
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$3(KafkaServer follower$1, KafkaServer s) {
        return s.config().brokerId() != follower$1.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$4(TopicPartition topicPartition$1, KafkaServer x$1) {
        LogManager qual$1 = x$1.getLogManager();
        TopicPartition x$12 = topicPartition$1;
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(x$12, x$2).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicOnControllerFailover$2(int controllerId$1, KafkaServer s) {
        return s.config().brokerId() == controllerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicOnControllerFailover$3(Option leaderIdOpt$2, int controllerId$1, KafkaServer s) {
        return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$2.get()) && s.config().brokerId() != controllerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentDuringDeleteTopic$3(scala.collection.immutable.Map expectedReplicaAssignment$1, KafkaServer s) {
        return ((LinearSeqOptimized)expectedReplicaAssignment$1.apply((Object)BoxesRunTime.boxToInteger((int)0))).contains((Object)BoxesRunTime.boxToInteger((int)s.config().brokerId()));
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentDuringDeleteTopic$5(TopicPartition topicPartition$2, KafkaServer x$2) {
        LogManager qual$1 = x$2.getLogManager();
        TopicPartition x$1 = topicPartition$2;
        boolean x$22 = qual$1.getLog$default$2();
        return qual$1.getLog(x$1, x$22).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentDuringDeleteTopic$7(Option leaderIdOpt$3, KafkaServer s) {
        return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$3.get());
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentDuringDeleteTopic$12(int controllerId$2, KafkaServer s) {
        return s.config().brokerId() == controllerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$getController$2(int controllerId$3, KafkaServer s) {
        return s.config().brokerId() == controllerId$3;
    }

    public static final /* synthetic */ PartitionAndReplica $anonfun$getAllReplicasFromAssignment$2(String topic$3, int partition$1, int r) {
        return new PartitionAndReplica(new TopicPartition(topic$3, partition$1), r);
    }

    public static final /* synthetic */ boolean $anonfun$testIncreasePartitionCountDuringDeleteTopic$3(scala.collection.immutable.Map expectedReplicaAssignment$2, KafkaServer s) {
        return ((LinearSeqOptimized)expectedReplicaAssignment$2.apply((Object)BoxesRunTime.boxToInteger((int)0))).contains((Object)BoxesRunTime.boxToInteger((int)s.config().brokerId()));
    }

    public static final /* synthetic */ boolean $anonfun$testIncreasePartitionCountDuringDeleteTopic$5(TopicPartition topicPartition$3, KafkaServer x$3) {
        LogManager qual$1 = x$3.getLogManager();
        TopicPartition x$1 = topicPartition$3;
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(x$1, x$2).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testIncreasePartitionCountDuringDeleteTopic$7(Option leaderIdOpt$4, KafkaServer s) {
        return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$4.get());
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicDuringAddPartition$1(Option leaderIdOpt$5, KafkaServer x$6) {
        return x$6.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$5.get());
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicDuringAddPartition$5(TopicPartition newPartition$1, KafkaServer x$7) {
        LogManager qual$3 = x$7.getLogManager();
        TopicPartition x$9 = newPartition$1;
        boolean x$10 = qual$3.getLog$default$2();
        return qual$3.getLog(x$9, x$10).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testAddPartitionDuringDeleteTopic$1(TopicPartition newPartition$2, KafkaServer x$8) {
        LogManager qual$3 = x$8.getLogManager();
        TopicPartition x$9 = newPartition$2;
        boolean x$10 = qual$3.getLog$default$2();
        return qual$3.getLog(x$9, x$10).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testRecreateTopicAfterDeletion$2(TopicPartition topicPartition$4, KafkaServer x$9) {
        LogManager qual$1 = x$9.getLogManager();
        TopicPartition x$1 = topicPartition$4;
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(x$1, x$2).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteNonExistingTopic$2(TopicPartition topicPartition$5, KafkaServer x$10) {
        LogManager qual$1 = x$10.getLogManager();
        TopicPartition x$1 = topicPartition$5;
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(x$1, x$2).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$createTestTopicAndCluster$4(TopicPartition topicPartition$6, KafkaServer x$12) {
        LogManager qual$1 = x$12.getLogManager();
        TopicPartition x$1 = topicPartition$6;
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(x$1, x$2).isDefined();
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeDups$2(IntRef counter$1, Log log$1, int key) {
        int count = counter$1.elem;
        log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(((Object)BoxesRunTime.boxToInteger((int)counter$1.elem)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4());
        ++counter$1.elem;
        return new Tuple2.mcII.sp(key, count);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$writeDups$1(int numKeys$1, IntRef counter$1, Log log$1, int _) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numKeys$1).map((Function1 & Serializable & scala.Serializable)key -> DeleteTopicTest.$anonfun$writeDups$2(counter$1, log$1, BoxesRunTime.unboxToInt((Object)key)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$testDisableDeleteTopic$3(TopicPartition topicPartition$7, KafkaServer x$13) {
        LogManager qual$1 = x$13.getLogManager();
        TopicPartition x$1 = topicPartition$7;
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(x$1, x$2).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testDeletingPartiallyDeletedTopic$4(KafkaServer x$16) {
        return x$16.kafkaController().isActive();
    }
}

