/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import joptsimple.OptionException;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommandTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.GroupNotEmptyException;
import org.apache.kafka.common.protocol.Errors;
import org.junit.Assert;
import org.junit.Test;
import scala.Array$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00153A\u0001D\u0007\u0001%!)q\u0003\u0001C\u00011!)!\u0004\u0001C\u00017!)1\u0007\u0001C\u00017!)Q\u0007\u0001C\u00017!)q\u0007\u0001C\u00017!)\u0011\b\u0001C\u00017!)1\b\u0001C\u00017!)Q\b\u0001C\u00017!)q\b\u0001C\u00017!)\u0011\t\u0001C\u00017!)1\t\u0001C\u00017\tAB)\u001a7fi\u0016\u001cuN\\:v[\u0016\u0014xI]8vaN$Vm\u001d;\u000b\u00059y\u0011!B1e[&t'\"\u0001\t\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0005\t\u0003)Ui\u0011!D\u0005\u0003-5\u0011\u0001dQ8ogVlWM]$s_V\u00048i\\7nC:$G+Z:u\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u0015\u0001\u0005IB/Z:u\t\u0016dW\r^3XSRDGk\u001c9jG>\u0003H/[8o)\u0005a\u0002CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"\u0001B+oSRDCAA\u0012,YA\u0011A%K\u0007\u0002K)\u0011aeJ\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002Q\u0005\u0019qN]4\n\u0005)*#\u0001\u0002+fgR\f\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0002[A\u0011a&M\u0007\u0002_)\t\u0001'\u0001\u0006k_B$8/[7qY\u0016L!AM\u0018\u0003\u001f=\u0003H/[8o\u000bb\u001cW\r\u001d;j_:\fQ\u0004^3ti\u0012+G.\u001a;f\u00076$gj\u001c8Fq&\u001cH/\u001b8h\u000fJ|W\u000f\u001d\u0015\u0003\u0007\r\n!\u0004^3ti\u0012+G.\u001a;f\u001d>tW\t_5ti&twm\u0012:pkBD#\u0001B\u0012\u00025Q,7\u000f\u001e#fY\u0016$XmQ7e\u001d>tW)\u001c9us\u001e\u0013x.\u001e9)\u0005\u0015\u0019\u0013a\u0006;fgR$U\r\\3uK:{g.R7qif<%o\\;qQ\t11%A\fuKN$H)\u001a7fi\u0016\u001cU\u000eZ#naRLxI]8va\"\u0012qaI\u0001\u0015i\u0016\u001cH\u000fR3mKR,W)\u001c9us\u001e\u0013x.\u001e9)\u0005!\u0019\u0013!\n;fgR$U\r\\3uK\u000ekGmV5uQ6K\u0007p\u00144Tk\u000e\u001cWm]:B]\u0012,%O]8sQ\tI1%\u0001\u0012uKN$H)\u001a7fi\u0016<\u0016\u000e\u001e5NSb|emU;dG\u0016\u001c8/\u00118e\u000bJ\u0014xN\u001d\u0015\u0003\u0015\r\n1\u0006^3ti\u0012+G.\u001a;f/&$\b.\u00168sK\u000e|wM\\5{K\u0012tUm^\"p]N,X.\u001a:PaRLwN\u001c\u0015\u0005\u0017\rZC\u0006")
public class DeleteConsumerGroupsTest
extends ConsumerGroupCommandTest {
    @Test(expected=OptionException.class)
    public void testDeleteWithTopicOption() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group(), "--topic"});
        this.getConsumerGroupService(cgcArgs);
    }

    @Test
    public void testDeleteCmdNonExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", missingGroup});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service.deleteGroups());
        Assert.assertTrue((String)new StringBuilder(68).append("The expected error (").append(Errors.GROUP_ID_NOT_FOUND).append(") was not detected while deleting consumer group").toString(), (output.contains(new StringBuilder(37).append("Group '").append(missingGroup).append("' could not be deleted due to:").toString()) && output.contains(Errors.GROUP_ID_NOT_FOUND.message()) ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteNonExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", missingGroup});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        Map result = service.deleteGroups();
        Assert.assertTrue((String)new StringBuilder(68).append("The expected error (").append(Errors.GROUP_ID_NOT_FOUND).append(") was not detected while deleting consumer group").toString(), (result.size() == 1 && result.keySet().contains((Object)missingGroup) && ((Throwable)result.get((Object)missingGroup).get()).getCause() instanceof GroupIdNotFoundException ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteCmdNonEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$1 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((SeqLike)((Option)service.collectGroupMembers(false)._2()).get()).size() == 1;
        Function0 & Serializable & scala.Serializable x$2 = (Function0 & Serializable & scala.Serializable)() -> "The group did not initialize as expected.";
        int x$3 = 3;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$1, (Function0<String>)x$2, x$4, x$5, x$3);
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service.deleteGroups());
        Assert.assertTrue((String)new StringBuilder(84).append("The expected error (").append(Errors.NON_EMPTY_GROUP).append(") was not detected while deleting consumer group. Output was: (").append(output).append(")").toString(), (output.contains(new StringBuilder(37).append("Group '").append(this.group()).append("' could not be deleted due to:").toString()) && output.contains(Errors.NON_EMPTY_GROUP.message()) ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteNonEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$1 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((SeqLike)((Option)service.collectGroupMembers(false)._2()).get()).size() == 1;
        Function0 & Serializable & scala.Serializable x$2 = (Function0 & Serializable & scala.Serializable)() -> "The group did not initialize as expected.";
        int x$3 = 3;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$1, (Function0<String>)x$2, x$4, x$5, x$3);
        Map result = service.deleteGroups();
        Assert.assertNotNull((String)new StringBuilder(73).append("Group was deleted successfully, but it shouldn't have been. Result was:(").append(result).append(")").toString(), (Object)result.get((Object)this.group()).get());
        Assert.assertTrue((String)new StringBuilder(83).append("The expected error (").append(Errors.NON_EMPTY_GROUP).append(") was not detected while deleting consumer group. Result was:(").append(result).append(")").toString(), (result.size() == 1 && result.keySet().contains((Object)this.group()) && ((Throwable)result.get((Object)this.group()).get()).getCause() instanceof GroupNotEmptyException ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteCmdEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$1 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> service.listGroups().contains((Object)this.group());
        Function0 & Serializable & scala.Serializable x$2 = (Function0 & Serializable & scala.Serializable)() -> "The group did not initialize as expected.";
        int x$3 = 3;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$1, (Function0<String>)x$2, x$4, x$5, x$3);
        executor.shutdown();
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$6 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            String string = service.collectGroupState().state();
            String string2 = "Empty";
            return !(string != null ? !string.equals(string2) : string2 != null);
        };
        Function0 & Serializable & scala.Serializable x$7 = (Function0 & Serializable & scala.Serializable)() -> "The group did become empty as expected.";
        int x$8 = 3;
        long x$9 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$10 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$6, (Function0<String>)x$7, x$9, x$10, x$8);
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service.deleteGroups());
        Assert.assertTrue((String)"The consumer group could not be deleted as expected", (boolean)output.contains(new StringBuilder(58).append("Deletion of requested consumer groups ('").append(this.group()).append("') was successful.").toString()));
    }

    @Test
    public void testDeleteEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$1 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> service.listGroups().contains((Object)this.group());
        Function0 & Serializable & scala.Serializable x$2 = (Function0 & Serializable & scala.Serializable)() -> "The group did not initialize as expected.";
        int x$3 = 3;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$1, (Function0<String>)x$2, x$4, x$5, x$3);
        executor.shutdown();
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$6 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            String string = service.collectGroupState().state();
            String string2 = "Empty";
            return !(string != null ? !string.equals(string2) : string2 != null);
        };
        Function0 & Serializable & scala.Serializable x$7 = (Function0 & Serializable & scala.Serializable)() -> "The group did become empty as expected.";
        int x$8 = 3;
        long x$9 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$10 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$6, (Function0<String>)x$7, x$9, x$10, x$8);
        Map result = service.deleteGroups();
        Assert.assertTrue((String)"The consumer group could not be deleted as expected", (result.size() == 1 && result.keySet().contains((Object)this.group()) && result.get((Object)this.group()).get() == null ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteCmdWithMixOfSuccessAndError() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$1 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> service.listGroups().contains((Object)this.group());
        Function0 & Serializable & scala.Serializable x$2 = (Function0 & Serializable & scala.Serializable)() -> "The group did not initialize as expected.";
        int x$3 = 3;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$1, (Function0<String>)x$2, x$4, x$5, x$3);
        executor.shutdown();
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$6 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            String string = service.collectGroupState().state();
            String string2 = "Empty";
            return !(string != null ? !string.equals(string2) : string2 != null);
        };
        Function0 & Serializable & scala.Serializable x$7 = (Function0 & Serializable & scala.Serializable)() -> "The group did become empty as expected.";
        int x$8 = 3;
        long x$9 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$10 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$6, (Function0<String>)x$7, x$9, x$10, x$8);
        ConsumerGroupCommand.ConsumerGroupService service2 = this.getConsumerGroupService((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cgcArgs)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--group", missingGroup})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service2.deleteGroups());
        Assert.assertTrue((String)"The consumer group deletion did not work as expected", (output.contains(new StringBuilder(37).append("Group '").append(missingGroup).append("' could not be deleted due to:").toString()) && output.contains(Errors.GROUP_ID_NOT_FOUND.message()) && output.contains(new StringBuilder(51).append("These consumer groups were deleted successfully: '").append(this.group()).append("'").toString()) ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteWithMixOfSuccessAndError() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$1 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> service.listGroups().contains((Object)this.group());
        Function0 & Serializable & scala.Serializable x$2 = (Function0 & Serializable & scala.Serializable)() -> "The group did not initialize as expected.";
        int x$3 = 3;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$1, (Function0<String>)x$2, x$4, x$5, x$3);
        executor.shutdown();
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$6 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            String string = service.collectGroupState().state();
            String string2 = "Empty";
            return !(string != null ? !string.equals(string2) : string2 != null);
        };
        Function0 & Serializable & scala.Serializable x$7 = (Function0 & Serializable & scala.Serializable)() -> "The group did become empty as expected.";
        int x$8 = 3;
        long x$9 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$10 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$6, (Function0<String>)x$7, x$9, x$10, x$8);
        ConsumerGroupCommand.ConsumerGroupService service2 = this.getConsumerGroupService((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cgcArgs)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--group", missingGroup})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        Map result = service2.deleteGroups();
        Assert.assertTrue((String)"The consumer group deletion did not work as expected", (result.size() == 2 && result.keySet().contains((Object)this.group()) && result.get((Object)this.group()).get() == null && result.keySet().contains((Object)missingGroup) && ((Throwable)result.get((Object)missingGroup).get()).getMessage().contains(Errors.GROUP_ID_NOT_FOUND.message()) ? 1 : 0) != 0);
    }

    @Test(expected=OptionException.class)
    public void testDeleteWithUnrecognizedNewConsumerOption() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--new-consumer", "--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        this.getConsumerGroupService(cgcArgs);
    }
}

