/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareTest;
import kafka.admin.ReplicaDistributions;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.zk.ConfigEntityZNode$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.security.JaasUtils;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001e4A\u0001E\t\u0001-!)q\u0005\u0001C\u0001Q!9!\u0006\u0001a\u0001\n\u0003Y\u0003b\u0002!\u0001\u0001\u0004%\t!\u0011\u0005\u0007\u0011\u0002\u0001\u000b\u0015\u0002\u0017\t\u000f%\u0003\u0001\u0019!C\u0001\u0015\"9a\n\u0001a\u0001\n\u0003y\u0005BB)\u0001A\u0003&1\nC\u0003S\u0001\u0011\u00053\u000bC\u0003^\u0001\u0011\u00053\u000bC\u0003c\u0001\u0011\u00051\u000bC\u0003h\u0001\u0011\u00051\u000bC\u0003j\u0001\u0011\u00051\u000bC\u0003l\u0001\u0011\u00051\u000bC\u0003n\u0001\u0011\u00051\u000bC\u0003p\u0001\u0011\u00051KA\u0005BI6Lg\u000eV3ti*\u0011!cE\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0002)\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\u0018;\r\u0002\"\u0001G\u000e\u000e\u0003eQ!AG\n\u0002\u0005i\\\u0017B\u0001\u000f\u001a\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tgB\u0011a$I\u0007\u0002?)\u0011\u0001eE\u0001\u0006kRLGn]\u0005\u0003E}\u0011q\u0001T8hO&tw\r\u0005\u0002%K5\t\u0011#\u0003\u0002'#\ti!+Y2l\u0003^\f'/\u001a+fgR\fa\u0001P5oSRtD#A\u0015\u0011\u0005\u0011\u0002\u0011aB:feZ,'o]\u000b\u0002YA\u0019Qf\u000e\u001e\u000f\u00059\"dBA\u00183\u001b\u0005\u0001$BA\u0019\u0016\u0003\u0019a$o\\8u}%\t1'A\u0003tG\u0006d\u0017-\u0003\u00026m\u00059\u0001/Y2lC\u001e,'\"A\u001a\n\u0005aJ$aA*fc*\u0011QG\u000e\t\u0003wyj\u0011\u0001\u0010\u0006\u0003{M\taa]3sm\u0016\u0014\u0018BA =\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002\u0017M,'O^3sg~#S-\u001d\u000b\u0003\u0005\u001a\u0003\"a\u0011#\u000e\u0003YJ!!\u0012\u001c\u0003\tUs\u0017\u000e\u001e\u0005\b\u000f\u000e\t\t\u00111\u0001-\u0003\rAH%M\u0001\tg\u0016\u0014h/\u001a:tA\u00059!p[+uS2\u001cX#A&\u0011\u0005ya\u0015BA' \u0005\u001dQ6.\u0016;jYN\f1B_6Vi&d7o\u0018\u0013fcR\u0011!\t\u0015\u0005\b\u000f\u001a\t\t\u00111\u0001L\u0003!Q8.\u0016;jYN\u0004\u0013!B:fiV\u0003H#\u0001\")\u0005!)\u0006C\u0001,\\\u001b\u00059&B\u0001-Z\u0003\u0015QWO\\5u\u0015\u0005Q\u0016aA8sO&\u0011Al\u0016\u0002\u0007\u0005\u00164wN]3\u0002\u0011Q,\u0017M\u001d#po:D#!C0\u0011\u0005Y\u0003\u0017BA1X\u0005\u0015\te\r^3s\u0003m!Xm\u001d;NC:,\u0018\r\u001c*fa2L7-Y!tg&<g.\\3oi\"\u0012!\u0002\u001a\t\u0003-\u0016L!AZ,\u0003\tQ+7\u000f^\u0001\u0016i\u0016\u001cH\u000fV8qS\u000e\u001c%/Z1uS>t\u0017J\u001c.LQ\tYA-\u0001\u0010uKN$Hk\u001c9jG\u000e\u0013X-\u0019;j_:<\u0016\u000e\u001e5D_2d\u0017n]5p]\"\u0012A\u0002Z\u0001\u001ci\u0016\u001cHoQ8oGV\u0014(/\u001a8u)>\u0004\u0018nY\"sK\u0006$\u0018n\u001c8)\u00055!\u0017a\u0007;fgR\u0014un\u001c;tiJ\f\u0007o\u00117jK:$\u0018\nZ\"p]\u001aLw\r\u000b\u0002\u000fI\u00061B/Z:u\u000f\u0016$(I]8lKJlU\r^1eCR\f7\u000f\u000b\u0002\u0010I\"\"\u0001A];x!\t\u00195/\u0003\u0002um\tQA-\u001a9sK\u000e\fG/\u001a3\"\u0003Y\fa\t\u00165jg\u0002\"Xm\u001d;!Q\u0006\u001c\bEY3f]\u0002\"W\r\u001d:fG\u0006$X\r\u001a\u0011b]\u0012\u0004s/\u001b7mA\t,\u0007E]3n_Z,G\rI5oA\u0005\u0004c-\u001e;ve\u0016\u0004#/\u001a7fCN,g&I\u0001y\u0003\u0015\td&\r\u00181\u0001")
public class AdminTest
extends ZooKeeperTestHarness
implements RackAwareTest {
    private Seq<KafkaServer> servers;
    private ZkUtils zkUtils;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest.checkReplicaDistribution$(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest.checkReplicaDistribution$default$6$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest.checkReplicaDistribution$default$7$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest.checkReplicaDistribution$default$8$(this);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest.getReplicaDistribution$(this, assignment, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest.toBrokerMetadata$(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest.toBrokerMetadata$default$2$(this);
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.zkUtils_$eq(ZkUtils$.MODULE$.apply(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), BoxesRunTime.unboxToBoolean((Object)this.zkAclsEnabled().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> JaasUtils.isZkSecurityEnabled()))));
    }

    @Override
    @After
    public void tearDown() {
        if (this.zkUtils() != null) {
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.zkUtils().close(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
        }
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testManualReplicaAssignment() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), "test", (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 0})))})), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5()), ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("AdminTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), "test", (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))})), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5()), ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("AdminTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        Map assignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))}));
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), "test", assignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        scala.collection.mutable.Map found = this.zkUtils().getPartitionAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test"})));
        Assert.assertEquals((Object)assignment, (Object)found.apply((Object)"test"));
    }

    @Test
    public void testTopicCreationInZK() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})))}));
        scala.collection.immutable.Map leaderForPartitionMap = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)BoxesRunTime.boxToInteger((int)1))}));
        String topic = "test";
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})));
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        TestUtils$.MODULE$.makeLeaderForPartition(this.zkClient(), topic, (scala.collection.immutable.Map<Object, Object>)leaderForPartitionMap, 1);
        scala.collection.immutable.Map actualReplicaList = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])leaderForPartitionMap.keys().toArray(ClassTag$.MODULE$.Int()))).map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)p))), (Object)this.zkUtils().getReplicasForPartition(topic, BoxesRunTime.unboxToInt((Object)p))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        Assert.assertEquals((long)expectedReplicaAssignment.size(), (long)actualReplicaList.size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), actualReplicaList.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assert.assertEquals((Object)expectedReplicaAssignment.get((Object)BoxesRunTime.boxToInteger((int)i)).get(), (Object)actualReplicaList.apply((Object)BoxesRunTime.boxToInteger((int)i))));
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5()), ClassTag$.MODULE$.apply(TopicExistsException.class), new Position("AdminTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
    }

    @Test
    public void testTopicCreationWithCollision() {
        String topic = "test.topic";
        String collidingTopic = "test_topic";
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})));
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), topic, 3, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AdminUtils$.MODULE$.createTopic(this.zkUtils(), collidingTopic, 3, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6()), ClassTag$.MODULE$.apply(InvalidTopicException.class), new Position("AdminTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
    }

    @Test
    public void testConcurrentTopicCreation() {
        String topic = "test.topic";
        ZkUtils zkMock = (ZkUtils)EasyMock.createNiceMock(ZkUtils.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)zkMock.pathExists(new StringBuilder(16).append("/brokers/topics/").append(topic).toString()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        EasyMock.expect((Object)zkMock.getAllTopics()).andReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"some.topic", topic, "some.other.topic"})));
        EasyMock.replay((Object[])new Object[]{zkMock});
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AdminUtils$.MODULE$.validateCreateOrUpdateTopic(zkMock, topic, (Map)Map$.MODULE$.empty(), new Properties(), false), ClassTag$.MODULE$.apply(TopicExistsException.class), new Position("AdminTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
    }

    @Test
    public void testBootstrapClientIdConfig() {
        String clientId = "my-client";
        Properties props = new Properties();
        props.setProperty("producer_byte_rate", "1000");
        props.setProperty("consumer_byte_rate", "2000");
        Map configMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)"1000"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)"2000")}));
        Map map = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), JavaConverters$.MODULE$.mapAsJavaMapConverter(configMap).asJava())}));
        ZkUtils qual$1 = this.zkUtils();
        String x$1 = ConfigEntityZNode$.MODULE$.path(ConfigType$.MODULE$.Client(), clientId);
        String x$2 = Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.mapAsJavaMapConverter(map).asJava());
        java.util.List x$3 = qual$1.updatePersistentPath$default$3();
        qual$1.updatePersistentPath(x$1, x$2, x$3);
        Map configInZk = AdminUtils$.MODULE$.fetchAllEntityConfigs(this.zkUtils(), ConfigType$.MODULE$.Client());
        Assert.assertEquals((String)"Must have 1 overridden client config", (long)1L, (long)configInZk.size());
        Assert.assertEquals((Object)props, (Object)configInZk.apply((Object)clientId));
        KafkaServer server = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18())), TestUtils$.MODULE$.createServer$default$2());
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server}))));
        Assert.assertEquals((Object)new Quota(1000.0, true), (Object)server.dataPlaneRequestProcessor().quotas().produce().quota("ANONYMOUS", clientId));
        Assert.assertEquals((Object)new Quota(2000.0, true), (Object)server.dataPlaneRequestProcessor().quotas().fetch().quota("ANONYMOUS", clientId));
    }

    @Test
    public void testGetBrokerMetadatas() {
        Range.Inclusive brokerList = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5);
        Map rackInfo = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        Seq<BrokerMetadata> brokerMetadatas = this.toBrokerMetadata((Map<Object, String>)rackInfo, (Seq<Object>)((Seq)brokerList.filterNot((Function1)rackInfo.keySet())));
        TestUtils$.MODULE$.createBrokersInZk(brokerMetadatas, this.zkClient());
        Seq processedMetadatas1 = AdminUtils$.MODULE$.getBrokerMetadatas(this.zkUtils(), (RackAwareMode)RackAwareMode.Disabled$.MODULE$, AdminUtils$.MODULE$.getBrokerMetadatas$default$3());
        Assert.assertEquals((Object)brokerList, (Object)processedMetadatas1.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), Seq$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)List$.MODULE$.fill(brokerList.size(), (Function0 & Serializable & scala.Serializable)() -> None$.MODULE$), (Object)processedMetadatas1.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.rack(), Seq$.MODULE$.canBuildFrom()));
        Seq processedMetadatas2 = AdminUtils$.MODULE$.getBrokerMetadatas(this.zkUtils(), (RackAwareMode)RackAwareMode.Safe$.MODULE$, AdminUtils$.MODULE$.getBrokerMetadatas$default$3());
        Assert.assertEquals((Object)brokerList, (Object)processedMetadatas2.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id()), Seq$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)List$.MODULE$.fill(brokerList.size(), (Function0 & Serializable & scala.Serializable)() -> None$.MODULE$), (Object)processedMetadatas2.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.rack(), Seq$.MODULE$.canBuildFrom()));
        this.intercept((Function0 & Serializable & scala.Serializable)() -> AdminUtils$.MODULE$.getBrokerMetadatas(this.zkUtils(), (RackAwareMode)RackAwareMode.Enforced$.MODULE$, AdminUtils$.MODULE$.getBrokerMetadatas$default$3()), ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("AdminTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
        List partialList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 5}));
        Seq processedMetadatas3 = AdminUtils$.MODULE$.getBrokerMetadatas(this.zkUtils(), (RackAwareMode)RackAwareMode.Enforced$.MODULE$, (Option)new Some((Object)partialList));
        Assert.assertEquals((Object)partialList, (Object)processedMetadatas3.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id()), Seq$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)partialList.map((Function1)rackInfo, List$.MODULE$.canBuildFrom()), (Object)processedMetadatas3.flatMap((Function1 & Serializable & scala.Serializable)x$6 -> Option$.MODULE$.option2Iterable(x$6.rack()), Seq$.MODULE$.canBuildFrom()));
        int numPartitions = 3;
        ZkUtils x$12 = this.zkUtils();
        String x$22 = "foo";
        int x$32 = numPartitions;
        int x$42 = 2;
        RackAwareMode.Safe$ x$52 = RackAwareMode.Safe$.MODULE$;
        Properties x$62 = AdminUtils$.MODULE$.createTopic$default$5();
        AdminUtils$.MODULE$.createTopic(x$12, x$22, x$32, x$42, x$62, (RackAwareMode)x$52);
        scala.collection.mutable.Map assignment = this.zkUtils().getReplicaAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assert.assertEquals((long)numPartitions, (long)assignment.size());
    }

    public AdminTest() {
        RackAwareTest.$init$(this);
        this.servers = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.zkUtils = null;
    }
}

