/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Objects;

public class Stamped<V>
implements Comparable {
    public final V value;
    public final long timestamp;

    public Stamped(V value, long timestamp) {
        this.value = value;
        this.timestamp = timestamp;
    }

    public int compareTo(Object other) {
        long otherTimestamp = ((Stamped)other).timestamp;
        if (this.timestamp < otherTimestamp) {
            return -1;
        }
        if (this.timestamp > otherTimestamp) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        long otherTimestamp = ((Stamped)other).timestamp;
        return Long.compare(this.timestamp, otherTimestamp) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.timestamp);
    }
}

