/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class DeleteAclsResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private List<DeleteAclsFilterResult> filterResults;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("filter_results", new ArrayOf(DeleteAclsFilterResult.SCHEMA_0), "The results for each filter."));
    public static final Schema SCHEMA_1 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("filter_results", new ArrayOf(DeleteAclsFilterResult.SCHEMA_1), "The results for each filter."));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};

    public DeleteAclsResponseData(Readable readable, short version) {
        this.filterResults = new ArrayList<DeleteAclsFilterResult>();
        this.read(readable, version);
    }

    public DeleteAclsResponseData(Struct struct, short version) {
        this.filterResults = new ArrayList<DeleteAclsFilterResult>();
        this.fromStruct(struct, version);
    }

    public DeleteAclsResponseData() {
        this.throttleTimeMs = 0;
        this.filterResults = new ArrayList<DeleteAclsFilterResult>();
    }

    @Override
    public short apiKey() {
        return 31;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable readable, short version) {
        this.throttleTimeMs = readable.readInt();
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.filterResults.clear();
        } else {
            this.filterResults.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.filterResults.add(new DeleteAclsFilterResult(readable, version));
            }
        }
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeInt(this.throttleTimeMs);
        writable.writeInt(this.filterResults.size());
        for (DeleteAclsFilterResult element : this.filterResults) {
            element.write(writable, version);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        Object[] nestedObjects = struct.getArray("filter_results");
        this.filterResults = new ArrayList<DeleteAclsFilterResult>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.filterResults.add(new DeleteAclsFilterResult((Struct)nestedObject, version));
        }
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        Struct[] nestedObjects = new Struct[this.filterResults.size()];
        int i = 0;
        for (DeleteAclsFilterResult element : this.filterResults) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("filter_results", (Object)nestedObjects);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 4;
        size += 4;
        for (DeleteAclsFilterResult element : this.filterResults) {
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DeleteAclsResponseData)) {
            return false;
        }
        DeleteAclsResponseData other = (DeleteAclsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return !(this.filterResults == null ? other.filterResults != null : !this.filterResults.equals(other.filterResults));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.filterResults == null ? 0 : this.filterResults.hashCode());
        return hashCode;
    }

    public String toString() {
        return "DeleteAclsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", filterResults=" + MessageUtil.deepToString(this.filterResults.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<DeleteAclsFilterResult> filterResults() {
        return this.filterResults;
    }

    public DeleteAclsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DeleteAclsResponseData setFilterResults(List<DeleteAclsFilterResult> v) {
        this.filterResults = v;
        return this;
    }

    public static class DeleteAclsMatchingAcl
    implements Message {
        private short errorCode;
        private String errorMessage;
        private byte resourceType;
        private String resourceName;
        private byte patternType;
        private String principal;
        private String host;
        private byte operation;
        private byte permissionType;
        public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The deletion error code, or 0 if the deletion succeeded."), new Field("error_message", Type.NULLABLE_STRING, "The deletion error message, or null if the deletion succeeded."), new Field("resource_type", Type.INT8, "The ACL resource type."), new Field("resource_name", Type.STRING, "The ACL resource name."), new Field("principal", Type.STRING, "The ACL principal."), new Field("host", Type.STRING, "The ACL host."), new Field("operation", Type.INT8, "The ACL operation."), new Field("permission_type", Type.INT8, "The ACL permission type."));
        public static final Schema SCHEMA_1 = new Schema(new Field("error_code", Type.INT16, "The deletion error code, or 0 if the deletion succeeded."), new Field("error_message", Type.NULLABLE_STRING, "The deletion error message, or null if the deletion succeeded."), new Field("resource_type", Type.INT8, "The ACL resource type."), new Field("resource_name", Type.STRING, "The ACL resource name."), new Field("pattern_type", Type.INT8, "The ACL resource pattern type."), new Field("principal", Type.STRING, "The ACL principal."), new Field("host", Type.STRING, "The ACL host."), new Field("operation", Type.INT8, "The ACL operation."), new Field("permission_type", Type.INT8, "The ACL permission type."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};

        public DeleteAclsMatchingAcl(Readable readable, short version) {
            this.read(readable, version);
        }

        public DeleteAclsMatchingAcl(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public DeleteAclsMatchingAcl() {
            this.errorCode = 0;
            this.errorMessage = "";
            this.resourceType = 0;
            this.resourceName = "";
            this.patternType = (byte)3;
            this.principal = "";
            this.host = "";
            this.operation = 0;
            this.permissionType = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable readable, short version) {
            this.errorCode = readable.readShort();
            this.errorMessage = readable.readNullableString();
            this.resourceType = readable.readByte();
            this.resourceName = readable.readNullableString();
            this.patternType = version >= 1 ? readable.readByte() : (byte)3;
            this.principal = readable.readNullableString();
            this.host = readable.readNullableString();
            this.operation = readable.readByte();
            this.permissionType = readable.readByte();
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeShort(this.errorCode);
            writable.writeNullableString(this.errorMessage);
            writable.writeByte(this.resourceType);
            writable.writeString(this.resourceName);
            if (version >= 1) {
                writable.writeByte(this.patternType);
            }
            writable.writeString(this.principal);
            writable.writeString(this.host);
            writable.writeByte(this.operation);
            writable.writeByte(this.permissionType);
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.errorCode = struct.getShort("error_code");
            this.errorMessage = struct.getString("error_message");
            this.resourceType = struct.getByte("resource_type");
            this.resourceName = struct.getString("resource_name");
            this.patternType = version >= 1 ? struct.getByte("pattern_type") : (byte)3;
            this.principal = struct.getString("principal");
            this.host = struct.getString("host");
            this.operation = struct.getByte("operation");
            this.permissionType = struct.getByte("permission_type");
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("error_code", (Object)this.errorCode);
            struct.set("error_message", (Object)this.errorMessage);
            struct.set("resource_type", (Object)this.resourceType);
            struct.set("resource_name", (Object)this.resourceName);
            if (version >= 1) {
                struct.set("pattern_type", (Object)this.patternType);
            }
            struct.set("principal", (Object)this.principal);
            struct.set("host", (Object)this.host);
            struct.set("operation", (Object)this.operation);
            struct.set("permission_type", (Object)this.permissionType);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += 2;
            if (this.errorMessage != null) {
                size += MessageUtil.serializedUtf8Length(this.errorMessage);
            }
            ++size;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.resourceName);
            if (version >= 1) {
                ++size;
            } else if (this.patternType != 3) {
                throw new UnsupportedVersionException("Attempted to write a non-default patternType at version " + version);
            }
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.principal);
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.host);
            ++size;
            return ++size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DeleteAclsMatchingAcl)) {
                return false;
            }
            DeleteAclsMatchingAcl other = (DeleteAclsMatchingAcl)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (this.resourceType != other.resourceType) {
                return false;
            }
            if (this.resourceName == null ? other.resourceName != null : !this.resourceName.equals(other.resourceName)) {
                return false;
            }
            if (this.patternType != other.patternType) {
                return false;
            }
            if (this.principal == null ? other.principal != null : !this.principal.equals(other.principal)) {
                return false;
            }
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.operation != other.operation) {
                return false;
            }
            return this.permissionType == other.permissionType;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            hashCode = 31 * hashCode + this.resourceType;
            hashCode = 31 * hashCode + (this.resourceName == null ? 0 : this.resourceName.hashCode());
            hashCode = 31 * hashCode + this.patternType;
            hashCode = 31 * hashCode + (this.principal == null ? 0 : this.principal.hashCode());
            hashCode = 31 * hashCode + (this.host == null ? 0 : this.host.hashCode());
            hashCode = 31 * hashCode + this.operation;
            hashCode = 31 * hashCode + this.permissionType;
            return hashCode;
        }

        public String toString() {
            return "DeleteAclsMatchingAcl(errorCode=" + this.errorCode + ", errorMessage='" + this.errorMessage + "', resourceType=" + this.resourceType + ", resourceName='" + this.resourceName + "', patternType=" + this.patternType + ", principal='" + this.principal + "', host='" + this.host + "', operation=" + this.operation + ", permissionType=" + this.permissionType + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public byte resourceType() {
            return this.resourceType;
        }

        public String resourceName() {
            return this.resourceName;
        }

        public byte patternType() {
            return this.patternType;
        }

        public String principal() {
            return this.principal;
        }

        public String host() {
            return this.host;
        }

        public byte operation() {
            return this.operation;
        }

        public byte permissionType() {
            return this.permissionType;
        }

        public DeleteAclsMatchingAcl setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public DeleteAclsMatchingAcl setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        public DeleteAclsMatchingAcl setResourceType(byte v) {
            this.resourceType = v;
            return this;
        }

        public DeleteAclsMatchingAcl setResourceName(String v) {
            this.resourceName = v;
            return this;
        }

        public DeleteAclsMatchingAcl setPatternType(byte v) {
            this.patternType = v;
            return this;
        }

        public DeleteAclsMatchingAcl setPrincipal(String v) {
            this.principal = v;
            return this;
        }

        public DeleteAclsMatchingAcl setHost(String v) {
            this.host = v;
            return this;
        }

        public DeleteAclsMatchingAcl setOperation(byte v) {
            this.operation = v;
            return this;
        }

        public DeleteAclsMatchingAcl setPermissionType(byte v) {
            this.permissionType = v;
            return this;
        }
    }

    public static class DeleteAclsFilterResult
    implements Message {
        private short errorCode;
        private String errorMessage;
        private List<DeleteAclsMatchingAcl> matchingAcls;
        public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if the filter succeeded."), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if the filter succeeded."), new Field("matching_acls", new ArrayOf(DeleteAclsMatchingAcl.SCHEMA_0), "The ACLs which matched this filter."));
        public static final Schema SCHEMA_1 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if the filter succeeded."), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if the filter succeeded."), new Field("matching_acls", new ArrayOf(DeleteAclsMatchingAcl.SCHEMA_1), "The ACLs which matched this filter."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};

        public DeleteAclsFilterResult(Readable readable, short version) {
            this.matchingAcls = new ArrayList<DeleteAclsMatchingAcl>();
            this.read(readable, version);
        }

        public DeleteAclsFilterResult(Struct struct, short version) {
            this.matchingAcls = new ArrayList<DeleteAclsMatchingAcl>();
            this.fromStruct(struct, version);
        }

        public DeleteAclsFilterResult() {
            this.errorCode = 0;
            this.errorMessage = "";
            this.matchingAcls = new ArrayList<DeleteAclsMatchingAcl>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable readable, short version) {
            this.errorCode = readable.readShort();
            this.errorMessage = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.matchingAcls.clear();
            } else {
                this.matchingAcls.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.matchingAcls.add(new DeleteAclsMatchingAcl(readable, version));
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeShort(this.errorCode);
            writable.writeNullableString(this.errorMessage);
            writable.writeInt(this.matchingAcls.size());
            for (DeleteAclsMatchingAcl element : this.matchingAcls) {
                element.write(writable, version);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.errorCode = struct.getShort("error_code");
            this.errorMessage = struct.getString("error_message");
            Object[] nestedObjects = struct.getArray("matching_acls");
            this.matchingAcls = new ArrayList<DeleteAclsMatchingAcl>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.matchingAcls.add(new DeleteAclsMatchingAcl((Struct)nestedObject, version));
            }
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("error_code", (Object)this.errorCode);
            struct.set("error_message", (Object)this.errorMessage);
            Struct[] nestedObjects = new Struct[this.matchingAcls.size()];
            int i = 0;
            for (DeleteAclsMatchingAcl element : this.matchingAcls) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("matching_acls", (Object)nestedObjects);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += 2;
            if (this.errorMessage != null) {
                size += MessageUtil.serializedUtf8Length(this.errorMessage);
            }
            size += 4;
            for (DeleteAclsMatchingAcl element : this.matchingAcls) {
                size += element.size(version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DeleteAclsFilterResult)) {
                return false;
            }
            DeleteAclsFilterResult other = (DeleteAclsFilterResult)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            return !(this.matchingAcls == null ? other.matchingAcls != null : !this.matchingAcls.equals(other.matchingAcls));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            hashCode = 31 * hashCode + (this.matchingAcls == null ? 0 : this.matchingAcls.hashCode());
            return hashCode;
        }

        public String toString() {
            return "DeleteAclsFilterResult(errorCode=" + this.errorCode + ", errorMessage='" + this.errorMessage + "', matchingAcls=" + MessageUtil.deepToString(this.matchingAcls.iterator()) + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public List<DeleteAclsMatchingAcl> matchingAcls() {
            return this.matchingAcls;
        }

        public DeleteAclsFilterResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public DeleteAclsFilterResult setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        public DeleteAclsFilterResult setMatchingAcls(List<DeleteAclsMatchingAcl> v) {
            this.matchingAcls = v;
            return this;
        }
    }
}

