/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testbeans.gui;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditorSupport;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.text.JTextComponent;
import org.apache.jmeter.gui.ClearGui;
import org.apache.jmeter.testbeans.gui.GenericTestBeanCustomizer;
import org.apache.jmeter.util.JMeterUtils;

class ComboStringEditor
extends PropertyEditorSupport
implements ItemListener,
ClearGui {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final String[] tags;
    private String initialEditValue;
    private final JComboBox combo;
    private final DefaultComboBoxModel model;
    private final Map<String, String> validTranslations;
    private boolean startingEdit = false;
    final Object UNDEFINED = new UniqueObject("property_undefined");
    private final Object EDIT = new UniqueObject("property_edit");
    private final int minTagIndex;
    private final int maxTagIndex;

    @Deprecated
    ComboStringEditor() {
        this(null, false, false);
    }

    ComboStringEditor(PropertyDescriptor descriptor) {
        this((String[])descriptor.getValue("tags"), GenericTestBeanCustomizer.notExpression(descriptor), GenericTestBeanCustomizer.notNull(descriptor), (ResourceBundle)descriptor.getValue("resourceBundle"));
    }

    ComboStringEditor(String[] tags, boolean noEdit, boolean noUndefined) {
        this(tags, noEdit, noUndefined, null);
    }

    ComboStringEditor(String[] pTags, boolean noEdit, boolean noUndefined, ResourceBundle rb) {
        this.tags = pTags == null ? EMPTY_STRING_ARRAY : (String[])pTags.clone();
        this.model = new DefaultComboBoxModel();
        if (rb != null && this.tags.length > 0) {
            this.validTranslations = new HashMap<String, String>();
            for (String tag : this.tags) {
                this.validTranslations.put(tag, rb.getString(tag));
            }
        } else {
            this.validTranslations = null;
        }
        if (!noUndefined) {
            this.model.addElement(this.UNDEFINED);
        }
        if (this.tags.length == 0) {
            this.minTagIndex = Integer.MAX_VALUE;
            this.maxTagIndex = Integer.MIN_VALUE;
        } else {
            this.minTagIndex = this.model.getSize();
            for (String tag : this.tags) {
                this.model.addElement(this.translate(tag));
            }
            this.maxTagIndex = this.model.getSize();
        }
        if (!noEdit) {
            this.model.addElement(this.EDIT);
        }
        this.combo = new JComboBox(this.model);
        this.combo.addItemListener(this);
        this.combo.setEditable(false);
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return this.combo;
    }

    @Override
    public Object getValue() {
        return this.getAsText();
    }

    @Override
    public String getAsText() {
        Object value = this.combo.getSelectedItem();
        if (this.UNDEFINED.equals(value)) {
            return null;
        }
        int item = this.combo.getSelectedIndex();
        if (item >= this.minTagIndex && item <= this.maxTagIndex) {
            return this.tags[item - this.minTagIndex];
        }
        return (String)value;
    }

    @Override
    public void setValue(Object value) {
        this.setAsText((String)value);
    }

    @Override
    public void setAsText(String value) {
        this.combo.setEditable(true);
        if (value == null) {
            this.combo.setSelectedItem(this.UNDEFINED);
        } else {
            this.combo.setSelectedItem(this.translate(value));
        }
        if (!this.startingEdit && this.combo.getSelectedIndex() >= 0) {
            this.combo.setEditable(false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (this.EDIT.equals(e.getItem())) {
                this.startingEdit = true;
                this.startEditing();
                this.startingEdit = false;
            } else {
                if (!this.startingEdit && this.combo.getSelectedIndex() >= 0) {
                    this.combo.setEditable(false);
                }
                this.firePropertyChange();
            }
        }
    }

    private void startEditing() {
        JTextComponent textField = (JTextComponent)this.combo.getEditor().getEditorComponent();
        this.combo.setEditable(true);
        textField.requestFocusInWindow();
        String text = this.translate(this.initialEditValue);
        if (text == null) {
            text = "";
        }
        this.combo.setSelectedItem(text);
        int i = text.indexOf("${}");
        if (i != -1) {
            textField.setCaretPosition(i + 2);
        } else {
            textField.selectAll();
        }
    }

    @Override
    public String[] getTags() {
        return (String[])this.tags.clone();
    }

    public void setInitialEditValue(String object) {
        this.initialEditValue = object;
    }

    @Override
    public void clearGui() {
        this.setAsText(this.initialEditValue);
    }

    private String translate(String input) {
        if (this.validTranslations != null) {
            String entry = this.validTranslations.get(input);
            return entry != null ? entry : input;
        }
        return input;
    }

    private static class UniqueObject {
        private final String propKey;
        private final String propValue;

        UniqueObject(String propKey) {
            this.propKey = propKey;
            this.propValue = JMeterUtils.getResString(propKey);
        }

        public String toString() {
            return this.propValue;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof UniqueObject) {
                return this.propKey.equals(((UniqueObject)other).propKey);
            }
            return false;
        }

        public int hashCode() {
            return this.propKey.hashCode();
        }
    }
}

