/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import org.apache.jmeter.gui.action.ActionNames;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public final class IconToolbarBean {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String ICON_FIELD_SEP = ",";
    private final String i18nKey;
    private final String actionName;
    private final String iconPath;
    private final String iconPathPressed;

    IconToolbarBean(String strToSplit, String iconSize) throws IllegalArgumentException {
        if (strToSplit == null) {
            throw new IllegalArgumentException("Icon definition must not be null");
        }
        String[] tmp = strToSplit.split(ICON_FIELD_SEP);
        if (tmp.length <= 2) {
            throw new IllegalArgumentException("Incorrect argument format - expected at least 2 fields separated by ,");
        }
        this.i18nKey = tmp[0];
        this.actionName = tmp[1];
        this.iconPath = tmp[2].replace("<SIZE>", iconSize);
        this.iconPathPressed = tmp.length > 3 ? tmp[3].replace("<SIZE>", iconSize) : this.iconPath;
    }

    public String getActionNameResolve() {
        String aName;
        try {
            aName = (String)ActionNames.class.getField(this.actionName).get(null);
        }
        catch (Exception e) {
            log.warn("Toolbar icon Action names error: " + this.actionName + ", use unknown action.");
            return this.actionName;
        }
        return aName;
    }

    public String getI18nKey() {
        return this.i18nKey;
    }

    public String getActionName() {
        return this.actionName;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public String getIconPathPressed() {
        return this.iconPathPressed;
    }
}

