/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JOptionPane;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.tree.JMeterTreeListener;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterTreeNodeTransferable;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class Copy
extends AbstractAction {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final HashSet<String> commands = new HashSet();

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    @Override
    public void doAction(ActionEvent e) {
        JMeterTreeListener treeListener = GuiPackage.getInstance().getTreeListener();
        JMeterTreeNode[] nodes = treeListener.getSelectedNodes();
        nodes = Copy.keepOnlyAncestors(nodes);
        nodes = Copy.cloneTreeNodes(nodes);
        Copy.setCopiedNodes(nodes);
    }

    public static JMeterTreeNode[] getCopiedNodes() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard.isDataFlavorAvailable(JMeterTreeNodeTransferable.JMETER_TREE_NODE_ARRAY_DATA_FLAVOR)) {
            try {
                return (JMeterTreeNode[])clipboard.getData(JMeterTreeNodeTransferable.JMETER_TREE_NODE_ARRAY_DATA_FLAVOR);
            }
            catch (Exception ex) {
                log.error("Clipboard node read error:" + ex.getMessage(), (Throwable)ex);
                JOptionPane.showMessageDialog(GuiPackage.getInstance().getMainFrame(), JMeterUtils.getResString("clipboard_node_read_error") + ":\n" + ex.getLocalizedMessage(), JMeterUtils.getResString("error_title"), 0);
            }
        }
        return null;
    }

    public static JMeterTreeNode cloneTreeNode(JMeterTreeNode node) {
        JMeterTreeNode treeNode = (JMeterTreeNode)node.clone();
        treeNode.setUserObject(((TestElement)node.getUserObject()).clone());
        Copy.cloneChildren(treeNode, node);
        return treeNode;
    }

    static JMeterTreeNode[] keepOnlyAncestors(JMeterTreeNode[] currentNodes) {
        ArrayList<JMeterTreeNode> nodes = new ArrayList<JMeterTreeNode>();
        for (int i = 0; i < currentNodes.length; ++i) {
            boolean exclude = false;
            for (int j = 0; j < currentNodes.length; ++j) {
                if (i == j || !currentNodes[i].isNodeAncestor(currentNodes[j])) continue;
                exclude = true;
                break;
            }
            if (exclude) continue;
            nodes.add(currentNodes[i]);
        }
        return nodes.toArray(new JMeterTreeNode[nodes.size()]);
    }

    public static void setCopiedNodes(JMeterTreeNode[] nodes) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            JMeterTreeNodeTransferable transferable = new JMeterTreeNodeTransferable();
            transferable.setTransferData(nodes);
            clipboard.setContents(transferable, null);
        }
        catch (Exception ex) {
            log.error("Clipboard node read error:" + ex.getMessage(), (Throwable)ex);
            JOptionPane.showMessageDialog(GuiPackage.getInstance().getMainFrame(), JMeterUtils.getResString("clipboard_node_read_error") + ":\n" + ex.getLocalizedMessage(), JMeterUtils.getResString("error_title"), 0);
        }
    }

    public static JMeterTreeNode[] cloneTreeNodes(JMeterTreeNode[] nodes) {
        JMeterTreeNode[] treeNodes = new JMeterTreeNode[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            treeNodes[i] = Copy.cloneTreeNode(nodes[i]);
        }
        return treeNodes;
    }

    private static void cloneChildren(JMeterTreeNode to, JMeterTreeNode from) {
        Enumeration<JMeterTreeNode> enumFrom = from.children();
        while (enumFrom.hasMoreElements()) {
            JMeterTreeNode child = enumFrom.nextElement();
            JMeterTreeNode childClone = (JMeterTreeNode)child.clone();
            childClone.setUserObject(((TestElement)child.getUserObject()).clone());
            to.add(childClone);
            Copy.cloneChildren((JMeterTreeNode)to.getLastChild(), child);
        }
    }

    static {
        commands.add("Copy");
    }
}

