/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JMeterError;
import org.apache.log.Logger;

public class ChangeLanguage
implements Command {
    private static final Set<String> commands = new HashSet<String>();
    private static final Logger log = LoggingManager.getLoggerForClass();

    @Override
    public void doAction(ActionEvent e) {
        String locale = ((Component)e.getSource()).getName();
        int sep = locale.indexOf(95);
        Locale loc = sep > 0 ? new Locale(locale.substring(0, sep), locale.substring(sep + 1)) : new Locale(locale, "");
        log.debug("Changing locale to " + loc.toString());
        try {
            JMeterUtils.setLocale(loc);
        }
        catch (JMeterError err) {
            JMeterUtils.reportErrorToUser(err.toString());
        }
    }

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    static {
        commands.add("change_language");
    }
}

