/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.engine.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.engine.util.ReplaceFunctionsWithStrings;
import org.apache.jmeter.engine.util.ReplaceStringWithFunctions;
import org.apache.jmeter.engine.util.UndoVariableReplacement;
import org.apache.jmeter.engine.util.ValueTransformer;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.MultiProperty;
import org.apache.jmeter.testelement.property.NumberProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ValueReplacer {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private final CompoundVariable masterFunction = new CompoundVariable();
    private Map<String, String> variables = new HashMap<String, String>();

    public ValueReplacer() {
    }

    public ValueReplacer(TestPlan tp) {
        this.setUserDefinedVariables(tp.getUserDefinedVariables());
    }

    boolean containsKey(String k) {
        return this.variables.containsKey(k);
    }

    public void setUserDefinedVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    public void replaceValues(TestElement el) throws InvalidVariableException {
        Collection<JMeterProperty> newProps = this.replaceValues(el.propertyIterator(), new ReplaceStringWithFunctions(this.masterFunction, this.variables));
        this.setProperties(el, newProps);
    }

    private void setProperties(TestElement el, Collection<JMeterProperty> newProps) {
        el.clear();
        for (JMeterProperty jmp : newProps) {
            el.setProperty(jmp);
        }
    }

    public void reverseReplace(TestElement el) throws InvalidVariableException {
        Collection<JMeterProperty> newProps = this.replaceValues(el.propertyIterator(), new ReplaceFunctionsWithStrings(this.masterFunction, this.variables));
        this.setProperties(el, newProps);
    }

    public void reverseReplace(TestElement el, boolean regexMatch) throws InvalidVariableException {
        Collection<JMeterProperty> newProps = this.replaceValues(el.propertyIterator(), new ReplaceFunctionsWithStrings(this.masterFunction, this.variables, regexMatch));
        this.setProperties(el, newProps);
    }

    public void undoReverseReplace(TestElement el) throws InvalidVariableException {
        Collection<JMeterProperty> newProps = this.replaceValues(el.propertyIterator(), new UndoVariableReplacement(this.masterFunction, this.variables));
        this.setProperties(el, newProps);
    }

    public void addVariable(String name, String value) {
        this.variables.put(name, value);
    }

    public void addVariables(Map<String, String> vars) {
        this.variables.putAll(vars);
    }

    private Collection<JMeterProperty> replaceValues(PropertyIterator iter, ValueTransformer transform) throws InvalidVariableException {
        LinkedList<JMeterProperty> props = new LinkedList<JMeterProperty>();
        while (iter.hasNext()) {
            JMeterProperty val = iter.next();
            if (log.isDebugEnabled()) {
                log.debug("About to replace in property of type: " + val.getClass() + ": " + val);
            }
            if (val instanceof StringProperty) {
                if (!val.getName().equals("TestElement.gui_class") && !val.getName().equals("TestElement.test_class")) {
                    val = transform.transformValue(val);
                    if (log.isDebugEnabled()) {
                        log.debug("Replacement result: " + val);
                    }
                }
            } else if (val instanceof NumberProperty) {
                val = transform.transformValue(val);
                if (log.isDebugEnabled()) {
                    log.debug("Replacement result: " + val);
                }
            } else if (val instanceof MultiProperty) {
                MultiProperty multiVal = (MultiProperty)val;
                Collection<JMeterProperty> newValues = this.replaceValues(multiVal.iterator(), transform);
                multiVal.clear();
                for (JMeterProperty jmp : newValues) {
                    multiVal.addProperty(jmp);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Replacement result: " + multiVal);
                }
            } else if (log.isDebugEnabled()) {
                log.debug("Won't replace " + val);
            }
            props.add(val);
        }
        return props;
    }
}

