/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.extractor.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.apache.jmeter.extractor.RegexExtractor;
import org.apache.jmeter.processor.gui.AbstractPostProcessorGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledTextField;

public class RegexExtractorGui
extends AbstractPostProcessorGui {
    private static final long serialVersionUID = 240L;
    private JLabeledTextField regexField;
    private JLabeledTextField templateField;
    private JLabeledTextField defaultField;
    private JLabeledTextField matchNumberField;
    private JLabeledTextField refNameField;
    private JRadioButton useBody;
    private JRadioButton useUnescapedBody;
    private JRadioButton useBodyAsDocument;
    private JRadioButton useHeaders;
    private JRadioButton useRequestHeaders;
    private JRadioButton useURL;
    private JRadioButton useCode;
    private JRadioButton useMessage;
    private ButtonGroup group;

    public RegexExtractorGui() {
        this.init();
    }

    public String getLabelResource() {
        return "regex_extractor_title";
    }

    public void configure(TestElement el) {
        super.configure(el);
        if (el instanceof RegexExtractor) {
            RegexExtractor re = (RegexExtractor)el;
            this.showScopeSettings(re, true);
            this.useHeaders.setSelected(re.useHeaders());
            this.useRequestHeaders.setSelected(re.useRequestHeaders());
            this.useBody.setSelected(re.useBody());
            this.useUnescapedBody.setSelected(re.useUnescapedBody());
            this.useBodyAsDocument.setSelected(re.useBodyAsDocument());
            this.useURL.setSelected(re.useUrl());
            this.useCode.setSelected(re.useCode());
            this.useMessage.setSelected(re.useMessage());
            this.regexField.setText(re.getRegex());
            this.templateField.setText(re.getTemplate());
            this.defaultField.setText(re.getDefaultValue());
            this.matchNumberField.setText(re.getMatchNumberAsString());
            this.refNameField.setText(re.getRefName());
        }
    }

    public TestElement createTestElement() {
        RegexExtractor extractor = new RegexExtractor();
        this.modifyTestElement((TestElement)extractor);
        return extractor;
    }

    public void modifyTestElement(TestElement extractor) {
        super.configureTestElement(extractor);
        if (extractor instanceof RegexExtractor) {
            RegexExtractor regex = (RegexExtractor)extractor;
            this.saveScopeSettings(regex);
            regex.setUseField(this.group.getSelection().getActionCommand());
            regex.setRefName(this.refNameField.getText());
            regex.setRegex(this.regexField.getText());
            regex.setTemplate(this.templateField.getText());
            regex.setDefaultValue(this.defaultField.getText());
            regex.setMatchNumber(this.matchNumberField.getText());
        }
    }

    public void clearGui() {
        super.clearGui();
        this.useBody.setSelected(true);
        this.regexField.setText("");
        this.templateField.setText("");
        this.defaultField.setText("");
        this.refNameField.setText("");
        this.matchNumberField.setText("");
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        Box box = Box.createVerticalBox();
        box.add(this.makeTitlePanel());
        box.add(this.createScopePanel(true));
        box.add(this.makeSourcePanel());
        this.add(box, "North");
        this.add(this.makeParameterPanel(), "Center");
    }

    private JPanel makeSourcePanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"regex_source")));
        this.useBody = new JRadioButton(JMeterUtils.getResString((String)"regex_src_body"));
        this.useUnescapedBody = new JRadioButton(JMeterUtils.getResString((String)"regex_src_body_unescaped"));
        this.useBodyAsDocument = new JRadioButton(JMeterUtils.getResString((String)"regex_src_body_as_document"));
        this.useHeaders = new JRadioButton(JMeterUtils.getResString((String)"regex_src_hdrs"));
        this.useRequestHeaders = new JRadioButton(JMeterUtils.getResString((String)"regex_src_hdrs_req"));
        this.useURL = new JRadioButton(JMeterUtils.getResString((String)"regex_src_url"));
        this.useCode = new JRadioButton(JMeterUtils.getResString((String)"assertion_code_resp"));
        this.useMessage = new JRadioButton(JMeterUtils.getResString((String)"assertion_message_resp"));
        this.group = new ButtonGroup();
        this.group.add(this.useBody);
        this.group.add(this.useUnescapedBody);
        this.group.add(this.useBodyAsDocument);
        this.group.add(this.useHeaders);
        this.group.add(this.useRequestHeaders);
        this.group.add(this.useURL);
        this.group.add(this.useCode);
        this.group.add(this.useMessage);
        panel.add(this.useBody);
        panel.add(this.useUnescapedBody);
        panel.add(this.useBodyAsDocument);
        panel.add(this.useHeaders);
        panel.add(this.useRequestHeaders);
        panel.add(this.useURL);
        panel.add(this.useCode);
        panel.add(this.useMessage);
        this.useBody.setSelected(true);
        this.useBody.setActionCommand("false");
        this.useUnescapedBody.setActionCommand("unescaped");
        this.useBodyAsDocument.setActionCommand("as_document");
        this.useHeaders.setActionCommand("true");
        this.useRequestHeaders.setActionCommand("request_headers");
        this.useURL.setActionCommand("URL");
        this.useCode.setActionCommand("code");
        this.useMessage.setActionCommand("message");
        return panel;
    }

    private JPanel makeParameterPanel() {
        this.regexField = new JLabeledTextField(JMeterUtils.getResString((String)"regex_field"));
        this.templateField = new JLabeledTextField(JMeterUtils.getResString((String)"template_field"));
        this.defaultField = new JLabeledTextField(JMeterUtils.getResString((String)"default_value_field"));
        this.refNameField = new JLabeledTextField(JMeterUtils.getResString((String)"ref_name_field"));
        this.matchNumberField = new JLabeledTextField(JMeterUtils.getResString((String)"match_num_field"));
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.initConstraints(gbc);
        this.addField(panel, this.refNameField, gbc);
        this.resetContraints(gbc);
        this.addField(panel, this.regexField, gbc);
        this.resetContraints(gbc);
        this.addField(panel, this.templateField, gbc);
        this.resetContraints(gbc);
        this.addField(panel, this.matchNumberField, gbc);
        this.resetContraints(gbc);
        gbc.weighty = 1.0;
        this.addField(panel, this.defaultField, gbc);
        return panel;
    }

    private void addField(JPanel panel, JLabeledTextField field, GridBagConstraints gbc) {
        List item = field.getComponentList();
        panel.add((Component)item.get(0), gbc.clone());
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel.add((Component)item.get(1), gbc.clone());
    }

    private void resetContraints(GridBagConstraints gbc) {
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.fill = 0;
    }

    private void initConstraints(GridBagConstraints gbc) {
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
    }
}

