/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.ModuleController;
import org.apache.jmeter.control.TestFragmentController;
import org.apache.jmeter.control.gui.AbstractControllerGui;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.MenuFactory;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class ModuleControllerGui
extends AbstractControllerGui
implements ActionListener {
    private static final long serialVersionUID = -4195441608252523573L;
    private static final String SEPARATOR = " > ";
    private static final TreeNode[] EMPTY_TREE_NODES = new TreeNode[0];
    private JMeterTreeNode selected = null;
    private final DefaultTreeModel moduleToRunTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
    private final JTree moduleToRunTreeNodes = new JTree(this.moduleToRunTreeModel);
    private final JLabel warningLabel;
    private JButton expandButton;

    public ModuleControllerGui() {
        this.moduleToRunTreeNodes.setCellRenderer(new ModuleControllerCellRenderer());
        this.warningLabel = new JLabel("");
        this.init();
    }

    public String getLabelResource() {
        return "module_controller_title";
    }

    public void configure(TestElement el) {
        super.configure(el);
        ModuleController controller = (ModuleController)el;
        this.selected = controller.getSelectedNode();
        if (this.selected == null && controller.getNodePath() != null) {
            this.warningLabel.setText(JMeterUtils.getResString((String)"module_controller_warning") + this.renderPath(controller.getNodePath()));
        } else {
            this.warningLabel.setText("");
        }
        this.reinitialize();
    }

    private String renderPath(Collection<?> path) {
        Iterator<?> iter = path.iterator();
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        while (iter.hasNext()) {
            if (first) {
                first = false;
                iter.next();
                continue;
            }
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append(SEPARATOR);
        }
        return buf.toString();
    }

    public TestElement createTestElement() {
        ModuleController mc = new ModuleController();
        this.configureTestElement((TestElement)mc);
        if (this.selected != null) {
            mc.setSelectedNode(this.selected);
        }
        return mc;
    }

    public void modifyTestElement(TestElement element) {
        this.configureTestElement(element);
        JMeterTreeNode tn = null;
        DefaultMutableTreeNode lastSelected = (DefaultMutableTreeNode)this.moduleToRunTreeNodes.getLastSelectedPathComponent();
        if (lastSelected != null && lastSelected.getUserObject() instanceof JMeterTreeNode) {
            tn = (JMeterTreeNode)lastSelected.getUserObject();
        }
        if (tn != null) {
            this.selected = tn;
            if (this.selected != null && !(this.selected.getTestElement() instanceof AbstractThreadGroup) && !(this.selected.getTestElement() instanceof TestPlan)) {
                ((ModuleController)element).setSelectedNode(this.selected);
            }
        }
    }

    public void clearGui() {
        super.clearGui();
        this.selected = null;
    }

    public JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        JMenu addMenu = MenuFactory.makeMenus((String[])new String[]{"menu_config_element", "menu_assertions", "menu_timer", "menu_listener"}, (String)JMeterUtils.getResString((String)"add"), (String)"Add");
        menu.add(addMenu);
        MenuFactory.addEditMenu((JPopupMenu)menu, (boolean)true);
        MenuFactory.addFileMenu((JPopupMenu)menu);
        return menu;
    }

    private void init() {
        this.setLayout((LayoutManager)new VerticalLayout(5, 3, 1));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel());
        JPanel modulesPanel = new JPanel();
        this.expandButton = new JButton(JMeterUtils.getResString((String)"expand"));
        this.expandButton.addActionListener(this);
        modulesPanel.add(this.expandButton);
        modulesPanel.setLayout(new BoxLayout(modulesPanel, 1));
        modulesPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        JLabel nodesLabel = new JLabel(JMeterUtils.getResString((String)"module_controller_module_to_run"));
        modulesPanel.add(nodesLabel);
        modulesPanel.add(this.warningLabel);
        this.add(modulesPanel);
        JPanel treePanel = new JPanel();
        treePanel.setLayout(new FlowLayout(0));
        treePanel.add(this.moduleToRunTreeNodes);
        this.add(treePanel);
    }

    private TreeNode[] findPathInTreeModel(int level, TreeNode[] testPlanPath, DefaultMutableTreeNode parent) {
        if (level >= testPlanPath.length) {
            return EMPTY_TREE_NODES;
        }
        int childCount = parent.getChildCount();
        JMeterTreeNode searchedTreeNode = (JMeterTreeNode)testPlanPath[level];
        for (int i = 0; i < childCount; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)parent.getChildAt(i);
            JMeterTreeNode childUserObj = (JMeterTreeNode)child.getUserObject();
            if (!childUserObj.equals(searchedTreeNode)) continue;
            if (level == testPlanPath.length - 1) {
                return child.getPath();
            }
            return this.findPathInTreeModel(level + 1, testPlanPath, child);
        }
        return EMPTY_TREE_NODES;
    }

    private void focusSelectedOnTree(JMeterTreeNode selected) {
        TreeNode[] path = selected.getPath();
        TreeNode[] filteredPath = new TreeNode[path.length - 1];
        for (int i = 1; i < path.length; ++i) {
            filteredPath[i - 1] = path[i];
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.moduleToRunTreeNodes.getModel().getRoot();
        Object[] dmtnPath = this.findPathInTreeModel(1, filteredPath, root);
        if (dmtnPath.length > 0) {
            TreePath treePath = new TreePath(dmtnPath);
            this.moduleToRunTreeNodes.setSelectionPath(treePath);
            this.moduleToRunTreeNodes.scrollPathToVisible(treePath);
        }
    }

    private void reinitialize() {
        ((DefaultMutableTreeNode)this.moduleToRunTreeModel.getRoot()).removeAllChildren();
        GuiPackage gp = GuiPackage.getInstance();
        if (gp != null) {
            JMeterTreeNode root = (JMeterTreeNode)GuiPackage.getInstance().getTreeModel().getRoot();
            this.buildTreeNodeModel(root, 0, null);
            this.moduleToRunTreeModel.nodeStructureChanged((TreeNode)this.moduleToRunTreeModel.getRoot());
        }
        if (this.selected != null) {
            this.focusSelectedOnTree(this.selected);
        }
    }

    private void buildTreeNodeModel(JMeterTreeNode node, int level, DefaultMutableTreeNode parent) {
        if (node != null) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                DefaultMutableTreeNode newNode;
                JMeterTreeNode cur = (JMeterTreeNode)node.getChildAt(i);
                TestElement te = cur.getTestElement();
                if (te instanceof Controller && !(te instanceof ModuleController) && level > 0) {
                    newNode = new DefaultMutableTreeNode(cur);
                    parent.add(newNode);
                    this.buildTreeNodeModel(cur, level + 1, newNode);
                    continue;
                }
                if (te instanceof TestFragmentController) {
                    newNode = new DefaultMutableTreeNode(cur);
                    parent.add(newNode);
                    this.buildTreeNodeModel(cur, level + 1, newNode);
                    continue;
                }
                if (te instanceof AbstractThreadGroup) {
                    newNode = new DefaultMutableTreeNode(cur);
                    parent.add(newNode);
                    this.buildTreeNodeModel(cur, level + 1, newNode);
                    continue;
                }
                if (!(te instanceof TestPlan)) continue;
                ((DefaultMutableTreeNode)this.moduleToRunTreeModel.getRoot()).setUserObject(cur);
                this.buildTreeNodeModel(cur, level, (DefaultMutableTreeNode)this.moduleToRunTreeModel.getRoot());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.expandButton) {
            JMeterTreeNode tn = null;
            DefaultMutableTreeNode selected = (DefaultMutableTreeNode)this.moduleToRunTreeNodes.getLastSelectedPathComponent();
            if (selected != null && selected.getUserObject() instanceof JMeterTreeNode) {
                tn = (JMeterTreeNode)selected.getUserObject();
            }
            if (tn != null) {
                TreePath treePath = new TreePath(tn.getPath());
                GuiPackage.getInstance().getTreeListener().getJTree().setSelectionPath(treePath);
                GuiPackage.getInstance().getTreeListener().getJTree().scrollPathToVisible(treePath);
            }
        }
    }

    protected void expandToSelectNode(JMeterTreeNode selected) {
        GuiPackage guiInstance = GuiPackage.getInstance();
        JTree jTree = guiInstance.getMainFrame().getTree();
        jTree.expandPath(new TreePath(selected.getPath()));
        selected.setMarkedBySearch(true);
    }

    private static class ModuleControllerCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1129098620102526299L;

        private ModuleControllerCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JMeterTreeNode node = (JMeterTreeNode)((DefaultMutableTreeNode)value).getUserObject();
            if (node != null) {
                super.getTreeCellRendererComponent(tree, node.getName(), selected, expanded, leaf, row, hasFocus);
                boolean enabled = node.isEnabled();
                ImageIcon icon = node.getIcon(enabled);
                if (icon != null) {
                    if (enabled) {
                        this.setIcon(icon);
                    } else {
                        this.setDisabledIcon(icon);
                    }
                }
            }
            return this;
        }
    }
}

