/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.entity.collections;

import java.io.Serializable;
import java.util.List;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.applib.filter.Filters;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacet;
import org.apache.isis.core.metamodel.facets.members.cssclass.CssClassFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.AdditionalLinksPanel;
import org.apache.isis.viewer.wicket.ui.components.collection.CollectionPanel;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionSelectorHelper;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionSelectorPanel;
import org.apache.isis.viewer.wicket.ui.components.widgets.containers.UiHintPathSignificantWebMarkupContainer;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class EntityCollectionsPanel
extends PanelAbstract<EntityModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_ENTITY_COLLECTIONS = "entityCollections";
    private static final String ID_COLLECTION_GROUP = "collectionGroup";
    private static final String ID_COLLECTION_NAME = "collectionName";
    private static final String ID_COLLECTIONS = "collections";
    private static final String ID_COLLECTION = "collection";
    private static final String ID_ADDITIONAL_LINKS = "additionalLinks";
    private static final String ID_SELECTOR_DROPDOWN = "selectorDropdown";

    public EntityCollectionsPanel(String id, EntityModel entityModel) {
        super(id, entityModel);
        this.buildGui();
    }

    private void buildGui() {
        this.buildEntityPropertiesAndOrCollectionsGui();
        this.setOutputMarkupId(true);
    }

    private void buildEntityPropertiesAndOrCollectionsGui() {
        EntityModel model = (EntityModel)this.getModel();
        ObjectAdapter adapter = (ObjectAdapter)model.getObject();
        if (adapter != null) {
            this.addCollections();
        } else {
            this.permanentlyHide(ID_ENTITY_COLLECTIONS);
        }
    }

    private void addCollections() {
        EntityModel entityModel = (EntityModel)this.getModel();
        ObjectAdapter adapter = (ObjectAdapter)entityModel.getObject();
        ObjectSpecification noSpec = adapter.getSpecification();
        List<ObjectAssociation> associations = this.visibleCollections(adapter, noSpec);
        RepeatingView collectionRv = new RepeatingView(ID_COLLECTIONS);
        this.add(new Component[]{collectionRv});
        for (ObjectAssociation association : associations) {
            UiHintPathSignificantWebMarkupContainer collectionRvContainer = new UiHintPathSignificantWebMarkupContainer(collectionRv.newChildId());
            collectionRv.add(new Component[]{collectionRvContainer});
            this.addCollectionToForm(entityModel, association, collectionRvContainer);
        }
    }

    private void addCollectionToForm(EntityModel entityModel, ObjectAssociation association, WebMarkupContainer collectionRvContainer) {
        CssClassFacet facet = (CssClassFacet)association.getFacet(CssClassFacet.class);
        if (facet != null) {
            ObjectAdapter objectAdapter = (ObjectAdapter)entityModel.getObject();
            String cssClass = facet.cssClass(objectAdapter);
            CssClassAppender.appendCssClassTo((MarkupContainer)collectionRvContainer, cssClass);
        }
        WebMarkupContainer fieldset = new WebMarkupContainer(ID_COLLECTION_GROUP);
        collectionRvContainer.add(new Component[]{fieldset});
        OneToManyAssociation otma = (OneToManyAssociation)association;
        CollectionPanel collectionPanel = new CollectionPanel(ID_COLLECTION, entityModel, otma);
        fieldset.addOrReplace(new Component[]{collectionPanel});
        Label labelComponent = collectionPanel.createLabel(ID_COLLECTION_NAME, association.getName());
        NamedFacet namedFacet = (NamedFacet)association.getFacet(NamedFacet.class);
        labelComponent.setEscapeModelStrings(namedFacet == null || namedFacet.escaped());
        String description = association.getDescription();
        if (description != null) {
            labelComponent.add(new Behavior[]{new AttributeAppender("title", (IModel)Model.of((Serializable)((Object)description)))});
        }
        fieldset.add(new Component[]{labelComponent});
        EntityCollectionModel entityCollectionModel = (EntityCollectionModel)collectionPanel.getModel();
        List links = entityCollectionModel.getLinks();
        AdditionalLinksPanel.addAdditionalLinks((MarkupContainer)fieldset, ID_ADDITIONAL_LINKS, links, AdditionalLinksPanel.Style.INLINE_LIST);
        CollectionSelectorHelper selectorHelper = new CollectionSelectorHelper(entityCollectionModel, this.getComponentFactoryRegistry());
        List<ComponentFactory> componentFactories = selectorHelper.getComponentFactories();
        if (componentFactories.size() <= 1) {
            this.permanentlyHide(ID_SELECTOR_DROPDOWN);
        } else {
            CollectionSelectorPanel selectorDropdownPanel = new CollectionSelectorPanel(ID_SELECTOR_DROPDOWN, entityCollectionModel);
            Model componentFactoryModel = new Model();
            int selected = selectorHelper.honourViewHintElseDefault((Component)selectorDropdownPanel);
            ComponentFactory selectedComponentFactory = componentFactories.get(selected);
            componentFactoryModel.setObject((Serializable)selectedComponentFactory);
            this.setOutputMarkupId(true);
            fieldset.addOrReplace(new Component[]{selectorDropdownPanel});
            collectionPanel.setSelectorDropdownPanel(selectorDropdownPanel);
        }
    }

    private List<ObjectAssociation> visibleCollections(ObjectAdapter adapter, ObjectSpecification noSpec) {
        return noSpec.getAssociations(Contributed.INCLUDED, this.visibleCollectionsFilter(adapter));
    }

    private Filter<ObjectAssociation> visibleCollectionsFilter(ObjectAdapter adapter) {
        return Filters.and((Filter[])new Filter[]{ObjectAssociation.Filters.COLLECTIONS, ObjectAssociation.Filters.dynamicallyVisible((AuthenticationSession)this.getAuthenticationSession(), (ObjectAdapter)adapter, (Where)Where.PARENTED_TABLES)});
    }
}

