/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui;

import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.panels.PanelUtil;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.CssResourceReference;

public abstract class ComponentFactoryAbstract
implements ComponentFactory {
    private static final long serialVersionUID = 1L;
    private final ComponentType componentType;
    private final String name;
    private final Class<?> componentClass;

    public ComponentFactoryAbstract(ComponentType componentType) {
        this(componentType, null, null);
    }

    public ComponentFactoryAbstract(ComponentType componentType, String name) {
        this(componentType, name, null);
    }

    public ComponentFactoryAbstract(ComponentType componentType, Class componentClass) {
        this(componentType, null, componentClass);
    }

    public ComponentFactoryAbstract(ComponentType componentType, String name, Class componentClass) {
        this.componentType = componentType;
        String string = this.name = name != null ? name : this.getClass().getSimpleName();
        if (componentClass != null && ComponentFactory.class.isAssignableFrom(componentClass)) {
            throw new IllegalArgumentException("specified a ComponentFactory as a componentClass... you probably meant the component instead? componentClass = " + componentClass.getName());
        }
        this.componentClass = componentClass;
    }

    @Override
    public ComponentType getComponentType() {
        return this.componentType;
    }

    @Override
    public final ComponentFactory.ApplicationAdvice appliesTo(ComponentType componentType, IModel<?> model) {
        if (componentType != this.getComponentType()) {
            return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
        }
        return this.appliesTo(model);
    }

    protected abstract ComponentFactory.ApplicationAdvice appliesTo(IModel<?> var1);

    protected final ComponentFactory.ApplicationAdvice appliesIf(boolean b) {
        return ComponentFactory.ApplicationAdvice.appliesIf(b);
    }

    protected final ComponentFactory.ApplicationAdvice appliesExclusivelyIf(boolean b) {
        return b ? ComponentFactory.ApplicationAdvice.APPLIES_EXCLUSIVELY : ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
    }

    @Override
    public final Component createComponent(IModel<?> model) {
        return this.createComponent(this.getComponentType().toString(), model);
    }

    @Override
    public abstract Component createComponent(String var1, IModel<?> var2);

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CssResourceReference getCssResourceReference() {
        return PanelUtil.cssResourceReferenceFor(this.componentClass);
    }
}

