/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.wrapper.proxy;

import com.google.common.collect.MapMaker;
import java.lang.reflect.Method;
import java.util.Map;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyFactory;
import org.apache.isis.applib.services.wrapper.WrapperObject;
import org.apache.isis.applib.services.wrapper.WrappingObject;
import org.apache.isis.core.commons.lang.ArrayExtensions;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.JavassistEnhanced;
import org.apache.isis.core.wrapper.handlers.DelegatingInvocationHandler;
import org.apache.isis.core.wrapper.internal.util.Util;
import org.apache.isis.core.wrapper.proxy.ProxyInstantiator;

public class ProxyInstantiatorForJavassist
implements ProxyInstantiator {
    private final Map<Class, ProxyFactory> proxyFactoryByClass;

    public ProxyInstantiatorForJavassist() {
        this(new MapMaker().weakKeys().concurrencyLevel(10).makeMap());
    }

    public ProxyInstantiatorForJavassist(Map<Class, ProxyFactory> proxyFactoryByClass) {
        this.proxyFactoryByClass = proxyFactoryByClass;
    }

    @Override
    public <T> T instantiateProxy(final DelegatingInvocationHandler<T> handler) {
        T toProxy = handler.getDelegate();
        Class<?> clazz = toProxy.getClass();
        if (clazz.isInterface()) {
            return (T)Util.createInstance(clazz, handler, WrapperObject.class);
        }
        ProxyFactory proxyFactory = this.proxyFactoryFor(clazz);
        Class enhancedClass = proxyFactory.createClass();
        Proxy proxy = (Proxy)Util.createInstance(enhancedClass);
        proxy.setHandler(new MethodHandler(){

            public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
                return handler.invoke(self, thisMethod, args);
            }
        });
        return (T)proxy;
    }

    private <T> ProxyFactory proxyFactoryFor(Class<T> toProxyClass) {
        ProxyFactory proxyFactory = this.proxyFactoryByClass.get(toProxyClass);
        if (proxyFactory == null) {
            proxyFactory = this.createProxyFactoryFor(toProxyClass);
            this.proxyFactoryByClass.put(toProxyClass, proxyFactory);
        }
        return proxyFactory;
    }

    private <T> ProxyFactory createProxyFactoryFor(Class<T> toProxyClass) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setSuperclass(toProxyClass);
        Class[] types = (Class[])ArrayExtensions.combine((Object[][])new Class[][]{toProxyClass.getInterfaces(), {JavassistEnhanced.class, WrappingObject.class}});
        proxyFactory.setInterfaces(types);
        proxyFactory.setFilter(new MethodFilter(){

            public boolean isHandled(Method m) {
                return !m.getName().equals("finalize") || m.isBridge();
            }
        });
        proxyFactory.setUseCache(true);
        return proxyFactory;
    }
}

