/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.wrapper.handlers;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.isis.applib.events.CollectionMethodEvent;
import org.apache.isis.applib.events.InteractionEvent;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.wrapper.handlers.DelegatingInvocationHandlerDefault;
import org.apache.isis.core.wrapper.handlers.DomainObjectInvocationHandler;

abstract class AbstractCollectionInvocationHandler<T, C>
extends DelegatingInvocationHandlerDefault<C> {
    private final List<Method> interceptedMethods = Lists.newArrayList();
    private final List<Method> vetoedMethods = Lists.newArrayList();
    private final String collectionName;
    private final OneToManyAssociation oneToManyAssociation;
    private final T domainObject;

    public AbstractCollectionInvocationHandler(C collectionOrMapToProxy, String collectionName, DomainObjectInvocationHandler<T> handler, OneToManyAssociation otma) {
        super(collectionOrMapToProxy, handler.getHeadlessViewer(), handler.getExecutionMode());
        this.collectionName = collectionName;
        this.oneToManyAssociation = otma;
        this.domainObject = handler.getDelegate();
    }

    protected Method intercept(Method method) {
        this.interceptedMethods.add(method);
        return method;
    }

    protected Method veto(Method method) {
        this.vetoedMethods.add(method);
        return method;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public OneToManyAssociation getCollection() {
        return this.oneToManyAssociation;
    }

    public T getDomainObject() {
        return this.domainObject;
    }

    @Override
    public Object invoke(Object collectionObject, Method method, Object[] args) throws Throwable {
        Object returnValueObj = this.delegate(method, args);
        if (this.interceptedMethods.contains(method)) {
            this.resolveIfRequired(this.domainObject);
            CollectionMethodEvent ev = new CollectionMethodEvent(this.getDelegate(), this.getCollection().getIdentifier(), this.getDomainObject(), method.getName(), args, returnValueObj);
            this.notifyListeners((InteractionEvent)ev);
            return returnValueObj;
        }
        if (this.vetoedMethods.contains(method)) {
            throw new UnsupportedOperationException(String.format("Method '%s' may not be called directly.", method.getName()));
        }
        return returnValueObj;
    }
}

