/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.webserver;

import com.google.inject.Injector;
import java.util.List;
import java.util.Map;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationBuilder;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.lang.ObjectExtensions;
import org.apache.isis.core.runtime.runner.IsisBootstrapper;
import org.apache.isis.core.runtime.runner.IsisRunner;
import org.apache.isis.core.webserver.WebServer;
import org.apache.isis.core.webserver.WebServerConstants;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WebServerBootstrapper
implements IsisBootstrapper {
    private static final Logger LOG = LoggerFactory.getLogger(WebServerBootstrapper.class);
    private static final String SRC_MAIN_WEBAPP = "src/main/webapp";
    private final IsisRunner runner;
    private Server jettyServer;

    WebServerBootstrapper(IsisRunner runner) {
        this.runner = runner;
    }

    public void bootstrap(Injector injector) {
        IsisConfigurationBuilder isisConfigurationBuilder = this.runner.getStartupConfiguration();
        IsisConfiguration configuration = isisConfigurationBuilder.getConfiguration();
        int port = configuration.getInteger("isis.embedded-web-server.port", 8080);
        String webappContextPath = configuration.getString("isis.embedded-web-server.webapp", "");
        WebServer.StartupMode startupMode = WebServer.StartupMode.lookup(configuration.getString("isis.embedded-web-server.startupMode", WebServerConstants.EMBEDDED_WEB_SERVER_STARTUP_MODE_DEFAULT));
        this.jettyServer = new Server(port);
        Connector[] connectors = this.jettyServer.getConnectors();
        WebAppContext context = new WebAppContext(SRC_MAIN_WEBAPP, webappContextPath);
        this.copyConfigurationPrimersIntoServletContext(context);
        this.jettyServer.setHandler((Handler)context);
        LOG.info("Starting Jetty on port '{}' to serve the web application", (Object)port);
        long start = System.currentTimeMillis();
        try {
            this.jettyServer.start();
            LOG.info("Started the application in {}ms", (Object)(System.currentTimeMillis() - start));
            if (startupMode.isForeground()) {
                System.in.read();
                System.out.println(">>> STOPPING EMBEDDED JETTY SERVER");
                this.jettyServer.stop();
                this.jettyServer.join();
            }
        }
        catch (Exception ex) {
            throw new IsisException("Unable to start Jetty server", (Throwable)ex);
        }
    }

    public Server getJettyServer() {
        return this.jettyServer;
    }

    private void copyConfigurationPrimersIntoServletContext(WebAppContext context) {
        List isisConfigurationBuilderPrimers = this.runner.getOptionHandlers();
        context.setAttribute("isis.configurationPrimers", (Object)isisConfigurationBuilderPrimers);
    }

    private void copyDeploymentTypeIntoInitParams(WebAppContext context) {
        Map initParams = context.getInitParams();
        Map convertedInitParams = (Map)ObjectExtensions.asT((Object)initParams);
        initParams.clear();
        initParams.putAll(convertedInitParams);
    }
}

