/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.util;

import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.adapter.oid.RootOidDefault;
import org.apache.isis.core.metamodel.adapter.oid.TypedOid;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.runtime.persistence.ObjectNotFoundException;
import org.apache.isis.core.runtime.persistence.PojoRecreationException;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.server.util.UrlDecoderUtils;

public final class OidUtils {
    private OidUtils() {
    }

    public static ObjectAdapter getObjectAdapterElseNull(RendererContext rendererContext, String domainType, String instanceIdEncoded) {
        String instanceIdUnencoded = UrlDecoderUtils.urlDecode(instanceIdEncoded);
        String oidStrUnencoded = OidUtils.getOidMarshaller().joinAsOid(domainType, instanceIdUnencoded);
        return OidUtils.getObjectAdapter(rendererContext, oidStrUnencoded);
    }

    public static ObjectAdapter getObjectAdapterElseNull(RendererContext rendererContext, String oidStrEncoded) {
        String oidStrUnencoded = UrlDecoderUtils.urlDecode(oidStrEncoded);
        return OidUtils.getObjectAdapter(rendererContext, oidStrUnencoded);
    }

    private static ObjectAdapter getObjectAdapter(RendererContext rendererContext, String oidStrUnencoded) {
        RootOidDefault rootOid = RootOidDefault.deString((String)oidStrUnencoded, (OidMarshaller)OidUtils.getOidMarshaller());
        ObjectSpecId specId = rootOid.getObjectSpecId();
        ObjectSpecification spec = IsisContext.getSpecificationLoader().lookupBySpecId(specId);
        if (spec == null) {
            return null;
        }
        PersistenceSession persistenceSession = rendererContext.getPersistenceSession();
        if (spec.containsFacet(ViewModelFacet.class)) {
            if (!rootOid.isViewModel()) {
                rootOid = new RootOidDefault(rootOid.getObjectSpecId(), rootOid.getIdentifier(), Oid.State.VIEWMODEL);
            }
            try {
                return persistenceSession.getAdapterManager().adapterFor((TypedOid)rootOid);
            }
            catch (ObjectNotFoundException ex) {
                return null;
            }
            catch (PojoRecreationException ex) {
                return null;
            }
        }
        try {
            ObjectAdapter objectAdapter = persistenceSession.loadObject((TypedOid)rootOid);
            return objectAdapter.isTransient() ? null : objectAdapter;
        }
        catch (ObjectNotFoundException ex) {
            return null;
        }
    }

    private static OidMarshaller getOidMarshaller() {
        return new OidMarshaller();
    }
}

