/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.resources;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.applib.version.VersionResource;
import org.apache.isis.viewer.restfulobjects.rendering.Caching;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.ReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.Responses;
import org.apache.isis.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.server.resources.ResourceAbstract;
import org.apache.isis.viewer.restfulobjects.server.resources.VersionReprRenderer;

public class VersionResourceServerside
extends ResourceAbstract
implements VersionResource {
    @GET
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/version"})
    public Response version() {
        this.init(RepresentationType.VERSION, Where.NOWHERE);
        this.fakeRuntimeExceptionIfXFail();
        VersionReprRenderer renderer = new VersionReprRenderer((RendererContext)this.getResourceContext(), null, JsonRepresentation.newMap((String[])new String[0]));
        renderer.includesSelf();
        return Responses.ofOk((ReprRenderer)renderer, (Caching)Caching.ONE_DAY).build();
    }

    public Response deleteVersionNotAllowed() {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Deleting the version resource is not allowed.", (Object[])new Object[0]);
    }

    public Response putVersionNotAllowed() {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Putting to the version resource is not allowed.", (Object[])new Object[0]);
    }

    public Response postVersionNotAllowed() {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Posting to the version resource is not allowed.", (Object[])new Object[0]);
    }

    private void fakeRuntimeExceptionIfXFail() {
        HttpHeaders httpHeaders = this.getResourceContext().getHttpHeaders();
        List requestHeader = httpHeaders.getRequestHeader("X-Fail");
        if (requestHeader != null && !requestHeader.isEmpty()) {
            throw RestfulObjectsApplicationException.create((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_FAILURE);
        }
    }
}

