/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.resources;

import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.url.UrlEncodingUtils;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.services.ServiceUtil;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.rendering.util.Util;
import org.apache.isis.viewer.restfulobjects.server.ResourceContext;
import org.apache.isis.viewer.restfulobjects.server.util.OidUtils;
import org.apache.isis.viewer.restfulobjects.server.util.UrlDecoderUtils;

public abstract class ResourceAbstract {
    @Context
    HttpHeaders httpHeaders;
    @Context
    UriInfo uriInfo;
    @Context
    Request request;
    @Context
    HttpServletRequest httpServletRequest;
    @Context
    HttpServletResponse httpServletResponse;
    @Context
    SecurityContext securityContext;
    @Context
    Providers providers;
    private ResourceContext resourceContext;

    protected void init(Where where) {
        this.init(RepresentationType.GENERIC, where);
    }

    protected void init(RepresentationType representationType, Where where) {
        String queryStringIfAny = this.getUrlDecodedQueryStringIfAny();
        this.init(representationType, where, queryStringIfAny);
    }

    private String getUrlDecodedQueryStringIfAny() {
        String queryStringIfAny = this.httpServletRequest.getQueryString();
        return UrlEncodingUtils.urlDecodeNullSafe((String)queryStringIfAny);
    }

    protected void init(RepresentationType representationType, Where where, InputStream arguments) {
        String urlDecodedQueryString = Util.asStringUtf8((InputStream)arguments);
        this.init(representationType, where, urlDecodedQueryString);
    }

    protected void init(RepresentationType representationType, Where where, String urlUnencodedQueryString) {
        if (!IsisContext.inSession()) {
            throw RestfulObjectsApplicationException.create((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.UNAUTHORIZED);
        }
        if (this.getAuthenticationSession() == null) {
            throw RestfulObjectsApplicationException.create((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.UNAUTHORIZED);
        }
        this.resourceContext = new ResourceContext(representationType, this.httpHeaders, this.providers, this.uriInfo, this.request, where, urlUnencodedQueryString, this.httpServletRequest, this.httpServletResponse, this.securityContext, this.getLocalization(), this.getAuthenticationSession(), this.getPersistenceSession(), this.getAdapterManager(), (SpecificationLoader)this.getSpecificationLoader(), this.getConfiguration(), this.getDeploymentType());
    }

    protected ResourceContext getResourceContext() {
        return this.resourceContext;
    }

    protected ObjectAdapter getObjectAdapterElseThrowNotFound(String domainType, String instanceId) {
        ObjectAdapter objectAdapter = this.getObjectAdapterElseNull(domainType, instanceId);
        if (objectAdapter == null) {
            String instanceIdUnencoded = UrlDecoderUtils.urlDecode(instanceId);
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.NOT_FOUND, (String)"could not determine adapter for OID: '%s:%s'", (Object[])new Object[]{domainType, instanceIdUnencoded});
        }
        return objectAdapter;
    }

    protected ObjectAdapter getObjectAdapterElseNull(String domainType, String instanceId) {
        return OidUtils.getObjectAdapterElseNull((RendererContext)this.resourceContext, domainType, instanceId);
    }

    protected ObjectAdapter getServiceAdapter(String serviceId) {
        List serviceAdapters = this.getPersistenceSession().getServices();
        for (ObjectAdapter serviceAdapter : serviceAdapters) {
            Object servicePojo = serviceAdapter.getObject();
            String id = ServiceUtil.id((Object)servicePojo);
            if (!serviceId.equals(id)) continue;
            return serviceAdapter;
        }
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.NOT_FOUND, (String)"Could not locate service '%s'", (Object[])new Object[]{serviceId});
    }

    protected DeploymentType getDeploymentType() {
        return IsisContext.getDeploymentType();
    }

    protected IsisConfiguration getConfiguration() {
        return IsisContext.getConfiguration();
    }

    protected AuthenticationSession getAuthenticationSession() {
        return IsisContext.getAuthenticationSession();
    }

    protected AuthenticationManager getAuthenticationManager() {
        return IsisContext.getAuthenticationManager();
    }

    protected SpecificationLoaderSpi getSpecificationLoader() {
        return IsisContext.getSpecificationLoader();
    }

    protected AdapterManager getAdapterManager() {
        return this.getPersistenceSession().getAdapterManager();
    }

    protected PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    protected Localization getLocalization() {
        return IsisContext.getLocalization();
    }

    protected OidMarshaller getOidMarshaller() {
        return IsisContext.getOidMarshaller();
    }

    protected HttpServletRequest getServletRequest() {
        return this.getResourceContext().getHttpServletRequest();
    }
}

