/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.resources;

import java.util.List;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.server.ResourceContext;
import org.apache.isis.viewer.restfulobjects.server.resources.JsonParserHelper;

public class ObjectAdapterUpdateHelper {
    private final ObjectAdapter objectAdapter;
    private final ResourceContext resourceContext;

    public ObjectAdapterUpdateHelper(ResourceContext resourceContext, ObjectAdapter objectAdapter) {
        this.objectAdapter = objectAdapter;
        this.resourceContext = resourceContext;
    }

    boolean copyOverProperties(JsonRepresentation propertiesMap, Intent intent) {
        ObjectSpecification objectSpec = this.objectAdapter.getSpecification();
        List properties = objectSpec.getAssociations(Contributed.EXCLUDED, ObjectAssociation.Filters.PROPERTIES);
        boolean allOk = true;
        for (ObjectAssociation association : properties) {
            ObjectAdapter valueAdapter;
            boolean valueProvided;
            OneToOneAssociation property = (OneToOneAssociation)association;
            ObjectSpecification propertySpec = property.getSpecification();
            String id = property.getId();
            JsonRepresentation propertyRepr = propertiesMap.getRepresentation(id, new Object[0]);
            Consent visibility = property.isVisible(this.resourceContext.getAuthenticationSession(), this.objectAdapter, this.resourceContext.getWhere());
            Consent usability = property.isUsable(this.resourceContext.getAuthenticationSession(), this.objectAdapter, this.resourceContext.getWhere());
            boolean invisible = visibility.isVetoed();
            boolean disabled = usability.isVetoed();
            boolean bl = valueProvided = propertyRepr != null;
            if (!valueProvided) {
                if (intent.shouldValidate() && (invisible || disabled) || !property.isMandatory()) continue;
                String invalidReason = propertiesMap.getString("x-ro-invalidReason");
                if (invalidReason != null) {
                    propertiesMap.mapPut("x-ro-invalidReason", invalidReason + "; " + property.getName());
                } else {
                    propertiesMap.mapPut("x-ro-invalidReason", "Mandatory field(s) missing: " + property.getName());
                }
                allOk = false;
                continue;
            }
            if (intent.shouldValidate()) {
                if (invisible) continue;
                if (disabled) {
                    propertyRepr.mapPut("invalidReason", usability.getReason());
                    allOk = false;
                    continue;
                }
            }
            try {
                valueAdapter = new JsonParserHelper((RendererContext)this.resourceContext, propertySpec).objectAdapterFor(propertyRepr);
            }
            catch (IllegalArgumentException ex) {
                propertyRepr.mapPut("invalidReason", ex.getMessage());
                allOk = false;
                continue;
            }
            Consent validity = property.isAssociationValid(this.objectAdapter, valueAdapter);
            if (validity.isAllowed()) {
                try {
                    property.set(this.objectAdapter, valueAdapter);
                }
                catch (IllegalArgumentException ex) {
                    propertyRepr.mapPut("invalidReason", ex.getMessage());
                    allOk = false;
                }
                continue;
            }
            propertyRepr.mapPut("invalidReason", validity.getReason());
            allOk = false;
        }
        return allOk;
    }

    static enum Intent {
        UPDATE_EXISTING,
        PERSISTING_NEW;


        private boolean shouldValidate() {
            return this == UPDATE_EXISTING;
        }
    }
}

