/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.resources;

import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.MemberType;

public class ObjectAdapterAccessHelper {
    private final ObjectAdapter objectAdapter;
    private final RendererContext rendererContext;

    public static void throwNotFoundException(String memberId, MemberType memberType) {
        String memberTypeStr = memberType.name().toLowerCase();
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.NOT_FOUND, (String)"%s '%s' either does not exist or is not visible", (Object[])new Object[]{memberTypeStr, memberId});
    }

    public ObjectAdapterAccessHelper(RendererContext rendererContext, ObjectAdapter objectAdapter) {
        this.objectAdapter = objectAdapter;
        this.rendererContext = rendererContext;
    }

    public OneToOneAssociation getPropertyThatIsVisibleForIntent(String propertyId, Intent intent) {
        ObjectAssociation association;
        Where where = this.rendererContext.getWhere();
        try {
            ObjectSpecification specification = this.objectAdapter.getSpecification();
            association = specification.getAssociation(propertyId);
        }
        catch (Exception ex) {
            ObjectAdapterAccessHelper.throwNotFoundException(propertyId, MemberType.PROPERTY);
            return null;
        }
        if (association == null || !association.isOneToOneAssociation()) {
            ObjectAdapterAccessHelper.throwNotFoundException(propertyId, MemberType.PROPERTY);
        }
        OneToOneAssociation property = (OneToOneAssociation)association;
        return this.memberThatIsVisibleForIntent(property, MemberType.PROPERTY, intent);
    }

    public OneToManyAssociation getCollectionThatIsVisibleForIntent(String collectionId, Intent intent) {
        ObjectAssociation association;
        Where where = this.rendererContext.getWhere();
        try {
            ObjectSpecification specification = this.objectAdapter.getSpecification();
            association = specification.getAssociation(collectionId);
        }
        catch (Exception ex) {
            ObjectAdapterAccessHelper.throwNotFoundException(collectionId, MemberType.COLLECTION);
            return null;
        }
        if (association == null || !association.isOneToManyAssociation()) {
            ObjectAdapterAccessHelper.throwNotFoundException(collectionId, MemberType.COLLECTION);
        }
        OneToManyAssociation collection = (OneToManyAssociation)association;
        return this.memberThatIsVisibleForIntent(collection, MemberType.COLLECTION, intent);
    }

    public ObjectAction getObjectActionThatIsVisibleForIntent(String actionId, Intent intent) {
        ObjectAction action;
        Where where = this.rendererContext.getWhere();
        try {
            ObjectSpecification specification = this.objectAdapter.getSpecification();
            action = specification.getObjectAction(actionId);
        }
        catch (Exception ex) {
            ObjectAdapterAccessHelper.throwNotFoundException(actionId, MemberType.ACTION);
            return null;
        }
        if (action == null) {
            ObjectAdapterAccessHelper.throwNotFoundException(actionId, MemberType.ACTION);
        }
        return this.memberThatIsVisibleForIntent(action, MemberType.ACTION, intent);
    }

    public <T extends ObjectMember> T memberThatIsVisibleForIntent(T objectMember, MemberType memberType, Intent intent) {
        Consent usable;
        Where where = this.rendererContext.getWhere();
        String memberId = objectMember.getId();
        AuthenticationSession authenticationSession = this.rendererContext.getAuthenticationSession();
        if (objectMember.isVisible(authenticationSession, this.objectAdapter, where).isVetoed()) {
            ObjectAdapterAccessHelper.throwNotFoundException(memberId, memberType);
        }
        if (intent.isMutate() && (usable = objectMember.isUsable(authenticationSession, this.objectAdapter, where)).isVetoed()) {
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.FORBIDDEN, (String)usable.getReason(), (Object[])new Object[0]);
        }
        return objectMember;
    }

    static enum Intent {
        ACCESS,
        MUTATE;


        public boolean isMutate() {
            return this == MUTATE;
        }
    }
}

