/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.resources;

import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.isis.applib.annotation.ActionSemantics;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext3;
import org.apache.isis.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ActionResultReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.DomainObjectLinkTo;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.MemberReprMode;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAdapterLinkTo;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndAction;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndActionInvocation;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndCollection;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndProperty;
import org.apache.isis.viewer.restfulobjects.rendering.service.RepresentationService;
import org.apache.isis.viewer.restfulobjects.server.ResourceContext;
import org.apache.isis.viewer.restfulobjects.server.resources.ObjectActionArgHelper;
import org.apache.isis.viewer.restfulobjects.server.resources.ObjectAdapterAccessHelper;

public class DomainResourceHelper {
    private final RepresentationService representationService;
    private RepresentationServiceContextAdapter representationServiceContext;
    private final ResourceContext resourceContext;
    private final ObjectAdapter objectAdapter;

    public DomainResourceHelper(ResourceContext resourceContext, ObjectAdapter objectAdapter) {
        this.resourceContext = resourceContext;
        this.objectAdapter = objectAdapter;
        this.using((ObjectAdapterLinkTo)new DomainObjectLinkTo());
        this.representationService = this.lookupService(RepresentationService.class);
    }

    public DomainResourceHelper using(ObjectAdapterLinkTo adapterLinkTo) {
        this.representationServiceContext = new RepresentationServiceContextAdapter(this.resourceContext, adapterLinkTo);
        adapterLinkTo.usingUrlBase((RendererContext)this.resourceContext).with(this.objectAdapter);
        return this;
    }

    public Response objectRepresentation() {
        return this.representationService.objectRepresentation((RepresentationService.Context)this.representationServiceContext, this.objectAdapter);
    }

    public Response propertyDetails(String propertyId, MemberReprMode memberMode) {
        ObjectAdapterAccessHelper accessHelper = new ObjectAdapterAccessHelper((RendererContext)this.representationServiceContext, this.objectAdapter);
        OneToOneAssociation property = accessHelper.getPropertyThatIsVisibleForIntent(propertyId, ObjectAdapterAccessHelper.Intent.ACCESS);
        return this.representationService.propertyDetails((RepresentationService.Context)this.representationServiceContext, new ObjectAndProperty(this.objectAdapter, property), memberMode);
    }

    public Response collectionDetails(String collectionId, MemberReprMode memberMode) {
        ObjectAdapterAccessHelper accessHelper = new ObjectAdapterAccessHelper((RendererContext)this.representationServiceContext, this.objectAdapter);
        OneToManyAssociation collection = accessHelper.getCollectionThatIsVisibleForIntent(collectionId, ObjectAdapterAccessHelper.Intent.ACCESS);
        return this.representationService.collectionDetails((RepresentationService.Context)this.representationServiceContext, new ObjectAndCollection(this.objectAdapter, collection), memberMode);
    }

    public Response actionPrompt(String actionId) {
        ObjectAdapterAccessHelper accessHelper = new ObjectAdapterAccessHelper((RendererContext)this.representationServiceContext, this.objectAdapter);
        ObjectAction action = accessHelper.getObjectActionThatIsVisibleForIntent(actionId, ObjectAdapterAccessHelper.Intent.ACCESS);
        return this.representationService.actionPrompt((RepresentationService.Context)this.representationServiceContext, new ObjectAndAction(this.objectAdapter, action));
    }

    public Response invokeActionQueryOnly(String actionId, JsonRepresentation arguments) {
        ObjectAdapterAccessHelper accessHelper = new ObjectAdapterAccessHelper((RendererContext)this.representationServiceContext, this.objectAdapter);
        ObjectAction action = accessHelper.getObjectActionThatIsVisibleForIntent(actionId, ObjectAdapterAccessHelper.Intent.MUTATE);
        ActionSemantics.Of actionSemantics = action.getSemantics();
        if (!actionSemantics.isSafeInNature()) {
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Method not allowed; action '%s' does not have safe semantics", (Object[])new Object[]{action.getId()});
        }
        return this.invokeActionUsingAdapters(action, arguments, ActionResultReprRenderer.SelfLink.INCLUDED);
    }

    public Response invokeActionIdempotent(String actionId, JsonRepresentation arguments) {
        ObjectAdapterAccessHelper accessHelper = new ObjectAdapterAccessHelper((RendererContext)this.representationServiceContext, this.objectAdapter);
        ObjectAction action = accessHelper.getObjectActionThatIsVisibleForIntent(actionId, ObjectAdapterAccessHelper.Intent.MUTATE);
        ActionSemantics.Of actionSemantics = action.getSemantics();
        if (!actionSemantics.isIdempotentInNature()) {
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Method not allowed; action '%s' is not idempotent", (Object[])new Object[]{action.getId()});
        }
        return this.invokeActionUsingAdapters(action, arguments, ActionResultReprRenderer.SelfLink.EXCLUDED);
    }

    public Response invokeAction(String actionId, JsonRepresentation arguments) {
        ObjectAdapterAccessHelper accessHelper = new ObjectAdapterAccessHelper((RendererContext)this.representationServiceContext, this.objectAdapter);
        ObjectAction action = accessHelper.getObjectActionThatIsVisibleForIntent(actionId, ObjectAdapterAccessHelper.Intent.MUTATE);
        return this.invokeActionUsingAdapters(action, arguments, ActionResultReprRenderer.SelfLink.EXCLUDED);
    }

    private Response invokeActionUsingAdapters(ObjectAction action, JsonRepresentation arguments, ActionResultReprRenderer.SelfLink selfLink) {
        RepresentationServiceContextAdapter rendererContext = this.representationServiceContext;
        ObjectAdapter objectAdapter = this.objectAdapter;
        ObjectActionArgHelper argHelper = new ObjectActionArgHelper((RendererContext)rendererContext, objectAdapter, action);
        List<ObjectAdapter> argAdapters = argHelper.parseAndValidateArguments(arguments);
        ObjectAdapter[] argArray2 = argAdapters.toArray(new ObjectAdapter[0]);
        ObjectAdapter returnedAdapter = action.execute(objectAdapter, argArray2);
        ObjectAndActionInvocation objectAndActionInvocation = new ObjectAndActionInvocation(this.objectAdapter, action, arguments, returnedAdapter);
        return this.representationService.actionResult((RepresentationService.Context)this.representationServiceContext, objectAndActionInvocation, selfLink);
    }

    private PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    private <T> T lookupService(Class<T> serviceType) {
        return (T)this.getPersistenceSession().getServiceOrNull(serviceType);
    }

    static class RepresentationServiceContextAdapter
    implements RepresentationService.Context3 {
        private final RendererContext3 rendererContext;
        private final ObjectAdapterLinkTo adapterLinkTo;

        RepresentationServiceContextAdapter(RendererContext3 rendererContext, ObjectAdapterLinkTo adapterLinkTo) {
            this.rendererContext = rendererContext;
            this.adapterLinkTo = adapterLinkTo;
        }

        public ObjectAdapterLinkTo getAdapterLinkTo() {
            return this.adapterLinkTo;
        }

        public String urlFor(String url) {
            return this.rendererContext.urlFor(url);
        }

        public AuthenticationSession getAuthenticationSession() {
            return this.rendererContext.getAuthenticationSession();
        }

        public IsisConfiguration getConfiguration() {
            return this.rendererContext.getConfiguration();
        }

        public PersistenceSession getPersistenceSession() {
            return this.rendererContext.getPersistenceSession();
        }

        public AdapterManager getAdapterManager() {
            return this.rendererContext.getAdapterManager();
        }

        public Where getWhere() {
            return this.rendererContext.getWhere();
        }

        public DeploymentType getDeploymentType() {
            return this.rendererContext.getDeploymentType();
        }

        public List<List<String>> getFollowLinks() {
            return this.rendererContext.getFollowLinks();
        }

        public List<MediaType> getAcceptableMediaTypes() {
            return this.rendererContext.getAcceptableMediaTypes();
        }

        public Localization getLocalization() {
            return this.rendererContext.getLocalization();
        }

        public boolean canEagerlyRender(ObjectAdapter objectAdapter) {
            return this.rendererContext.canEagerlyRender(objectAdapter);
        }

        public boolean honorUiHints() {
            return this.rendererContext.honorUiHints();
        }

        public boolean objectPropertyValuesOnly() {
            return this.rendererContext.objectPropertyValuesOnly();
        }

        public boolean suppressDescribedByLinks() {
            return this.rendererContext.suppressDescribedByLinks();
        }

        public boolean suppressUpdateLink() {
            return this.rendererContext.suppressUpdateLink();
        }

        public boolean suppressMemberId() {
            return this.rendererContext.suppressMemberId();
        }

        public boolean suppressMemberLinks() {
            return this.rendererContext.suppressMemberLinks();
        }

        public boolean suppressMemberExtensions() {
            return this.rendererContext.suppressMemberExtensions();
        }

        public boolean suppressMemberDisabledReason() {
            return this.rendererContext.suppressMemberDisabledReason();
        }
    }
}

