/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.resources;

import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.commons.url.UrlEncodingUtils;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.DomainObjectResource;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.MemberReprMode;
import org.apache.isis.viewer.restfulobjects.rendering.service.conneg.PrettyPrinting;
import org.apache.isis.viewer.restfulobjects.rendering.util.Util;
import org.apache.isis.viewer.restfulobjects.server.resources.DomainResourceHelper;
import org.apache.isis.viewer.restfulobjects.server.resources.JsonParserHelper;
import org.apache.isis.viewer.restfulobjects.server.resources.ObjectAdapterAccessHelper;
import org.apache.isis.viewer.restfulobjects.server.resources.ObjectAdapterUpdateHelper;
import org.apache.isis.viewer.restfulobjects.server.resources.ResourceAbstract;

@Path(value="/objects")
public class DomainObjectResourceServerside
extends ResourceAbstract
implements DomainObjectResource {
    @POST
    @Path(value="/{domainType}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response persist(@PathParam(value="domainType") String domainType, InputStream object) {
        this.init(RepresentationType.DOMAIN_OBJECT, Where.OBJECT_FORMS);
        String objectStr = Util.asStringUtf8((InputStream)object);
        JsonRepresentation objectRepr = Util.readAsMap((String)objectStr);
        if (!objectRepr.isMap()) {
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (String)"Body is not a map; got %s", (Object[])new Object[]{objectRepr});
        }
        ObjectSpecification domainTypeSpec = this.getSpecificationLoader().lookupBySpecId(ObjectSpecId.of((String)domainType));
        if (domainTypeSpec == null) {
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (String)"Could not determine type of domain object to persist (no class with domainType Id of '%s')", (Object[])new Object[]{domainType});
        }
        ObjectAdapter objectAdapter = this.getResourceContext().getPersistenceSession().createTransientInstance(domainTypeSpec);
        ObjectAdapterUpdateHelper updateHelper = new ObjectAdapterUpdateHelper(this.getResourceContext(), objectAdapter);
        JsonRepresentation membersMap = objectRepr.getMap("members");
        if (membersMap == null) {
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (String)"Could not find members map; got %s", (Object[])new Object[]{objectRepr});
        }
        if (!updateHelper.copyOverProperties(membersMap, ObjectAdapterUpdateHelper.Intent.PERSISTING_NEW)) {
            throw RestfulObjectsApplicationException.createWithBody((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (JsonRepresentation)objectRepr, (String)"Illegal property value", (Object[])new Object[0]);
        }
        Consent validity = objectAdapter.getSpecification().isValid(objectAdapter);
        if (validity.isVetoed()) {
            throw RestfulObjectsApplicationException.createWithBody((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (JsonRepresentation)objectRepr, (String)validity.getReason(), (Object[])new Object[0]);
        }
        this.getResourceContext().getPersistenceSession().makePersistent(objectAdapter);
        return this.getDomainResourceHelper(objectAdapter).objectRepresentation();
    }

    @GET
    @Path(value="/{domainType}/{instanceId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    @PrettyPrinting
    public Response object(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId) {
        this.init(RepresentationType.DOMAIN_OBJECT, Where.OBJECT_FORMS);
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId);
        return this.getDomainResourceHelper(objectAdapter).objectRepresentation();
    }

    private DomainResourceHelper getDomainResourceHelper(ObjectAdapter objectAdapter) {
        return new DomainResourceHelper(this.getResourceContext(), objectAdapter);
    }

    @PUT
    @Path(value="/{domainType}/{instanceId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    @PrettyPrinting
    public Response object(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, InputStream object) {
        this.init(RepresentationType.DOMAIN_OBJECT, Where.OBJECT_FORMS);
        String objectStr = Util.asStringUtf8((InputStream)object);
        JsonRepresentation argRepr = Util.readAsMap((String)objectStr);
        if (!argRepr.isMap()) {
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (String)"Body is not a map; got %s", (Object[])new Object[]{argRepr});
        }
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId);
        ObjectAdapterUpdateHelper updateHelper = new ObjectAdapterUpdateHelper(this.getResourceContext(), objectAdapter);
        if (!updateHelper.copyOverProperties(argRepr, ObjectAdapterUpdateHelper.Intent.UPDATE_EXISTING)) {
            throw RestfulObjectsApplicationException.createWithBody((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (JsonRepresentation)argRepr, (String)"Illegal property value", (Object[])new Object[0]);
        }
        Consent validity = objectAdapter.getSpecification().isValid(objectAdapter);
        if (validity.isVetoed()) {
            throw RestfulObjectsApplicationException.createWithBody((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (JsonRepresentation)argRepr, (String)validity.getReason(), (Object[])new Object[0]);
        }
        return this.getDomainResourceHelper(objectAdapter).objectRepresentation();
    }

    public Response deleteMethodNotSupported(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId) {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Deleting objects is not supported.", (Object[])new Object[0]);
    }

    public Response postMethodNotAllowed(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId) {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Posting to object resource is not allowed.", (Object[])new Object[0]);
    }

    @GET
    @Path(value="/{domainType}/{instanceId}/properties/{propertyId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-property", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object-property", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    @PrettyPrinting
    public Response propertyDetails(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="propertyId") String propertyId) {
        this.init(RepresentationType.OBJECT_PROPERTY, Where.OBJECT_FORMS);
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId);
        DomainResourceHelper helper = this.getDomainResourceHelper(objectAdapter);
        return helper.propertyDetails(propertyId, MemberReprMode.READ);
    }

    @PUT
    @Path(value="/{domainType}/{instanceId}/properties/{propertyId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-property", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object-property", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response modifyProperty(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="propertyId") String propertyId, InputStream body) {
        this.init(Where.OBJECT_FORMS);
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId);
        DomainResourceHelper helper = this.getDomainResourceHelper(objectAdapter);
        ObjectAdapterAccessHelper accessHelper = new ObjectAdapterAccessHelper((RendererContext)this.getResourceContext(), objectAdapter);
        OneToOneAssociation property = accessHelper.getPropertyThatIsVisibleForIntent(propertyId, ObjectAdapterAccessHelper.Intent.MUTATE);
        ObjectSpecification propertySpec = property.getSpecification();
        String bodyAsString = Util.asStringUtf8((InputStream)body);
        ObjectAdapter argAdapter = new JsonParserHelper((RendererContext)this.getResourceContext(), propertySpec).parseAsMapWithSingleValue(bodyAsString);
        Consent consent = property.isAssociationValid(objectAdapter, argAdapter);
        if (consent.isVetoed()) {
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.UNAUTHORIZED, (String)consent.getReason(), (Object[])new Object[0]);
        }
        property.set(objectAdapter, argAdapter);
        return helper.propertyDetails(propertyId, MemberReprMode.WRITE);
    }

    @DELETE
    @Path(value="/{domainType}/{instanceId}/properties/{propertyId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-property", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object-property", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response clearProperty(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="propertyId") String propertyId) {
        this.init(Where.OBJECT_FORMS);
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId);
        DomainResourceHelper helper = this.getDomainResourceHelper(objectAdapter);
        ObjectAdapterAccessHelper accessHelper = new ObjectAdapterAccessHelper((RendererContext)this.getResourceContext(), objectAdapter);
        OneToOneAssociation property = accessHelper.getPropertyThatIsVisibleForIntent(propertyId, ObjectAdapterAccessHelper.Intent.MUTATE);
        Consent consent = property.isAssociationValid(objectAdapter, null);
        if (consent.isVetoed()) {
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.UNAUTHORIZED, (String)consent.getReason(), (Object[])new Object[0]);
        }
        property.set(objectAdapter, null);
        return helper.propertyDetails(propertyId, MemberReprMode.WRITE);
    }

    public Response postPropertyNotAllowed(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="propertyId") String propertyId) {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Posting to a property resource is not allowed.", (Object[])new Object[0]);
    }

    @GET
    @Path(value="/{domainType}/{instanceId}/collections/{collectionId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-collection", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object-collection", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    @PrettyPrinting
    public Response accessCollection(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="collectionId") String collectionId) {
        this.init(RepresentationType.OBJECT_COLLECTION, Where.PARENTED_TABLES);
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId);
        return this.getDomainResourceHelper(objectAdapter).collectionDetails(collectionId, MemberReprMode.READ);
    }

    @PUT
    @Path(value="/{domainType}/{instanceId}/collections/{collectionId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-collection", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object-collection", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response addToSet(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="collectionId") String collectionId, InputStream body) {
        this.init(Where.PARENTED_TABLES);
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId);
        DomainResourceHelper helper = this.getDomainResourceHelper(objectAdapter);
        ObjectAdapterAccessHelper accessHelper = new ObjectAdapterAccessHelper((RendererContext)this.getResourceContext(), objectAdapter);
        OneToManyAssociation collection = accessHelper.getCollectionThatIsVisibleForIntent(collectionId, ObjectAdapterAccessHelper.Intent.MUTATE);
        if (!collection.getCollectionSemantics().isSet()) {
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (String)"Collection '%s' does not have set semantics", (Object[])new Object[]{collectionId});
        }
        ObjectSpecification collectionSpec = collection.getSpecification();
        String bodyAsString = Util.asStringUtf8((InputStream)body);
        ObjectAdapter argAdapter = new JsonParserHelper((RendererContext)this.getResourceContext(), collectionSpec).parseAsMapWithSingleValue(bodyAsString);
        Consent consent = collection.isValidToAdd(objectAdapter, argAdapter);
        if (consent.isVetoed()) {
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.UNAUTHORIZED, (String)consent.getReason(), (Object[])new Object[0]);
        }
        collection.addElement(objectAdapter, argAdapter);
        return helper.collectionDetails(collectionId, MemberReprMode.WRITE);
    }

    @POST
    @Path(value="/{domainType}/{instanceId}/collections/{collectionId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-collection", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object-collection", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response addToList(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="collectionId") String collectionId, InputStream body) {
        this.init(Where.PARENTED_TABLES);
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId);
        DomainResourceHelper helper = this.getDomainResourceHelper(objectAdapter);
        ObjectAdapterAccessHelper accessHelper = new ObjectAdapterAccessHelper((RendererContext)this.getResourceContext(), objectAdapter);
        OneToManyAssociation collection = accessHelper.getCollectionThatIsVisibleForIntent(collectionId, ObjectAdapterAccessHelper.Intent.MUTATE);
        if (!collection.getCollectionSemantics().isListOrArray()) {
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Collection '%s' does not have list or array semantics", (Object[])new Object[]{collectionId});
        }
        ObjectSpecification collectionSpec = collection.getSpecification();
        String bodyAsString = Util.asStringUtf8((InputStream)body);
        ObjectAdapter argAdapter = new JsonParserHelper((RendererContext)this.getResourceContext(), collectionSpec).parseAsMapWithSingleValue(bodyAsString);
        Consent consent = collection.isValidToAdd(objectAdapter, argAdapter);
        if (consent.isVetoed()) {
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.UNAUTHORIZED, (String)consent.getReason(), (Object[])new Object[0]);
        }
        collection.addElement(objectAdapter, argAdapter);
        return helper.collectionDetails(collectionId, MemberReprMode.WRITE);
    }

    @DELETE
    @Path(value="/{domainType}/{instanceId}/collections/{collectionId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-collection", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object-collection", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response removeFromCollection(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="collectionId") String collectionId) {
        this.init(Where.PARENTED_TABLES);
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId);
        DomainResourceHelper helper = this.getDomainResourceHelper(objectAdapter);
        ObjectAdapterAccessHelper accessHelper = new ObjectAdapterAccessHelper((RendererContext)this.getResourceContext(), objectAdapter);
        OneToManyAssociation collection = accessHelper.getCollectionThatIsVisibleForIntent(collectionId, ObjectAdapterAccessHelper.Intent.MUTATE);
        ObjectSpecification collectionSpec = collection.getSpecification();
        ObjectAdapter argAdapter = new JsonParserHelper((RendererContext)this.getResourceContext(), collectionSpec).parseAsMapWithSingleValue(this.getResourceContext().getUrlUnencodedQueryString());
        Consent consent = collection.isValidToRemove(objectAdapter, argAdapter);
        if (consent.isVetoed()) {
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.UNAUTHORIZED, (String)consent.getReason(), (Object[])new Object[0]);
        }
        collection.removeElement(objectAdapter, argAdapter);
        return helper.collectionDetails(collectionId, MemberReprMode.WRITE);
    }

    @GET
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-action", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object-action", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    @PrettyPrinting
    public Response actionPrompt(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="actionId") String actionId) {
        this.init(RepresentationType.OBJECT_ACTION, Where.OBJECT_FORMS);
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId);
        DomainResourceHelper helper = this.getDomainResourceHelper(objectAdapter);
        return helper.actionPrompt(actionId);
    }

    public Response deleteActionPromptNotAllowed(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="actionId") String actionId) {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Deleting action prompt resource is not allowed.", (Object[])new Object[0]);
    }

    public Response postActionPromptNotAllowed(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="actionId") String actionId) {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Posting to an action prompt resource is not allowed.", (Object[])new Object[0]);
    }

    public Response putActionPromptNotAllowed(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="actionId") String actionId) {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Putting to an action prompt resource is not allowed.", (Object[])new Object[0]);
    }

    @GET
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}/invoke")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/action-result", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/action-result", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    @PrettyPrinting
    public Response invokeActionQueryOnly(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="actionId") String actionId, @QueryParam(value="x-isis-querystring") String xIsisUrlEncodedQueryString) {
        String urlUnencodedQueryString = UrlEncodingUtils.urlDecodeNullSafe((String)(xIsisUrlEncodedQueryString != null ? xIsisUrlEncodedQueryString : this.httpServletRequest.getQueryString()));
        this.init(RepresentationType.ACTION_RESULT, Where.STANDALONE_TABLES, urlUnencodedQueryString);
        JsonRepresentation arguments = this.getResourceContext().getQueryStringAsJsonRepr();
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId);
        DomainResourceHelper helper = this.getDomainResourceHelper(objectAdapter);
        return helper.invokeActionQueryOnly(actionId, arguments);
    }

    @PUT
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}/invoke")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/action-result", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/action-result", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    @PrettyPrinting
    public Response invokeActionIdempotent(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="actionId") String actionId, InputStream body) {
        this.init(RepresentationType.ACTION_RESULT, Where.STANDALONE_TABLES, body);
        JsonRepresentation arguments = this.getResourceContext().getQueryStringAsJsonRepr();
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId);
        DomainResourceHelper helper = this.getDomainResourceHelper(objectAdapter);
        return helper.invokeActionIdempotent(actionId, arguments);
    }

    @POST
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}/invoke")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/action-result", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/action-result", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    @PrettyPrinting
    public Response invokeAction(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="actionId") String actionId, InputStream body) {
        this.init(RepresentationType.ACTION_RESULT, Where.STANDALONE_TABLES, body);
        JsonRepresentation arguments = this.getResourceContext().getQueryStringAsJsonRepr();
        ObjectAdapter objectAdapter = this.getObjectAdapterElseThrowNotFound(domainType, instanceId);
        DomainResourceHelper helper = this.getDomainResourceHelper(objectAdapter);
        Where where = this.getResourceContext().getWhere();
        return helper.invokeAction(actionId, arguments);
    }

    public Response deleteInvokeActionNotAllowed(@PathParam(value="domainType") String domainType, @PathParam(value="instanceId") String instanceId, @PathParam(value="actionId") String actionId) {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Deleting an action invocation resource is not allowed.", (Object[])new Object[0]);
    }
}

