/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.authentication;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.runtime.authentication.standard.SimpleSession;
import org.apache.isis.core.webapp.auth.AuthenticationSessionStrategyAbstract;

public class AuthenticationSessionStrategyHeader
extends AuthenticationSessionStrategyAbstract {
    public static final String HEADER_ISIS_USER = "isis.user";

    public AuthenticationSession lookupValid(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String user = httpServletRequest.getHeader(HEADER_ISIS_USER);
        List<String> roles = this.rolesFrom(httpServletRequest);
        if (Strings.isNullOrEmpty((String)user)) {
            return null;
        }
        return new SimpleSession(user, roles);
    }

    protected List<String> rolesFrom(HttpServletRequest httpServletRequest) {
        String rolesStr = httpServletRequest.getHeader("isis.roles");
        if (rolesStr == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)rolesStr));
    }
}

