/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.authentication;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.authentication.AuthenticationRequest;
import org.apache.isis.core.runtime.authentication.AuthenticationRequestPassword;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.webapp.auth.AuthenticationSessionStrategyAbstract;

public class AuthenticationSessionStrategyBasicAuth
extends AuthenticationSessionStrategyAbstract {
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String BASIC_AUTH_PREFIX = "Basic ";
    private static Pattern USER_AND_PASSWORD_REGEX = Pattern.compile("^(.+):(.+)$");

    public AuthenticationSession lookupValid(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String digest = this.getBasicAuthDigest(httpServletRequest);
        if (digest == null) {
            return null;
        }
        String userAndPassword = this.unencoded(digest);
        Matcher matcher = USER_AND_PASSWORD_REGEX.matcher(userAndPassword);
        if (!matcher.matches()) {
            return null;
        }
        String user = matcher.group(1);
        String password = matcher.group(2);
        AuthenticationRequestPassword request = new AuthenticationRequestPassword(user, password);
        AuthenticationSession authSession = this.getAuthenticationManager().authenticate((AuthenticationRequest)request);
        return authSession;
    }

    String getBasicAuthDigest(HttpServletRequest httpServletRequest) {
        String authStr = httpServletRequest.getHeader(HEADER_AUTHORIZATION);
        return authStr != null && authStr.startsWith(BASIC_AUTH_PREFIX) ? authStr.substring(BASIC_AUTH_PREFIX.length()) : null;
    }

    protected String unencoded(String encodedDigest) {
        return new String(new Base64().decode(encodedDigest.getBytes()));
    }

    protected AuthenticationManager getAuthenticationManager() {
        return IsisContext.getAuthenticationManager();
    }
}

