/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server;

import com.google.common.collect.Lists;
import java.util.List;
import javax.jdo.JDOException;

class RuntimeExceptionPojo {
    private final String className;
    private final String message;
    private final List<String> stackTrace = Lists.newArrayList();
    private RuntimeExceptionPojo causedBy;

    public static RuntimeExceptionPojo create(Exception ex) {
        return new RuntimeExceptionPojo(ex);
    }

    private static String format(StackTraceElement stackTraceElement) {
        return stackTraceElement.toString();
    }

    public RuntimeExceptionPojo(Throwable ex) {
        StackTraceElement[] stackTraceElements;
        this.className = ex.getClass().getName();
        this.message = RuntimeExceptionPojo.messageFor(ex);
        for (StackTraceElement stackTraceElement : stackTraceElements = ex.getStackTrace()) {
            this.stackTrace.add(RuntimeExceptionPojo.format(stackTraceElement));
        }
        Throwable cause = RuntimeExceptionPojo.causeOf(ex);
        if (cause != null && cause != ex) {
            this.causedBy = new RuntimeExceptionPojo(cause);
        }
    }

    private static Throwable causeOf(Throwable ex) {
        if (ex instanceof JDOException) {
            JDOException jdoException = (JDOException)ex;
            Throwable[] nestedExceptions = jdoException.getNestedExceptions();
            return nestedExceptions.length > 0 ? nestedExceptions[0] : null;
        }
        return ex.getCause();
    }

    private static String messageFor(Throwable ex) {
        String message = ex.getMessage();
        return message != null ? message : ex.getClass().getName();
    }

    public String getClassName() {
        return this.className;
    }

    public String getMessage() {
        return this.message;
    }

    public List<String> getStackTrace() {
        return this.stackTrace;
    }

    public RuntimeExceptionPojo getCausedBy() {
        return this.causedBy;
    }
}

