/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server;

import com.google.common.base.Throwables;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.isis.core.commons.exceptions.ExceptionUtils;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.transaction.IsisTransaction;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.applib.util.JsonMapper;
import org.apache.isis.viewer.restfulobjects.server.RuntimeExceptionPojo;
import org.jboss.resteasy.spi.Failure;

@Provider
public class RuntimeExceptionMapper
implements ExceptionMapper<RuntimeException> {
    public Response toResponse(RuntimeException ex) {
        IsisTransaction currentTransaction = IsisContext.getTransactionManager().getTransaction();
        Throwable rootCause = Throwables.getRootCause((Throwable)ex);
        List causalChain = Throwables.getCausalChain((Throwable)ex);
        for (Throwable throwable : causalChain) {
            if (throwable != rootCause) continue;
            currentTransaction.clearAbortCause();
        }
        RestfulResponse.HttpStatusCode statusCode = RestfulResponse.HttpStatusCode.INTERNAL_SERVER_ERROR;
        if (ex instanceof Failure) {
            Failure failure = (Failure)ex;
            statusCode = RestfulResponse.HttpStatusCode.statusFor((int)failure.getErrorCode());
        }
        Response.ResponseBuilder builder = Response.status((Response.StatusType)statusCode.getJaxrsStatusType()).type("application/json;profile=urn:org.restfulobjects:repr-types/error").entity((Object)RuntimeExceptionMapper.jsonFor(ex));
        return builder.build();
    }

    static String jsonFor(Exception ex) {
        try {
            return JsonMapper.instance().write((Object)RuntimeExceptionPojo.create(ex));
        }
        catch (Exception e) {
            return "{ \"exception\": \"" + ExceptionUtils.getFullStackTrace((Throwable)ex) + "\" }";
        }
    }
}

