/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.isis.viewer.restfulobjects.rendering.HasHttpStatusCode;

class RestfulObjectsApplicationExceptionPojo {
    private final String className;
    private final int httpStatusCode;
    private final String message;
    private final List<String> stackTrace = Lists.newArrayList();
    private RestfulObjectsApplicationExceptionPojo causedBy;

    public static RestfulObjectsApplicationExceptionPojo create(Throwable ex) {
        return new RestfulObjectsApplicationExceptionPojo(ex);
    }

    private static String format(StackTraceElement stackTraceElement) {
        return stackTraceElement.toString();
    }

    public RestfulObjectsApplicationExceptionPojo(Throwable ex) {
        StackTraceElement[] stackTraceElements;
        this.className = ex.getClass().getName();
        this.httpStatusCode = this.getHttpStatusCodeIfAny(ex);
        this.message = ex.getMessage();
        for (StackTraceElement stackTraceElement : stackTraceElements = ex.getStackTrace()) {
            this.stackTrace.add(RestfulObjectsApplicationExceptionPojo.format(stackTraceElement));
        }
        Throwable cause = ex.getCause();
        if (cause != null && cause != ex) {
            this.causedBy = new RestfulObjectsApplicationExceptionPojo(cause);
        }
    }

    private int getHttpStatusCodeIfAny(Throwable ex) {
        if (!(ex instanceof HasHttpStatusCode)) {
            return 0;
        }
        HasHttpStatusCode hasHttpStatusCode = (HasHttpStatusCode)ex;
        return hasHttpStatusCode.getHttpStatusCode().getStatusCode();
    }

    public String getClassName() {
        return this.className;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public String getMessage() {
        return this.message;
    }

    public List<String> getStackTrace() {
        return this.stackTrace;
    }

    public RestfulObjectsApplicationExceptionPojo getCausedBy() {
        return this.causedBy;
    }
}

