/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server;

import java.util.List;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.isis.core.commons.exceptions.ExceptionUtils;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.applib.util.JsonMapper;
import org.apache.isis.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.server.RestfulObjectsApplicationExceptionPojo;

@Provider
public class RestfulObjectsApplicationExceptionMapper
implements ExceptionMapper<RestfulObjectsApplicationException> {
    @Context
    HttpHeaders httpHeaders;

    public Response toResponse(RestfulObjectsApplicationException ex) {
        Response.ResponseBuilder builder = Response.status((Response.StatusType)ex.getHttpStatusCode().getJaxrsStatusType());
        String message = ex.getMessage();
        if (message != null) {
            builder.header(RestfulResponse.Header.WARNING.getName(), (Object)RestfulResponse.Header.WARNING.render((Object)message));
        }
        boolean xml = false;
        List acceptableMediaTypes = this.httpHeaders.getAcceptableMediaTypes();
        for (MediaType acceptableMediaType : acceptableMediaTypes) {
            xml = xml || acceptableMediaType.getSubtype().equals("xml");
        }
        JsonRepresentation bodyRepr = ex.getBody();
        Throwable cause = ex.getCause();
        if (bodyRepr != null) {
            if (!xml) {
                String body = bodyRepr.toString();
                builder.entity((Object)body);
                builder.type("application/json");
            } else {
                builder.type("application/xml");
            }
        } else if (cause == null) {
            if (!xml) {
                builder.type("application/json");
            } else {
                builder.type("application/xml");
            }
        } else if (!xml) {
            String body;
            try {
                body = JsonMapper.instance().write((Object)RestfulObjectsApplicationExceptionPojo.create(cause));
            }
            catch (Exception e) {
                body = "{ \"exception\": \"" + ExceptionUtils.getFullStackTrace((Throwable)cause) + "\" }";
            }
            builder.entity((Object)body);
            builder.type("application/json;profile=urn:org.restfulobjects:repr-types/error");
        } else {
            RestfulObjectsApplicationExceptionPojo exceptionPojo = RestfulObjectsApplicationExceptionPojo.create(cause);
            StringBuilder buf = new StringBuilder();
            buf.append("<exception>\n");
            buf.append("  <httpStatusCode>").append(exceptionPojo.getHttpStatusCode()).append("</httpStatusCode>/n");
            buf.append("  <message>").append(exceptionPojo.getMessage()).append("</message>/n");
            buf.append("  <stackTrace>/n");
            for (String line : exceptionPojo.getStackTrace()) {
                buf.append("    <stackTraceElement>").append(line).append("    </stackTraceElement>/n");
            }
            buf.append("  </stackTrace>/n");
            buf.append("</exception>");
            builder.entity((Object)buf.toString());
            builder.type("application/xml;profile=urn:org.restfulobjects:repr-types/error");
        }
        return builder.build();
    }
}

