/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulRequest;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext3;
import org.apache.isis.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.rendering.util.Util;

public class ResourceContext
implements RendererContext3 {
    private final HttpHeaders httpHeaders;
    private final UriInfo uriInfo;
    private final Request request;
    private final Providers providers;
    private final HttpServletRequest httpServletRequest;
    private final HttpServletResponse httpServletResponse;
    private final SecurityContext securityContext;
    private final Localization localization;
    private final IsisConfiguration configuration;
    private final AuthenticationSession authenticationSession;
    private final PersistenceSession persistenceSession;
    private final AdapterManager adapterManager;
    private final SpecificationLoader specificationLoader;
    private List<List<String>> followLinks;
    private final Where where;
    private final DeploymentType deploymentType;
    private final String urlUnencodedQueryString;
    private JsonRepresentation readQueryStringAsMap;
    private Set<Oid> rendered = Sets.newHashSet();
    private static final boolean HONOR_UI_HINTS_DEFAULT = false;
    private static final boolean OBJECT_PROPERTY_VALUES_ONLY_DEFAULT = false;
    private static final boolean SUPPRESS_DESCRIBED_BY_LINKS_DEFAULT = false;
    private static final boolean SUPPRESS_UPDATE_LINK_DEFAULT = false;
    private static final boolean SUPPRESS_MEMBER_ID_DEFAULT = false;
    private static final boolean SUPPRESS_MEMBER_LINKS_DEFAULT = false;
    private static final boolean SUPPRESS_MEMBER_EXTENSIONS_DEFAULT = false;
    private static final boolean SUPPRESS_MEMBER_DISABLED_REASON_DEFAULT = false;

    public ResourceContext(RepresentationType representationType, HttpHeaders httpHeaders, Providers providers, UriInfo uriInfo, Request request, Where where, String urlUnencodedQueryStringIfAny, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SecurityContext securityContext, Localization localization, AuthenticationSession authenticationSession, PersistenceSession persistenceSession, AdapterManager objectAdapterLookup, SpecificationLoader specificationLoader, IsisConfiguration configuration, DeploymentType deploymentType) {
        this.httpHeaders = httpHeaders;
        this.providers = providers;
        this.uriInfo = uriInfo;
        this.request = request;
        this.urlUnencodedQueryString = urlUnencodedQueryStringIfAny;
        this.httpServletRequest = httpServletRequest;
        this.httpServletResponse = httpServletResponse;
        this.securityContext = securityContext;
        this.localization = localization;
        this.configuration = configuration;
        this.authenticationSession = authenticationSession;
        this.persistenceSession = persistenceSession;
        this.adapterManager = objectAdapterLookup;
        this.specificationLoader = specificationLoader;
        this.where = where;
        this.deploymentType = deploymentType;
        this.init(representationType);
    }

    void init(RepresentationType representationType) {
        this.getQueryStringAsJsonRepr();
        this.ensureCompatibleAcceptHeader(representationType);
        this.ensureDomainModelQueryParamSupported();
        this.followLinks = Collections.unmodifiableList((List)this.getArg(RestfulRequest.RequestParameter.FOLLOW_LINKS));
    }

    private void ensureDomainModelQueryParamSupported() {
        RestfulRequest.DomainModel domainModel = (RestfulRequest.DomainModel)this.getArg(RestfulRequest.RequestParameter.DOMAIN_MODEL);
        if (domainModel != RestfulRequest.DomainModel.FORMAL) {
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (String)"x-ro-domain-model of '%s' is not supported", (Object[])new Object[]{domainModel});
        }
    }

    private void ensureCompatibleAcceptHeader(RepresentationType representationType) {
        if (representationType == null) {
            return;
        }
        String producedProfile = representationType.getMediaTypeProfile();
        if (producedProfile != null) {
            for (MediaType mediaType : this.httpHeaders.getAcceptableMediaTypes()) {
                String acceptedProfileValue = (String)mediaType.getParameters().get("profile");
                if (acceptedProfileValue == null || producedProfile.equals(acceptedProfileValue)) continue;
                throw RestfulObjectsApplicationException.create((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.NOT_ACCEPTABLE);
            }
        }
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public String getUrlUnencodedQueryString() {
        return this.urlUnencodedQueryString;
    }

    public JsonRepresentation getQueryStringAsJsonRepr() {
        if (this.readQueryStringAsMap == null) {
            this.readQueryStringAsMap = this.requestArgsAsMap();
        }
        return this.readQueryStringAsMap;
    }

    protected JsonRepresentation requestArgsAsMap() {
        Map params = this.httpServletRequest.getParameterMap();
        if (ResourceContext.simpleQueryArgs(params)) {
            JsonRepresentation map = JsonRepresentation.newMap((String[])new String[0]);
            for (String paramName : params.keySet()) {
                String paramValue = ((String[])params.get(paramName))[0];
                try {
                    int paramValueAsInt = Integer.parseInt(paramValue);
                    map.mapPut(paramName + ".value", paramValueAsInt);
                }
                catch (Exception ex) {
                    map.mapPut(paramName + ".value", ResourceContext.stripQuotes(paramValue));
                }
            }
            return map;
        }
        String queryString = this.getUrlUnencodedQueryString();
        return Util.readQueryStringAsMap((String)queryString);
    }

    static String stripQuotes(String str) {
        if (Strings.isNullOrEmpty((String)str)) {
            return str;
        }
        if (str.startsWith("\"") && str.endsWith("\"")) {
            return str.substring(1, str.lastIndexOf("\""));
        }
        return str;
    }

    private static boolean simpleQueryArgs(Map<String, String[]> params) {
        if (params.isEmpty()) {
            return false;
        }
        for (String paramName : params.keySet()) {
            if (!"x-isis-querystring".equals(paramName) && !paramName.startsWith("{")) continue;
            return false;
        }
        return true;
    }

    public <Q> Q getArg(RestfulRequest.RequestParameter<Q> requestParameter) {
        JsonRepresentation queryStringJsonRepr = this.getQueryStringAsJsonRepr();
        return (Q)requestParameter.valueOf(queryStringJsonRepr);
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public Request getRequest() {
        return this.request;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    public List<MediaType> getAcceptableMediaTypes() {
        return this.httpHeaders.getAcceptableMediaTypes();
    }

    public HttpServletResponse getServletResponse() {
        return this.httpServletResponse;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    public List<List<String>> getFollowLinks() {
        return this.followLinks;
    }

    public Localization getLocalization() {
        return this.localization;
    }

    public AuthenticationSession getAuthenticationSession() {
        return this.authenticationSession;
    }

    public AdapterManager getAdapterManager() {
        return this.adapterManager;
    }

    public PersistenceSession getPersistenceSession() {
        return this.persistenceSession;
    }

    public List<ObjectAdapter> getServiceAdapters() {
        return this.persistenceSession.getServices();
    }

    public SpecificationLoader getSpecificationLoader() {
        return this.specificationLoader;
    }

    public IsisConfiguration getConfiguration() {
        return this.configuration;
    }

    public Where getWhere() {
        return this.where;
    }

    public boolean canEagerlyRender(ObjectAdapter objectAdapter) {
        Oid oid = objectAdapter.getOid();
        return this.rendered.add(oid);
    }

    public boolean honorUiHints() {
        return this.getConfiguration().getBoolean("isis.viewer.restfulobjects.honorUiHints", false);
    }

    public boolean objectPropertyValuesOnly() {
        return this.getConfiguration().getBoolean("isis.viewer.restfulobjects.objectPropertyValuesOnly", false);
    }

    public boolean suppressDescribedByLinks() {
        return this.getConfiguration().getBoolean("isis.viewer.restfulobjects.suppressDescribedByLinks", false);
    }

    public boolean suppressUpdateLink() {
        return this.getConfiguration().getBoolean("isis.viewer.restfulobjects.suppressUpdateLink", false);
    }

    public boolean suppressMemberId() {
        return this.getConfiguration().getBoolean("isis.viewer.restfulobjects.suppressMemberId", false);
    }

    public boolean suppressMemberLinks() {
        return this.getConfiguration().getBoolean("isis.viewer.restfulobjects.suppressMemberLinks", false);
    }

    public boolean suppressMemberExtensions() {
        return this.getConfiguration().getBoolean("isis.viewer.restfulobjects.suppressMemberExtensions", false);
    }

    public boolean suppressMemberDisabledReason() {
        return this.getConfiguration().getBoolean("isis.viewer.restfulobjects.suppressMemberDisabledReason", false);
    }

    public String urlFor(String url) {
        return this.getUriInfo().getBaseUri().toString() + url;
    }
}

